/*
  GNOME Comics Organizer
  Copyright (C) 1999-2001 Maxximum Software
   
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <glade/glade.h>

#include "functions.h"
#include "fileops.h"
#include "fileops-helper.h"

extern GladeXML *xml;
extern GString *GLADE_FILE;
extern GList *ComicList;

extern gchar *current_filename;
extern gboolean file_changed;

extern gchar *MainWindowKey;
extern gchar *ComicListKey;
extern gchar *ComicToAddKey;
extern gchar *ComicToAddToKey;
extern gchar *ComicToEditKey;
extern gchar *IssueToEditKey;

void on_open_file_selection_ok_button_clicked (GtkButton *button, gpointer user_data)
{
  GtkWidget *comics_tree, *main_window, *open_file_selection;
  FILE *fp;
  GString *wintitle, *temp;
  GladeXML *temp_xml = user_data;

  wintitle = g_string_new(NULL);
  open_file_selection = glade_xml_get_widget(temp_xml, "open_file_selection");
  main_window = gtk_object_get_data (GTK_OBJECT (open_file_selection), MainWindowKey);

  comics_tree = glade_xml_get_widget (xml, "comics_tree");

  /* FIXME - very ugly hack to make sure sufficient space is allocated for current_filename */
  temp = g_string_new(NULL);
  g_string_sprintf(temp, "%s", gtk_file_selection_get_filename (GTK_FILE_SELECTION (open_file_selection)));
  current_filename = temp->str;
  g_string_free(temp, FALSE);
  fp = my_open (current_filename, "r");
  if (fp == NULL)
    {
      gnome_app_flash(GNOME_APP(main_window), "Unable to open file.");
      return;
    }

  real_clear_list(main_window);
  temp = g_string_new(NULL);
  g_string_sprintf(temp, "%s", gtk_file_selection_get_filename (GTK_FILE_SELECTION (open_file_selection)));
  current_filename = temp->str;  /* real_clear_list also clears current_filename, so we set it again...  */
  g_string_free(temp, FALSE);

  ComicList = LoadFile(ComicList, fp);
  my_close();

  if (ComicList!=NULL)
    {
      CreateComicsTreeList(GTK_TREE (comics_tree), ComicList);
      gnome_app_flash(GNOME_APP (main_window), "File opened.");
      g_string_sprintf(wintitle, "GNOME Comics Organizer - %s", g_basename(current_filename));
      gtk_window_set_title (GTK_WINDOW (main_window), wintitle->str);
      file_changed = FALSE;
      /* FIXME - Resolve links between Comics and Issues */
    }

  gtk_widget_destroy(open_file_selection);
}

void on_open_file_selection_cancel_button_clicked (GtkButton *button, gpointer user_data)
{
  GtkWidget *open_file_selection;
  GladeXML *temp_xml = user_data;

  open_file_selection = glade_xml_get_widget (temp_xml, "open_file_selection");
  gtk_widget_destroy(open_file_selection);
}

gboolean on_open_file_selection_delete_event (GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
  GtkWidget *open_file_selection;
  GladeXML *temp_xml = user_data;

  open_file_selection = glade_xml_get_widget (temp_xml, "open_file_selection");
  gtk_widget_destroy(open_file_selection);

  return FALSE;
}

void real_open (GtkWidget *widget)
{
  GtkWidget *open_file_selection = NULL;
  GtkWidget *main_window;
  GladeXML *temp_xml;

  main_window = glade_xml_get_widget (xml, "main_window");
  temp_xml = glade_xml_new (GLADE_FILE->str, "open_file_selection");
  open_file_selection = glade_xml_get_widget (temp_xml, "open_file_selection");

  gtk_signal_connect_full (GTK_OBJECT(glade_xml_get_widget (temp_xml, "ok_button")), "clicked",
			   GTK_SIGNAL_FUNC(on_open_file_selection_ok_button_clicked), NULL,
			   temp_xml, (GtkDestroyNotify)gtk_object_unref,
			   FALSE, FALSE);
  gtk_signal_connect_full (GTK_OBJECT(glade_xml_get_widget (temp_xml, "cancel_button")), "clicked",
			   GTK_SIGNAL_FUNC(on_open_file_selection_cancel_button_clicked), NULL,
			   temp_xml, (GtkDestroyNotify)gtk_object_unref,
			   FALSE, FALSE);
  gtk_signal_connect_full (GTK_OBJECT(open_file_selection), "delete_event",
			   GTK_SIGNAL_FUNC(on_open_file_selection_delete_event), NULL,
			   temp_xml, (GtkDestroyNotify)gtk_object_unref,
			   FALSE, FALSE);
  
  gtk_object_set_data (GTK_OBJECT(open_file_selection), MainWindowKey, main_window);
  
  gtk_widget_show (open_file_selection);
}
