/*  Note: You are free to use whatever license you want.
    Eventually you will be able to edit it within Glade. */

/*  gcrontab
 *  Copyright (C) <YEAR> <AUTHORS>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <sys/stat.h>
#include <unistd.h>
#include <string.h>

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include "gcrontabsig.h"
#include "gcrontabsrc.h"

GtkWidget*
get_widget                             (GtkWidget       *widget,
                                        gchar           *widget_name)
{
  GtkWidget *parent, *found_widget;

  for (;;)
    {
      if (GTK_IS_MENU (widget))
        parent = gtk_menu_get_attach_widget (GTK_MENU (widget));
      else
        parent = widget->parent;
      if (parent == NULL)
        break;
      widget = parent;
    }

  found_widget = (GtkWidget*) gtk_object_get_data (GTK_OBJECT (widget),
                                                   widget_name);
  if (!found_widget)
    g_warning ("Widget not found: %s", widget_name);
  return found_widget;
}

/* This is an internally used function to set notebook tab widgets. */
void
set_notebook_tab                       (GtkWidget       *notebook,
                                        gint             page_num,
                                        GtkWidget       *widget)
{
  GtkNotebookPage *page;
  GtkWidget *notebook_page;

  page = (GtkNotebookPage*) g_list_nth (GTK_NOTEBOOK (notebook)->children, page_num)->data;
  notebook_page = page->child;
  gtk_widget_ref (notebook_page);
  gtk_notebook_remove_page (GTK_NOTEBOOK (notebook), page_num);
  gtk_notebook_insert_page (GTK_NOTEBOOK (notebook), notebook_page,
                            widget, page_num);
  gtk_widget_unref (notebook_page);
}

static GList *pixmaps_directories = NULL;

/* Use this function to set the directory containing installed pixmaps. */
void
add_pixmap_directory                   (gchar           *directory)
{
  pixmaps_directories = g_list_prepend (pixmaps_directories, g_strdup (directory));
}

/* This is an internally used function to check if a pixmap file exists. */
#ifndef G_DIR_SEPARATOR_S
#define G_DIR_SEPARATOR_S "/"
#endif
gchar*
check_file_exists                      (gchar           *directory,
                                        gchar           *filename)
{
  gchar *full_filename;
  struct stat s;
  gint status;

  full_filename = g_malloc (strlen (directory) + 1 + strlen (filename) + 1);
  strcpy (full_filename, directory);
  strcat (full_filename, G_DIR_SEPARATOR_S);
  strcat (full_filename, filename);

  status = stat (full_filename, &s);
  if (status == 0 && S_ISREG (s.st_mode))
    return full_filename;
  g_free (full_filename);
  return NULL;
}

/* This is an internally used function to create pixmaps. */
GtkWidget*
create_pixmap                          (GtkWidget       *widget,
                                        gchar           *filename)
{
  gchar *found_filename = NULL;
  GdkColormap *colormap;
  GdkPixmap *gdkpixmap;
  GdkBitmap *mask;
  GtkWidget *pixmap;
  GList *elem;

  /* We first try any pixmaps directories set by the application. */
  elem = pixmaps_directories;
  while (elem)
    {
      found_filename = check_file_exists ((gchar*)elem->data, filename);
      if (found_filename)
        break;
      elem = elem->next;
    }

  /* If we haven't found the pixmap, try the source directory. */
  if (!found_filename)
    {
      found_filename = check_file_exists ("../xtra/xpm", filename);
    }

  if (!found_filename)
    {
      g_print ("Couldn't find pixmap file: %s", filename);
      return NULL;
    }

  colormap = gtk_widget_get_colormap (widget);
  gdkpixmap = gdk_pixmap_colormap_create_from_xpm (NULL, colormap, &mask,
                                                   NULL, found_filename);
  g_free (found_filename);
  if (gdkpixmap == NULL)
    return NULL;
  pixmap = gtk_pixmap_new (gdkpixmap, mask);
  gdk_pixmap_unref (gdkpixmap);
  gdk_bitmap_unref (mask);
  return pixmap;
}

GtkWidget*
create_win_citem ()
{
  GtkWidget *win_citem;
  GtkWidget *hbox1;
  GtkWidget *vbox1;
  GtkWidget *hbox2;
  GtkWidget *label1;
  GtkWidget *cmb_from;
  GtkWidget *chk_to;
  GtkWidget *frame1;
  GtkWidget *vbox2;
  GtkWidget *hbox3;
  GtkWidget *label2;
  GtkWidget *cmb_to;
  GtkWidget *hbox4;
  GtkWidget *chk_step;
  GtkObject *sbt_step_adj;
  GtkWidget *sbt_step;
  GtkWidget *vbuttonbox1;
  GtkWidget *btn_add;
  GtkWidget *vbox9;
  GtkWidget *pixmap3;
  GtkWidget *label16;
  GtkWidget *btn_del;
  GtkWidget *vbox10;
  GtkWidget *pixmap4;
  GtkWidget *label17;
  GtkWidget *scrolledwindow1;
  GtkWidget *grd_cronln;
  GtkWidget *label11;
  GtkWidget *label12;
  GtkWidget *label13;
  GtkWidget *vbuttonbox2;
  GtkWidget *btn_accept;
  GtkWidget *vbox11;
  GtkWidget *pixmap5;
  GtkWidget *label18;
  GtkWidget *btn_cancel;
  GtkWidget *vbox12;
  GtkWidget *pixmap6;
  GtkWidget *label19;
  GtkTooltips *tooltips;

  tooltips = gtk_tooltips_new ();

  win_citem = gtk_window_new (GTK_WINDOW_DIALOG);
  gtk_object_set_data (GTK_OBJECT (win_citem), "win_citem", win_citem);
  gtk_widget_set_usize (win_citem, 600, 200);
  gtk_window_set_title (GTK_WINDOW (win_citem), "Cron item");
  gtk_window_set_policy (GTK_WINDOW (win_citem), TRUE, TRUE, FALSE);

  hbox1 = gtk_hbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (win_citem), "hbox1", hbox1);
  gtk_widget_show (hbox1);
  gtk_container_add (GTK_CONTAINER (win_citem), hbox1);

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (win_citem), "vbox1", vbox1);
  gtk_widget_show (vbox1);
  gtk_box_pack_start (GTK_BOX (hbox1), vbox1, FALSE, TRUE, 0);
  gtk_container_border_width (GTK_CONTAINER (vbox1), 4);

  hbox2 = gtk_hbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (win_citem), "hbox2", hbox2);
  gtk_widget_show (hbox2);
  gtk_box_pack_start (GTK_BOX (vbox1), hbox2, TRUE, TRUE, 0);

  label1 = gtk_label_new ("From");
  gtk_object_set_data (GTK_OBJECT (win_citem), "label1", label1);
  gtk_widget_show (label1);
  gtk_box_pack_start (GTK_BOX (hbox2), label1, FALSE, TRUE, 3);

  cmb_from = gtk_combo_new ();
  gtk_object_set_data (GTK_OBJECT (win_citem), "cmb_from", cmb_from);
  gtk_widget_show (cmb_from);
  gtk_box_pack_start (GTK_BOX (hbox2), cmb_from, FALSE, TRUE, 0);
  gtk_widget_set_usize (GTK_COMBO (cmb_from)->entry, 84, -2);
  gtk_widget_set_usize (cmb_from, 100, -2);

  chk_to = gtk_check_button_new_with_label ("Is range");
  gtk_object_set_data (GTK_OBJECT (win_citem), "chk_to", chk_to);
  gtk_widget_show (chk_to);
  gtk_box_pack_start (GTK_BOX (vbox1), chk_to, FALSE, FALSE, 0);
  gtk_signal_connect (GTK_OBJECT (chk_to), "toggled",
                      GTK_SIGNAL_FUNC (on_chk_to_toggled),
                      NULL);

  frame1 = gtk_frame_new ("");
  gtk_object_set_data (GTK_OBJECT (win_citem), "frame1", frame1);
  gtk_widget_show (frame1);
  gtk_box_pack_start (GTK_BOX (vbox1), frame1, TRUE, TRUE, 0);
  gtk_widget_set_usize (frame1, 136, -2);
  gtk_container_border_width (GTK_CONTAINER (frame1), 4);
  gtk_widget_set_sensitive (frame1, FALSE);

  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (win_citem), "vbox2", vbox2);
  gtk_widget_show (vbox2);
  gtk_container_add (GTK_CONTAINER (frame1), vbox2);

  hbox3 = gtk_hbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (win_citem), "hbox3", hbox3);
  gtk_widget_show (hbox3);
  gtk_box_pack_start (GTK_BOX (vbox2), hbox3, TRUE, TRUE, 0);

  label2 = gtk_label_new ("to");
  gtk_object_set_data (GTK_OBJECT (win_citem), "label2", label2);
  gtk_widget_show (label2);
  gtk_box_pack_start (GTK_BOX (hbox3), label2, FALSE, TRUE, 7);

  cmb_to = gtk_combo_new ();
  gtk_object_set_data (GTK_OBJECT (win_citem), "cmb_to", cmb_to);
  gtk_widget_show (cmb_to);
  gtk_box_pack_start (GTK_BOX (hbox3), cmb_to, FALSE, TRUE, 0);
  gtk_widget_set_usize (GTK_COMBO (cmb_to)->entry, 84, -2);
  gtk_widget_set_usize (cmb_to, 100, -2);

  hbox4 = gtk_hbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (win_citem), "hbox4", hbox4);
  gtk_widget_show (hbox4);
  gtk_box_pack_start (GTK_BOX (vbox2), hbox4, TRUE, TRUE, 0);

  chk_step = gtk_check_button_new_with_label ("step");
  gtk_object_set_data (GTK_OBJECT (win_citem), "chk_step", chk_step);
  gtk_widget_show (chk_step);
  gtk_box_pack_start (GTK_BOX (hbox4), chk_step, FALSE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (chk_step), "toggled",
                      GTK_SIGNAL_FUNC (on_chk_step_toggled),
                      NULL);

  sbt_step_adj = gtk_adjustment_new (1, 0, 100, 1, 10, 10);
  sbt_step = gtk_spin_button_new (GTK_ADJUSTMENT (sbt_step_adj), 1, 0);
  gtk_object_set_data (GTK_OBJECT (win_citem), "sbt_step", sbt_step);
  gtk_widget_show (sbt_step);
  gtk_box_pack_start (GTK_BOX (hbox4), sbt_step, TRUE, TRUE, 0);
  gtk_widget_set_sensitive (sbt_step, FALSE);
  gtk_spin_button_set_update_policy (GTK_SPIN_BUTTON (sbt_step), GTK_UPDATE_IF_VALID);

  vbuttonbox1 = gtk_vbutton_box_new ();
  gtk_object_set_data (GTK_OBJECT (win_citem), "vbuttonbox1", vbuttonbox1);
  gtk_widget_show (vbuttonbox1);
  gtk_box_pack_start (GTK_BOX (hbox1), vbuttonbox1, FALSE, TRUE, 0);
  gtk_container_border_width (GTK_CONTAINER (vbuttonbox1), 4);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (vbuttonbox1), GTK_BUTTONBOX_SPREAD);

  btn_add = gtk_button_new ();
  gtk_object_set_data (GTK_OBJECT (win_citem), "btn_add", btn_add);
  gtk_widget_show (btn_add);
  gtk_container_add (GTK_CONTAINER (vbuttonbox1), btn_add);
  gtk_tooltips_set_tip (tooltips, btn_add, "Click here to add the current interval to list", NULL);
  gtk_signal_connect (GTK_OBJECT (btn_add), "clicked",
                      GTK_SIGNAL_FUNC (on_btn_add_clicked),
                      NULL);

  vbox9 = gtk_vbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (win_citem), "vbox9", vbox9);
  gtk_widget_show (vbox9);
  gtk_container_add (GTK_CONTAINER (btn_add), vbox9);

  pixmap3 = create_pixmap (win_citem, "rarr.xpm");
  if (pixmap3 == NULL)
    g_error ("Couldn't create pixmap");
  gtk_object_set_data (GTK_OBJECT (win_citem), "pixmap3", pixmap3);
  gtk_widget_show (pixmap3);
  gtk_box_pack_start (GTK_BOX (vbox9), pixmap3, TRUE, TRUE, 0);

  label16 = gtk_label_new ("Add");
  gtk_object_set_data (GTK_OBJECT (win_citem), "label16", label16);
  gtk_widget_show (label16);
  gtk_box_pack_start (GTK_BOX (vbox9), label16, TRUE, TRUE, 0);

  btn_del = gtk_button_new ();
  gtk_object_set_data (GTK_OBJECT (win_citem), "btn_del", btn_del);
  gtk_widget_show (btn_del);
  gtk_container_add (GTK_CONTAINER (vbuttonbox1), btn_del);
  gtk_tooltips_set_tip (tooltips, btn_del, "Click here to delete the current selected item", NULL);
  gtk_signal_connect (GTK_OBJECT (btn_del), "clicked",
                      GTK_SIGNAL_FUNC (on_btn_del_clicked),
                      NULL);

  vbox10 = gtk_vbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (win_citem), "vbox10", vbox10);
  gtk_widget_show (vbox10);
  gtk_container_add (GTK_CONTAINER (btn_del), vbox10);

  pixmap4 = create_pixmap (win_citem, "del.xpm");
  if (pixmap4 == NULL)
    g_error ("Couldn't create pixmap");
  gtk_object_set_data (GTK_OBJECT (win_citem), "pixmap4", pixmap4);
  gtk_widget_show (pixmap4);
  gtk_box_pack_start (GTK_BOX (vbox10), pixmap4, TRUE, TRUE, 0);

  label17 = gtk_label_new ("Del");
  gtk_object_set_data (GTK_OBJECT (win_citem), "label17", label17);
  gtk_widget_show (label17);
  gtk_box_pack_start (GTK_BOX (vbox10), label17, TRUE, TRUE, 0);

  scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
  gtk_object_set_data (GTK_OBJECT (win_citem), "scrolledwindow1", scrolledwindow1);
  gtk_widget_show (scrolledwindow1);
  gtk_box_pack_start (GTK_BOX (hbox1), scrolledwindow1, TRUE, TRUE, 0);

  grd_cronln = gtk_clist_new (3);
  gtk_object_set_data (GTK_OBJECT (win_citem), "grd_cronln", grd_cronln);
  gtk_widget_show (grd_cronln);
  gtk_container_add (GTK_CONTAINER (scrolledwindow1), grd_cronln);
  gtk_widget_set_usize (grd_cronln, 150, -2);
  gtk_signal_connect (GTK_OBJECT (grd_cronln), "select_row",
                      GTK_SIGNAL_FUNC (on_grd_cronln_select_row),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (grd_cronln), "unselect_row",
                      GTK_SIGNAL_FUNC (on_grd_cronln_unselect_row),
                      NULL);
  gtk_clist_set_column_width (GTK_CLIST (grd_cronln), 0, 81);
  gtk_clist_set_column_width (GTK_CLIST (grd_cronln), 1, 84);
  gtk_clist_set_column_width (GTK_CLIST (grd_cronln), 2, 50);
  gtk_clist_column_titles_show (GTK_CLIST (grd_cronln));

  label11 = gtk_label_new ("From");
  gtk_object_set_data (GTK_OBJECT (win_citem), "label11", label11);
  gtk_widget_show (label11);
  gtk_clist_set_column_widget (GTK_CLIST (grd_cronln), 0, label11);

  label12 = gtk_label_new ("To");
  gtk_object_set_data (GTK_OBJECT (win_citem), "label12", label12);
  gtk_widget_show (label12);
  gtk_clist_set_column_widget (GTK_CLIST (grd_cronln), 1, label12);

  label13 = gtk_label_new ("Step");
  gtk_object_set_data (GTK_OBJECT (win_citem), "label13", label13);
  gtk_widget_show (label13);
  gtk_clist_set_column_widget (GTK_CLIST (grd_cronln), 2, label13);

  vbuttonbox2 = gtk_vbutton_box_new ();
  gtk_object_set_data (GTK_OBJECT (win_citem), "vbuttonbox2", vbuttonbox2);
  gtk_widget_show (vbuttonbox2);
  gtk_box_pack_start (GTK_BOX (hbox1), vbuttonbox2, FALSE, TRUE, 7);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (vbuttonbox2), GTK_BUTTONBOX_END);

  btn_accept = gtk_button_new ();
  gtk_object_set_data (GTK_OBJECT (win_citem), "btn_accept", btn_accept);
  gtk_widget_show (btn_accept);
  gtk_container_add (GTK_CONTAINER (vbuttonbox2), btn_accept);
  gtk_signal_connect (GTK_OBJECT (btn_accept), "clicked",
                      GTK_SIGNAL_FUNC (on_btn_accept_clicked),
                      NULL);

  vbox11 = gtk_vbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (win_citem), "vbox11", vbox11);
  gtk_widget_show (vbox11);
  gtk_container_add (GTK_CONTAINER (btn_accept), vbox11);

  pixmap5 = create_pixmap (win_citem, "accept.xpm");
  if (pixmap5 == NULL)
    g_error ("Couldn't create pixmap");
  gtk_object_set_data (GTK_OBJECT (win_citem), "pixmap5", pixmap5);
  gtk_widget_show (pixmap5);
  gtk_box_pack_start (GTK_BOX (vbox11), pixmap5, TRUE, TRUE, 0);

  label18 = gtk_label_new ("Accept");
  gtk_object_set_data (GTK_OBJECT (win_citem), "label18", label18);
  gtk_widget_show (label18);
  gtk_box_pack_start (GTK_BOX (vbox11), label18, TRUE, TRUE, 0);

  btn_cancel = gtk_button_new ();
  gtk_object_set_data (GTK_OBJECT (win_citem), "btn_cancel", btn_cancel);
  gtk_widget_show (btn_cancel);
  gtk_container_add (GTK_CONTAINER (vbuttonbox2), btn_cancel);
  gtk_signal_connect (GTK_OBJECT (btn_cancel), "clicked",
                      GTK_SIGNAL_FUNC (on_btn_cancel_clicked),
                      NULL);

  vbox12 = gtk_vbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (win_citem), "vbox12", vbox12);
  gtk_widget_show (vbox12);
  gtk_container_add (GTK_CONTAINER (btn_cancel), vbox12);

  pixmap6 = create_pixmap (win_citem, "del.xpm");
  if (pixmap6 == NULL)
    g_error ("Couldn't create pixmap");
  gtk_object_set_data (GTK_OBJECT (win_citem), "pixmap6", pixmap6);
  gtk_widget_show (pixmap6);
  gtk_box_pack_start (GTK_BOX (vbox12), pixmap6, TRUE, TRUE, 0);

  label19 = gtk_label_new ("Cancel");
  gtk_object_set_data (GTK_OBJECT (win_citem), "label19", label19);
  gtk_widget_show (label19);
  gtk_box_pack_start (GTK_BOX (vbox12), label19, TRUE, TRUE, 0);

  gtk_object_set_data (GTK_OBJECT (win_citem), "tooltips", tooltips);

  return win_citem;
}

GtkWidget*
create_win_main ()
{
  GtkWidget *win_main;
  GtkWidget *vbox3;
  GtkWidget *handlebox2;
  GtkWidget *mnu_main;
  GtkWidget *file;
  GtkWidget *file_menu;
  GtkWidget *New;
  GtkWidget *separator1;
  GtkWidget *open;
  GtkWidget *save;
  GtkWidget *saveas;
  GtkWidget *separador2;
  GtkWidget *quit;
  GtkWidget *options;
  GtkWidget *options_menu;
  GtkWidget *stdbars;
  GtkWidget *timebar;
  GtkWidget *help;
  GtkWidget *help_menu;
  GtkWidget *hlp;
  GtkWidget *separador3;
  GtkWidget *about;
  GtkWidget *handlebox4;
  GtkWidget *toolbar4;
  GtkWidget *tmp_toolbar_icon;
  GtkWidget *btn_tbrnew;
  GtkWidget *btn_tbropen;
  GtkWidget *btn_tbrsave;
  GtkWidget *btn_tbradd;
  GtkWidget *btn_tbrdel;
  GtkWidget *btn_tbrhelp;
  GtkWidget *btn_tbrexit;
  GtkWidget *handlebox5;
  GtkWidget *toolbar6;
  GtkWidget *btn_minute;
  GtkWidget *btn_hour;
  GtkWidget *btn_dayofmonth;
  GtkWidget *btn_month;
  GtkWidget *btn_dayofweek;
  GtkWidget *btn_action;
  GtkWidget *vseparator1;
  GtkWidget *btn_calendar;
  GtkWidget *scrolledwindow3;
  GtkWidget *grd_cron;
  GtkWidget *label3;
  GtkWidget *label4;
  GtkWidget *label5;
  GtkWidget *label6;
  GtkWidget *label7;
  GtkWidget *label8;
  GtkWidget *hbuttonbox2;
  GtkWidget *btn_addline;
  GtkWidget *vbox7;
  GtkWidget *pixmap1;
  GtkWidget *label14;
  GtkWidget *btn_delline;
  GtkWidget *vbox8;
  GtkWidget *pixmap2;
  GtkWidget *label15;
  GtkWidget *stb_main;
  GtkTooltips *tooltips;

  tooltips = gtk_tooltips_new ();

  win_main = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_object_set_data (GTK_OBJECT (win_main), "win_main", win_main);
  gtk_widget_set_usize (win_main, 540, 0);
  gtk_signal_connect (GTK_OBJECT (win_main), "delete_event",
                      GTK_SIGNAL_FUNC (on_win_main_delete_event),
                      NULL);
  gtk_window_set_title (GTK_WINDOW (win_main), "Gcrontab");
  gtk_window_set_policy (GTK_WINDOW (win_main), TRUE, TRUE, FALSE);

  vbox3 = gtk_vbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (win_main), "vbox3", vbox3);
  gtk_widget_show (vbox3);
  gtk_container_add (GTK_CONTAINER (win_main), vbox3);

  handlebox2 = gtk_handle_box_new ();
  gtk_object_set_data (GTK_OBJECT (win_main), "handlebox2", handlebox2);
  gtk_widget_show (handlebox2);
  gtk_box_pack_start (GTK_BOX (vbox3), handlebox2, FALSE, TRUE, 0);

  mnu_main = gtk_menu_bar_new ();
  gtk_object_set_data (GTK_OBJECT (win_main), "mnu_main", mnu_main);
  gtk_widget_show (mnu_main);
  gtk_container_add (GTK_CONTAINER (handlebox2), mnu_main);

  file = gtk_menu_item_new_with_label ("File");
  gtk_object_set_data (GTK_OBJECT (win_main), "file", file);
  gtk_widget_show (file);
  gtk_container_add (GTK_CONTAINER (mnu_main), file);
  gtk_signal_connect (GTK_OBJECT (file), "activate",
                      GTK_SIGNAL_FUNC (on_file_activate),
                      NULL);

  file_menu = gtk_menu_new ();
  gtk_object_set_data (GTK_OBJECT (win_main), "file_menu", file_menu);
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (file), file_menu);

  New = gtk_menu_item_new_with_label ("New");
  gtk_object_set_data (GTK_OBJECT (win_main), "New", New);
  gtk_widget_show (New);
  gtk_container_add (GTK_CONTAINER (file_menu), New);
  gtk_signal_connect (GTK_OBJECT (New), "activate",
                      GTK_SIGNAL_FUNC (on_new_activate),
                      NULL);

  separator1 = gtk_menu_item_new ();
  gtk_object_set_data (GTK_OBJECT (win_main), "separator1", separator1);
  gtk_widget_show (separator1);
  gtk_container_add (GTK_CONTAINER (file_menu), separator1);

  open = gtk_menu_item_new_with_label ("Open");
  gtk_object_set_data (GTK_OBJECT (win_main), "open", open);
  gtk_widget_show (open);
  gtk_container_add (GTK_CONTAINER (file_menu), open);
  gtk_signal_connect (GTK_OBJECT (open), "activate",
                      GTK_SIGNAL_FUNC (on_open_activate),
                      NULL);

  save = gtk_menu_item_new_with_label ("Save");
  gtk_object_set_data (GTK_OBJECT (win_main), "save", save);
  gtk_widget_show (save);
  gtk_container_add (GTK_CONTAINER (file_menu), save);
  gtk_signal_connect (GTK_OBJECT (save), "activate",
                      GTK_SIGNAL_FUNC (on_save_activate),
                      NULL);

  saveas = gtk_menu_item_new_with_label ("Save as");
  gtk_object_set_data (GTK_OBJECT (win_main), "saveas", saveas);
  gtk_widget_show (saveas);
  gtk_container_add (GTK_CONTAINER (file_menu), saveas);
  gtk_signal_connect (GTK_OBJECT (saveas), "activate",
                      GTK_SIGNAL_FUNC (on_saveas_activate),
                      NULL);

  separador2 = gtk_menu_item_new ();
  gtk_object_set_data (GTK_OBJECT (win_main), "separador2", separador2);
  gtk_widget_show (separador2);
  gtk_container_add (GTK_CONTAINER (file_menu), separador2);

  quit = gtk_menu_item_new_with_label ("quit");
  gtk_object_set_data (GTK_OBJECT (win_main), "quit", quit);
  gtk_widget_show (quit);
  gtk_container_add (GTK_CONTAINER (file_menu), quit);
  gtk_signal_connect (GTK_OBJECT (quit), "activate",
                      GTK_SIGNAL_FUNC (on_quit_activate),
                      NULL);

  options = gtk_menu_item_new_with_label ("Options");
  gtk_object_set_data (GTK_OBJECT (win_main), "options", options);
  gtk_widget_show (options);
  gtk_container_add (GTK_CONTAINER (mnu_main), options);

  options_menu = gtk_menu_new ();
  gtk_object_set_data (GTK_OBJECT (win_main), "options_menu", options_menu);
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (options), options_menu);

  stdbars = gtk_check_menu_item_new_with_label ("Standard bar");
  gtk_object_set_data (GTK_OBJECT (win_main), "stdbars", stdbars);
  gtk_widget_show (stdbars);
  gtk_container_add (GTK_CONTAINER (options_menu), stdbars);
  gtk_signal_connect (GTK_OBJECT (stdbars), "activate",
                      GTK_SIGNAL_FUNC (on_stdbars_activate),
                      NULL);

  timebar = gtk_check_menu_item_new_with_label ("Time bar");
  gtk_object_set_data (GTK_OBJECT (win_main), "timebar", timebar);
  gtk_widget_show (timebar);
  gtk_container_add (GTK_CONTAINER (options_menu), timebar);
  gtk_signal_connect (GTK_OBJECT (timebar), "activate",
                      GTK_SIGNAL_FUNC (on_timebar_activate),
                      NULL);

  help = gtk_menu_item_new_with_label ("Help");
  gtk_object_set_data (GTK_OBJECT (win_main), "help", help);
  gtk_widget_show (help);
  gtk_container_add (GTK_CONTAINER (mnu_main), help);
  gtk_menu_item_right_justify (GTK_MENU_ITEM (help));

  help_menu = gtk_menu_new ();
  gtk_object_set_data (GTK_OBJECT (win_main), "help_menu", help_menu);
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (help), help_menu);

  hlp = gtk_menu_item_new_with_label ("Help");
  gtk_object_set_data (GTK_OBJECT (win_main), "hlp", hlp);
  gtk_widget_show (hlp);
  gtk_container_add (GTK_CONTAINER (help_menu), hlp);
  gtk_signal_connect (GTK_OBJECT (hlp), "activate",
                      GTK_SIGNAL_FUNC (on_hlp_activate),
                      NULL);

  separador3 = gtk_menu_item_new ();
  gtk_object_set_data (GTK_OBJECT (win_main), "separador3", separador3);
  gtk_widget_show (separador3);
  gtk_container_add (GTK_CONTAINER (help_menu), separador3);

  about = gtk_menu_item_new_with_label ("About");
  gtk_object_set_data (GTK_OBJECT (win_main), "about", about);
  gtk_widget_show (about);
  gtk_container_add (GTK_CONTAINER (help_menu), about);
  gtk_signal_connect (GTK_OBJECT (about), "activate",
                      GTK_SIGNAL_FUNC (on_about_activate),
                      NULL);

  handlebox4 = gtk_handle_box_new ();
  gtk_object_set_data (GTK_OBJECT (win_main), "handlebox4", handlebox4);
  gtk_widget_show (handlebox4);
  gtk_box_pack_start (GTK_BOX (vbox3), handlebox4, FALSE, TRUE, 0);

  toolbar4 = gtk_toolbar_new (GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_BOTH);
  gtk_object_set_data (GTK_OBJECT (win_main), "toolbar4", toolbar4);
  gtk_widget_show (toolbar4);
  gtk_container_add (GTK_CONTAINER (handlebox4), toolbar4);

  tmp_toolbar_icon = create_pixmap (win_main, "new.xpm");
  if (tmp_toolbar_icon == NULL)
    g_error ("Couldn't create pixmap");
  btn_tbrnew = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar4),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                "New",
                                "New Crontab file", NULL,
                                tmp_toolbar_icon, NULL, NULL);
  gtk_object_set_data (GTK_OBJECT (win_main), "btn_tbrnew", btn_tbrnew);
  gtk_widget_show (btn_tbrnew);
  gtk_widget_set_usize (btn_tbrnew, 38, 38);
  gtk_signal_connect (GTK_OBJECT (btn_tbrnew), "clicked",
                      GTK_SIGNAL_FUNC (on_btn_tbrnew_clicked),
                      NULL);

  tmp_toolbar_icon = create_pixmap (win_main, "open.xpm");
  if (tmp_toolbar_icon == NULL)
    g_error ("Couldn't create pixmap");
  btn_tbropen = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar4),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                "Open",
                                "Open crontab file", NULL,
                                tmp_toolbar_icon, NULL, NULL);
  gtk_object_set_data (GTK_OBJECT (win_main), "btn_tbropen", btn_tbropen);
  gtk_widget_show (btn_tbropen);
  gtk_widget_set_usize (btn_tbropen, 32, 40);
  gtk_signal_connect (GTK_OBJECT (btn_tbropen), "clicked",
                      GTK_SIGNAL_FUNC (on_btn_tbropen_clicked),
                      NULL);

  tmp_toolbar_icon = create_pixmap (win_main, "save.xpm");
  if (tmp_toolbar_icon == NULL)
    g_error ("Couldn't create pixmap");
  btn_tbrsave = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar4),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                "Save",
                                "Save current file", NULL,
                                tmp_toolbar_icon, NULL, NULL);
  gtk_object_set_data (GTK_OBJECT (win_main), "btn_tbrsave", btn_tbrsave);
  gtk_widget_show (btn_tbrsave);
  gtk_widget_set_usize (btn_tbrsave, 32, 40);
  gtk_signal_connect (GTK_OBJECT (btn_tbrsave), "clicked",
                      GTK_SIGNAL_FUNC (on_btn_tbrsave_clicked),
                      NULL);

  tmp_toolbar_icon = create_pixmap (win_main, "add.xpm");
  if (tmp_toolbar_icon == NULL)
    g_error ("Couldn't create pixmap");
  btn_tbradd = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar4),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                "Add",
                                "Add an empty crontab line", NULL,
                                tmp_toolbar_icon, NULL, NULL);
  gtk_object_set_data (GTK_OBJECT (win_main), "btn_tbradd", btn_tbradd);
  gtk_widget_show (btn_tbradd);
  gtk_signal_connect (GTK_OBJECT (btn_tbradd), "clicked",
                      GTK_SIGNAL_FUNC (on_btn_tbradd_clicked),
                      NULL);

  tmp_toolbar_icon = create_pixmap (win_main, "del.xpm");
  if (tmp_toolbar_icon == NULL)
    g_error ("Couldn't create pixmap");
  btn_tbrdel = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar4),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                "Del",
                                "Delete current selected line", NULL,
                                tmp_toolbar_icon, NULL, NULL);
  gtk_object_set_data (GTK_OBJECT (win_main), "btn_tbrdel", btn_tbrdel);
  gtk_widget_show (btn_tbrdel);
  gtk_signal_connect (GTK_OBJECT (btn_tbrdel), "clicked",
                      GTK_SIGNAL_FUNC (on_btn_tbrdel_clicked),
                      NULL);

  tmp_toolbar_icon = create_pixmap (win_main, "help.xpm");
  if (tmp_toolbar_icon == NULL)
    g_error ("Couldn't create pixmap");
  btn_tbrhelp = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar4),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                "Help",
                                "Help", NULL,
                                tmp_toolbar_icon, NULL, NULL);
  gtk_object_set_data (GTK_OBJECT (win_main), "btn_tbrhelp", btn_tbrhelp);
  gtk_widget_show (btn_tbrhelp);
  gtk_signal_connect (GTK_OBJECT (btn_tbrhelp), "clicked",
                      GTK_SIGNAL_FUNC (on_btn_tbrhelp_clicked),
                      NULL);

  tmp_toolbar_icon = create_pixmap (win_main, "exit.xpm");
  if (tmp_toolbar_icon == NULL)
    g_error ("Couldn't create pixmap");
  btn_tbrexit = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar4),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                "Exit",
                                "Quit this program", NULL,
                                tmp_toolbar_icon, NULL, NULL);
  gtk_object_set_data (GTK_OBJECT (win_main), "btn_tbrexit", btn_tbrexit);
  gtk_widget_show (btn_tbrexit);
  gtk_signal_connect (GTK_OBJECT (btn_tbrexit), "clicked",
                      GTK_SIGNAL_FUNC (on_btn_tbrexit_clicked),
                      NULL);

  handlebox5 = gtk_handle_box_new ();
  gtk_object_set_data (GTK_OBJECT (win_main), "handlebox5", handlebox5);
  gtk_widget_show (handlebox5);
  gtk_box_pack_start (GTK_BOX (vbox3), handlebox5, FALSE, TRUE, 0);

  toolbar6 = gtk_toolbar_new (GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_BOTH);
  gtk_object_set_data (GTK_OBJECT (win_main), "toolbar6", toolbar6);
  gtk_widget_show (toolbar6);
  gtk_container_add (GTK_CONTAINER (handlebox5), toolbar6);

  tmp_toolbar_icon = create_pixmap (win_main, "minute.xpm");
  if (tmp_toolbar_icon == NULL)
    g_error ("Couldn't create pixmap");
  btn_minute = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar6),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                " Min.",
                                "Edit minutes from current line", NULL,
                                tmp_toolbar_icon, NULL, NULL);
  gtk_object_set_data (GTK_OBJECT (win_main), "btn_minute", btn_minute);
  gtk_widget_show (btn_minute);
  gtk_widget_set_usize (btn_minute, 38, 38);
  gtk_signal_connect (GTK_OBJECT (btn_minute), "clicked",
                      GTK_SIGNAL_FUNC (on_btn_minute_clicked),
                      NULL);

  tmp_toolbar_icon = create_pixmap (win_main, "hour.xpm");
  if (tmp_toolbar_icon == NULL)
    g_error ("Couldn't create pixmap");
  btn_hour = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar6),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                "Hour",
                                "Edit hours from current line", NULL,
                                tmp_toolbar_icon, NULL, NULL);
  gtk_object_set_data (GTK_OBJECT (win_main), "btn_hour", btn_hour);
  gtk_widget_show (btn_hour);
  gtk_signal_connect (GTK_OBJECT (btn_hour), "clicked",
                      GTK_SIGNAL_FUNC (on_btn_hour_clicked),
                      NULL);

  tmp_toolbar_icon = create_pixmap (win_main, "dom.xpm");
  if (tmp_toolbar_icon == NULL)
    g_error ("Couldn't create pixmap");
  btn_dayofmonth = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar6),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                "DoM",
                                "Edit day of Month from current line", NULL,
                                tmp_toolbar_icon, NULL, NULL);
  gtk_object_set_data (GTK_OBJECT (win_main), "btn_dayofmonth", btn_dayofmonth);
  gtk_widget_show (btn_dayofmonth);
  gtk_signal_connect (GTK_OBJECT (btn_dayofmonth), "clicked",
                      GTK_SIGNAL_FUNC (on_btn_dayofmonth_clicked),
                      NULL);

  tmp_toolbar_icon = create_pixmap (win_main, "month.xpm");
  if (tmp_toolbar_icon == NULL)
    g_error ("Couldn't create pixmap");
  btn_month = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar6),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                "Mon",
                                "Edit Month from current line", NULL,
                                tmp_toolbar_icon, NULL, NULL);
  gtk_object_set_data (GTK_OBJECT (win_main), "btn_month", btn_month);
  gtk_widget_show (btn_month);
  gtk_signal_connect (GTK_OBJECT (btn_month), "clicked",
                      GTK_SIGNAL_FUNC (on_btn_month_clicked),
                      NULL);

  tmp_toolbar_icon = create_pixmap (win_main, "dow.xpm");
  if (tmp_toolbar_icon == NULL)
    g_error ("Couldn't create pixmap");
  btn_dayofweek = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar6),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                "DoW",
                                "Edit day of Week from current line", NULL,
                                tmp_toolbar_icon, NULL, NULL);
  gtk_object_set_data (GTK_OBJECT (win_main), "btn_dayofweek", btn_dayofweek);
  gtk_widget_show (btn_dayofweek);
  gtk_signal_connect (GTK_OBJECT (btn_dayofweek), "clicked",
                      GTK_SIGNAL_FUNC (on_btn_dayofweek_clicked),
                      NULL);

  tmp_toolbar_icon = create_pixmap (win_main, "action.xpm");
  if (tmp_toolbar_icon == NULL)
    g_error ("Couldn't create pixmap");
  btn_action = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar6),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                "Cmd",
                                "Edit command from current line", NULL,
                                tmp_toolbar_icon, NULL, NULL);
  gtk_object_set_data (GTK_OBJECT (win_main), "btn_action", btn_action);
  gtk_widget_show (btn_action);
  gtk_signal_connect (GTK_OBJECT (btn_action), "clicked",
                      GTK_SIGNAL_FUNC (on_btn_action_clicked),
                      NULL);

  vseparator1 = gtk_vseparator_new ();
  gtk_object_set_data (GTK_OBJECT (win_main), "vseparator1", vseparator1);
  gtk_widget_show (vseparator1);
  gtk_toolbar_append_widget (GTK_TOOLBAR (toolbar6), vseparator1, NULL, NULL);
  gtk_widget_set_usize (vseparator1, 77, 30);

  tmp_toolbar_icon = create_pixmap (win_main, "cal.xpm");
  if (tmp_toolbar_icon == NULL)
    g_error ("Couldn't create pixmap");
  btn_calendar = gtk_toolbar_append_element (GTK_TOOLBAR (toolbar6),
                                GTK_TOOLBAR_CHILD_BUTTON,
                                NULL,
                                "Cal",
                                NULL, NULL,
                                tmp_toolbar_icon, NULL, NULL);
  gtk_object_set_data (GTK_OBJECT (win_main), "btn_calendar", btn_calendar);
  gtk_widget_show (btn_calendar);
  gtk_signal_connect (GTK_OBJECT (btn_calendar), "clicked",
                      GTK_SIGNAL_FUNC (on_btn_calendar_clicked),
                      NULL);

  scrolledwindow3 = gtk_scrolled_window_new (NULL, NULL);
  gtk_object_set_data (GTK_OBJECT (win_main), "scrolledwindow3", scrolledwindow3);
  gtk_widget_show (scrolledwindow3);
  gtk_box_pack_start (GTK_BOX (vbox3), scrolledwindow3, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow3), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  grd_cron = gtk_clist_new (6);
  gtk_object_set_data (GTK_OBJECT (win_main), "grd_cron", grd_cron);
  gtk_widget_show (grd_cron);
  gtk_container_add (GTK_CONTAINER (scrolledwindow3), grd_cron);
  gtk_widget_set_usize (grd_cron, -2, 140);
  gtk_signal_connect (GTK_OBJECT (grd_cron), "select_row",
                      GTK_SIGNAL_FUNC (on_grd_cron_select_row),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (grd_cron), "unselect_row",
                      GTK_SIGNAL_FUNC (on_grd_cron_unselect_row),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (grd_cron), "click_column",
                      GTK_SIGNAL_FUNC (on_grd_cron_click_column),
                      NULL);
  gtk_signal_connect_after (GTK_OBJECT (grd_cron), "click_column",
                            GTK_SIGNAL_FUNC (on_grd_cron_click_column_after),
                            NULL);
  gtk_clist_set_column_width (GTK_CLIST (grd_cron), 0, 65);
  gtk_clist_set_column_width (GTK_CLIST (grd_cron), 1, 61);
  gtk_clist_set_column_width (GTK_CLIST (grd_cron), 2, 80);
  gtk_clist_set_column_width (GTK_CLIST (grd_cron), 3, 57);
  gtk_clist_set_column_width (GTK_CLIST (grd_cron), 4, 80);
  gtk_clist_set_column_width (GTK_CLIST (grd_cron), 5, 80);
  gtk_clist_column_titles_show (GTK_CLIST (grd_cron));

  label3 = gtk_label_new ("Minute");
  gtk_object_set_data (GTK_OBJECT (win_main), "label3", label3);
  gtk_widget_show (label3);
  gtk_clist_set_column_widget (GTK_CLIST (grd_cron), 0, label3);

  label4 = gtk_label_new ("Hour");
  gtk_object_set_data (GTK_OBJECT (win_main), "label4", label4);
  gtk_widget_show (label4);
  gtk_clist_set_column_widget (GTK_CLIST (grd_cron), 1, label4);

  label5 = gtk_label_new ("Day of month");
  gtk_object_set_data (GTK_OBJECT (win_main), "label5", label5);
  gtk_widget_show (label5);
  gtk_clist_set_column_widget (GTK_CLIST (grd_cron), 2, label5);

  label6 = gtk_label_new ("Month");
  gtk_object_set_data (GTK_OBJECT (win_main), "label6", label6);
  gtk_widget_show (label6);
  gtk_clist_set_column_widget (GTK_CLIST (grd_cron), 3, label6);

  label7 = gtk_label_new ("Day of week");
  gtk_object_set_data (GTK_OBJECT (win_main), "label7", label7);
  gtk_widget_show (label7);
  gtk_clist_set_column_widget (GTK_CLIST (grd_cron), 4, label7);

  label8 = gtk_label_new ("Action");
  gtk_object_set_data (GTK_OBJECT (win_main), "label8", label8);
  gtk_widget_show (label8);
  gtk_clist_set_column_widget (GTK_CLIST (grd_cron), 5, label8);

  hbuttonbox2 = gtk_hbutton_box_new ();
  gtk_object_set_data (GTK_OBJECT (win_main), "hbuttonbox2", hbuttonbox2);
  gtk_widget_show (hbuttonbox2);
  gtk_box_pack_start (GTK_BOX (vbox3), hbuttonbox2, FALSE, TRUE, 1);
  gtk_container_border_width (GTK_CONTAINER (hbuttonbox2), 1);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox2), GTK_BUTTONBOX_END);
  gtk_button_box_set_child_ipadding (GTK_BUTTON_BOX (hbuttonbox2), 8, 0);

  btn_addline = gtk_button_new ();
  gtk_object_set_data (GTK_OBJECT (win_main), "btn_addline", btn_addline);
  gtk_widget_show (btn_addline);
  gtk_container_add (GTK_CONTAINER (hbuttonbox2), btn_addline);
  gtk_tooltips_set_tip (tooltips, btn_addline, "Add an empty crontab line", NULL);
  gtk_signal_connect (GTK_OBJECT (btn_addline), "clicked",
                      GTK_SIGNAL_FUNC (on_btn_addline_clicked),
                      NULL);

  vbox7 = gtk_vbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (win_main), "vbox7", vbox7);
  gtk_widget_show (vbox7);
  gtk_container_add (GTK_CONTAINER (btn_addline), vbox7);

  pixmap1 = create_pixmap (win_main, "add.xpm");
  if (pixmap1 == NULL)
    g_error ("Couldn't create pixmap");
  gtk_object_set_data (GTK_OBJECT (win_main), "pixmap1", pixmap1);
  gtk_widget_show (pixmap1);
  gtk_box_pack_start (GTK_BOX (vbox7), pixmap1, TRUE, TRUE, 0);

  label14 = gtk_label_new ("Add new");
  gtk_object_set_data (GTK_OBJECT (win_main), "label14", label14);
  gtk_widget_show (label14);
  gtk_box_pack_start (GTK_BOX (vbox7), label14, TRUE, TRUE, 0);

  btn_delline = gtk_button_new ();
  gtk_object_set_data (GTK_OBJECT (win_main), "btn_delline", btn_delline);
  gtk_widget_show (btn_delline);
  gtk_container_add (GTK_CONTAINER (hbuttonbox2), btn_delline);
  gtk_tooltips_set_tip (tooltips, btn_delline, "Delete current selected line", NULL);
  gtk_signal_connect (GTK_OBJECT (btn_delline), "clicked",
                      GTK_SIGNAL_FUNC (on_btn_delline_clicked),
                      NULL);

  vbox8 = gtk_vbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (win_main), "vbox8", vbox8);
  gtk_widget_show (vbox8);
  gtk_container_add (GTK_CONTAINER (btn_delline), vbox8);

  pixmap2 = create_pixmap (win_main, "del.xpm");
  if (pixmap2 == NULL)
    g_error ("Couldn't create pixmap");
  gtk_object_set_data (GTK_OBJECT (win_main), "pixmap2", pixmap2);
  gtk_widget_show (pixmap2);
  gtk_box_pack_start (GTK_BOX (vbox8), pixmap2, TRUE, TRUE, 0);

  label15 = gtk_label_new ("Delete");
  gtk_object_set_data (GTK_OBJECT (win_main), "label15", label15);
  gtk_widget_show (label15);
  gtk_box_pack_start (GTK_BOX (vbox8), label15, TRUE, TRUE, 0);

  stb_main = gtk_statusbar_new ();
  gtk_object_set_data (GTK_OBJECT (win_main), "stb_main", stb_main);
  gtk_widget_show (stb_main);
  gtk_box_pack_start (GTK_BOX (vbox3), stb_main, FALSE, TRUE, 0);

  gtk_object_set_data (GTK_OBJECT (win_main), "tooltips", tooltips);

  return win_main;
}

GtkWidget*
create_dlg_command ()
{
  GtkWidget *dlg_command;
  GtkWidget *dialog_vbox1;
  GtkWidget *frame2;
  GtkWidget *hbox6;
  GtkWidget *vbox4;
  GSList *vbox4_group = NULL;
  GtkWidget *rbt_command;
  GtkWidget *rbt_file;
  GtkWidget *edt_command;
  GtkWidget *btn_xtra;
  GtkWidget *dialog_action_area1;
  GtkWidget *hbuttonbox3;
  GtkWidget *btn_acceptcmd;
  GtkWidget *btn_cancelcmd;

  dlg_command = gtk_dialog_new ();
  gtk_object_set_data (GTK_OBJECT (dlg_command), "dlg_command", dlg_command);
  gtk_widget_set_usize (dlg_command, 407, -2);
  gtk_window_set_title (GTK_WINDOW (dlg_command), "Command set");
  gtk_window_set_policy (GTK_WINDOW (dlg_command), TRUE, TRUE, FALSE);

  dialog_vbox1 = GTK_DIALOG (dlg_command)->vbox;
  gtk_object_set_data (GTK_OBJECT (dlg_command), "dialog_vbox1", dialog_vbox1);
  gtk_widget_show (dialog_vbox1);

  frame2 = gtk_frame_new (NULL);
  gtk_object_set_data (GTK_OBJECT (dlg_command), "frame2", frame2);
  gtk_widget_show (frame2);
  gtk_box_pack_start (GTK_BOX (dialog_vbox1), frame2, TRUE, TRUE, 0);

  hbox6 = gtk_hbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (dlg_command), "hbox6", hbox6);
  gtk_widget_show (hbox6);
  gtk_container_add (GTK_CONTAINER (frame2), hbox6);
  gtk_container_border_width (GTK_CONTAINER (hbox6), 6);

  vbox4 = gtk_vbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (dlg_command), "vbox4", vbox4);
  gtk_widget_show (vbox4);
  gtk_box_pack_start (GTK_BOX (hbox6), vbox4, FALSE, TRUE, 0);

  rbt_command = gtk_radio_button_new_with_label (vbox4_group, "Command");
  vbox4_group = gtk_radio_button_group (GTK_RADIO_BUTTON (rbt_command));
  gtk_object_set_data (GTK_OBJECT (dlg_command), "rbt_command", rbt_command);
  gtk_widget_show (rbt_command);
  gtk_box_pack_start (GTK_BOX (vbox4), rbt_command, TRUE, TRUE, 0);

  rbt_file = gtk_radio_button_new_with_label (vbox4_group, "File");
  vbox4_group = gtk_radio_button_group (GTK_RADIO_BUTTON (rbt_file));
  gtk_object_set_data (GTK_OBJECT (dlg_command), "rbt_file", rbt_file);
  gtk_widget_show (rbt_file);
  gtk_box_pack_start (GTK_BOX (vbox4), rbt_file, TRUE, TRUE, 0);

  edt_command = gtk_entry_new ();
  gtk_object_set_data (GTK_OBJECT (dlg_command), "edt_command", edt_command);
  gtk_widget_show (edt_command);
  gtk_box_pack_start (GTK_BOX (hbox6), edt_command, TRUE, TRUE, 6);

  btn_xtra = gtk_button_new_with_label ("...");
  gtk_object_set_data (GTK_OBJECT (dlg_command), "btn_xtra", btn_xtra);
  gtk_widget_show (btn_xtra);
  gtk_box_pack_start (GTK_BOX (hbox6), btn_xtra, FALSE, FALSE, 0);
  gtk_widget_set_usize (btn_xtra, 23, -2);
  gtk_signal_connect (GTK_OBJECT (btn_xtra), "clicked",
                      GTK_SIGNAL_FUNC (on_btn_xtra_clicked),
                      NULL);

  dialog_action_area1 = GTK_DIALOG (dlg_command)->action_area;
  gtk_object_set_data (GTK_OBJECT (dlg_command), "dialog_action_area1", dialog_action_area1);
  gtk_widget_show (dialog_action_area1);
  gtk_container_border_width (GTK_CONTAINER (dialog_action_area1), 10);

  hbuttonbox3 = gtk_hbutton_box_new ();
  gtk_object_set_data (GTK_OBJECT (dlg_command), "hbuttonbox3", hbuttonbox3);
  gtk_widget_show (hbuttonbox3);
  gtk_box_pack_start (GTK_BOX (dialog_action_area1), hbuttonbox3, TRUE, TRUE, 0);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox3), GTK_BUTTONBOX_SPREAD);

  btn_acceptcmd = gtk_button_new_with_label ("Accept");
  gtk_object_set_data (GTK_OBJECT (dlg_command), "btn_acceptcmd", btn_acceptcmd);
  gtk_widget_show (btn_acceptcmd);
  gtk_container_add (GTK_CONTAINER (hbuttonbox3), btn_acceptcmd);
  gtk_signal_connect (GTK_OBJECT (btn_acceptcmd), "clicked",
                      GTK_SIGNAL_FUNC (on_btn_acceptcmmd_clicked),
                      NULL);

  btn_cancelcmd = gtk_button_new_with_label ("Cancel");
  gtk_object_set_data (GTK_OBJECT (dlg_command), "btn_cancelcmd", btn_cancelcmd);
  gtk_widget_show (btn_cancelcmd);
  gtk_container_add (GTK_CONTAINER (hbuttonbox3), btn_cancelcmd);
  gtk_signal_connect (GTK_OBJECT (btn_cancelcmd), "clicked",
                      GTK_SIGNAL_FUNC (on_btn_cancelcmd_clicked),
                      NULL);

  return dlg_command;
}

GtkWidget*
create_win_edit ()
{
  GtkWidget *win_edit;
  GtkWidget *vbox5;
  GtkWidget *scrolledwindow2;
  GtkWidget *edt_text;
  GtkWidget *hbuttonbox6;
  GtkWidget *btn_close;

  win_edit = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_object_set_data (GTK_OBJECT (win_edit), "win_edit", win_edit);
  gtk_widget_set_usize (win_edit, 400, 400);
  gtk_window_set_policy (GTK_WINDOW (win_edit), TRUE, TRUE, FALSE);

  vbox5 = gtk_vbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (win_edit), "vbox5", vbox5);
  gtk_widget_show (vbox5);
  gtk_container_add (GTK_CONTAINER (win_edit), vbox5);

  scrolledwindow2 = gtk_scrolled_window_new (NULL, NULL);
  gtk_object_set_data (GTK_OBJECT (win_edit), "scrolledwindow2", scrolledwindow2);
  gtk_widget_show (scrolledwindow2);
  gtk_box_pack_start (GTK_BOX (vbox5), scrolledwindow2, TRUE, TRUE, 0);

  edt_text = gtk_text_new (NULL, NULL);
  gtk_object_set_data (GTK_OBJECT (win_edit), "edt_text", edt_text);
  gtk_widget_show (edt_text);
  gtk_container_add (GTK_CONTAINER (scrolledwindow2), edt_text);
  gtk_widget_set_usize (edt_text, 400, 400);
  gtk_signal_connect (GTK_OBJECT (edt_text), "changed",
                      GTK_SIGNAL_FUNC (on_edt_text_changed),
                      NULL);
  gtk_text_set_editable (GTK_TEXT (edt_text), TRUE);

  hbuttonbox6 = gtk_hbutton_box_new ();
  gtk_object_set_data (GTK_OBJECT (win_edit), "hbuttonbox6", hbuttonbox6);
  gtk_widget_show (hbuttonbox6);
  gtk_box_pack_start (GTK_BOX (vbox5), hbuttonbox6, FALSE, TRUE, 0);

  btn_close = gtk_button_new_with_label ("Close");
  gtk_object_set_data (GTK_OBJECT (win_edit), "btn_close", btn_close);
  gtk_widget_show (btn_close);
  gtk_container_add (GTK_CONTAINER (hbuttonbox6), btn_close);
  gtk_signal_connect (GTK_OBJECT (btn_close), "clicked",
                      GTK_SIGNAL_FUNC (on_btn_close_clicked),
                      NULL);

  return win_edit;
}

GtkWidget*
create_win_filesel (GtkSignalFunc cb)
{
  GtkWidget *win_filesel;
  GtkWidget *ok_button1;
  GtkWidget *cancel_button1;

  win_filesel = gtk_file_selection_new ("File select");
  gtk_object_set_data (GTK_OBJECT (win_filesel), "win_filesel", win_filesel);
  gtk_container_border_width (GTK_CONTAINER (win_filesel), 10);

  ok_button1 = GTK_FILE_SELECTION (win_filesel)->ok_button;
  gtk_object_set_data (GTK_OBJECT (win_filesel), "ok_button1", ok_button1);
  gtk_widget_show (ok_button1);
  GTK_WIDGET_SET_FLAGS (ok_button1, GTK_CAN_DEFAULT);
  gtk_signal_connect (GTK_OBJECT (ok_button1), "clicked",
                      GTK_SIGNAL_FUNC (cb),
                      win_filesel);

  cancel_button1 = GTK_FILE_SELECTION (win_filesel)->cancel_button;
  gtk_object_set_data (GTK_OBJECT (win_filesel), "cancel_button1", cancel_button1);
  gtk_widget_show (cancel_button1);
  GTK_WIDGET_SET_FLAGS (cancel_button1, GTK_CAN_DEFAULT);
  gtk_signal_connect (GTK_OBJECT (cancel_button1), "clicked",
                      GTK_SIGNAL_FUNC (on_cancel_button1_clicked),
                      NULL);

  return win_filesel;
}


GtkWidget*
create_win_msg (char *title,char *msg)
{
  GtkWidget *win_msg;
  GtkWidget *vbox6;
  GtkWidget *lbl_msg;
  GtkWidget *hbuttonbox7;
  GtkWidget *btn_msgok;

  win_msg = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_object_set_data (GTK_OBJECT (win_msg), "win_msg", win_msg);
  gtk_window_set_title (GTK_WINDOW (win_msg), title);
  gtk_window_set_policy (GTK_WINDOW (win_msg), TRUE, TRUE, FALSE);

  vbox6 = gtk_vbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (win_msg), "vbox6", vbox6);
  gtk_widget_show (vbox6);
  gtk_container_add (GTK_CONTAINER (win_msg), vbox6);

  lbl_msg = gtk_label_new (msg);
  gtk_object_set_data (GTK_OBJECT (win_msg), "lbl_msg", lbl_msg);
  gtk_widget_show (lbl_msg);
  gtk_box_pack_start (GTK_BOX (vbox6), lbl_msg, TRUE, TRUE, 0);

  hbuttonbox7 = gtk_hbutton_box_new ();
  gtk_object_set_data (GTK_OBJECT (win_msg), "hbuttonbox7", hbuttonbox7);
  gtk_widget_show (hbuttonbox7);
  gtk_box_pack_start (GTK_BOX (vbox6), hbuttonbox7, FALSE, TRUE, 3);

  btn_msgok = gtk_button_new_with_label ("Dismiss");
  gtk_object_set_data (GTK_OBJECT (win_msg), "btn_msgok", btn_msgok);
  gtk_widget_show (btn_msgok);
  gtk_container_add (GTK_CONTAINER (hbuttonbox7), btn_msgok);
  gtk_signal_connect (GTK_OBJECT (btn_msgok), "clicked",
                      GTK_SIGNAL_FUNC (on_btn_msgok_clicked),
                      NULL);

  return win_msg;
}

GtkWidget*
create_win_cal ()
{
  GtkWidget *win_cal;
  GtkWidget *vbox7;
  GtkWidget *cal_selday;
  GtkWidget *hbuttonbox8;
  GtkWidget *btn_okcal;
  GtkWidget *btn_cancelcal;

  win_cal = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_object_set_data (GTK_OBJECT (win_cal), "win_cal", win_cal);
  gtk_window_set_title (GTK_WINDOW (win_cal), "Calendar");
  gtk_window_set_policy (GTK_WINDOW (win_cal), TRUE, TRUE, FALSE);

  vbox7 = gtk_vbox_new (FALSE, 0);
  gtk_object_set_data (GTK_OBJECT (win_cal), "vbox7", vbox7);
  gtk_widget_show (vbox7);
  gtk_container_add (GTK_CONTAINER (win_cal), vbox7);

  cal_selday = gtk_calendar_new ();
  gtk_object_set_data (GTK_OBJECT (win_cal), "cal_selday", cal_selday);
  gtk_widget_show (cal_selday);
  gtk_box_pack_start (GTK_BOX (vbox7), cal_selday, TRUE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (cal_selday), "day_selected",
                      GTK_SIGNAL_FUNC (on_cal_selday_day_selected),
                      NULL);
  gtk_calendar_display_options (GTK_CALENDAR (cal_selday),GTK_CALENDAR_SHOW_HEADING | GTK_CALENDAR_SHOW_DAY_NAMES);
  hbuttonbox8 = gtk_hbutton_box_new ();
  gtk_object_set_data (GTK_OBJECT (win_cal), "hbuttonbox8", hbuttonbox8);
  gtk_widget_show (hbuttonbox8);
  gtk_box_pack_start (GTK_BOX (vbox7), hbuttonbox8, FALSE, TRUE, 4);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox8), GTK_BUTTONBOX_SPREAD);

  btn_okcal = gtk_button_new_with_label ("Accept");
  gtk_object_set_data (GTK_OBJECT (win_cal), "btn_okcal", btn_okcal);
  gtk_widget_show (btn_okcal);
  gtk_container_add (GTK_CONTAINER (hbuttonbox8), btn_okcal);
  gtk_signal_connect (GTK_OBJECT (btn_okcal), "clicked",
                      GTK_SIGNAL_FUNC (on_btn_okcal_clicked),
                      NULL);

  btn_cancelcal = gtk_button_new_with_label ("Cancel");
  gtk_object_set_data (GTK_OBJECT (win_cal), "btn_cancelcal", btn_cancelcal);
  gtk_widget_show (btn_cancelcal);
  gtk_container_add (GTK_CONTAINER (hbuttonbox8), btn_cancelcal);
  gtk_signal_connect (GTK_OBJECT (btn_cancelcal), "clicked",
                      GTK_SIGNAL_FUNC (on_btn_cancelcal_clicked),
                      NULL);

  return win_cal;
}

