from libdesklets.controls import Control

from ICountdown2 import ICountdown2

try:
	from datetime import datetime
	import os

except ImportError, error:
	print("*** ERROR ***")
	print("Unable to import required modules: %s" % error)
	print("*** ERROR ***")
	print("")
except Exception, error:
	print("*** ERROR ***")
	print("Unknown error: %s" % error)
	print("*** ERROR ***")
#end try


#
# Control for time-related stuff.
#
class Countdown2(Control, ICountdown2):

	def __init__(self):

		Control.__init__(self)

	def __get_diff(self):

		targettime = datetime(self.__year, self.__month, self.__day, int(self.__time[0:2]), int(self.__time[3:5]))

		if(self.__type == "0"):

			delta = targettime - datetime.now()

		else:

			delta = datetime.now() - targettime

		difftime = (delta.days * 3600 * 24) + delta.seconds

		return difftime

	def __set_year(self, year):

		self.__year = int(year)

	def __set_month(self, month):

		self.__month = int(month)

	def __set_day(self, day):

		self.__day = int(day)

	def __set_time(self, time):

		self.__time = time

	def __set_type(self, cnttype):

		self.__type = cnttype


	year = property(fset = __set_year, doc="the year")
	month = property(fset = __set_month, doc="the month")
	day = property(fset = __set_day, doc="the day")
	time = property(fset = __set_time, doc="the time")
	cnttype = property(fset = __set_type, doc="the type")
	diff = property(fget = __get_diff, doc="the diff-time")

def get_class(): return Countdown2

