/* Functions for setting EWMH flags on windows.
 * Copyright (C) 2003, 2004 Martin Grimme
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#include "utils.h"

#include <gdk/gdk.h>
#include <gdk/gdkx.h>

#include <X11/Xatom.h>


#define _NET_WM_STATE_REMOVE        0    /* remove/unset property */
#define _NET_WM_STATE_ADD           1    /* add/set property */

#define ATOM(name) gdk_x11_get_xatom_by_name(name)

PyMODINIT_FUNC initewmh(void);

static void
_change_state (GdkNativeWindow window, gboolean add, const gchar* atom,
	       const gchar* state1, const gchar* state2)
{
  XEvent xev;

  xev.type = ClientMessage;
  xev.xclient.type = ClientMessage;
  xev.xclient.window = window;
  xev.xclient.message_type = ATOM(atom);
  xev.xclient.format = 32;
  xev.xclient.data.l[0] = add ? _NET_WM_STATE_ADD : _NET_WM_STATE_REMOVE;
  xev.xclient.data.l[1] = ATOM(state1);
  xev.xclient.data.l[2] = state2 ? (long)state2 : 0;

  XSendEvent(GDK_DISPLAY(), GDK_ROOT_WINDOW(), False,
	     SubstructureNotifyMask, &xev);
}



static PyObject* set_above(PyObject *self, PyObject *args)
{
  int value;
  GdkWindow *window;

  if(!PyArg_ParseTuple(args, "O&i", parse_gdk_window, &window, &value))
    return NULL;

  _change_state(GDK_WINDOW_XID(window), (gboolean) value, "_NET_WM_STATE",
		"_NET_WM_STATE_ABOVE", NULL);

  Py_INCREF(Py_None);
  return Py_None;
}



static PyObject* set_below(PyObject *self, PyObject *args)
{
  int value;
  GdkWindow *window;

  if(!PyArg_ParseTuple(args, "O&i", parse_gdk_window, &window, &value))
      return NULL;

  _change_state(GDK_WINDOW_XID(window), (gboolean) value, "_NET_WM_STATE",
		"_NET_WM_STATE_BELOW", NULL);

  Py_INCREF(Py_None);
  return Py_None;
}



static PyObject* set_type_dock(PyObject *self, PyObject *args)
{
  int value;
  GdkWindow *window;

  if(!PyArg_ParseTuple(args, "O&i", parse_gdk_window, &window, &value))
    return NULL;

  if (value)
    gdk_window_set_type_hint(window, GDK_WINDOW_TYPE_HINT_DOCK);
  else
    gdk_window_set_type_hint(window, GDK_WINDOW_TYPE_HINT_NORMAL);

  Py_INCREF(Py_None);
  return Py_None;
}



PyMODINIT_FUNC
initewmh(void)
{
  static const PyMethodDef methods[] =
    {
      {"set_above", set_above, METH_VARARGS, NULL},
      {"set_below", set_below, METH_VARARGS, NULL},
      {"set_type_dock", set_type_dock, METH_VARARGS, NULL},
      {NULL, NULL, 0, NULL}
    };

  if(!gdesklets_get_pygobject_type())
    return;

  Py_InitModule("ewmh", (PyMethodDef*) methods);
}
