/*****************************************************************************
 *    copyright notice for MARVIN'S program
 *****************************************************************************
 *
 *    Copyright (c) 1993
 *    David H. Gay and Andrew L. Rohl 
 *    The Royal Institution of Great Britain
 *    21 Albemarle Street
 *    London, W1X 4BS
 *    UK
 *
 *    e-mail  dgay@ricx.royal-institution.ac.uk
 *            andrew@ricx.royal-institution.ac.uk
 *
 *    Permission to distribute the executable and program documentation is
 *    granted to any individual or institutions provided it is not sold for
 *    profit.  The source code may NOT be modified or distributed in any 
 *    form without the express permission of the authors.
 *
 *****************************************************************************
 *
 *    This software is provided "as is" without any expressed or implied
 *    warranty.
 *
 *****************************************************************************/

/******************************************************************************
 * table.h
 *  Macros for manipulating tables which are structures of the following form
 *    struct {	
 *      gint n_elements;
 *		gint n_alloced;
 *		data	*;
 *	     }
 *****************************************************************************/
#ifndef _TABLE_H
#define _TABLE_H

#define	TAB_ALLOC	32

#define	TABLE_TYPEDEF(ELEM_TYPE)	\
	typedef struct { 	\
		gint	n_elements;	\
		gint	n_alloced;	\
		ELEM_TYPE	*data;	\
	}

#define	TABLE_ELEMENT(TAB, N, FIELD)	(TAB).data[(N)].FIELD
#define	TABLE_RECORD(TAB, N)		(TAB).data[(N)]
#define	TABLE_R_ADRS(TAB, N)		(&((TAB).data[(N)]))
#define	TABLE_e_ADRS(TAB, N, FIELD)	(&((TAB).data[(N)].FIELD))
#define	TABLE_N(TAB)		 	((TAB).n_elements)
#define TABLE_MAX(TAB)                  ((TAB).n_alloced)
#define	TABLE_INDEX(TAB,PTR) 		(PTR - (TAB).data)
#define EOTAB(TAB)			(((TAB).data)+((TAB).n_elements))
	
#define	TABLE_INIT(TAB) { 	\
	(TAB).n_elements = 0;	\
	(TAB).n_alloced  = 0;	\
	(TAB).data       = NULL;	\
	}

#define	TABLE_FREE(TAB) { 	\
	(TAB).n_elements = 0;	\
	(TAB).n_alloced  = 0;	\
	g_free((TAB).data);		\
	}

#define TABLE_ADD_RECORD(TAB, REC) {	\
	if ((TAB).n_elements >= (TAB).n_alloced)	{	\
		(TAB).n_alloced += TAB_ALLOC;	\
		(TAB).data = (void *)our_alloc((TAB).data, sizeof(REC)*(TAB).n_alloced, #TAB); 	\
	}	\
	memcpy(&(TAB).data[(TAB).n_elements],&REC,sizeof(REC));	\
	(TAB).n_elements++;	\
}

#define TABLE_REPLACE_RECORD(TAB, REC, N) { \
	if (N >= TABLE_N(TAB)) {	\
		TABLE_ADD_RECORD(TAB, REC)	\
	}	\
	else {	\
		memcpy(&((TAB).data[(N)]),&REC,sizeof(REC));	\
	}	\
}	

#define TABLE_ALLOCATE_RECORDS(TAB, N_REC) {	\
       	 (TAB).n_elements = N_REC;	\
	 (TAB).n_alloced  = N_REC;	\
	 (TAB).data = (void *)our_alloc((TAB).data, sizeof(*(TAB).data)*(TAB).n_alloced, #TAB); 	\
}

/*
 *	TABLE_DELETE_RECORDS deletes N elements starting with START
 *	this macro will not delete past the end of the list
 *	and will not delete any if the START is past the end of the list
 */
#define TABLE_DEL_RECORDS(TAB, START, N) {	\
	gint _ta_nmov, _ta_ndel; \
	_ta_ndel = START + N <= EOTAB(TAB) ? N : EOTAB(TAB) - START;	\
	_ta_nmov = EOTAB(TAB) - START - _ta_ndel;	\
	if (START >= EOTAB(TAB)) _ta_ndel = 0, _ta_nmov = 0;	\
	if (_ta_nmov > 0) {	\
		memmove(START,START+_ta_ndel,_ta_nmov*sizeof((TAB).data[0]));	\
	}	\
	(TAB).n_elements -= _ta_ndel;	\
}

#define TABLE_CROP(TAB) {	\
	if ((TAB).n_elements > (TAB).n_alloced) { \
		(TAB).n_alloced = (TAB).n_elements;	\
		(TAB).data = (void *)our_alloc((TAB).data, sizeof((TAB).data[0])*(TAB).n_alloced, #TAB);	\
	} \
}

#define TABLE_SORT(TAB, COMP) { \
	qsort((TAB).data, (TAB).n_elements, sizeof((TAB).data[0]), COMP);	\
}

#define TABLE_SWAP_RECORDS(A,B) { \
	void *T; \
	T = our_alloc(T, sizeof(*A), #A); \
	if (T == NULL) { \
		fprintf(stderr, "malloc failed\n"); \
		exit (1); \
	} \
	memmove(T, B, sizeof(*A)); \
	memmove(B, A, sizeof(*A)); \
	memmove(A, T, sizeof(*A)); \
	g_free(T); \
}

#define	TABLE_FIND(TAB, TEST, PTR) {	\
	gint	i;	\
	PTR = NULL;	\
	for (i = 0; i < (TAB).n_elements; i++) {	\
		PTR = &(TAB).data[i];	\
		if (TEST) \
			break;	\
		\
		PTR = NULL; \
	}	\
}

#define	TABLECPY(TO,FROM) { \
	TO.n_elements = FROM.n_elements; \
	TO.n_alloced  = FROM.n_elements; \
	(TO).data = (void *)our_alloc((TO).data, sizeof((TO).data[0])*(TO).n_alloced, #TO);	\
	memcpy(&(TO).data[0],&(FROM).data[0],(TO).n_elements*sizeof((TO).data[0]));	\
}

#define TABLE_FOREACH(TAB, IDX) for (IDX = (TAB).data; IDX < EOTAB(TAB); IDX++)
#define TABLE_WHILEEACH(TAB, IDX) for (; IDX < EOTAB(TAB); IDX++)
#define TABLE_WHILE(TAB, COND, IDX) for (; (IDX < EOTAB(TAB)) && (COND); IDX++)

#ifdef _VECTOR_H
TABLE_TYPEDEF(vector)  vector_array;
#endif

#endif		/* _TABLE_H */
