/* gdkxft - Provide Xft font support in gdk
 * Copyright (C) 2001 Josh Parsons
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>
#include <glade/glade.h>
#include <capplet-widget.h>
#include "gdkxftcfg.h"

static GtkWidget *capplet=NULL,*frame=NULL;
static GladeXML *gxml=NULL;

void
changed(void)
{
  capplet_widget_state_changed(CAPPLET_WIDGET(capplet),TRUE);
}

static void
do_revert(GtkWidget *capplet,gpointer user_data)
{
  read_cfg();
}

static void
do_ok(GtkWidget *capplet,gpointer user_data)
{
  write_cfg();
}

int
main (int argc, char **argv)
{
  if (gnome_capplet_init ("gdkxft-capplet", VERSION, argc,
			  argv, NULL, 0, NULL) != 0)
    return 1;

  glade_gnome_init();

  /* set up the glade interface */
  gxml = glade_xml_new(DATADIR "/gdkxft-capplet.glade","gdkxft");
  g_assert(gxml!=NULL);
  glade_xml_signal_autoconnect(gxml);
  frame=glade_xml_get_widget(gxml,"gdkxft");
  g_assert(frame!=NULL);

  /* look for the clists */
  good_font_clist=GTK_CLIST(glade_xml_get_widget(gxml,
						 "good_font_clist"));
  bad_font_clist= GTK_CLIST(glade_xml_get_widget(gxml,
						 "bad_font_clist"));
  bad_app_clist=  GTK_CLIST(glade_xml_get_widget(gxml,
						 "bad_app_clist"));
  g_assert(good_font_clist!=NULL);
  g_assert(bad_font_clist!=NULL);
  g_assert(bad_app_clist!=NULL);

  /* revert to start us off */
  read_cfg();

  /* hook up to control center */
  capplet = capplet_widget_new();
  gtk_container_add(GTK_CONTAINER(capplet),frame);

  gtk_signal_connect (GTK_OBJECT (capplet), "revert",
		      GTK_SIGNAL_FUNC (do_revert), NULL);
  /*gtk_signal_connect (GTK_OBJECT (capplet), "try",
    GTK_SIGNAL_FUNC (do_try), NULL);*/
  gtk_signal_connect (GTK_OBJECT (capplet), "ok",
		      GTK_SIGNAL_FUNC (do_ok), NULL);

  /* go! */
  gtk_widget_show_all(GTK_WIDGET(capplet));
  capplet_gtk_main ();

  return 0;
}
