
/*
   geas - GNU Enterprise Application Server
 
   Copyright (C) 2000 Free Software Foundation
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
 
*/

#ifndef CONNECTION_H
#define CONNECTION_H

#include "geas-skeleton.h"

CORBA_char *Connection__get_currentUserID(GEAS_object_reference * id,
      CORBA_Environment * ev);

GEAS_classnames *Connection__get_classes(GEAS_object_reference * id,
      CORBA_Environment * ev);
GEAS_classlist *Connection__get_schema(GEAS_object_reference * id,
                                       CORBA_Environment * ev);
GEAS_ClassDefinition *Connection_getClassDefinition(GEAS_object_reference * id,
      CORBA_char * classname,
      CORBA_Environment * ev);
GEAS_ClassDefinition *Connection_getFullClassDefinition(GEAS_object_reference *
      id,
      CORBA_char * classname,
      CORBA_Environment * ev);
GEAS_LookupOptions *Connection_getLookupFieldOptions(GEAS_object_reference *
      id, CORBA_char * classname,
      CORBA_char * fieldname,
      CORBA_Environment * ev);
CORBA_boolean Connection_supportsFeature(GEAS_object_reference * id,
      GEAS_Feature featureID,
      CORBA_Environment * ev);
GEAS_DataObject Connection_newObject(GEAS_object_reference * id,
                                     CORBA_char * classname,
                                     CORBA_Environment * ev);
GEAS_ObjectList Connection_newEmptyList(GEAS_object_reference * id,
                                     CORBA_char * classname,
                                     CORBA_Environment * ev);

GEAS_ObjectList Connection_loadObjects(GEAS_object_reference * id,
                                       CORBA_char * classname,
                                       CORBA_char * fieldname,
                                       CORBA_char * searchvalue,
                                       CORBA_Environment * ev);
GEAS_ObjectList Connection_loadAll(GEAS_object_reference * id,
                                   CORBA_char * classname,
                                   CORBA_Environment * ev);
GEAS_ObjectList Connection_loadSingleObject(GEAS_object_reference * id,
      CORBA_char * classname,
      CORBA_char * fieldname,
      CORBA_char * searhvalue,
      CORBA_Environment * ev);

void Connection_logout(GEAS_object_reference * id, CORBA_Environment * ev);
void Connection_flush(GEAS_object_reference * id, CORBA_Environment * ev);

CORBA_boolean Connection_supportsFeature(GEAS_object_reference * id,
      GEAS_Feature featureID,
      CORBA_Environment * ev);

GEAS_Query_Query
Connection_newQuery(GEAS_object_reference * id, CORBA_Environment * ev);

GEAS_ObjectList
Connection_executeQuery(GEAS_object_reference * id,
                        GEAS_Query_Query querytoperform,
                        CORBA_Environment * ev);

void Connection_realNewObject(GEAS_object_reference * id);

GEAS_LoadDefinition *
Connection_getReferenceDefinition(GEAS_object_reference * id,
				  CORBA_char * classname,
				  CORBA_char * fieldname,
				  CORBA_Environment * ev);

CORBA_unsigned_long
Connection_countAllInstances(GEAS_object_reference * id,
			     CORBA_char * classname,
			     CORBA_Environment * ev);

/* did I say you should use this? no, I didn't. so don't. */
void Connection_clearCache(GEAS_object_reference * id,CORBA_Environment * ev);
void Connection_activateEventLog(GEAS_object_reference * id,CORBA_Environment * ev);
GEAS_Changes *Connection__get_latestChanges(GEAS_object_reference * id,CORBA_Environment * ev);
void Connection_logEdit( const char *classname , const char *oid , const char *fieldname , GEAS_object_reference * id );
void Connection_logDelete(const char *classname, const char *oid, GEAS_object_reference * id);

#endif /* CONNECTION_H */
