/*
   datamonitor.h - Database communication monitoring

   Copyright (C) 2001 Free Software Foundation

   This file is part of the GNU Enterprise Application Server (GEAS)

   GEAS is free software; you can redistribute it and/or modify it under
   the terms of the GNU General Public License as published by the Free
   Software Foundation; either version 2, or (at your option) any later
   version.

   GEAS is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
   for more details.

   You should have received a copy of the GNU General Public License
   along with GEAS; if not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   $Id: datamonitor.h,v 1.10 2001/06/10 13:12:35 ntiffin Exp $
*/

#ifndef _DATAMONITOR_H
#define _DATAMONITOR_H

#include <glib.h>

/* log everything */
#define DM_ALL                          0xffffffff

/* write events */
#define DM_EVENT_OBJECT_NEW             0x00000001 /* classname/objectid */
#define DM_EVENT_OBJECT_DELETE          0x00000002 /* classname/objectid */
#define DM_EVENT_FIELD_WRITE            0x00000004 /* classname/objectid.field = value */

/* read events */
#define DM_EVENT_FIELD_READ             0x00000008 /* classname/objectid.field */

/* transaction events */
#define DM_TRANSACTION_BEGIN            0x00000010
#define DM_TRANSACTION_COMMIT           0x00000020
#define DM_TRANSACTION_ROLLBACK         0x00000040
#define DM_TRANSACTION_CHECKPOINT       0x00000080

/* log all events */
#define DM_EVENT_ALL (DM_EVENT_OBJECT_NEW | DM_EVENT_OBJECT_DELETE | DM_EVENT_FIELD_WRITE | DM_EVENT_FIELD_READ)

/* generic logable events */
#define DM_EVENT_WARNING                0x00000100
#define DM_EVENT_ERROR                  0x00000200
#define DM_EVENT_MESSAGE                0x00000400
#define DM_EVENT_DATABASE               0x00000800

/* log all generic messages */
#define DM_MESSAGE_ALL (DM_EVENT_WARNING | DM_EVENT_ERROR | DM_EVENT_MESSAGE)

#define DM_EVENT_SECURITY_LOGON_SUCCESS 0x01000000
#define DM_EVENT_SECURITY_LOGON_FAIL    0x02000000
#define DM_EVENT_SECURITY               0x04000000

/* log all security related items */
#define DM_EVENT_ALL_SECURITY (DM_EVENT_SECURITY_LOGON_SUCCES |  DM_EVENT_SECURITY_LOGON_FAIL | DM_EVENT_SECURITY)


/* log file flags (not event types) */
#define DM_LOG_NO_TRANSACTIONS       0x00000000
#define DM_LOG_ALLOW_TRANSACTIONS    0x00000001
#define DM_LOG_REQUIRE_TRANSACTIONS  0x00000003


void init_datamonitor (void);
void close_datamonitor (void);

void add_datamonitor_logfile (const gchar *filename, guint32 events,
                              guint32 flags);

/* data access events */
void dm_event (const gchar *username, const gchar *transactionid,
               guint32 event, ...);

/* generic loggable events */
void dm_logentry (guint32 type, const gchar *username, const gchar *fmt, ...);
void dm_vlogentry (guint32 type, const gchar *username,
                   const gchar *fmt, va_list a);

#endif /* datamonitor.h */
