
/*
   dataobject.h
   
   Part of GNU Enterprise Application Server (GEAS)
 
   Copyright (C) 2000 Free Software Foundation
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
   
   $Id: dataobject.h,v 1.7 2001/06/10 12:56:12 ntiffin Exp $
   
*/

#ifndef DATAOBJECT_H
#define DATAOBJECT_H

#include "geas-skeleton.h"

GEAS_ObjectReference DataObject__get_objectID (GEAS_object_reference * id,
                                               CORBA_Environment * ev);
CORBA_boolean DataObject_ofclass (GEAS_object_reference * id,
                                  CORBA_char * classname,
                                  CORBA_Environment * ev);
CORBA_char *DataObject__get_classname (GEAS_object_reference * id,
                                       CORBA_Environment * ev);
GEAS_classnames *DataObject__get_classes (GEAS_object_reference * id,
                                          CORBA_Environment * ev);
GEAS_fieldlist *DataObject__get_allfields (GEAS_object_reference * id,
                                           CORBA_Environment * ev);
GEAS_LookupOptions *DataObject_getLookupFieldOptions (GEAS_object_reference *
                                                      id, char *field,
                                                      CORBA_Environment * ev);
void DataObject_setLookupField (GEAS_object_reference * id,
                                GEAS_LookupOption * setting,
                                CORBA_Environment * ev);
CORBA_char *DataObject_getField (GEAS_object_reference * id,
                                 CORBA_char * fieldname,
                                 CORBA_Environment * ev);
void DataObject_setField (GEAS_object_reference * id, CORBA_char * fieldname,
                          CORBA_char * value, CORBA_Environment * ev);
GEAS_DataObject DataObject_getReference (GEAS_object_reference * id,
                                         CORBA_char * fieldname,
                                         CORBA_Environment * ev);
GEAS_ObjectList DataObject_getList (GEAS_object_reference * id,
                                    CORBA_char * field,
                                    CORBA_Environment * ev);
void DataObject_insert (GEAS_object_reference * id, CORBA_char * fieldname,
                        GEAS_DataObject obj, CORBA_Environment * ev);
void DataObject_setReference (GEAS_object_reference * id,
                              CORBA_char * fieldname, GEAS_DataObject obj,
                              CORBA_Environment * ev);
void DataObject_flush (GEAS_object_reference * id, CORBA_Environment * ev);
void DataObject_delete (GEAS_object_reference * id, CORBA_Environment * ev);
CORBA_char *DataObject_callMethod (GEAS_object_reference * id,
                                   CORBA_char * methodname,
                                   GEAS_Arguments * args,
                                   CORBA_Environment * ev);

#endif /* DATAOBJECT_H */
