
/*
   objectcache.h
   
   Part of GNU Enterprise Application Server (GEAS)
 
   Copyright (C) 2001 Free Software Foundation
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
   
   $Id: objectcache.h,v 1.20 2001/06/26 03:01:26 treshna Exp $
 
*/

#include "oql/oql.h"

#ifndef OBJECTCACHE_H
#define OBJECTCACHE_H

#include "objectcache_internal.h"

/** \brief Opaque data structure for object data */
typedef struct _ObjectData ObjectData;

/* object flags */
enum object_flag
{
  of_indatabase,                /* true if all fields are stored in database */
  of_deleted                    /* true if deleted but database not updated  */
};
#define FLAG_ON  TRUE
#define FLAG_OFF FALSE


/* allocate/free cache */
void create_object_cache (guint32 max_lenght);
void free_object_cache (void);

void oc_shrink_cache (unsigned int new_max_length);
void oc_extend_cache (unsigned int new_max_length);

/* Searching */
ObjectData *oc_find_object_by_key (const char *classname, const char *key);
ObjectData *oc_find_cached_object_by_key (const char *classname,
                                          const char *key);

/* Object management */
void oc_empty_cache (void);
ObjectData *oc_add_empty_object (const char *classname, const char *key);
gboolean oc_remove_object (ObjectData * object);
gboolean oc_remove_object2(ObjectData * object); /* hack for lists */
gboolean oc_delete_object (const char *classname, const char *keystr);

const char *oc_get_object_class (ObjectData * object);
const char *oc_get_object_key (ObjectData * object);

gboolean oc_validate_object (const char *classname, const char *keystr);

void oc_flush_object_to_store (ObjectData * obj);

/* Object flags */
void oc_set_object_flag (ObjectData * object, enum object_flag flag,
                         gboolean state);
gboolean oc_get_object_flag (ObjectData * object, enum object_flag flag);


/* Data access */
char *oc_get_object_field (ObjectData * object, const char *fieldname);
gboolean oc_set_object_field (ObjectData * object, const char *fieldname,
                              const char *value, gboolean readonly);

/* only call this if the field is not part of an index */
gboolean oc_set_object_field_quick(ObjectData * object, const char *fieldname,
                              const char *value, gboolean readonly);

ObjectData *oc_search_for_single_object (_QueryData * q);
GList *oc_search_for_objects (_QueryData * q);

void  oc_set_object_userdata( ObjectData *obj , void *data );
void *oc_get_object_userdata( ObjectData *obj );

void oc_print_stats( void );

void oc_freeze( void );
void oc_thaw( void );

#endif
