/*
   SQL generation

   Copyright (C) 2001 Free Software Foundation

   This file is part of the GNU Enterprise Application Server (GEAS)

   GEAS is free software; you can redistribute it and/or modify it under
   the terms of the GNU General Public License as published by the Free
   Software Foundation; either version 2, or (at your option) any later
   version.

   GEAS is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
   for more details.

   You should have received a copy of the GNU General Public License
   along with GEAS; if not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   $Id: oql.h,v 1.30 2001/06/08 22:42:43 reinhard Exp $
*/

#ifndef _OQL_H
#define _OQL_H

#include <glib.h>
#include "classdata.h"

/* handle to a query structure */
/* FIXME: This is really a mess */
typedef void    QueryData;
typedef struct __QueryData _QueryData;

typedef enum
{
  OQL_SELECT, OQL_DELETE, OQL_WRITE
}
QueryType;

/* handle to a query structure */
/* this is needed by objectcache.c (sigh) */
struct __QueryData
{
  /* All types */
  QueryType type;
  char *sql;
  gboolean indatabase; /* used by WRITE */

  char *orderby;
  gboolean reversesearch;

  GList *conditions;
  GList *classes;
  GList *fields;
  GList *complex;

  GList *values;

  gboolean uselimit;
  unsigned int maxresults;
};

enum querytest {
     q_equals      , q_notequals ,
     q_lessthan    , q_notlessthan ,
     q_greaterthan , q_notgreaterthan ,
     q_contains    , q_notcontains ,
     q_startswith  , q_notstartswith ,
     q_endswith    , q_notendswith ,
     q_hackish /* a hack-ish flag */
};

/* fields for adding query coditions */
/* this is needed by objectcache.c (sigh) */
struct __QueryCondition
{
  char *targetclass;                 /* targetclass adding the condition to */
  char *field;                       /* condition field */
  char *relation;                    /* relation in query condition */
  char *value;                       /* condition value */
  enum querytest test;
  gboolean casesensitive;
};

typedef struct __QueryCondition _QueryCondition;

/* Database type */
typedef int     DBType;

const char     *get_last_oql_error (void);

/* get query as an ASCII text string. currently only supports GEAS
 * (objectstore) ready SQL (do not modify/free resulting string) */
const char     *oql_query_as_sql (_QueryData * query, DBType database);

/* let any part of GEAS create SQL statements. is this really a
 * good idea? somehow I really don't think so..... */
_QueryData     *oql_make_sql_query (const char *query);

/* find the classname being loaded */
const char     *oql_query_get_classname (_QueryData * query);

/* free memory associated with query (incl. ASCII strings, as above */
void            oql_free_query (_QueryData * query);

/* get field names in the order requested */
const char     *oql_query_get_field_name (_QueryData * query, int field);

/* find a field name's index by position (ie, field 'NAME' was the
   Nth selected) */
int             oql_query_get_field_position (_QueryData * query,
					      const char *fieldname);

/* create queries */

/* write data */
_QueryData     *oql_write_object (const gchar * classname, const gchar * key,
				  GHashTable * values, gboolean update);

/* delete entries */
_QueryData     *oql_delete_object (const char *classname, const char *key);
_QueryData     *oql_delete_all_objects (const char *classname,
					const char *fieldname,
					const char *key);

/* load a single object */
_QueryData     *oql_load_object_by_key (const char *classname,
					const char *key);

/* load all instances of a given class */
_QueryData     *oql_find_all_objects (const char *classname);

/* get a single field from an object */
_QueryData     *oql_load_object_field_by_key (const char *classname,
					      const char *field,
					      const char *key);

_QueryData     *oql_load_object (const char *classname);

/* make a query, then add restrictions */
#define create_base_query(classname)  oql_find_all_objects(classname)

/* WHERE (loadclass.fieldname relation value) */
gboolean        do_oql_add_query_constraint (_QueryData * query,
					     const char *loadclass,
					     const char *fieldname,
					     const char *relation,
					     const char *value,
					     enum querytest test,
					     gboolean casesensitive);

enum oql_logic
{
  oql_and, oql_or
};

typedef struct oql_field
{
  char           *field;
  enum querytest  test;
  gboolean        invert;
  char           *value;
  gboolean        casesensitive;
}
oql_field;

typedef struct oql_constraint
{
  char           *classname;
  enum oql_logic  logic;
  GList          *fields;
  GList          *constraints;
}
oql_constraint;

void            oql_limit_results (_QueryData * q, unsigned long int limit);

gboolean        oql_add_complex_constraint (_QueryData * q,
					    oql_constraint * c);

oql_field      *oql_make_field (char *field, enum querytest test, char *value,
				gboolean casesensitive, gboolean invert);
oql_constraint *oql_make_constraint (enum oql_logic logic);
void            oql_add_field (oql_constraint * c, oql_field * f);
void            oql_add_constraint (oql_constraint * c,
				    oql_constraint * addme);

/* parse OQL query and create */
_QueryData     *oql_load (const char *classname, const char *OQL_query);

/* search for objects that have a particular value in a particular field */
_QueryData     *oql_objects_field_search (const char *classname,
					  const char *field,
					  const char *value);

void            add_order_by (_QueryData * query, const char *orderby,
			      gboolean reverse);

#define OQL_DBTYPE_CACHEONLY 0
#define OQL_DBTYPE_UNKNOWN   (-1)

#define OQL_DBTYPE_MYSQL                 1	/* MySQL format quoting */
#define OQL_DBTYPE_POSTGRESQL     	 2	/* PostgreSQL format quoting */
//#define OQL_DBTYPE_POSTGRESQL_INSERT     3 /* PostgreSQL format quoting */
//#define OQL_DBTYPE_POSTGRESQL_UPDATE     4 /* PostgreSQL format quoting */

/* convert from old API to new */
#define oql_add_query_constraint(q,x,v,r,c,f) do_oql_add_query_constraint(q,c,f,r,v,q_hackish,TRUE)

char           *oql_quote_column (const char *table, const char *column,
				  DBType db);

typedef struct sql_reserved_word
{
  /* what's the word? */
  char           *word;

  /* true if reserved in a particular database */
  gboolean        mysql, postgresql;
}
_sql_reserved_word;

void            quick_reserved_word (const char *word, gboolean mysql,
				     gboolean postgresql);
void            add_reserved_word (const char *word, int dbtype,
				   gboolean reserved);
gboolean        is_word_reserved (const char *word, int dbtype);

#define SQL_RESERVED     TRUE
#define SQL_NOTRESERVED  FALSE

char           *oql_translate_for_write (char *value, odl_class *c,
					 const char *fieldname, int database);
char           *oql_translate_from_read (char *value, odl_class *c,
					 const char *fieldname, int database);

#endif /* oql.h */
