/* 
   transaction.h
   
   Part of GNU Enterprise Application Server (GEAS)

   Copyright (C) 2001 Free Software Foundation

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
   
   $Id: transaction.h,v 1.3 2001/06/10 12:56:12 ntiffin Exp $

*/

#ifndef TRANSACTION_H
#define TRANSACTION_H

/* factory methods */
GEAS_Transaction
TransactionFactory_new (GEAS_object_reference * id, CORBA_Environment * ev);

GEAS_Transaction
TransactionFactory_current (GEAS_object_reference * id,
                            CORBA_Environment * ev);

/* transaction methods */

void Transaction_begin (GEAS_object_reference * id, CORBA_Environment * ev);
void Transaction_commit (GEAS_object_reference * id, CORBA_Environment * ev);
void Transaction_abort (GEAS_object_reference * id, CORBA_Environment * ev);
void Transaction_checkpoint (GEAS_object_reference * id,
                             CORBA_Environment * ev);
void Transaction_join (GEAS_object_reference * id, CORBA_Environment * ev);
void Transaction_leave (GEAS_object_reference * id, CORBA_Environment * ev);
CORBA_boolean Transaction_isOpen (GEAS_object_reference * id,
                                  CORBA_Environment * ev);

#endif /* TRANSACTION_H */
