static char rcsid[] = "$Id: sim_check.c,v 1.5 1997/06/12 23:24:36 dhb Exp $";

/*
** $Log: sim_check.c,v $
** Revision 1.5  1997/06/12 23:24:36  dhb
** Changed simulation_dt type from float to double to avoid
** roundoff errors in float to double compares when checking
** element clocks against the simulation dt.
**
** Revision 1.4  1994/06/15 20:58:46  dhb
** Moved checking of projections into the projection CHECK actions.
** (Now in axonlib.)
**
 * Revision 1.3  1993/12/23  02:23:54  dhb
 * Changed direct call to element action function to use CallActionFunc()
 * in order to support extended objects.
 *
 * Revision 1.2  1993/02/16  22:27:21  dhb
 * 1.4 to 2.0 command argument changes.
 *
 * 	CheckSimulation (check) required no changes.
 *
 * Fixed type error in rcsid variable declaration.
 *
 * Revision 1.1  1992/10/27  19:41:41  dhb
 * Initial revision
 *
*/

#include "sim_ext.h"

/*
** check the consistency of the time intervals for the 
** buffers projections and segments
*/
CheckSimulation()
{
Element			*element;
Projection 		*projection;
Buffer			*buffer;
Connection 		*connection;
int			j,k;
ElementStack		*stk;
double 			simulation_dt;
PFI 			func;
Action			*action;

    Reschedule();
    simulation_dt = ClockValue(0);
    if(simulation_dt <= 0.0){
	Error();
	printf("Invalid simulation step size of %f\n",simulation_dt);
    }
    /*
    ** go through each enabled element
    */
    stk = NewPutElementStack(RootElement());
    /*
    ** scan all elements except those that are disabled
    */
    action = GetAction("CHECK");
    while(element = NewFastNextElement(1,stk)){
	if(Clockrate(element) < simulation_dt){
	    Error();
	    printf("the interval for '%s' (%f) ",
	    Pathname(element),
	    Clockrate(element));
	    printf("is less than the simulation dt (%f)\n",
	    simulation_dt);
	}
	/*
	** does the object have a check action?
	*/
	CallActionFunc(element, action);
    }
    NewFreeElementStack(stk);
    CHECK_Simulate();
} 
