/*
** 1998-06-04 -	An encapsulation of the DirPane's rescan function as a native command.
**		Highly useful, especially in menus.
*/

#include "gentoo.h"

#include "cmdseq.h"
#include "dirpane.h"
#include "dirhistory.h"
#include "errors.h"

#include "cmd_dirrescan.h"

/* ----------------------------------------------------------------------------------------- */

/* 2002-07-19 -	Rescan source directory. */
gint cmd_dirrescan(MainInfo *min, DirPane *src, DirPane *dst, const CmdArg *ca)
{
	err_clear(min);
	dp_rescan(src);
	dp_show_stats(src);
	if(errno)
	{
		err_set(min, errno, "DirRescan", src->dir.path);
		err_show(min);
	}
	return errno == 0;
}
