/*
** 1998-05-25 -	The PARENT native command, which simply causes the currently active
**		dir pane to go up one level, to its parent directory.
** 1999-07-03 -	Rewrote entire function, should now work a little bit better. I hope.
*/

#include "gentoo.h"

#include <stdlib.h>

#include "cmdseq.h"
#include "strutil.h"

#include "cmd_parent.h"

/* ----------------------------------------------------------------------------------------- */

/* 1999-07-03 -	Go up one level in the source pane. Rewritten to add a little more armor
**		plating. Still far from bullet-proof, though...
*/
gint cmd_parent(MainInfo *min, DirPane *src, DirPane *dst, const CmdArg *ca)
{
	gchar	*ptr;
	GString	*comp;

	ptr = src->dir.path + strlen(src->dir.path) - 1;

	if(*ptr == G_DIR_SEPARATOR)
		ptr--;

	comp = g_string_new("");
	while(ptr >= src->dir.path)
	{
		if(*ptr != G_DIR_SEPARATOR)
			g_string_prepend_c(comp, *ptr--);
		else
		{
			if(strcmp(comp->str, ".") == 0)	/* Skip any "." components, so parent("/home/./././.") is "/". */
			{
				ptr--;
				continue;
			}
			g_string_assign(comp, src->dir.path);
			g_string_truncate(comp, ptr - src->dir.path);
			if(*comp->str == '\0')
				g_string_assign(comp, "/");
			csq_execute_format(min, "DirEnter 'dir=%s'", stu_escape(comp->str));
			break;
		}
	}
	g_string_free(comp, TRUE);
	return 0;
}
