/* Gerris - The GNU Flow Solver
 * Copyright (C) 2001 National Institute of Water and Atmospheric Research
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.  
 */

#ifndef __GFS_H__
#define __GFS_H__

#include <gerris/ftt.h>
#include <gerris/fluid.h>
#include <gerris/output.h>
#include <gerris/solid.h>
#include <gerris/poisson.h>
#include <gerris/advection.h>
#include <gerris/boundary.h>
#include <gerris/timestep.h>
#include <gerris/domain.h>
#include <gerris/init.h>
#include <gerris/refine.h>
#include <gerris/event.h>
#include <gerris/simulation.h>
#include <gerris/graphic.h>
#include <gerris/adaptive.h>
#include <gerris/source.h>
#include <gerris/vof.h>
#include <gerris/cartesian.h>
#include <gerris/surface.h>
#include <gerris/unstructured.h>
#include <gerris/map.h>
#include <gerris/particle.h>
#include <gerris/version.h>

#endif /* GFS_H */
