/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2002-2004 The GFC Development Team.
 *
 *  tablesignals.cc - Atk::Table virtual signal handlers
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "table.hh"
#include "tablesignals.hh"
#include "private/tableiface.hh"
#include <gfc/glib/object.hh>
#include <gfc/glib/objectsignals.hh>

using namespace GFC;

/*  Atk::TableSignals
 */

Atk::TableSignals::TableSignals(Table *table)
{
	Atk::TableIface::init(ATK_TABLE_GET_IFACE(table->atk_table()));
}

Atk::TableSignals::~TableSignals()
{
}

void
Atk::TableSignals::on_row_inserted(int row, int num_inserted)
{
	AtkTableIface *g_iface = TableIface::get_parent_iface(instance_);
	if (g_iface->row_inserted)
		g_iface->row_inserted((AtkTable*)instance_, row, num_inserted);
}

void
Atk::TableSignals::on_column_inserted(int column, int num_inserted)
{
	AtkTableIface *g_iface = TableIface::get_parent_iface(instance_);
	if (g_iface->column_inserted)
		g_iface->column_inserted((AtkTable*)instance_, column, num_inserted);
}

void
Atk::TableSignals::on_row_deleted(int row, int num_deleted)
{
	AtkTableIface *g_iface = TableIface::get_parent_iface(instance_);
	if (g_iface->row_deleted)
		g_iface->row_deleted((AtkTable*)instance_, row, num_deleted);
}

void
Atk::TableSignals::on_column_deleted(int column, int num_deleted)
{
	AtkTableIface *g_iface = TableIface::get_parent_iface(instance_);
	if (g_iface->column_deleted)
		g_iface->column_deleted((AtkTable*)instance_, column, num_deleted);
}

void
Atk::TableSignals::on_row_reordered()
{
	AtkTableIface *g_iface = TableIface::get_parent_iface(instance_);
	if (g_iface->row_reordered)
		g_iface->row_reordered((AtkTable*)instance_);
}

void
Atk::TableSignals::on_column_reordered()
{
	AtkTableIface *g_iface = TableIface::get_parent_iface(instance_);
	if (g_iface->column_reordered)
		g_iface->column_reordered((AtkTable*)instance_);
}

void
Atk::TableSignals::on_model_changed()
{
	AtkTableIface *g_iface = TableIface::get_parent_iface(instance_);
	if (g_iface->model_changed)
		g_iface->model_changed((AtkTable*)instance_);
}

/*  Atk::TableIface
 */

void
Atk::TableIface::init(AtkTableIface *g_iface)
{
	g_iface->row_inserted = &row_inserted_proxy;
	g_iface->column_inserted = &column_inserted_proxy;
	g_iface->row_deleted = &row_deleted_proxy;
	g_iface->column_deleted = &column_deleted_proxy;
	g_iface->row_reordered = &row_reordered_proxy;
	g_iface->column_reordered = &column_reordered_proxy;
	g_iface->model_changed = &model_changed_proxy;
}

AtkTableIface*
Atk::TableIface::get_parent_iface(void *instance)
{
	void *ptr = g_type_interface_peek_parent(ATK_TABLE_GET_IFACE(instance));
	return static_cast<AtkTableIface*>(ptr);
}

void
Atk::TableIface::row_inserted_proxy(AtkTable *table, gint row, gint num_inserted)
{
	void *ptr = g_object_get_qdata((GObject*)table, G::ObjectSignals::quark());
	if (ptr)
	{
		G::Object *object = static_cast<G::Object*>(ptr);
		dynamic_cast<TableSignals*>(object)->on_row_inserted(row, num_inserted);
	}
	else
	{
		AtkTableIface *g_iface = TableIface::get_parent_iface(table);
		if (g_iface->row_inserted)
			g_iface->row_inserted(table, row, num_inserted);
	}
}

void
Atk::TableIface::column_inserted_proxy(AtkTable *table, gint column, gint num_inserted)
{
	void *ptr = g_object_get_qdata((GObject*)table, G::ObjectSignals::quark());
	if (ptr)
	{
		G::Object *object = static_cast<G::Object*>(ptr);
		dynamic_cast<TableSignals*>(object)->on_column_inserted(column, num_inserted);
	}
	else
	{
		AtkTableIface *g_iface = TableIface::get_parent_iface(table);
		if (g_iface->column_inserted)
			g_iface->column_inserted(table, column, num_inserted);
	}
}

void
Atk::TableIface::row_deleted_proxy(AtkTable *table, gint row, gint num_deleted)
{
	void *ptr = g_object_get_qdata((GObject*)table, G::ObjectSignals::quark());
	if (ptr)
	{
		G::Object *object = static_cast<G::Object*>(ptr);
		dynamic_cast<TableSignals*>(object)->on_row_deleted(row, num_deleted);
	}
	else
	{
		AtkTableIface *g_iface = TableIface::get_parent_iface(table);
		if (g_iface->row_deleted)
			g_iface->row_deleted(table, row, num_deleted);
	}
}

void
Atk::TableIface::column_deleted_proxy(AtkTable *table, gint column, gint num_deleted)
{
	void *ptr = g_object_get_qdata((GObject*)table, G::ObjectSignals::quark());
	if (ptr)
	{
		G::Object *object = static_cast<G::Object*>(ptr);
		dynamic_cast<TableSignals*>(object)->on_column_deleted(column, num_deleted);
	}
	else
	{
		AtkTableIface *g_iface = TableIface::get_parent_iface(table);
		if (g_iface->column_deleted)
			g_iface->column_deleted(table, column, num_deleted);
	}
}

void
Atk::TableIface::row_reordered_proxy(AtkTable *table)
{
	void *ptr = g_object_get_qdata((GObject*)table, G::ObjectSignals::quark());
	if (ptr)
	{
		G::Object *object = static_cast<G::Object*>(ptr);
		dynamic_cast<TableSignals*>(object)->on_row_reordered();
	}
	else
	{
		AtkTableIface *g_iface = TableIface::get_parent_iface(table);
		if (g_iface->row_reordered)
			g_iface->row_reordered(table);
	}
}

void
Atk::TableIface::column_reordered_proxy(AtkTable *table)
{
	void *ptr = g_object_get_qdata((GObject*)table, G::ObjectSignals::quark());
	if (ptr)
	{
		G::Object *object = static_cast<G::Object*>(ptr);
		dynamic_cast<TableSignals*>(object)->on_column_reordered();
	}
	else
	{
		AtkTableIface *g_iface = TableIface::get_parent_iface(table);
		if (g_iface->column_reordered)
			g_iface->column_reordered(table);
	}
}

void
Atk::TableIface::model_changed_proxy(AtkTable *table)
{
	void *ptr = g_object_get_qdata((GObject*)table, G::ObjectSignals::quark());
	if (ptr)
	{
		G::Object *object = static_cast<G::Object*>(ptr);
		dynamic_cast<TableSignals*>(object)->on_model_changed();
	}
	else
	{
		AtkTableIface *g_iface = TableIface::get_parent_iface(table);
		if (g_iface->model_changed)
			g_iface->model_changed(table);
	}
}

