/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2003-2004 The GFC Development Team.
 *
 *  image.inl - Gdk::Image inline functions
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

inline GdkImage*
GFC::Gdk::Image::gdk_image() const
{
	return reinterpret_cast<GdkImage*>(instance_);
}

inline GFC::Gdk::Image::operator GdkImage* () const
{
	return this ? gdk_image() : 0;
}

inline GFC::Gdk::ImageType
GFC::Gdk::Image::image_type() const
{
	return (ImageType)gdk_image()->type;
}

inline GFC::Gdk::ByteOrder
GFC::Gdk::Image::byte_order() const
{
	return (ByteOrder)gdk_image()->byte_order;
}

inline int
GFC::Gdk::Image::width() const
{
	return gdk_image()->width;
}

inline int
GFC::Gdk::Image::height() const
{
	return gdk_image()->height;
}

inline unsigned short
GFC::Gdk::Image::depth() const
{
	return gdk_image()->depth;
}

inline unsigned short
GFC::Gdk::Image::bytes_per_pixel() const
{
	return gdk_image()->bpp;
}

inline unsigned short
GFC::Gdk::Image::bytes_per_line() const
{
	return gdk_image()->bpl;
}

inline unsigned int
GFC::Gdk::Image::get_pixel(int x, int y) const
{
	return gdk_image_get_pixel(gdk_image(), x, y);
}

inline void
GFC::Gdk::Image::put_pixel(int x, int y, unsigned int pixel)
{
	gdk_image_put_pixel(gdk_image(), x, y, pixel);
}

