/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2002-2004 The GFC Development Team.
 *
 *  radiomenuitem.cc - GtkRadioMenuItem C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "radiomenuitem.hh"
#include "private/radiomenuitemclass.hh"
#include <gfc/glib/private/marshal.hh>

using namespace GFC;

/*  Gtk::RadioMenuItem
 */

Gtk::RadioMenuItem::RadioMenuItem(GtkRadioMenuItem *radio_menu_item, bool owns_reference)
: CheckMenuItem((GtkCheckMenuItem*)radio_menu_item, owns_reference)
{
}

Gtk::RadioMenuItem::RadioMenuItem()
: CheckMenuItem((GtkCheckMenuItem*)RadioMenuItemClass::create())
{
}

Gtk::RadioMenuItem::RadioMenuItem(const RadioMenuItem *group)
: CheckMenuItem((GtkCheckMenuItem*)RadioMenuItemClass::create())
{
	if (group)	
		set_group(group->get_group());
}

Gtk::RadioMenuItem::RadioMenuItem(const RadioMenuItem *group, const char *label, bool use_underline)
: CheckMenuItem((GtkCheckMenuItem*)RadioMenuItemClass::create())
{
	add_label(label, use_underline);
	if (group)	
		set_group(group->get_group());
}

Gtk::RadioMenuItem::RadioMenuItem(const RadioMenuItem *group, const String& label, bool use_underline)
: CheckMenuItem((GtkCheckMenuItem*)RadioMenuItemClass::create())
{
	add_label(label, use_underline);
	if (group)	
		set_group(group->get_group());
}

Gtk::RadioMenuItem::~RadioMenuItem()
{
}

/*  Gtk::RadioMenuItem signals
 */

const Gtk::RadioMenuItem::GroupChangedSignalType Gtk::RadioMenuItem::group_changed_signal("group-changed", (GCallback)&G::Marshal::void_callback);
