/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2002-2004 The GFC Development Team.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
/// @file gfc/gtk/settings.hh
/// @brief A GtkSettings C++ wrapper interface.
///
/// Provides Settings, an object that holds the current settings for a screen.

#ifndef GFC_GTK_SETTINGS_HH
#define GFC_GTK_SETTINGS_HH

#ifndef GFC_G_OBJECT_HH
#include <gfc/glib/object.hh>
#endif

#ifndef GFC_G_PROPERTY_HH
#include <gfc/glib/property.hh>
#endif

#ifndef __GTK_SETTINGS_H__
#include <gtk/gtksettings.h>
#endif

namespace GFC {

namespace Gdk {
class Screen;
}

namespace Gtk {

/// @class Settings settings.hh gfc/gtk/settings.hh
/// @brief A GtkSettings C++ wrapper class.
///
/// The Settings object holds the current settings for a GDK screen.

class Settings : public G::Object
{
	friend class G::Object;

	Settings(const Settings&);
	Settings& operator=(const Settings&);
	
protected:
/// @name Constructors
/// @{

	explicit Settings(GtkSettings *settings, bool owns_reference = true);
	///< Construct a new Settings from an existing GtkSettings.
	///< @param settings A pointer to a GtkSettings.
	///< @param owns_reference Set false if the initial reference count is floating, set true if it's not.
	///<
	///< <BR>The <EM>settings</EM> can be a newly created GtkSettings or an existing
	///< GtkSettings (see G::Object::Object).

/// @}
/// @name Property Prototypes
/// @{

	typedef G::Property<int> GtkDoubleClickTimePropertyType;
	typedef G::PropertyProxy<G::Object, GtkDoubleClickTimePropertyType> GtkDoubleClickTimePropertyProxy;
	static const GtkDoubleClickTimePropertyType gtk_double_click_time_property;
	///< Maximum time allowed between two clicks for them to be considered a double click
	///< (see prop_gtk_double_click_time()).

	typedef G::Property<bool> GtkCursorBlinkPropertyType;
	typedef G::PropertyProxy<G::Object, GtkCursorBlinkPropertyType> GtkCursorBlinkPropertyProxy;
	static const GtkCursorBlinkPropertyType gtk_cursor_blink_property;
	///< Whether the cursor should blink (see prop_gtk_cursor_blink()).

	typedef G::Property<int> GtkCursorBlinkTimePropertyType;
	typedef G::PropertyProxy<G::Object, GtkCursorBlinkTimePropertyType> GtkCursorBlinkTimePropertyProxy;
	static const GtkCursorBlinkTimePropertyType gtk_cursor_blink_time_property;
	///< Length of the cursor blink cycle, in milleseconds (see prop_gtk_cursor_blink_time()).

	typedef G::Property<bool> GtkSplitCursorPropertyType;
	typedef G::PropertyProxy<G::Object, GtkSplitCursorPropertyType> GtkSplitCursorPropertyProxy;
	static const GtkSplitCursorPropertyType gtk_split_cursor_property;
	///< Whether two cursors should be displayed for mixed left-to-right and right-to-left text
	///< (see prop_gtk_split_cursor()).

	typedef G::Property<String> GtkThemeNamePropertyType;
	typedef G::PropertyProxy<G::Object, GtkThemeNamePropertyType> GtkThemeNamePropertyProxy;
	static const GtkThemeNamePropertyType gtk_theme_name_property;
	///< Name of theme RC file to load (see prop_gtk_theme_name()).

	typedef G::Property<String> GtkIconThemeNamePropertyType;
	typedef G::PropertyProxy<G::Object, GtkIconThemeNamePropertyType> GtkIconThemeNamePropertyProxy;
	static const GtkIconThemeNamePropertyType gtk_icon_theme_name_property;
	///< Name of icon theme to use (see prop_gtk_icon_theme_name()).

	typedef G::Property<String> GtkKeyThemeNamePropertyType;
	typedef G::PropertyProxy<G::Object, GtkKeyThemeNamePropertyType> GtkKeyThemeNamePropertyProxy;
	static const GtkKeyThemeNamePropertyType gtk_key_theme_name_property;
	///< Name of key theme RC file to load (see prop_gtk_key_theme_name()).

	typedef G::Property<String> GtkMenuBarAccelPropertyType;
	typedef G::PropertyProxy<G::Object, GtkMenuBarAccelPropertyType> GtkMenuBarAccelPropertyProxy;
	static const GtkMenuBarAccelPropertyType gtk_menu_bar_accel_property;
	///< Keybinding to activate the menu bar (see prop_gtk_menu_bar_accel()).

	typedef G::Property<int> GtkDndDragThresholdPropertyType;
	typedef G::PropertyProxy<G::Object, GtkDndDragThresholdPropertyType> GtkDndDragThresholdPropertyProxy;
	static const GtkDndDragThresholdPropertyType gtk_dnd_drag_threshold_property;
	///< Number of pixels the cursor can move before dragging (see prop_gtk_dnd_drag_threshold()).

	typedef G::Property<String> GtkFontNamePropertyType;
	typedef G::PropertyProxy<G::Object, GtkFontNamePropertyType> GtkFontNamePropertyProxy;
	static const GtkFontNamePropertyType gtk_font_name_property;
	///< Name of default font to use (see prop_gtk_font_name()).

	typedef G::Property<String> GtkIconSizesPropertyType;
	typedef G::PropertyProxy<G::Object, GtkIconSizesPropertyType> GtkIconSizesPropertyProxy;
	static const GtkIconSizesPropertyType gtk_icon_sizes_property;
	///< List of icon sizes (gtk-menu=16,16;gtk-button=20,20...) (see prop_gtk_icon_sizes()).

/// @}

public:
/// @name Constructors
/// @{

	virtual ~Settings();
	///< Destructor.
	
/// @}

	static Settings* get(const Gdk::Screen *screen = 0);
	///< Gets the Settings object for the specified screen, creating it if necessary.
	///< @param screen A Gdk::Screen, or null for the default screen.
	///< @return A Settings object.
	///<
	///< <BR><B>Note:</B> The default GDK screen is the only screen in the absence of MultiHead support.

/// @name Accessors
/// @{

	GtkSettings* gtk_settings() const;
	///< Get a pointer to the GtkSettings structure.

	operator GtkSettings* () const;
	///< Conversion operator; safely converts a Settings to a GtkSettings pointer.

/// @}
/// @name Property Proxies
/// @{

	const GtkDoubleClickTimePropertyProxy prop_gtk_double_click_time();
	///< Maximum time allowed between two clicks for them to be considered a double click
	///< (in milliseconds) (int : Read / Write).

	const GtkCursorBlinkPropertyProxy prop_gtk_cursor_blink();
	///< Whether the cursor should blink (bool : Read / Write).

	const GtkCursorBlinkTimePropertyProxy prop_gtk_cursor_blink_time();
	///< Length of the cursor blink cycle, in milleseconds (int : Read / Write).

	const GtkSplitCursorPropertyProxy prop_gtk_split_cursor();
	///< Whether two cursors should be displayed for mixed left-to-right and right-to-left text
	///< (bool : Read / Write).

	const GtkThemeNamePropertyProxy prop_gtk_theme_name();
	///< Name of theme RC file to load (String : Read / Write).

	const GtkIconThemeNamePropertyProxy prop_gtk_icon_theme_name();
	///< Name of icon theme to use (String : Read / Write).

	const GtkKeyThemeNamePropertyProxy prop_gtk_key_theme_name();
	///< Name of key theme RC file to load (String : Read / Write).

	const GtkMenuBarAccelPropertyProxy prop_gtk_menu_bar_accel();
	///< Keybinding to activate the menu bar (String : Read / Write).

	const GtkDndDragThresholdPropertyProxy prop_gtk_dnd_drag_threshold();
	///< Number of pixels the cursor can move before dragging (int : Read / Write).

	const GtkFontNamePropertyProxy prop_gtk_font_name();
	///< Name of default font to use (String : Read / Write).

	const GtkIconSizesPropertyProxy prop_gtk_icon_sizes();
	///< List of icon sizes (gtk-menu=16,16;gtk-button=20,20...) (String : Read / Write).

/// @}
};

} // namespace Gtk

} // namespace GFC

#include <gfc/gtk/inline/settings.inl>

#endif // GFC_GTK_SETTINGS_HH

