/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2003-2004 The GFC Development Team.
 *
 *  types.inl - Pango types inline functions
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

inline PangoRectangle*
GFC::Pango::Rectangle::pango_rectangle() const
{
	return const_cast<PangoRectangle*>(&rectangle_);
}

inline GFC::Pango::Rectangle::operator PangoRectangle* () const
{
	return this ? pango_rectangle() : 0;
}

inline int
GFC::Pango::Rectangle::x() const
{
	return rectangle_.x;
}

inline int
GFC::Pango::Rectangle::y() const
{
	return rectangle_.y;
}

inline int
GFC::Pango::Rectangle::width() const
{
	return rectangle_.width;
}

inline int
GFC::Pango::Rectangle::height() const
{
	return rectangle_.height;
}

inline int
GFC::Pango::Rectangle::ascent() const
{
	return PANGO_ASCENT(*pango_rectangle());
}

inline int
GFC::Pango::Rectangle::descent() const
{
	return PANGO_DESCENT(*pango_rectangle());
}

inline int
GFC::Pango::Rectangle::lbearing() const
{
	return PANGO_LBEARING(*pango_rectangle());
}

inline int
GFC::Pango::Rectangle::rbearing() const
{
	return PANGO_RBEARING(*pango_rectangle());
}

