{-
HOpenGL - a binding of OpenGL and GLUT for Haskell.
Copyright (C) 2001  Sven Panne <Sven.Panne@BetaResearch.de>

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with this library (COPYING.LIB); if not, write to the Free
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

This module corresponds to section 6.1.12 (Saving and Restoring State) of
the OpenGL 1.2.1 specs.
-}

module GL_SavResState (
   AttributeGroup(..), pushAttrib, popAttrib,
   ClientAttributeGroup(..), pushClientAttrib, popClientAttrib
) where

import GL_Constants     (gl_ACCUM_BUFFER_BIT, gl_COLOR_BUFFER_BIT, gl_CURRENT_BIT,
                         gl_DEPTH_BUFFER_BIT, gl_ENABLE_BIT, gl_EVAL_BIT,
                         gl_FOG_BIT, gl_HINT_BIT, gl_LIGHTING_BIT, gl_LINE_BIT,
                         gl_LIST_BIT, gl_PIXEL_MODE_BIT, gl_POINT_BIT,
                         gl_POLYGON_BIT, gl_POLYGON_STIPPLE_BIT, gl_SCISSOR_BIT,
                         gl_STENCIL_BUFFER_BIT, gl_TEXTURE_BIT, gl_TRANSFORM_BIT,
                         gl_VIEWPORT_BIT, gl_ALL_ATTRIB_BITS,
                         gl_CLIENT_VERTEX_ARRAY_BIT, gl_CLIENT_PIXEL_STORE_BIT,
                         gl_ALL_CLIENT_ATTRIB_BITS)
import GL_BasicTypes    (GLbitfield, toBitfield)

---------------------------------------------------------------------------

-- GL_ACCUM_BUFFER_BIT:   Collision with GL_Misc.Buffer (resolved here)
-- GL_COLOR_BUFFER_BIT:   Collision with GL_Misc.Buffer (resolved here)
-- GL_DEPTH_BUFFER_BIT:   Collision with GL_Misc.Buffer (resolved here)
-- GL_STENCIL_BUFFER_BIT: Collision with GL_Misc.Buffer (resolved here)
data AttributeGroup =
     AccumBufferBit'
   | ColorBufferBit'
   | CurrentBit
   | DepthBufferBit'
   | EnableBit
   | EvalBit
   | FogBit
   | HintBit
   | LightingBit
   | LineBit
   | ListBit
   | PixelModeBit
   | PointBit
   | PolygonBit
   | PolygonStippleBit
   | ScissorBit
   | StencilBufferBit'
   | TextureBit
   | TransformBit
   | ViewportBit
   | AllAttribBits
   deriving (Eq,Ord)

marshalAttributeGroup :: AttributeGroup -> GLbitfield
marshalAttributeGroup AccumBufferBit'   = gl_ACCUM_BUFFER_BIT
marshalAttributeGroup ColorBufferBit'   = gl_COLOR_BUFFER_BIT
marshalAttributeGroup CurrentBit        = gl_CURRENT_BIT
marshalAttributeGroup DepthBufferBit'   = gl_DEPTH_BUFFER_BIT
marshalAttributeGroup EnableBit         = gl_ENABLE_BIT
marshalAttributeGroup EvalBit           = gl_EVAL_BIT
marshalAttributeGroup FogBit            = gl_FOG_BIT
marshalAttributeGroup HintBit           = gl_HINT_BIT
marshalAttributeGroup LightingBit       = gl_LIGHTING_BIT
marshalAttributeGroup LineBit           = gl_LINE_BIT
marshalAttributeGroup ListBit           = gl_LIST_BIT
marshalAttributeGroup PixelModeBit      = gl_PIXEL_MODE_BIT
marshalAttributeGroup PointBit          = gl_POINT_BIT
marshalAttributeGroup PolygonBit        = gl_POLYGON_BIT
marshalAttributeGroup PolygonStippleBit = gl_POLYGON_STIPPLE_BIT
marshalAttributeGroup ScissorBit        = gl_SCISSOR_BIT
marshalAttributeGroup StencilBufferBit' = gl_STENCIL_BUFFER_BIT
marshalAttributeGroup TextureBit        = gl_TEXTURE_BIT
marshalAttributeGroup TransformBit      = gl_TRANSFORM_BIT
marshalAttributeGroup ViewportBit       = gl_VIEWPORT_BIT
marshalAttributeGroup AllAttribBits     = gl_ALL_ATTRIB_BITS

pushAttrib :: [AttributeGroup] -> IO ()
pushAttrib = glPushAttrib . toBitfield marshalAttributeGroup

foreign import "glPushAttrib" unsafe glPushAttrib :: GLbitfield -> IO ()

foreign import "glPopAttrib" unsafe popAttrib :: IO ()

data ClientAttributeGroup =
     ClientVertexArrayBit
   | ClientPixelStoreBit
   | ClientAllAttribBits
   deriving (Eq,Ord)

marshalClientAttributeGroup :: ClientAttributeGroup -> GLbitfield
marshalClientAttributeGroup ClientVertexArrayBit = gl_CLIENT_VERTEX_ARRAY_BIT
marshalClientAttributeGroup ClientPixelStoreBit  = gl_CLIENT_PIXEL_STORE_BIT
marshalClientAttributeGroup ClientAllAttribBits  = gl_ALL_CLIENT_ATTRIB_BITS

pushClientAttrib :: [ClientAttributeGroup] -> IO ()
pushClientAttrib = glPushClientAttrib . toBitfield marshalClientAttributeGroup

foreign import "glPushClientAttrib" unsafe glPushClientAttrib :: GLbitfield -> IO ()

foreign import "glPopClientAttrib" unsafe popClientAttrib :: IO ()
