module RgnCCall_12 ( HRGN
                   , rgn_AND, rgn_OR, rgn_XOR, rgn_DIFF, rgn_COPY
                   , winCreateRectRgn, winCreatePolygonRgn
                   , winSetRgnToRect
                   , winCombineRgn
                   , winGetRgnBox
                   ) where


--	********************************************************************************
--	Clean to Haskell Standard Object I/O library, version 1.2
--	
--	RgnCCall_12 contains OS operations to manage regions.
--	********************************************************************************


import Cutil_12
import Ostoolbox


type	HRGN = Int


--	CombineRgn() Styles.
rgn_AND, rgn_OR, rgn_XOR, rgn_DIFF, rgn_COPY :: Int
rgn_AND		= 1
rgn_OR		= 2
rgn_XOR		= 3
rgn_DIFF	= 4
rgn_COPY	= 5


{-	Operations to create, modify and destroy regions.
-}
winCreateRectRgn :: Int -> Int -> Int -> Int -> IO HRGN
winCreateRectRgn a1 a2 a3 a4
	= do {
		-- Marshal arguments:
		o1 <- malloc 4;
		o2 <- malloc 4;
		-- Call C:
		cWinCreateRectRgn a1 a2 a3 a4 osNewToolbox o1 o2;
		-- Read/free:
		r1 <- fpeek o1;
		r2 <- free o2;
		return r1
	  }
foreign import stdcall "cpicture_121" "WinCreateRectRgn" cWinCreateRectRgn :: Int -> Int -> Int -> Int -> Int -> Addr -> Addr -> IO ()

winCreatePolygonRgn :: Int -> Int -> Int -> IO HRGN
winCreatePolygonRgn a1 a2 a3
	= do {
		-- Marshal arguments:
		o1 <- malloc 4;
		o2 <- malloc 4;
		-- Call C:
		cWinCreatePolygonRgn a1 a2 a3 osNewToolbox o1 o2;
		-- Read/free:
		r1 <- fpeek o1;
		r2 <- free o2;
		return r1
	  }
foreign import stdcall "cpicture_121" "WinCreatePolygonRgn" cWinCreatePolygonRgn :: Int -> Int -> Int -> Int -> Addr -> Addr -> IO ()

winSetRgnToRect :: Int -> Int -> Int -> Int -> HRGN -> IO HRGN
winSetRgnToRect a1 a2 a3 a4 a5
	= do {
		-- Marshal arguments:
		o1 <- malloc 4;
		o2 <- malloc 4;
		-- Call C:
		cWinSetRgnToRect a1 a2 a3 a4 a5 osNewToolbox o1 o2;
		-- Read/free:
		r1 <- fpeek o1;
		r2 <- free o2;
		return r1
	  }
foreign import stdcall "cpicture_121" "WinSetRgnToRect" cWinSetRgnToRect :: Int -> Int -> Int -> Int -> HRGN -> Int -> Addr -> Addr -> IO ()

winCombineRgn :: HRGN -> HRGN -> HRGN -> Int -> IO HRGN
winCombineRgn a1 a2 a3 a4
	= do {
		-- Marshal arguments:
		o1 <- malloc 4;
		o2 <- malloc 4;
		-- Call C:
		cWinCombineRgn a1 a2 a3 a4 osNewToolbox o1 o2;
		-- Read/free:
		r1 <- fpeek o1;
		r2 <- free o2;
		return r1
	  }
foreign import stdcall "cpicture_121" "WinCombineRgn" cWinCombineRgn :: HRGN -> HRGN -> HRGN -> Int -> Int -> Addr -> Addr -> IO ()

winGetRgnBox :: HRGN -> IO (Int,Int,Int,Int,Bool,Bool)
winGetRgnBox a1
	= do {
		-- Marshal arguments:
		o1 <- malloc 4;
		o2 <- malloc 4;
		o3 <- malloc 4;
		o4 <- malloc 4;
		o5 <- malloc 4;
		o6 <- malloc 4;
		o7 <- malloc 4;
		-- Call C:
		cWinGetRgnBox a1 osNewToolbox o1 o2 o3 o4 o5 o6 o7;
		-- Read/free:
		r1 <- fpeek o1;
		r2 <- fpeek o2;
		r3 <- fpeek o3;
		r4 <- fpeek o4;
		r5 <- fpeek o5;
		r6 <- fpeek o6;
		r7 <- free o7;
		return (r1,r2,r3,r4,itob r5,itob r6)
	  }
foreign import stdcall "cpicture_121" "WinGetRgnBox" cWinGetRgnBox :: HRGN -> Int -> Addr -> Addr -> Addr -> Addr -> Addr -> Addr -> Addr -> IO ()
