{-# OPTIONS -#include <windows.h> #-}
{-# OPTIONS -#include "errors.h" #-}
{-# OPTIONS -#include "win32debug.h" #-}
{-# OPTIONS -#include "finalizers.h" #-}
{-# OPTIONS -#include "Win32Brush_stub_ffi.h" #-}
module Win32Brush where

import StdDIS
import Win32Types
import GDITypes


----------------------------------------------------------------
-- Brush
----------------------------------------------------------------

createSolidBrush :: COLORREF -> IO HBRUSH
createSolidBrush arg1 =
  prim_createSolidBrush arg1
  >>= \ gc_result ->
  access_prim_createSolidBrush_res1 (gc_result :: Addr) >>= \ res1 ->
  access_prim_createSolidBrush_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_createSolidBrush_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (res1))
foreign import  ccall "prim_createSolidBrush" unsafe prim_createSolidBrush :: Word32 -> IO (Addr)
foreign import ccall "access_prim_createSolidBrush_res1" unsafe access_prim_createSolidBrush_res1 :: Addr -> IO (Addr)
foreign import ccall "access_prim_createSolidBrush_gc_failed" unsafe access_prim_createSolidBrush_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_createSolidBrush_gc_failstring" unsafe access_prim_createSolidBrush_gc_failstring :: Addr -> IO (Addr)

createHatchBrush :: HatchStyle -> COLORREF -> IO HBRUSH
createHatchBrush gc_arg1 arg2 =
  case ( word16ToWord32  gc_arg1) of { arg1 ->
  prim_createHatchBrush arg1 arg2
  >>= \ gc_result ->
  access_prim_createHatchBrush_res1 (gc_result :: Addr) >>= \ res1 ->
  access_prim_createHatchBrush_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_createHatchBrush_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (res1))}
foreign import  ccall "prim_createHatchBrush" unsafe prim_createHatchBrush :: Word32 -> Word32 -> IO (Addr)
foreign import ccall "access_prim_createHatchBrush_res1" unsafe access_prim_createHatchBrush_res1 :: Addr -> IO (Addr)
foreign import ccall "access_prim_createHatchBrush_gc_failed" unsafe access_prim_createHatchBrush_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_createHatchBrush_gc_failstring" unsafe access_prim_createHatchBrush_gc_failstring :: Addr -> IO (Addr)

createPatternBrush :: HBITMAP -> IO HBRUSH
createPatternBrush arg1 =
  prim_createPatternBrush arg1
  >>= \ gc_result ->
  access_prim_createPatternBrush_res1 (gc_result :: Addr) >>= \ res1 ->
  access_prim_createPatternBrush_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_createPatternBrush_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (res1))
foreign import  ccall "prim_createPatternBrush" unsafe prim_createPatternBrush :: Addr -> IO (Addr)
foreign import ccall "access_prim_createPatternBrush_res1" unsafe access_prim_createPatternBrush_res1 :: Addr -> IO (Addr)
foreign import ccall "access_prim_createPatternBrush_gc_failed" unsafe access_prim_createPatternBrush_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_createPatternBrush_gc_failstring" unsafe access_prim_createPatternBrush_gc_failstring :: Addr -> IO (Addr)

deleteBrush :: HBRUSH -> IO ()
deleteBrush arg1 =
  prim_deleteBrush arg1
  >>= \ gc_result ->
  access_prim_deleteBrush_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_deleteBrush_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))
foreign import  ccall "prim_deleteBrush" unsafe prim_deleteBrush :: Addr -> IO (Addr)
foreign import ccall "access_prim_deleteBrush_gc_failed" unsafe access_prim_deleteBrush_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_deleteBrush_gc_failstring" unsafe access_prim_deleteBrush_gc_failstring :: Addr -> IO (Addr)

----------------------------------------------------------------

type StockBrush   = WORD

wHITE_BRUSH :: StockBrush
wHITE_BRUSH =
  unsafePerformIO(
    prim_wHITE_BRUSH
    >>= \  res1  ->
    let gc_res1 = ( word32ToWord16  (res1)) in
    (return (gc_res1)))
foreign import  ccall "prim_wHITE_BRUSH" unsafe prim_wHITE_BRUSH :: IO (Word32)
lTGRAY_BRUSH :: StockBrush
lTGRAY_BRUSH =
  unsafePerformIO(
    prim_lTGRAY_BRUSH
    >>= \  res1  ->
    let gc_res1 = ( word32ToWord16  (res1)) in
    (return (gc_res1)))
foreign import  ccall "prim_lTGRAY_BRUSH" unsafe prim_lTGRAY_BRUSH :: IO (Word32)
gRAY_BRUSH :: StockBrush
gRAY_BRUSH =
  unsafePerformIO(
    prim_gRAY_BRUSH
    >>= \  res1  ->
    let gc_res1 = ( word32ToWord16  (res1)) in
    (return (gc_res1)))
foreign import  ccall "prim_gRAY_BRUSH" unsafe prim_gRAY_BRUSH :: IO (Word32)
dKGRAY_BRUSH :: StockBrush
dKGRAY_BRUSH =
  unsafePerformIO(
    prim_dKGRAY_BRUSH
    >>= \  res1  ->
    let gc_res1 = ( word32ToWord16  (res1)) in
    (return (gc_res1)))
foreign import  ccall "prim_dKGRAY_BRUSH" unsafe prim_dKGRAY_BRUSH :: IO (Word32)
bLACK_BRUSH :: StockBrush
bLACK_BRUSH =
  unsafePerformIO(
    prim_bLACK_BRUSH
    >>= \  res1  ->
    let gc_res1 = ( word32ToWord16  (res1)) in
    (return (gc_res1)))
foreign import  ccall "prim_bLACK_BRUSH" unsafe prim_bLACK_BRUSH :: IO (Word32)
nULL_BRUSH :: StockBrush
nULL_BRUSH =
  unsafePerformIO(
    prim_nULL_BRUSH
    >>= \  res1  ->
    let gc_res1 = ( word32ToWord16  (res1)) in
    (return (gc_res1)))
foreign import  ccall "prim_nULL_BRUSH" unsafe prim_nULL_BRUSH :: IO (Word32)
hOLLOW_BRUSH :: StockBrush
hOLLOW_BRUSH =
  unsafePerformIO(
    prim_hOLLOW_BRUSH
    >>= \  res1  ->
    let gc_res1 = ( word32ToWord16  (res1)) in
    (return (gc_res1)))
foreign import  ccall "prim_hOLLOW_BRUSH" unsafe prim_hOLLOW_BRUSH :: IO (Word32)

getStockBrush :: StockBrush -> IO HBRUSH
getStockBrush gc_arg1 =
  case ( word16ToWord32  gc_arg1) of { arg1 ->
  prim_getStockBrush arg1
  >>= \ gc_result ->
  access_prim_getStockBrush_res1 (gc_result :: Addr) >>= \ res1 ->
  access_prim_getStockBrush_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_getStockBrush_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (res1))}
foreign import  ccall "prim_getStockBrush" unsafe prim_getStockBrush :: Word32 -> IO (Addr)
foreign import ccall "access_prim_getStockBrush_res1" unsafe access_prim_getStockBrush_res1 :: Addr -> IO (Addr)
foreign import ccall "access_prim_getStockBrush_gc_failed" unsafe access_prim_getStockBrush_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_getStockBrush_gc_failstring" unsafe access_prim_getStockBrush_gc_failstring :: Addr -> IO (Addr)

----------------------------------------------------------------
-- End
----------------------------------------------------------------

