// QM1E_MOPAC.H : the MOPAC engine.

// Copyright (C) 2001 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "config.h"	// this is target-dependent...

#ifndef QM1E_MOPAC_H
#define QM1E_MOPAC_H

class qm1_eng_mopac;

/*################################################################################################*/

#include "qm1eng.h"
#include "qm1mdl.h"

/*################################################################################################*/

class qm1_eng_mopac : public qm1_eng
{
	private:
	
	static qm1_eng_mopac * mopac_lock;
	
	public:
	
	qm1_eng_mopac(qm1_mdl &, i32s);
	~qm1_eng_mopac(void);
	
	static qm1_eng_mopac * GetLock(void) { return mopac_lock; }
	
	i32s GetOrbitalCount(void);	// virtual
	f64 GetOrbitalEnergy(i32s);	// virtual
	
	i32s GetElectronCount(void);	// virtual
	
	void Compute(i32s);	// virtual

	void SetupPlotting(void);	// virtual
	
	fGL GetESP(fGL *, fGL *);	// virtual
	fGL GetElDens(fGL *, fGL *);	// virtual
	
	fGL GetOrbital(fGL *, fGL *);	// virtual
	fGL GetOrbDens(fGL *, fGL *);	// virtual
};

/*################################################################################################*/

#endif	// QM1E_MOPAC_H

// eof
