/* $Header: /cvs/gnome/gIDE/src/gI_functions.c,v 1.2 1999/11/06 17:45:39 jpr Exp $ */
/* gIDE
 * Copyright (C) 1998-2000 Steffen Kern
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "structs.h"
#include "gI_functions.h"
#include "gI_document.h"
#include "gI_file.h"
#include "gI_compile.h"
#include "gI_common.h"


/* globals */
static gchar org_line[MAXLEN];
static GtkWidget *clist;
static GtkWidget *func_window = NULL;

/* externs */
extern gI_window *main_window;

static void func_window_destroy( GtkWidget *widget, gpointer data );
static void select_function( GtkWidget *widget, gint row, gint column, GdkEventButton *bevent );
static glong show_functions( gchar *file );
static glong c_parse_line( gchar *buf, glong line, gchar *file );



static void func_window_destroy( GtkWidget *widget, gpointer data )
{
    gtk_widget_destroy( func_window );
    func_window = NULL;
}


static void select_function( GtkWidget *widget, gint row, gint column, GdkEventButton *bevent )
{
    gchar *selected_file;
    gchar *selected_line;

    if( !bevent )
	return;

    if( bevent->type == GDK_2BUTTON_PRESS )
    {
        selected_file = (gchar *) gtk_clist_get_row_data( GTK_CLIST( clist ), row );
        gtk_clist_get_text( GTK_CLIST( clist ), row, 1, &selected_line );

        if( check_file_open( selected_file ) )
        {
            goto_file( selected_file );
        }
        else
        {
            file_open_by_name( main_window, selected_file );
        }
		goto_line( atoi( selected_line ) );
    }
}


void show_all_functions()
{
    glong i;
    gI_document *document;

    if( func_window )
        return;
    
    for(i=0;i<g_list_length( main_window->documents );i++)
    {
        document = (gI_document *) g_list_nth_data( main_window->documents, i );

        if( !document )
            continue;

        if( !document->filename )
            continue;

        if( show_functions( document->filename ) != 1 )
            return;
    }
}


static glong show_functions( gchar *file )
{
    gchar buf[MAXLEN];
    glong i;
    glong line = 0;
    c_status c_status;
    gchar *list_titles[] = { "File", "Line", "Name" };
    GtkWidget *func_vbox;
    GtkWidget *scr_win;
    FILE *infile;

    if( !func_window )
    {
        func_window = gtk_window_new( GTK_WINDOW_TOPLEVEL );
        gtk_widget_set_usize( func_window, 600, 400 );
        gtk_window_set_title( GTK_WINDOW( func_window ), "Functions Window" );
        gtk_signal_connect( GTK_OBJECT( func_window ), "destroy",
                            GTK_SIGNAL_FUNC( func_window_destroy ), NULL );
        
        func_vbox = gtk_vbox_new( FALSE, 0 );
        gtk_container_add( GTK_CONTAINER( func_window ), func_vbox );
        gtk_widget_show( func_vbox );

	scr_win = gtk_scrolled_window_new( NULL, NULL );
	gtk_box_pack_start( GTK_BOX( func_vbox ), scr_win, TRUE, TRUE, 0 );
	gtk_widget_show( scr_win );

        clist = gtk_clist_new_with_titles( 3, list_titles );
        gtk_clist_column_titles_passive( GTK_CLIST( clist ) );
        gtk_clist_set_column_width( GTK_CLIST( clist ), 0, 100 );
        gtk_clist_set_column_width( GTK_CLIST( clist ), 1, 40 );
	gtk_container_add( GTK_CONTAINER( scr_win ), clist );
        gtk_signal_connect( GTK_OBJECT( clist ), "select_row",
                            GTK_SIGNAL_FUNC( select_function ), NULL );
        gtk_widget_show( clist );

        /*
        hsep = gtk_hseparator_new();
        gtk_box_pack_start( GTK_BOX( func_vbox ), hsep, FALSE, TRUE, 5 );
        gtk_widget_show( hsep );
        */
    }

    infile = fopen( file, "r" );
    if( infile == NULL )
    {
        printf("ERROR: can't open file %s\n",file);
        return( -1 );
    }


    init_cstatus( &c_status );

    while( !feof( infile ) )
    {
        fgets( buf, sizeof( buf ), infile );
        if( feof( infile ) )
            break;
        for(i=0;i<=strlen(buf);i++)
            c_parse_special(buf,i,&c_status);
    }

    if( c_status.comment )
    {
        gI_error_dialog( "Base parsing failed, unfinished comment");
        printf( "\nERROR: base parsing failed, numbers doesn't match: %ld; %ld, %ld, %ld\n", c_status.comment, c_status.klammern_1,c_status.klammern_2,c_status.klammern_3 );
        return( -1 );
    }

    if( c_status.klammern_1 || c_status.klammern_2 || c_status.klammern_3 )
    {
        printf( "\nERROR: base parsing failed, numbers doesn't match: %ld, %ld, %ld\n", c_status.klammern_1,c_status.klammern_2,c_status.klammern_3 );
        return( -1 );
    }

    /* Re-Init */
    rewind( infile );
    init_cstatus( &c_status );

    while( !feof( infile ) )
    {
        fgets( buf, sizeof( buf ), infile );
        line++;
        if( feof( infile ) )
            break;
        c_parse_line( buf, line, file );
    }

    fclose( infile );

    gtk_widget_show( func_window );

    return( 1 );
}


static glong c_parse_line( gchar *buf, glong line, gchar *file )
{
    gchar key[MAXLEN];
    gchar *ptr;
    glong kc = 0;
    glong i;
    static c_status c_status;
    static glong waiting = 0;
    gchar *row[3];
    gchar line_str[32];
    glong newrow;


    /* backup the complete original line */
    if( !waiting )
        strcpy( org_line, buf );
    else
        strcat( org_line, buf );

    for(i=0;i<strlen(buf);i++)
    {
        c_parse_special( buf, i, &c_status );

        if( c_status.comment || c_status.hyph || c_status.dhyph )
            continue;

        if( c_status.klammern_1 && waiting )
        {
            waiting = 0;
            ptr = strchr( org_line, ')' );
            if( !ptr )
            {
                printf("ERROR: incomplete function head.. this point should never be reached\n" );
                exit( -1 );
            }
            else
            {
                ptr = strchr( org_line, '{' );
                if( !ptr )
                {
                    printf("ERROR: something is going wrong here....aborting!\n" );
                    exit( -1 );
                }
                
                ptr--;
                
                while( *ptr != ')' )
                {
                    ptr--;
                }

                ptr++;
                *ptr = ';';
                ptr++;
                *ptr = '\0';

                g_snprintf( line_str, 32, "%ld", line );
                row[0] = file_strip_name( file );
                row[1] = line_str;
                row[2] = org_line;
                newrow = gtk_clist_append( GTK_CLIST( clist ), row );
                gtk_clist_set_row_data( GTK_CLIST( clist ), newrow, (gpointer) file );
                continue;
            }
        }

        if( buf[i] == ';' && waiting )
            waiting = 0;

        if( c_status.klammern_1 )
            continue;

        switch( buf[i] )
        {
            case '(':
                if( kc != 0 )
                {
                    key[kc] = '\0';
                    kc = 0;

                    waiting = 1;
                }
                break;

            case ')':
            case ';':
            case '=':
            case ' ':
            case '\t':
            case '/':
            case '*':
            case '+':
            case '-':
                kc = 0;
                break;

            default:
                key[kc] = buf[i];
                kc++;
                break;
        }
    }

    return( 1 );
}


glong c_parse_special( gchar *buf, glong cc, c_status *c_status )
{
    if( buf[cc] == '*' && buf[cc-1] == '/' && !c_status->hyph && !c_status->dhyph )
        c_status->comment = 1;
    if( buf[cc] == '/' && buf[cc-1] == '*' && !c_status->hyph && !c_status->dhyph )
        c_status->comment = 0;
	if( cc > 0 && buf[cc] == '/' && buf[cc-1] == '/' && !c_status->hyph && !c_status->dhyph )
                buf[cc-1] = '\0';       /* c++ style comment, terminate string at the beginning of it */

    if( buf[cc] == '\'' && !c_status->dhyph )
	{
        if( ( buf[cc-1] == '\\' && buf[cc-2] == '\\' )
            || ( buf[cc-1] != '\\' ) )
		{
			if( c_status->hyph )
                            c_status->hyph = 0;
                        else
                            c_status->hyph = 1;
		}
	}

	if( buf[cc] == '"' && !c_status->hyph )
	{
            if( ( buf[cc-1] == '\\' && buf[cc-2] == '\\' )
                || ( buf[cc-1] != '\\' )
                || ( buf[cc-1] != '\\' && buf[cc-2] == '\\' ) )
			{
                if( c_status->dhyph )
                    c_status->dhyph = 0;
                else
                    c_status->dhyph = 1;
			}
	}

        if( !c_status->comment && !c_status->hyph && !c_status->dhyph )
        {
            if( buf[cc] == '{' )
                c_status->klammern_1++;
            if( buf[cc] == '}' )
                c_status->klammern_1--;
            if( buf[cc] == '(' )
      	           c_status->klammern_2++;
            if( buf[cc] == ')' )
                c_status->klammern_2--;
            if( buf[cc] == '[' )
                c_status->klammern_3++;
            if( buf[cc] == ']' )
                c_status->klammern_3--;
        }

        return( 1 );
}


glong init_cstatus( c_status *c_status )
{
        c_status->klammern_1 = 0;
        c_status->klammern_2 = 0;
        c_status->klammern_3 = 0;
        c_status->comment = 0;
        c_status->hyph = 0;
        c_status->dhyph = 0;

        return( 1 );
}
