/* $Header: /cvs/gnome/gIDE/src/gI_project.c,v 1.4 1999/11/20 02:34:45 jpr Exp $ */
/* gIDE
 * Copyright (C) 1998-2000 Steffen Kern
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <config.h>

#ifdef HAVE_STRPTIME
#define _GNU_SOURCE
#endif

#include <gtk/gtk.h>
#include <sys/types.h>
#include <dirent.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <unistd.h>

#include "structs.h"
#include "gI_cfp.h"
#include "gI_project.h"
#include "gI_document.h"
#include "gI_file.h"
#include "gI_compile.h"
#include "gI_window.h"
#include "gI_common.h"


/* local prototypes */
void project_open_file_in_editor(GtkWidget *widget,gchar *file);
void project_add_new_file_to(GtkWidget *widget,gpointer );
static void project_remove_file_from( GtkWidget *widget, gchar *file );
static void move_up_entries( gI_project *project, glong target, glong source );

/* globals */
static GtkWidget *project_window = NULL;
static GtkWidget *e_prjname;
static GtkWidget *e_prjver;
static GtkWidget *files_list;
static GtkWidget *lib_list;
static GtkWidget *e_lib;
static GtkWidget *cb_open;
static GtkWidget *cb_close;
static GtkWidget *prj_list;
static GtkWidget *e_cpar;
static GtkWidget *e_cinc;
static GtkWidget *e_lpar;
static GtkWidget *e_llib;
static GtkWidget *target_list;
static GtkWidget *e_target;
/*static GtkWidget *cb_select;*/
static GtkWidget *cb_delete;
static GtkWidget *e_prjdir;
static GtkWidget *e_prjroot;
static GtkWidget *e_prjfdir;

#ifdef OLD_TODO_LIST /* TODO LIST */
static GtkWidget *e_todo;
static GtkWidget *todo_list;
#endif

static GtkWidget *e_changelog;
static GtkWidget *e_mtarget;

static glong lib_selected = -1;
static glong prj_selected = -1;
static glong target_selected = -1;

#ifdef OLD_TODO_LIST /* TODO LIST */
static glong todo_selected = -1;
#endif

static gI_project *current_project = NULL;
static GtkWidget *root_tree = NULL;

static gchar *objects = NULL;

#ifdef OLD_TODO_LIST /* TODO LIST */
static gchar *todo_status[] = { "Dummy", "To Do", "Work in Progress", "Done" };
#endif

/* Local prototypes */
static void _project_add_to_current(gI_project *parent_project, gI_project *project);

/* externs */
extern gI_window *main_window;
extern gI_config *cfg;
extern gchar prj_path[];

/* Destroy the Project New/Edit/etc. window (project_mask()) */
static void project_window_destroy( GtkWidget *widget, gpointer data )
{
	gI_project *project = gI_project_get_current();

	if(project && project->todoPane)
	{
		gI_todo_pane_destroy(project->todoPane);
		project->todoPane = NULL;
	}

	if(project_window)
		gtk_widget_destroy( project_window );
	project_window = NULL;
}


static void file_add_ok( GtkWidget *widget, GtkFileSelection *file_sel )
{
	gint newrow;
	gint rownum;
	gchar *insrow[4];
	gchar *target;
	gchar *sel_filename;
	gchar *filename;
	GList *rowp;

	gtk_clist_get_text( GTK_CLIST( target_list ), target_selected, 0, &target );

	sel_filename = gtk_file_selection_get_filename( GTK_FILE_SELECTION( file_sel ) );

	rowp = GTK_CLIST( file_sel -> file_list ) -> row_list;
	rownum = 0;
	newrow=0;

	while( rowp )
	{
		if (GTK_CLIST_ROW( rowp ) -> state == GTK_STATE_SELECTED )
		{
			if ( gtk_clist_get_cell_type( GTK_CLIST( file_sel -> file_list ), rownum, 0 ) == GTK_CELL_TEXT )
			{
				gtk_clist_get_text( GTK_CLIST( file_sel -> file_list ), rownum, 0, &filename );
				if( filename != NULL )
				{
					if( GTK_WIDGET_VISIBLE( file_sel ) )
						gtk_widget_hide( GTK_WIDGET( file_sel ) );
					{
						gchar fwrp[MAXLEN];
						gchar *p, *q;
						gI_project *project = gI_project_get_current();

						project->prjroot = g_strdup( gtk_entry_get_text( GTK_ENTRY( e_prjroot ) ) );

						q = p = get_path( sel_filename );
						if( project->prjroot && !isempty( project->prjroot ) && !strncmp( p, project->prjroot, strlen(project->prjroot) ) )
						{
							p += strlen(project->prjroot);
						}

						if( !isempty( p ) )
						{
							if( p[strlen(p)-1] == '/'
							        || filename[0] == '/' )
							{
								g_snprintf( fwrp, MAXLEN, "%s%s", p, filename );
							}
							else
							{
								g_snprintf( fwrp, MAXLEN, "%s/%s", p, filename );
							}
						}
						else
						{
							g_snprintf( fwrp, MAXLEN, "%s", filename );
						}

						g_free( q );

						insrow[0] = fwrp;
						insrow[1] = SOURCE;
						insrow[2]=target;
						insrow[3]= YES;

						newrow = gtk_clist_append( GTK_CLIST( files_list ), insrow );
						gtk_clist_set_row_data( GTK_CLIST( files_list ),newrow, (gpointer) target );
					}
				}
			}
		}
		rownum++;
		rowp = g_list_next( rowp );
	}

	if( GTK_WIDGET_VISIBLE( file_sel ) )
		gtk_widget_hide( GTK_WIDGET( file_sel ) );
}

static void file_add_cancel( GtkWidget *widget, GtkFileSelection *file_sel )
{
	if( GTK_WIDGET_VISIBLE( file_sel ) )
		gtk_widget_hide( GTK_WIDGET( file_sel ) );
}


static void files_add_select( GtkWidget *widget, gpointer data )
{
	static GtkWidget *file_sel = NULL;

	if( target_selected == -1 )
	{
		gI_error_dialog( _("No Target selected!") );
		return;
	}

	if( !file_sel )
	{
		file_sel = gtk_file_selection_new( _("Add File to Project...") );
		gtk_clist_set_selection_mode( GTK_CLIST
		                              ( GTK_FILE_SELECTION ( file_sel ) -> file_list ),
		                              GTK_SELECTION_EXTENDED );

		gtk_signal_connect( GTK_OBJECT( file_sel ), "destroy",
		                    GTK_SIGNAL_FUNC( gtk_widget_destroy ), file_sel );
		gtk_signal_connect( GTK_OBJECT( GTK_FILE_SELECTION( file_sel )->ok_button ), "clicked",
		                    GTK_SIGNAL_FUNC( file_add_ok ), file_sel );
		gtk_signal_connect( GTK_OBJECT( GTK_FILE_SELECTION( file_sel )->cancel_button ), "clicked",
		                    GTK_SIGNAL_FUNC( file_add_cancel ), file_sel );
	}

	if( GTK_WIDGET_VISIBLE( file_sel ) )
		return;
	else
		gtk_widget_show( file_sel );
}


static void files_remove_select( GtkWidget *widget, gpointer data )
{
	gint rownum;
	GList *rowp;

	rowp = GTK_CLIST( files_list ) -> row_list;
	rownum = 0;

	while( rowp )  /* this was a bit tricky but it works fine now :-) */
	{
		if(GTK_CLIST_ROW(rowp)->state==GTK_STATE_SELECTED) {
			rowp=g_list_next(rowp);
			gtk_clist_remove( GTK_CLIST( files_list ),rownum );
		}
		else {
			rowp = g_list_next( rowp );
			rownum++;
		}
	}
}


static void files_list_select( GtkWidget *widget, gint row, gint column, GdkEventButton *bevent )
{
	gchar *build;

	if( !bevent )
		return;

	if( bevent->type == GDK_2BUTTON_PRESS || bevent->type == GDK_3BUTTON_PRESS )
	{
		if( column == 3 )
		{
			gtk_clist_get_text( GTK_CLIST( files_list ), row, column, &build );
			if( !strncmp( build, "Yes", 3 ) )
			{
				gtk_clist_set_text( GTK_CLIST( files_list ), row, column, "No" );
			}
			else
			{
				gtk_clist_set_text( GTK_CLIST( files_list ), row, column, "Yes" );
			}
		}
	}
}



static void lib_list_select( GtkWidget *widget, gint row, gint column, GdkEventButton *bevent )
{
	GList *selection;

	selection = GTK_CLIST( widget )->selection;
	if( !selection )
		lib_selected = -1;
	else
		lib_selected = row;
}


static void target_list_select( GtkWidget *widget, gint row, gint column, GdkEventButton *bevent )
{
	GList *selection;

	selection = GTK_CLIST( widget )->selection;
	if( !selection )
		target_selected = -1;
	else
		target_selected = row;
}


static void lib_add_select( GtkWidget *widget, gpointer data )
{
	gchar *insrow[1];
	gchar *ptr;

	ptr = gtk_entry_get_text( GTK_ENTRY( e_lib ) );
	if( !ptr || isempty( ptr ) )
		return;

	insrow[0] = ptr;
	gtk_clist_append( GTK_CLIST( lib_list ), insrow );
	gtk_entry_set_text( GTK_ENTRY( e_lib ), "" );
}


static void lib_remove_select( GtkWidget *widget, gpointer data )
{
	if( lib_selected == -1 )
	{
		gI_error_dialog( _("No Library selected!") );
		return;
	}

	gtk_clist_remove( GTK_CLIST( lib_list ), lib_selected );
	lib_selected = -1;
}


static void target_add_select( GtkWidget *widget, gpointer data )
{
	gchar *ptr;
	gchar *insrow[2];

	ptr = gtk_entry_get_text( GTK_ENTRY( e_target ) );
	if( !ptr || isempty( ptr ) )
		return;

	insrow[0] = ptr;
	insrow[1] = NOT_YET_SUPPORTED;
	gtk_clist_append( GTK_CLIST( target_list ), insrow );
	gtk_entry_set_text( GTK_ENTRY( e_target ), "" );
}


static void target_remove_select( GtkWidget *widget, gpointer data )
{
	gchar *target_to_remove;
	gchar target[MAXLEN];
	glong i;

	if( target_selected == -1 )
	{
		gI_error_dialog( _("No Target selected!") );
		return;
	}

	gtk_clist_get_text( GTK_CLIST( target_list ), target_selected, 0, &target_to_remove );
	for(i=0;i<(GTK_CLIST( files_list )->rows);i++)
	{
		strcpy( target, (gchar *) gtk_clist_get_row_data( GTK_CLIST( files_list ), i ) );
		if( !strcmp( target_to_remove, target ) )
			gtk_clist_remove( GTK_CLIST( files_list ), i );
	}

	gtk_clist_remove( GTK_CLIST( target_list ), target_selected );
	target_selected = -1;
}

#ifdef OLD_TODO_LIST  /* NEW TODO LIST */
static void todo_add_select( GtkWidget *widget, gpointer data )
{
	gchar *insrow[2];
	glong row;
	gI_todo *todo;
	gchar *ptr;

	ptr = gtk_entry_get_text( GTK_ENTRY( e_todo ) );
	if( !ptr || isempty( ptr ) )
		return;

	todo = g_malloc0( sizeof( gI_todo ) );
	todo->item = malloc( (strlen( ptr ) + 1) * sizeof( gchar ) );
	strcpy( todo->item, ptr );
	todo->status = N_TODO_TODO;

	insrow[0] = ptr;
	insrow[1] = todo_status[N_TODO_TODO];
	row = gtk_clist_append( GTK_CLIST( todo_list ), insrow );
	gtk_clist_set_row_data( GTK_CLIST( todo_list ), row, (gpointer) todo );

	gtk_entry_set_text( GTK_ENTRY( e_todo ), "" );
}


static void todo_remove_select( GtkWidget *widget, gpointer data )
{
	if( todo_selected == -1 )
	{
		gI_error_dialog( _("No Item selected!") );
		return;
	}

	gtk_clist_remove( GTK_CLIST( todo_list ), todo_selected );

	todo_selected = -1;
}

static void inc_status_select( GtkWidget *widget, gpointer data )
{
	gI_todo *todo;
	glong save_selection;
	FILE *changelog;
	gI_project *project;
	time_t tptr;
	gchar *user;
	gchar tstr[100];
	gchar *ptr;
	gchar *tmpname = NULL;

	if( todo_selected == -1 )
	{
		gI_error_dialog( _("No Item selected!") );
		return;
	}

	save_selection = todo_selected;

	todo = (gI_todo *) gtk_clist_get_row_data( GTK_CLIST( todo_list ), todo_selected );

	if( todo->status < N_TODO_DONE )
	{
		todo->status++;
	}
	else
	{
		/* message box? */
		return;
	}

	if( cfg->changelog )
	{
		if( todo->status == N_TODO_DONE )
		{
			project = gI_project_get_current();

			if( isempty( project->changelog ) )
			{
				/* error handling */
				gI_error_dialog( _("No ChangeLog-File specified.") );
				return;
			}

			if( file_exist( project->changelog ) )
			{
				tmpname = move_to_tmp( project->changelog );
				if( !tmpname )
				{
					/* error handling */
					gI_error_dialog( _("Unable to move ChangeLog to temponary file") );
					return;
				}
			}
			changelog = fopen( project->changelog, "w" );
			if( !changelog )
			{
				/* error handling */
				gI_error_dialog( _("Unable to Open ChangeLog-File") );
				return;
			}

			tptr = time(NULL);
			strcpy( tstr, ctime( &tptr ) );
			ptr = strchr( tstr, '\n' );
			if( ptr )
				*ptr = '\0';
			user = getenv( "USER" );
			if( user )
				fprintf( changelog, "%s <%s>\n", tstr, user );
			else
				fprintf( changelog, "%s\n", tstr );
			fprintf( changelog, "\t* %s\n", todo->item );
			fprintf( changelog, "\n" );

			fclose( changelog );

			if( tmpname )
				append_file( project->changelog, tmpname );

			remove( tmpname );

			g_free( tmpname );
		}
	}

	gtk_clist_set_text( GTK_CLIST( todo_list ), todo_selected, 1, todo_status[todo->status] );
	gtk_clist_set_row_data( GTK_CLIST( todo_list ), todo_selected, (gpointer) todo );

	todo_selected = save_selection;
}

static void dec_status_select( GtkWidget *widget, gpointer data )
{
	gI_todo *todo;
	glong save_selection;

	if( todo_selected == -1 )
		return;

	save_selection = todo_selected;

	todo = (gI_todo *) gtk_clist_get_row_data( GTK_CLIST( todo_list ), todo_selected );

	if( todo->status > N_TODO_TODO )
	{
		todo->status--;
	}
	else
	{
		/* message box? */
		return;
	}

	gtk_clist_set_text( GTK_CLIST( todo_list ), todo_selected, 1, todo_status[todo->status] );
	gtk_clist_set_row_data( GTK_CLIST( todo_list ), todo_selected, (gpointer) todo );

	todo_selected = save_selection;
}


static void todo_list_select( GtkWidget *widget, gint row, gint column, GdkEventButton *bevent )
{
	GList *selection;

	selection = GTK_CLIST( widget )->selection;
	if( !selection )
		todo_selected = -1;
	else
		todo_selected = row;
}
#endif  /* NEW TODO LIST */

static glong target_exist( gI_project *project, gchar *target )
{
	glong i;

	for(i=0;i<project->targets_no;i++)
	{
		if( !strcmp( project->targets[i]->name, target ) )
			return( 1 );
	}

	return( 0 );
}


static void _ttt_add_select( GtkWidget *widget, GtkWidget *entry )
{
	gchar *target;
	gchar *insrow[3];
	glong row;
	gchar *selected_target;

	gtk_clist_get_text( GTK_CLIST( target_list ), target_selected, 0, &selected_target );
	target = gtk_entry_get_text( GTK_ENTRY( entry ) );

	if( !target || isempty( target ) )
		return;

	if( !target_exist( gI_project_get_current(), target ) )
	{
		gI_error_dialog( _("Specified target does not exist!") );
		return;
	}

	insrow[0] = target;
	insrow[1] = TARGET;
	insrow[2] = selected_target;
	row = gtk_clist_append( GTK_CLIST( files_list ), insrow );
	gtk_clist_set_row_data( GTK_CLIST( files_list ), row, (gpointer) selected_target );
}


static void ttt_add_select( GtkWidget *widget, gpointer data )
{
	if( target_selected == -1 )
	{
		gI_error_dialog( _("No Target selected!") );
		return;
	}

	entry_dialog( "Target", "Add Target", _ttt_add_select );
}

/* Project file constructor.  Initializes files, todo items, but not libs.*/
static gI_project *project_create( void )
{
	glong i,j;
	gI_project *project;

	project = g_malloc0(sizeof(gI_project));

	for(i=0;i<MAX_PROJECT_TARGETS;i++)
		project->targets[i] = g_malloc0( sizeof( gI_target ) );

#ifdef OLD_TODO_LIST /* NEW TODO LIST */
	for(i=0;i<MAX_TODO_ITEMS;i++)
		project->todo[i] = g_malloc0( sizeof( gI_todo ) );
#endif

	project->filename = NULL;
	project->name = NULL;
	project->version = NULL;
	project->changelog = NULL;
	project->prjroot = NULL;
	project->prjfdir = NULL;
	for(j=0;j<MAX_PROJECT_TARGETS;j++)
	{
		for(i=0;i<MAX_PROJECT_FILES;i++)
		{
			project->targets[j]->sources[i] = NULL;
			project->targets[j]->build[i] = 0;
		}
		project->targets[j]->name = NULL;
		project->targets[j]->sources_no = 0;
	}
	project->libs_no = 0;
	for(i=0;i<MAX_PROJECT_FILES;i++)
		project->libs[i] = NULL;
	project->cpar = NULL;
	project->cinc = NULL;
	project->lpar = NULL;
	project->llib = NULL;

#ifdef OLD_TODO_LIST /* NEW TODO LIST */
	for(i=0;i<MAX_TODO_ITEMS;i++)
	{
		project->todo[i]->item = NULL;
		project->todo[i]->status = 0;
	}
#endif

	project->mtarget = NULL;

	return project;
}

/* Destructor function to destroy project & deallocate mem etc. */
static void project_destroy( gI_project *project )
{
	glong i, j;

	g_assert( project );

	if( project->filename )
		g_free( project->filename );
	if( project->name )
		g_free( project->name );
	if( project->version )
		g_free( project->version);
	if( project->changelog )
		g_free( project->changelog);

	if( project->prjroot )
		g_free( project->prjroot );
	if( project->prjfdir )
		g_free( project->prjfdir );

	for(j=0; j<MAX_PROJECT_TARGETS; j++)
	{
		for(i=0; i < project->targets[j]->sources_no ; i++)
		{
			g_assert( project->targets[j]->sources[i] ); /* presumably, sources_no
									should work */
			g_free( project->targets[j]->sources[i] );
		}
		if( project->targets[j]->name )
			g_free( project->targets[j]->name );
		g_free( project->targets[j] );
	}

	for(j=0; j<MAX_PROJECT_FILES && j<project->libs_no; j++) /* presumably,
							      libs_no works */
	{
		g_assert( project->libs[j] );
		g_free( project->libs[j] );
	}

	if( project->cpar )
		g_free( project->cpar );
	if( project->cinc )
		g_free( project->cinc );
	if( project->lpar )
		g_free( project->lpar );
	if( project->llib )
		g_free( project->llib );

#ifdef OLD_TODO_LIST /* NEW TODO LIST */
	for(i=0;i<MAX_TODO_ITEMS;i++)
	{
		if( project->todo[i]->item )
			g_free( project->todo[i]->item );
		g_free( project->todo[i] );
	}
#else
	gI_todo_list_destroy(project->todoList);
#endif

	if( project->mtarget )
		g_free( project->mtarget );

	g_free( project );

}

static void project_ok_select( GtkWidget *widget, gI_project *project )
{
	gchar *ptr;
	gchar *selected_target;
	gchar *selected_lib;
	gchar *target_target;
	gchar *target_file;
	gchar *file_comment;
	gchar msg[STRLEN];
	glong i,j;
	glong sources_no;
	FILE *prjfile;

#ifdef OLD_TODO_LIST /* TODO LIST */
	gI_todo *tmp_todo;
#endif

	gchar *build;

	/* save project */
	ptr = gtk_entry_get_text( GTK_ENTRY( e_prjname ) );
	if( ptr )
	{
		if( isempty( ptr ) )
		{
			gI_error_dialog( _("Project Name is missing!") );
			return;
		}
		project->name = (gchar *) realloc( project->name, (strlen( ptr ) + 1 ) * sizeof( gchar ) );
		strcpy( project->name, ptr );
	}

	ptr = gtk_entry_get_text( GTK_ENTRY( e_prjver ) );
	if( ptr )
	{
		project->version = (gchar *) realloc( project->version, (strlen( ptr ) + 1 ) * sizeof( gchar ) ),
		                   strcpy( project->version, ptr );
	}

	ptr = gtk_entry_get_text( GTK_ENTRY( e_changelog ) );
	if( ptr )
	{
		project->changelog = (gchar *) realloc( project->changelog, (strlen( ptr ) + 1) * sizeof( gchar ) );
		strcpy( project->changelog, ptr );
	}

	ptr = gtk_entry_get_text( GTK_ENTRY( e_prjroot ) );
	if( ptr )
	{
		project->prjroot = (gchar *) realloc( project->prjroot, (strlen( ptr ) +1 ) );
		strcpy( project->prjroot, ptr );
	}

	ptr = gtk_entry_get_text( GTK_ENTRY( e_prjfdir ) );
	if( ptr )
	{
		project->prjfdir = (gchar *) realloc( project->prjfdir, (strlen( ptr ) + 1) );
		strcpy( project->prjfdir, ptr );
	}

	for(i=0;i<(GTK_CLIST( target_list )->rows);i++)
	{
		if (i>=MAX_PROJECT_TARGETS)
		{
			g_snprintf( msg, sizeof(msg), _("\nUnable to save more than %d targets per project! If you need\n more, then change the \"#define MAX_PROJECT_TARGETS\"\nin structs.h and recompile.\n"), MAX_PROJECT_TARGETS);
			gI_error_dialog( msg);
			break;
		}
		gtk_clist_get_text( GTK_CLIST( target_list ), i, 0, &selected_target );
		project->targets[i]->name = (gchar *) realloc( project->targets[i]->name, (strlen( selected_target ) + 1) * sizeof( gchar ) );
		strcpy( project->targets[i]->name, selected_target );
		sources_no = -1;
		for(j=0;j<(GTK_CLIST( files_list )->rows);j++)
		{
			if (j>=MAX_PROJECT_FILES)
			{
				g_snprintf( msg, sizeof(msg), _("\nUnable to save more than %d files per project! If you need\n more, then change the \"#define MAX_PROJECT_FILES\"\nin structs.h and recompile.\n"), MAX_PROJECT_FILES);
				gI_error_dialog( msg);
				break;
			}
			gtk_clist_get_text( GTK_CLIST( files_list ), j, 0, &target_file );
			target_target = (gchar *) gtk_clist_get_row_data( GTK_CLIST( files_list ), j );
			if( !strcmp( selected_target, target_target ) )
			{
				sources_no++;
				gtk_clist_get_text( GTK_CLIST( files_list ), j, 1, &file_comment );
				if( !strcmp( file_comment, SOURCE ) )
				{
					gchar *p;

					if( project->targets[i]->sources[sources_no] )
						g_free( project->targets[i]->sources[sources_no] );

					if( !strncmp( target_file,
					              project->prjroot, strlen( project->prjroot ) ) )
					{
						p = target_file + strlen( project->prjroot );
						project->targets[i]->sources[sources_no] =
						    g_strdup( p );
					}
					else
					{
						project->targets[i]->sources[sources_no] =
						    g_strdup( target_file );
					}

					gtk_clist_get_text( GTK_CLIST( files_list ), j, 3, &build );
					if( !strncmp( build, "Yes", 3 ) )
						project->targets[i]->build[sources_no] = 1;	/* default: build */
					else
						project->targets[i]->build[sources_no] = 0;	/* default: build */
				}
				else
				{
					project->targets[i]->sources[sources_no] = (gchar *) realloc( project->targets[i]->sources[sources_no], (strlen( target_file ) + 2) * sizeof( gchar ) );
					sprintf( project->targets[i]->sources[sources_no], "%%%s", target_file );
				}
			}
		}
		if( sources_no == -1 )
			sources_no = 0;
		project->targets[i]->sources_no = sources_no + 1;
	}
	project->targets_no = GTK_CLIST( target_list )->rows;

	for(i=0;i<(GTK_CLIST( lib_list )->rows);i++)
	{
		if ( i >= MAX_PROJECT_FILES )
		{
			g_snprintf( msg, sizeof(msg), _("\nUnable to save more than %d libraries per\nproject! If you need more, change the \"#define MAX_PROJECT_FILES\"\nin structs.h and recompile.\n"), MAX_PROJECT_FILES );
			gI_error_dialog( msg);
			break;
		}
		gtk_clist_get_text( GTK_CLIST( lib_list ), i, 0, &selected_lib );
		project->libs[i] = (gchar *) realloc( project->libs[i], (strlen( selected_lib ) + 1) * sizeof( gchar ) );
		strcpy( project->libs[i], selected_lib );
	}
	project->libs_no = i;

	ptr = gtk_entry_get_text( GTK_ENTRY( e_cpar ) );
	if( ptr )
	{
		project->cpar = (gchar *) realloc( project->cpar, (strlen( ptr ) + 1) * sizeof( gchar ) );
		strcpy( project->cpar, ptr );
	}

	ptr = gtk_entry_get_text( GTK_ENTRY( e_cinc ) );
	if( ptr )
	{
		project->cinc = (gchar *) realloc( project->cinc, (strlen( ptr ) + 1) * sizeof( gchar ) );
		strcpy( project->cinc, ptr );
	}

	ptr = gtk_entry_get_text( GTK_ENTRY( e_lpar ) );
	if( ptr )
	{
		project->lpar = (gchar *) realloc( project->lpar, (strlen( ptr ) + 1) * sizeof( gchar ) );
		strcpy( project->lpar, ptr );
	}

	ptr = gtk_entry_get_text( GTK_ENTRY( e_llib ) );
	if( ptr )
	{
		project->llib = (gchar *) realloc( project->llib, (strlen( ptr ) + 1) * sizeof( gchar ) );
		strcpy( project->llib,  ptr );
	}

#ifdef OLD_TODO_LIST /* NEW TODO LIST */
	for(i=0;i<(GTK_CLIST( todo_list )->rows);i++)
	{
		if ( i >= MAX_TODO_ITEMS )
		{
			g_snprintf( msg, sizeof(msg), _("Unable to save more than %d ToDo items per\nproject! If you need more, change the \"#define MAX_TODO_ITEMS\"\nin structs.h and recompile"), MAX_TODO_ITEMS );
			gI_error_dialog( msg);
			break;
		}
		tmp_todo = (gI_todo *) gtk_clist_get_row_data( GTK_CLIST( todo_list ), i );
		project->todo[i]->item = realloc( project->todo[i]->item, (strlen( tmp_todo->item ) + 1) * sizeof( gchar ) );
		strcpy( project->todo[i]->item, tmp_todo->item );
		project->todo[i]->status = tmp_todo->status;
	}
	project->todo_no = i;
#endif

	ptr = gtk_entry_get_text( GTK_ENTRY( e_mtarget ) );
	if( ptr )
	{
		project->mtarget = (gchar *) realloc( project->mtarget, (strlen( ptr ) + 1) * sizeof( gchar ) );
		strcpy( project->mtarget, ptr );
	}

	if( !isempty( project->prjfdir ) && project->filename
	        && !strstr( project->filename, project->prjfdir ) )
	{
		g_free( project->filename );
		project->filename = NULL;
	}

	if( !isempty( project->prjfdir ) )
	{
		/* good way? */
		strcpy( prj_path, project->prjfdir );
	}

	if( !project->filename )
	{
		if( !isempty( project->version ) )
		{
			project->filename = g_strconcat( prj_path, "/", project->name, "-", project->version, ".prj", NULL );
		}
		else
		{
			project->filename = g_strconcat( prj_path, "/", project->name, ".prj", NULL );
		}
	}

	prjfile = fopen( project->filename, "w" );
	if( !prjfile )
	{
		/* error handling */
		gI_error_dialog( _("Unable to Create Project-File") );
		return;
	}

	fprintf( prjfile, "; gIDE %s - Project File\n\n", VERSION );

	fprintf( prjfile, "PROJECT: %s\n", project->name );
	fprintf( prjfile, "VERSION: %s\n", project->version );
	fprintf( prjfile, "CHANGELOG: !%s!\n", project->changelog );
	fprintf( prjfile, "MTARGET: !%s!\n", project->mtarget );
	fprintf( prjfile, "PRJROOT: !%s!\n", project->prjroot );
	fprintf( prjfile, "PRJFDIR: !%s!\n", project->prjfdir );

	fprintf( prjfile, "$TARGETS: %d\n", project->targets_no );
	for(i=0;i<project->targets_no;i++)
		fprintf( prjfile, "%s\n", project->targets[i]->name );
	fprintf( prjfile, "$END TARGETS\n" );

	for(j=0;j<project->targets_no;j++)
	{
		fprintf( prjfile, "$SOURCES: %d\n", project->targets[j]->sources_no );
		fprintf( prjfile, "%ld\n", j );
		for(i=0;i<project->targets[j]->sources_no;i++)
		{
			fprintf( prjfile, "%s\n", project->targets[j]->sources[i] );
			fprintf( prjfile, "%d\n", project->targets[j]->build[i] );
		}
		fprintf( prjfile, "$END SOURCES\n" );
	}

	fprintf( prjfile, "$LIBS: %d\n", project->libs_no );
	for(i=0;i<project->libs_no;i++)
		fprintf( prjfile, "%s\n", project->libs[i] );
	fprintf( prjfile, "$END LIBS\n" );

	fprintf( prjfile, "CPAR: !%s!\n", project->cpar );
	fprintf( prjfile, "CINC: !%s!\n", project->cinc );

	fprintf( prjfile, "LPAR: !%s!\n", project->lpar );
	fprintf( prjfile, "LLIB: !%s!\n", project->llib );

#ifdef OLD_TODO_LIST /* NEW TODO LIST */
	fprintf( prjfile, "$TODO: %d\n", project->todo_no );
	for(i=0;i<project->todo_no;i++)
	{
		if( cfg->remdone )
		{
			if( project->todo[i]->status < N_TODO_DONE )
				fprintf( prjfile, "!%s! %%%d%%\n", project->todo[i]->item, project->todo[i]->status );
		}
		else
			fprintf( prjfile, "!%s! %%%d%%\n", project->todo[i]->item, project->todo[i]->status );
	}
	fprintf( prjfile, "$END TODO\n" );
#else
	gI_todo_list_write_to_file(project->todoList, prjfile,
	                           "$Begin_Todo List",
	                           "$End_Todo List");
#endif

	fclose( prjfile );

	project_window_destroy( NULL, NULL );

	if( cfg->prjftree )
	{
		gtk_widget_show( main_window->tree_box );
		project_files_tree( main_window->tree_viewport, project );
	}
}

/* Create project edit/new/etc window.  Not project tree */
static void project_mask( gI_project *project, glong mode )
{
	gchar mode_str[32];
	GtkWidget *hbox;
	GtkWidget *vbox;
	GtkWidget *notebook;
	GtkWidget *book_vbox;
	GtkWidget *label;
	GtkWidget *frame;
	GtkWidget *_vbox;
	GtkWidget *hsep;
	GtkWidget *button;
	GtkWidget *scrwin;
	GtkWidget *temp;
	glong i,j,row;
	gchar *insrow[4];
	gchar *target_list_titles[] = { "Target", "Comment" };
	gchar *files_list_titles[] = { "File", "Comment", "Target", "Build" };

#ifdef OLD_TODO_LIST /* TODO LIST */
	gchar *todo_list_titles[] = { "Item", "Status" };
#endif

	if( project_window )
		return;

	project_window = gtk_window_new( GTK_WINDOW_TOPLEVEL );
	gtk_widget_set_usize( project_window, 550, 500 );

	switch( mode )
	{
	case 0:
		strcpy( mode_str, _("New Project") );
		break;

	case 4:
		strcpy( mode_str, _("Edit Project") );
		break;

	default:
		strcpy( mode_str, _("Project") );
	}

	gtk_window_set_title( GTK_WINDOW( project_window ), mode_str );
	gtk_signal_connect( GTK_OBJECT( project_window ), "destroy",
	                    GTK_SIGNAL_FUNC( project_window_destroy ), NULL );

	vbox = gtk_vbox_new( FALSE, 0 );
	gtk_container_add( GTK_CONTAINER( project_window ), vbox );
	gtk_widget_show( vbox );

	notebook = gtk_notebook_new();
	gtk_box_pack_start( GTK_BOX( vbox ), notebook, TRUE, TRUE, 5 );
	gtk_notebook_set_scrollable( GTK_NOTEBOOK( notebook ), TRUE );
	gtk_notebook_set_show_tabs( GTK_NOTEBOOK( notebook ), TRUE );
	gtk_notebook_set_show_border( GTK_NOTEBOOK( notebook ), TRUE );
	gtk_widget_show( notebook );


	/* Main */

	label = gtk_label_new( _("Project") );
	book_vbox = gtk_vbox_new( FALSE, 0 );
	gtk_notebook_append_page( GTK_NOTEBOOK( notebook ), book_vbox, label );
	gtk_widget_show( book_vbox );
	gtk_widget_show( label );

	frame = gtk_frame_new( _("Project") );
	gtk_box_pack_start( GTK_BOX( book_vbox ), frame, FALSE, TRUE, 10 );
	gtk_widget_show( frame );

	_vbox = gtk_vbox_new( FALSE, 0 );
	gtk_container_add( GTK_CONTAINER( frame ), _vbox );
	gtk_widget_show( _vbox );

	hbox = gtk_hbox_new( FALSE, 0 );
	gtk_box_pack_start( GTK_BOX( _vbox ), hbox, FALSE, TRUE, 10 );
	gtk_widget_show( hbox );

	label = gtk_label_new( _("Project Name       ") );
	gtk_box_pack_start( GTK_BOX( hbox ), label, FALSE, TRUE, 5 );
	gtk_widget_show( label );

	e_prjname = gtk_entry_new_with_max_length( 128 );
	gtk_box_pack_start( GTK_BOX( hbox ), e_prjname, TRUE, TRUE, 5 );
	gtk_widget_show( e_prjname );

	hbox = gtk_hbox_new( FALSE, 0 );
	gtk_box_pack_start( GTK_BOX( _vbox ), hbox, FALSE, TRUE, 10 );
	gtk_widget_show( hbox );

	label = gtk_label_new( _("Project Version    ") );
	gtk_box_pack_start( GTK_BOX( hbox ), label, FALSE, TRUE, 5 );
	gtk_widget_show( label );

	e_prjver = gtk_entry_new_with_max_length( 16 );
	gtk_box_pack_start( GTK_BOX( hbox ), e_prjver, TRUE, TRUE, 5 );
	gtk_widget_show( e_prjver );

	hbox = gtk_hbox_new( FALSE, 0 );
	gtk_box_pack_start( GTK_BOX( _vbox ), hbox, FALSE, TRUE, 10 );
	gtk_widget_show( hbox );

	label = gtk_label_new( _("Main Target Name") );
	gtk_box_pack_start( GTK_BOX( hbox ), label, FALSE, TRUE, 5 );
	gtk_widget_show( label );

	e_mtarget = gtk_entry_new_with_max_length( 255 );
	gtk_box_pack_start( GTK_BOX( hbox ), e_mtarget, TRUE, TRUE, 5 );
	gtk_widget_show( e_mtarget );

	hbox = gtk_hbox_new( FALSE, 0 );
	gtk_box_pack_start( GTK_BOX( _vbox ), hbox, FALSE, TRUE, 10 );
	gtk_widget_show( hbox );

	label = gtk_label_new( _("ChangeLog-File  ") );
	gtk_box_pack_start( GTK_BOX( hbox ), label, FALSE, TRUE, 5 );
	gtk_widget_show( label );

	e_changelog = gtk_entry_new_with_max_length( 255 );
	gtk_box_pack_start( GTK_BOX( hbox ), e_changelog, TRUE, TRUE, 5 );
	gtk_widget_show( e_changelog );

	frame = gtk_frame_new( _("Parameters") );
	gtk_box_pack_start( GTK_BOX( book_vbox ), frame, FALSE, TRUE, 10 );
	gtk_widget_show( frame );

	_vbox = gtk_vbox_new( FALSE, 0 );
	gtk_container_add( GTK_CONTAINER( frame ), _vbox );
	gtk_widget_show( _vbox );

	hbox = gtk_hbox_new( FALSE, 0 );
	gtk_box_pack_start( GTK_BOX( _vbox ), hbox, TRUE, TRUE, 10 );
	gtk_widget_show( hbox );

	label = gtk_label_new( _("Project Files Root Dir:") );
	gtk_box_pack_start( GTK_BOX( hbox ), label, FALSE, TRUE, 5 );
	gtk_widget_show( label );

	e_prjroot = gtk_entry_new_with_max_length( 255 );
	gtk_box_pack_start( GTK_BOX( hbox ), e_prjroot, TRUE, TRUE, 5 );
	gtk_widget_show( e_prjroot );

	hbox = gtk_hbox_new( FALSE, 0 );
	gtk_box_pack_start( GTK_BOX( _vbox ), hbox, TRUE, TRUE, 10 );
	gtk_widget_show( hbox );

	label = gtk_label_new( _("Project-File Dir:") );
	gtk_box_pack_start( GTK_BOX( hbox ), label, FALSE, TRUE, 5 );
	gtk_widget_show( label );

	e_prjfdir = gtk_entry_new_with_max_length( 255 );
	gtk_box_pack_start( GTK_BOX( hbox ), e_prjfdir, TRUE, TRUE, 5 );
	gtk_widget_show( e_prjfdir );


	label = gtk_label_new( _("Targets") );
	book_vbox = gtk_vbox_new( FALSE, 0 );
	gtk_notebook_append_page( GTK_NOTEBOOK( notebook ), book_vbox, label );
	gtk_widget_show( book_vbox );
	gtk_widget_show( label );

	frame = gtk_frame_new( _("Targets") );
	gtk_box_pack_start( GTK_BOX( book_vbox ), frame, TRUE, TRUE, 10 );
	gtk_widget_show( frame );

	_vbox = gtk_vbox_new( FALSE, 0 );
	gtk_container_add( GTK_CONTAINER( frame ), _vbox );
	gtk_widget_show( _vbox );

	hbox = gtk_hbox_new( FALSE, 0 );
	gtk_box_pack_start( GTK_BOX( _vbox ), hbox, TRUE, TRUE, 10 );
	gtk_widget_show( hbox );

	temp = gtk_scrolled_window_new(NULL,NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(temp),
	                               GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);
	gtk_widget_show(temp);
	gtk_box_pack_start( GTK_BOX( hbox ), temp, TRUE, TRUE, 5 );
	target_list = gtk_clist_new_with_titles( 2, target_list_titles );
	gtk_clist_column_titles_passive( GTK_CLIST( target_list ) );
	gtk_clist_set_column_width( GTK_CLIST( target_list ), 0, 250 );
	gtk_container_add(GTK_CONTAINER(temp), target_list);
	gtk_signal_connect( GTK_OBJECT( target_list ), "select_row",
	                    GTK_SIGNAL_FUNC( target_list_select ), NULL );
	gtk_signal_connect( GTK_OBJECT( target_list ), "unselect_row",
	                    GTK_SIGNAL_FUNC( target_list_select ), NULL );
	gtk_widget_show( target_list );

	hbox = gtk_hbox_new( FALSE, 0 );
	gtk_box_pack_start( GTK_BOX( _vbox ), hbox, FALSE, TRUE, 5 );
	gtk_widget_show( hbox );

	button = gtk_button_new_with_label( _("   New Target   ") );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, TRUE, 5 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
	                    GTK_SIGNAL_FUNC( target_add_select ), NULL );
	gtk_widget_show( button );

	button = gtk_button_new_with_label( _("  Remove Target  ") );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, TRUE, 5 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
	                    GTK_SIGNAL_FUNC( target_remove_select ), NULL );
	gtk_widget_show( button );

	e_target = gtk_entry_new_with_max_length( 255 );
	gtk_box_pack_start( GTK_BOX( hbox ), e_target, TRUE, TRUE, 5 );
	gtk_widget_show( e_target );

	label = gtk_label_new( _("Sources") );
	book_vbox = gtk_vbox_new( FALSE, 0 );
	gtk_notebook_append_page( GTK_NOTEBOOK( notebook ), book_vbox, label );
	gtk_widget_show( book_vbox );
	gtk_widget_show( label );

	frame = gtk_frame_new( _("Sources") );
	gtk_box_pack_start( GTK_BOX( book_vbox ), frame, TRUE, TRUE, 10 );
	gtk_widget_show( frame );

	_vbox = gtk_vbox_new( FALSE, 0 );
	gtk_container_add( GTK_CONTAINER( frame ), _vbox );
	gtk_widget_show( _vbox );

	scrwin = gtk_scrolled_window_new( NULL, NULL );
	gtk_box_pack_start( GTK_BOX( _vbox ), scrwin, TRUE, TRUE, 5 );
	gtk_widget_show( scrwin );
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrwin),
	                               GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);

	files_list = gtk_clist_new_with_titles( 4, files_list_titles );
	gtk_clist_column_titles_passive( GTK_CLIST( files_list ) );
	gtk_clist_set_selection_mode( GTK_CLIST( files_list ),
	                              GTK_SELECTION_EXTENDED );

	gtk_clist_set_column_width( GTK_CLIST( files_list ), 0, 300 );
	gtk_clist_set_column_width( GTK_CLIST( files_list ), 1, 60 );
	gtk_clist_set_column_width( GTK_CLIST( files_list ), 2, 100 );
	gtk_container_add( GTK_CONTAINER( scrwin ), files_list );
	/*gtk_box_pack_start( GTK_BOX( _vbox ), files_list, TRUE, TRUE, 5 );*/
	gtk_signal_connect( GTK_OBJECT( files_list ), "select_row",
	                    GTK_SIGNAL_FUNC( files_list_select ), NULL );
	gtk_widget_show( files_list );

	hbox = gtk_hbox_new( FALSE, 0 );
	gtk_box_pack_start( GTK_BOX( _vbox ), hbox, FALSE, TRUE, 10 );
	gtk_widget_show( hbox );

	button = gtk_button_new_with_label( _("   Add Files   ") );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, TRUE, 5 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
	                    GTK_SIGNAL_FUNC( files_add_select ), NULL );
	gtk_widget_show( button );

	button = gtk_button_new_with_label( _("  Remove Files  ") );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, TRUE, 5 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
	                    GTK_SIGNAL_FUNC( files_remove_select ), NULL );
	gtk_widget_show( button );

	button = gtk_button_new_with_label( _("   Add Target   ") );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, TRUE, 20 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
	                    GTK_SIGNAL_FUNC( ttt_add_select ), NULL );
	gtk_widget_show( button );


	label = gtk_label_new( _("Libraries") );
	book_vbox = gtk_vbox_new( FALSE, 0 );
	gtk_notebook_append_page( GTK_NOTEBOOK( notebook ), book_vbox, label );
	gtk_widget_show( book_vbox );
	gtk_widget_show( label );

	frame = gtk_frame_new( _("Libraries") );
	gtk_box_pack_start( GTK_BOX( book_vbox ), frame, TRUE, TRUE, 10 );
	gtk_widget_show( frame );

	_vbox = gtk_vbox_new( FALSE, 0 );
	gtk_container_add( GTK_CONTAINER( frame ), _vbox );
	gtk_widget_show( _vbox );

	temp = gtk_scrolled_window_new(NULL, NULL);
	gtk_box_pack_start( GTK_BOX( _vbox ), temp, TRUE, TRUE, 5 );
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(temp),
	                               GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);
	gtk_widget_show(temp);

	lib_list = gtk_clist_new( 1 );
	gtk_clist_column_titles_hide( GTK_CLIST( lib_list ) );
	gtk_clist_column_titles_passive( GTK_CLIST( lib_list ) );
	gtk_container_add(GTK_CONTAINER(temp), lib_list);
	gtk_signal_connect( GTK_OBJECT( lib_list ), "select_row",
	                    GTK_SIGNAL_FUNC( lib_list_select ), NULL );
	gtk_signal_connect( GTK_OBJECT( lib_list ), "unselect_row",
	                    GTK_SIGNAL_FUNC( lib_list_select ), NULL );
	gtk_widget_show( lib_list );

	hbox = gtk_hbox_new( FALSE, 0 );
	gtk_box_pack_start( GTK_BOX( _vbox ), hbox, FALSE, TRUE, 10 );
	gtk_widget_show( hbox );

	button = gtk_button_new_with_label( _("   Add   ") );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, TRUE, 5 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
	                    GTK_SIGNAL_FUNC( lib_add_select ), NULL );
	gtk_widget_show( button );

	button = gtk_button_new_with_label( _("  Remove  ") );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, TRUE, 5 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
	                    GTK_SIGNAL_FUNC( lib_remove_select ), NULL );
	gtk_widget_show( button );

	e_lib = gtk_entry_new_with_max_length( 255 );
	gtk_box_pack_start( GTK_BOX( hbox ), e_lib, TRUE, TRUE, 15 );
	gtk_widget_show( e_lib );


	label = gtk_label_new( _("Parameters") );
	book_vbox = gtk_vbox_new( FALSE, 0 );
	gtk_notebook_append_page( GTK_NOTEBOOK( notebook ), book_vbox, label );
	gtk_widget_show( book_vbox );
	gtk_widget_show( label );

	frame = gtk_frame_new( _("Compile") );
	gtk_box_pack_start( GTK_BOX( book_vbox ), frame, FALSE, TRUE, 10 );
	gtk_widget_show( frame );

	_vbox = gtk_vbox_new( FALSE, 0 );
	gtk_container_add( GTK_CONTAINER( frame ), _vbox );
	gtk_widget_show( _vbox );

	hbox = gtk_hbox_new( FALSE, 0 );
	gtk_box_pack_start( GTK_BOX( _vbox ), hbox, FALSE, TRUE, 10 );
	gtk_widget_show( hbox );

	label = gtk_label_new( _("Options        ") );
	gtk_box_pack_start( GTK_BOX( hbox ), label, FALSE, TRUE, 5 );
	gtk_widget_show( label );

	e_cpar = gtk_entry_new_with_max_length( 255 );
	gtk_box_pack_start( GTK_BOX( hbox ), e_cpar, TRUE, TRUE, 5 );
	gtk_widget_show( e_cpar );

	hbox = gtk_hbox_new( FALSE, 0 );
	gtk_box_pack_start( GTK_BOX( _vbox ), hbox, FALSE, TRUE, 10 );
	gtk_widget_show( hbox );

	label = gtk_label_new( _("Include-Path") );
	gtk_box_pack_start( GTK_BOX( hbox ), label, FALSE, TRUE, 5 );
	gtk_widget_show( label );

	e_cinc = gtk_entry_new_with_max_length( 255 );
	gtk_box_pack_start( GTK_BOX( hbox ), e_cinc, TRUE, TRUE, 5 );
	gtk_widget_show( e_cinc );


	frame = gtk_frame_new( _("Link") );
	gtk_box_pack_start( GTK_BOX( book_vbox ), frame, FALSE, TRUE, 10 );
	gtk_widget_show( frame );

	_vbox = gtk_vbox_new( FALSE, 0 );
	gtk_container_add( GTK_CONTAINER( frame ), _vbox );
	gtk_widget_show( _vbox );

	hbox = gtk_hbox_new( FALSE, 0 );
	gtk_box_pack_start( GTK_BOX( _vbox ), hbox, FALSE, TRUE, 10 );
	gtk_widget_show( hbox );

	label = gtk_label_new( _("Options  ") );
	gtk_box_pack_start( GTK_BOX( hbox ), label, FALSE, TRUE, 5 );
	gtk_widget_show( label );

	e_lpar = gtk_entry_new_with_max_length( 255 );
	gtk_box_pack_start( GTK_BOX( hbox ), e_lpar, TRUE, TRUE, 5 );
	gtk_widget_show( e_lpar );

	hbox = gtk_hbox_new( FALSE, 0 );
	gtk_box_pack_start( GTK_BOX( _vbox ), hbox, FALSE, TRUE, 10 );
	gtk_widget_show( hbox );

	label = gtk_label_new( _("Lib-Path") );
	gtk_box_pack_start( GTK_BOX( hbox ), label, FALSE, TRUE, 5 );
	gtk_widget_show( label );

	e_llib = gtk_entry_new_with_max_length( 255 );
	gtk_box_pack_start( GTK_BOX( hbox ), e_llib, TRUE, TRUE, 5 );
	gtk_widget_show( e_llib );


#ifdef OLD_TODO_LIST    /* NEW TODO LIST */
	label = gtk_label_new( "ToDo" );
	book_vbox = gtk_vbox_new( FALSE, 0 );
	gtk_notebook_append_page( GTK_NOTEBOOK( notebook ), book_vbox, label );
	gtk_widget_show( book_vbox );
	gtk_widget_show( label );

	frame = gtk_frame_new( "ToDo" );
	gtk_box_pack_start( GTK_BOX( book_vbox ), frame, TRUE, TRUE, 10 );
	gtk_widget_show( frame );

	_vbox = gtk_vbox_new( FALSE, 0 );
	gtk_container_add( GTK_CONTAINER( frame ), _vbox );
	gtk_widget_show( _vbox );

	todo_list = gtk_clist_new_with_titles( 2, todo_list_titles );
	gtk_clist_column_titles_passive( GTK_CLIST( todo_list ) );
	gtk_clist_set_column_width( GTK_CLIST( todo_list ), 0, 400 );
	gtk_box_pack_start( GTK_BOX( _vbox ), todo_list, TRUE, TRUE, 5 );
	gtk_signal_connect( GTK_OBJECT( todo_list ), "select_row",
	                    GTK_SIGNAL_FUNC( todo_list_select ), NULL );
	gtk_signal_connect( GTK_OBJECT( todo_list ), "unselect_row",
	                    GTK_SIGNAL_FUNC( todo_list_select ), NULL );
	gtk_widget_show( todo_list );

	frame = gtk_frame_new( _("New Item") );
	gtk_box_pack_start( GTK_BOX( book_vbox ), frame, FALSE, TRUE, 10 );
	gtk_widget_show( frame );


	_vbox = gtk_vbox_new( FALSE, 0 );
	gtk_container_add( GTK_CONTAINER( frame ), _vbox );
	gtk_widget_show( _vbox );

	hbox = gtk_hbox_new( FALSE, 0 );
	gtk_box_pack_start( GTK_BOX( _vbox ), hbox, FALSE, TRUE, 10 );
	gtk_widget_show( hbox );

	e_todo = gtk_entry_new_with_max_length( 255 );
	gtk_box_pack_start( GTK_BOX( hbox ), e_todo, TRUE, TRUE, 5 );
	gtk_widget_show( e_todo );

	button = gtk_button_new_with_label( _("   Add   ") );
	gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, TRUE, 10 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
	                    GTK_SIGNAL_FUNC( todo_add_select ), NULL );
	gtk_widget_show( button );

	hbox = gtk_hbox_new( FALSE, 0 );
	gtk_box_pack_start( GTK_BOX( _vbox ), hbox, FALSE, TRUE, 10 );
	gtk_widget_show( hbox );

	button = gtk_button_new_with_label( _(" Remove ") );
	gtk_box_pack_start( GTK_BOX( hbox ), button, TRUE, TRUE, 10 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
	                    GTK_SIGNAL_FUNC( todo_remove_select ), NULL );
	gtk_widget_show( button );

	button = gtk_button_new_with_label( _(" Inc. Status ") );
	gtk_box_pack_start( GTK_BOX( hbox ), button, TRUE, TRUE, 10 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
	                    GTK_SIGNAL_FUNC( inc_status_select ), NULL );
	gtk_widget_show( button );

	button = gtk_button_new_with_label( _(" Dec. Status ") );
	gtk_box_pack_start( GTK_BOX( hbox ), button, TRUE, TRUE, 10 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
	                    GTK_SIGNAL_FUNC( dec_status_select ), NULL );
	gtk_widget_show( button );

#else
	if(!project->todoList)
	{
		g_print("Creating project in mask");
		project->todoList = gI_todo_list_create();
	}

	project->todoPane = gI_todo_pane_create_from_todo(project->todoList);



	label = gtk_label_new("Todo");
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook),
	                         project->todoPane->vbox,
	                         label);

#endif


	hsep = gtk_hseparator_new();
	gtk_box_pack_start( GTK_BOX( vbox ), hsep, FALSE, TRUE, 5 );
	gtk_widget_show( hsep );

	hbox = gtk_hbox_new( FALSE, 0 );
	gtk_box_pack_start( GTK_BOX( vbox ), hbox, FALSE, TRUE, 10 );
	gtk_widget_show( hbox );


	button = gnome_stock_button( GNOME_STOCK_BUTTON_OK );
	gtk_box_pack_start( GTK_BOX( hbox ), button, TRUE, TRUE, 10 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
	                    GTK_SIGNAL_FUNC( project_ok_select ), project );
	gtk_widget_show( button );

	button = gnome_stock_button( GNOME_STOCK_BUTTON_CANCEL );
	gtk_box_pack_start( GTK_BOX( hbox ), button, TRUE, TRUE, 10 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
	                    GTK_SIGNAL_FUNC( project_window_destroy ), project );
	gtk_widget_show( button );

	/* if edit mode, insert data */
	if( mode == 4 )
	{
		/* We're apparently not guaranteed to have strings for these.
		gtk_entry doesn't like it if we pass a null string. */

		if(project->name)
			gtk_entry_set_text( GTK_ENTRY( e_prjname ), project->name );
		if(project->version)
			gtk_entry_set_text( GTK_ENTRY( e_prjver ), project->version );
		if(project->changelog)
			gtk_entry_set_text( GTK_ENTRY( e_changelog ), project->changelog );
		if(project->mtarget)
			gtk_entry_set_text( GTK_ENTRY( e_mtarget ), project->mtarget );

		for(i=0;i<project->targets_no;i++)
		{
			insrow[0] = project->targets[i]->name;
			insrow[1] = NOT_YET_SUPPORTED;
			gtk_clist_append( GTK_CLIST( target_list ), insrow );

			for(j=0;j<project->targets[i]->sources_no;j++)
			{
				if( project->targets[i]->sources[j][0] == '%' )
				{
					insrow[0] = (project->targets[i]->sources[j])+1;
					insrow[1] = TARGET;
					insrow[2] = project->targets[i]->name;
					insrow[3] = NO;
					row = gtk_clist_append( GTK_CLIST( files_list ), insrow );
					gtk_clist_set_row_data( GTK_CLIST( files_list ), row, (gpointer) project->targets[i]->name );
				}
				else
				{
					insrow[0] = project->targets[i]->sources[j];
					insrow[1] = SOURCE;
					insrow[2] = project->targets[i]->name;
					if( project->targets[i]->build[j] )
						insrow[3] = YES;
					else
						insrow[3] = NO;
					row = gtk_clist_append( GTK_CLIST( files_list ), insrow );
					gtk_clist_set_row_data( GTK_CLIST( files_list ), row, (gpointer) project->targets[i]->name );
				}
			}
		}

		for(i=0;i<project->libs_no;i++)
		{
			insrow[0] = project->libs[i];
			gtk_clist_append( GTK_CLIST( lib_list ), insrow );
		}

		/* Don't pass null pointers to gtk_entry... */
		if(project->cpar)
			gtk_entry_set_text( GTK_ENTRY( e_cpar ), project->cpar );
		if(project->cinc)
			gtk_entry_set_text( GTK_ENTRY( e_cinc ), project->cinc );
		if(project->lpar)
			gtk_entry_set_text( GTK_ENTRY( e_lpar ), project->lpar );
		if(project->llib)
			gtk_entry_set_text( GTK_ENTRY( e_llib ), project->llib );

#ifdef OLD_TODO_LIST  /* NEW TODO LIST */
		for(i=0;i<project->todo_no;i++)
		{
			insrow[0] = project->todo[i]->item;
			insrow[1] = todo_status[project->todo[i]->status];
			row = gtk_clist_append( GTK_CLIST( todo_list ), insrow );
			gtk_clist_set_row_data( GTK_CLIST( todo_list ), row, (gpointer) project->todo[i] );
		}
#endif

	}

	if( project->prjroot )
		gtk_entry_set_text( GTK_ENTRY( e_prjroot ), project->prjroot );
	if( project->prjfdir )
		gtk_entry_set_text( GTK_ENTRY( e_prjfdir ), project->prjfdir );
	else
		gtk_entry_set_text( GTK_ENTRY( e_prjfdir ), prj_path );

	/* Go to first page... */
	gtk_notebook_set_page(GTK_NOTEBOOK(notebook), 0);

	gtk_widget_show( project_window );
}


gI_project *gI_project_get_current()
{
	return( current_project );
}

/* Open and parse a project */
static void _project_open( GtkWidget *widget, gpointer data )
{
	gchar *selected_project[1];
	FILE *prjfile;
	gchar prjwp[MAXLEN];
	gchar buf[MAXLEN];
	gchar key[64], arg[256];
	gI_project *project;
	glong i,j,k;
	gchar *ptr;
	GList *selection;

	selection = GTK_CLIST( prj_list )->selection;
	if( !selection )
		return;

	prj_selected = (gint) selection->data;

	project = project_create();
	/* g_free( current_project );  */

	gtk_clist_get_text( GTK_CLIST( prj_list ), prj_selected, 0, selected_project );

	g_snprintf( prjwp, MAXLEN, "%s/%s.prj", prj_path, selected_project[0] );
	prjfile = fopen( prjwp, "r" );
	if( !prjfile )
	{
		gI_error_dialog( _("Unable to Open Project File") );
		return;
	}

	project->filename = g_strdup( prjwp );

	if( GTK_TOGGLE_BUTTON( cb_close )->active )
		_close_all_files( main_window );

	while( fgets( buf, sizeof(buf), prjfile ) )
	{
		strcpy( buf, SK_CutLeadingBlanks( buf ) );
		if( buf[0] == ';' || buf[0] == '#' )
			continue;

		if( sscanf( buf, "%s %s\n", key, arg ) == 2 )
		{
			if( !strcmp( key, "PROJECT:" ) )
			{
				project->name = (gchar *) malloc( (strlen( arg ) + 1) * sizeof( gchar ) );
				strcpy( project->name, arg );
			}

			if( !strcmp( key, "VERSION:" ) )
			{
				project->version = (gchar *) malloc( (strlen( arg ) + 1) * sizeof( gchar ) );
				strcpy( project->version, arg );
			}

			if( !strcmp( key, "CHANGELOG:" ) )
			{
				ptr = SK_GetBetween( buf, '!', '!' );
				project->changelog = (gchar *) malloc( (strlen( ptr ) +1) * sizeof( gchar ) );
				strcpy( project->changelog, ptr );
			}

			if( !strcmp( key, "MTARGET:" ) )
			{
				ptr = SK_GetBetween( buf, '!', '!' );
				project->mtarget = (gchar *) malloc( (strlen( ptr ) +1) * sizeof( gchar ) );
				strcpy( project->mtarget, ptr );
			}

			if( !strcmp( key, "PRJROOT:" ) )
			{
				ptr = SK_GetBetween( buf, '!', '!' );
				project->prjroot = (gchar *) malloc( (strlen( ptr ) +1) * sizeof( gchar ) );
				strcpy( project->prjroot, ptr );
			}

			if( !strcmp( key, "PRJFDIR:" ) )
			{
				ptr = SK_GetBetween( buf, '!', '!' );
				project->prjfdir = (gchar *) malloc( (strlen( ptr ) +1) * sizeof( gchar ) );
				strcpy( project->prjfdir, ptr );
			}

			if( !strcmp( key, "$TARGETS:" ) )
			{
				project->targets_no = atoi( arg );
				for(i=0;i<project->targets_no;i++)
				{
					fgets( buf, sizeof(buf), prjfile );
					ptr = strchr( buf, '\n' );
					if( ptr )
						*ptr = '\0';
					project->targets[i]->name = (gchar *) malloc( (strlen( buf ) + 1) * sizeof( gchar ) );
					strcpy( project->targets[i]->name, buf );
				}
			}

			if( !strcmp( key, "$SOURCES:" ) )
			{
				k = atoi( arg );
				fgets( buf, sizeof(buf), prjfile );
				j = atoi( buf );
				project->targets[j]->sources_no = k;

				for(i=0;i<project->targets[j]->sources_no;i++)
				{
					fgets( buf, sizeof(buf), prjfile );
					ptr = strchr( buf, '\n' );
					if( ptr )
						*ptr = '\0';
					if( GTK_TOGGLE_BUTTON( cb_open )->active )
					{
						if( isempty( project->prjroot ) )
						{
							if( !check_file_open( buf ) )
								file_open_by_name( main_window, buf );
						}
						else
						{
							gchar cfname[MAXLEN];

							g_snprintf( cfname, sizeof(cfname), "%s/%s", project->prjroot, buf );
							if( !check_file_open( cfname ) )
								file_open_by_name( main_window, cfname );
						}
					}
					project->targets[j]->sources[i] = (gchar *) malloc( (strlen( buf ) + 1) * sizeof( gchar ) );
					strcpy( project->targets[j]->sources[i], buf );

					fgets( buf, sizeof(buf), prjfile );
					project->targets[j]->build[i] = atoi( buf );
				}
			}

			if( !strcmp( key, "$LIBS:" ) )
			{
				project->libs_no = atoi( arg );

				for(i=0;i<project->libs_no;i++)
				{
					fgets( buf, sizeof( buf ), prjfile );
					if( feof( prjfile ) )
					{
						g_error( "Unfinished Statement in Project-File\n" );
						exit( -1 );
					}

					if( !strcmp( buf, "$END LIBS" ) )
					{
						/* something is going wrong */
						break;
					}

					project->libs[i] = (gchar *) malloc( (strlen( buf ) + 1) * sizeof( gchar ) );
					ptr = strchr( buf, '\n' );
					if( ptr )
						*ptr = '\0';
					strcpy( project->libs[i], buf );
				}

			}

			if( !strcmp( key, "CPAR:" ) )
			{
				strcpy( arg, SK_GetBetween( buf,  '!', '!' ) );
				project->cpar = (gchar *) malloc( (strlen( buf ) + 1) * sizeof( gchar ) );
				strcpy( project->cpar, arg );
			}

			if( !strcmp( key, "CINC:" ) )
			{
				strcpy( arg, SK_GetBetween( buf, '!', '!' ) );
				project->cinc = (gchar *) malloc( (strlen( buf ) + 1) * sizeof( gchar ) );
				strcpy( project->cinc, arg );
			}

			if( !strcmp( key, "LPAR:" ) )
			{
				strcpy( arg, SK_GetBetween( buf, '!', '!' ) );
				project->lpar = (gchar *) malloc( (strlen( buf ) + 1) * sizeof( gchar ) );
				strcpy( project->lpar, arg );
			}

			if( !strcmp( key, "LLIB:" ) )
			{
				strcpy( arg, SK_GetBetween( buf, '!', '!' ) );
				project->llib = (gchar *) malloc( (strlen( buf ) + 1) * sizeof( gchar ) );
				strcpy( project->llib, arg );
			}

#ifdef OLD_TODO_LIST /* NEW TODO LIST */
			if( !strcmp( key, "$TODO:" ) )
			{
				project->todo_no = atoi( arg );
				for(i=0;i<project->todo_no;i++)
				{
					fgets( buf, sizeof(buf), prjfile );
					ptr = strchr( buf, '\n' );
					if( ptr )
						*ptr = '\0';
					ptr = SK_GetBetween( buf, '%', '%' );
					project->todo[i]->status = atoi( ptr );
					ptr = SK_GetBetween( buf, '!', '!' );
					project->todo[i]->item = (gchar *) malloc( (strlen( ptr ) + 1) * sizeof( gchar ) );
					strcpy( project->todo[i]->item, ptr );
				}
			}
#else
			if( !strcmp( key, "$Begin_Todo" ) )
			{
				project->todoList = gI_todo_list_read_from_file(
				                        prjfile,
				                        "$End_Todo List");
			}
#endif

		}
	}
	/*    current_project = g_malloc0( sizeof( gI_project ) ); No. */

	if(!project->todoList)
	{
		g_print("No todo list found");
		project->todoList = gI_todo_list_create();
	}

	_project_add_to_current(gI_project_get_current(), project);

	current_project = project;

	/***
	    if( GTK_TOGGLE_BUTTON( cb_select )->active )
	    {
	        project_window_destroy( NULL, NULL );
	        project_open_file( NULL, NULL );
	    }
	    else
	***/
	{
		project_window_destroy( NULL, NULL );
	}

	if( cfg->prjftree )
	{
		gtk_widget_show( main_window->tree_box );
		project_files_tree( main_window->tree_viewport, project );
	}

	prj_selected = -1;
}


static void _project_delete( GtkWidget *widget, gpointer data )
{
	gchar *selected_project;
	gchar prjwp[MAXLEN];
	FILE *prjfile;
	gchar buf[MAXLEN];
	gchar key[64],arg[64];
	gchar *ptr;
	glong k,j,i,hits;

	if( prj_selected == -1 )
		return;

	gtk_clist_get_text( GTK_CLIST( prj_list ), prj_selected, 0, &selected_project );
	g_snprintf( prjwp, MAXLEN, "%s/%s.prj", prj_path, selected_project );

	if( GTK_TOGGLE_BUTTON( cb_delete )->active )
	{
		/* in this case, we need to read the project file */
		prjfile = fopen( prjwp, "r" );
		if( !prjfile )
		{
			gI_error_dialog( _("Unable to Open Project File") );
			return;
		}

		/* we read only the sources */
		while( fgets( buf, MAXLEN, prjfile ) )
		{
			hits = sscanf( buf, "%s %s", key, arg );
			if( hits != 2 )
				continue;

			if( !strcmp( key, "$SOURCES:" ) )
			{
				k = atoi( arg );
				fgets( buf, sizeof(buf), prjfile );
				j = atoi( buf );

				for(i=0;i<k;i++)
				{
					fgets( buf, sizeof(buf), prjfile );
					ptr = strchr( buf, '\n' );
					if( ptr )
						*ptr = '\0';
					remove( buf );
				}
			}
			else
				continue;
		}
	}

	remove( prjwp );

	gtk_clist_remove( GTK_CLIST( prj_list ), prj_selected );
	prj_selected = -1;
}


static void prj_list_select( GtkWidget *widget, gint row, gint column, GdkEventButton *bevent )
{
	if( !bevent )
		return;

	if( bevent->type == GDK_2BUTTON_PRESS || bevent->type == GDK_3BUTTON_PRESS )
	{
		prj_selected = row;
		_project_open( NULL, NULL );
		prj_selected = -1;
	}
	else
	{
		GList *selection;

		selection = GTK_CLIST( widget )->selection;
		if( !selection )
			prj_selected = -1;
		else
			prj_selected = row;
	}
}


static void prjdir_activated( GtkWidget *widget, gpointer data )
{
	DIR *dir;
	struct dirent *dirent;
	gchar *path;
	gchar *insrow[1];
	gchar tmpstr[STRLEN];
	gchar *ptr;

	path = gtk_entry_get_text( GTK_ENTRY( e_prjdir ) );
	if( !path || isempty( path ) )
		return;

	gtk_clist_clear( GTK_CLIST( prj_list ) );

	/* insert data */
	dir = opendir( path );
	while( (dirent = readdir( dir )) )
	{
		if( strstr( dirent->d_name, ".prj" ) )
		{
			strncpy( tmpstr, dirent->d_name, STRLEN );
			ptr = strstr( tmpstr, ".prj" );
			if( ptr )
			{
				if( strncmp( ptr, ".prj", 4 ) )
					continue;
				*ptr = '\0';
			}
			insrow[0] = tmpstr;
			gtk_clist_append( GTK_CLIST( prj_list ), insrow );
		}
	}
	closedir( dir );

	/* dont know, if this is a good way.. */
	strcpy( prj_path, path );
}



static void gI_project_open_dialog()
{
	GtkWidget *vbox;
	GtkWidget *hbox;
	GtkWidget *button;
	GtkWidget *frame;
	GtkWidget *hsep;
	GtkWidget *frame_vbox;
	DIR *dir;
	struct dirent *dirent;
	gchar *insrow[1];
	gchar tmpstr[STRLEN];
	gchar *ptr;
	GtkWidget *label;

	if( project_window )
		return;

	project_window = gtk_window_new( GTK_WINDOW_TOPLEVEL );
	gtk_widget_set_usize( project_window, 275, 325 );
	gtk_window_set_title( GTK_WINDOW( project_window ), _("Open Project...") );
	gtk_signal_connect( GTK_OBJECT( project_window ), "destroy",
	                    GTK_SIGNAL_FUNC( project_window_destroy ), NULL );

	vbox = gtk_vbox_new( FALSE, 0 );
	gtk_container_add( GTK_CONTAINER( project_window ), vbox );
	gtk_widget_show( vbox );

	frame = gtk_frame_new( _("Projects") );
	gtk_box_pack_start( GTK_BOX( vbox ), frame, TRUE, TRUE, 5 );
	gtk_widget_show( frame );

	prj_list = gtk_clist_new( 1 );
	gtk_container_add( GTK_CONTAINER( frame ), prj_list );
	gtk_widget_set_usize( prj_list, 150, 75 );
	gtk_signal_connect( GTK_OBJECT( prj_list ), "select_row",
	                    GTK_SIGNAL_FUNC( prj_list_select ), NULL );
	gtk_signal_connect( GTK_OBJECT( prj_list ),"unselect_row",
	                    GTK_SIGNAL_FUNC( prj_list_select ), NULL );
	gtk_widget_show( prj_list );

	hsep = gtk_hseparator_new();
	gtk_box_pack_start( GTK_BOX( vbox ), hsep, FALSE, TRUE, 5 );
	gtk_widget_show( hsep );

	frame = gtk_frame_new( _("Options") );
	gtk_box_pack_start( GTK_BOX( vbox ), frame, FALSE, TRUE, 5 );
	gtk_widget_show( frame );

	frame_vbox = gtk_vbox_new( FALSE, 0 );
	gtk_container_add( GTK_CONTAINER( frame ), frame_vbox );
	gtk_widget_show( frame_vbox );

	cb_open = gtk_check_button_new_with_label( _("Open all Project Files") );
	gtk_box_pack_start( GTK_BOX( frame_vbox ), cb_open, FALSE, TRUE, 0 );
	gtk_widget_show( cb_open );

	cb_close = gtk_check_button_new_with_label( _("Close all other Files") );
	gtk_box_pack_start( GTK_BOX( frame_vbox ), cb_close, FALSE, TRUE, 0 );
	gtk_widget_show( cb_close );

	/*** was always non-functional
	    cb_select = gtk_check_button_new_with_label( "Project File Selector" );
	    gtk_box_pack_start( GTK_BOX( frame_vbox ), cb_select, FALSE, TRUE, 0 );
	    gtk_widget_show( cb_select );
	    gtk_widget_set_sensitive( cb_select, FALSE );
	***/

	hbox = gtk_hbox_new( FALSE, 0 );
	gtk_box_pack_start( GTK_BOX( frame_vbox ), hbox, FALSE, TRUE, 0 );
	gtk_widget_show( hbox );

	label = gtk_label_new( _("Directory:") );
	gtk_box_pack_start( GTK_BOX( hbox ), label, FALSE, TRUE, 5 );
	gtk_widget_show( label );

	e_prjdir = gtk_entry_new_with_max_length( 255 );
	gtk_box_pack_start( GTK_BOX( hbox ), e_prjdir, TRUE, TRUE, 1 );
	gtk_signal_connect( GTK_OBJECT( e_prjdir ), "activate",
	                    GTK_SIGNAL_FUNC( prjdir_activated ), NULL );
	gtk_widget_show( e_prjdir );

	hsep = gtk_hseparator_new();
	gtk_box_pack_start( GTK_BOX( vbox ), hsep, FALSE, TRUE, 5 );
	gtk_widget_show( hsep );

	hbox = gtk_hbox_new( FALSE, 0 );
	gtk_box_pack_start( GTK_BOX( vbox ), hbox, FALSE, TRUE, 10 );
	gtk_widget_show( hbox );

	button = gtk_button_new_with_label( _("Open") );
	gtk_box_pack_start( GTK_BOX( hbox ), button, TRUE, TRUE, 5 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
	                    GTK_SIGNAL_FUNC( _project_open ), NULL );
	gtk_widget_show( button );

	/* insert data */
	dir = opendir( prj_path );
	while( (dirent = readdir( dir )) )
	{
		if( strstr( dirent->d_name, ".prj" ) )
		{
			strncpy( tmpstr, dirent->d_name, STRLEN );
			ptr = strstr( tmpstr, ".prj" );
			if( ptr )
			{
				if( strncmp( ptr, ".prj", 4 ) )
					continue;
				*ptr = '\0';
			}
			insrow[0] = tmpstr;
			gtk_clist_append( GTK_CLIST( prj_list ), insrow );
		}
	}
	closedir( dir );

	gtk_entry_set_text( GTK_ENTRY( e_prjdir ), prj_path );

	gtk_widget_show( project_window );
}


static void gI_project_delete_dialog()
{
	GtkWidget *vbox;
	GtkWidget *hbox;
	GtkWidget *button;
	GtkWidget *frame;
	GtkWidget *hsep;
	GtkWidget *frame_vbox;
	DIR *dir;
	struct dirent *dirent;
	gchar *insrow[1];
	gchar tmpstr[STRLEN];
	gchar *ptr;

	if( project_window )
		return;

	project_window = gtk_window_new( GTK_WINDOW_TOPLEVEL );
	gtk_widget_set_usize( project_window, 250, 325 );
	gtk_window_set_title( GTK_WINDOW( project_window ), _("Delete Project...") );
	gtk_signal_connect( GTK_OBJECT( project_window ), "destroy",
	                    GTK_SIGNAL_FUNC( project_window_destroy ), NULL );

	vbox = gtk_vbox_new( FALSE, 0 );
	gtk_container_add( GTK_CONTAINER( project_window ), vbox );
	gtk_widget_show( vbox );

	frame = gtk_frame_new( _("Projects") );
	gtk_box_pack_start( GTK_BOX( vbox ), frame, TRUE, TRUE, 5 );
	gtk_widget_show( frame );

	prj_list = gtk_clist_new( 1 );
	gtk_container_add( GTK_CONTAINER( frame ), prj_list );
	gtk_widget_set_usize( prj_list, 150, 75 );
	gtk_signal_connect( GTK_OBJECT( prj_list ), "select_row",
	                    GTK_SIGNAL_FUNC( prj_list_select ), NULL );
	gtk_signal_connect( GTK_OBJECT( prj_list ),"unselect_row",
	                    GTK_SIGNAL_FUNC( prj_list_select ), NULL );
	gtk_widget_show( prj_list );

	hsep = gtk_hseparator_new();
	gtk_box_pack_start( GTK_BOX( vbox ), hsep, FALSE, TRUE, 5 );
	gtk_widget_show( hsep );

	frame = gtk_frame_new( _("Options") );
	gtk_box_pack_start( GTK_BOX( vbox ), frame, FALSE, TRUE, 5 );
	gtk_widget_show( frame );

	frame_vbox = gtk_vbox_new( FALSE, 0 );
	gtk_container_add( GTK_CONTAINER( frame ), frame_vbox );
	gtk_widget_show( frame_vbox );

	cb_delete = gtk_check_button_new_with_label( _("Delete all Project Files") );
	gtk_box_pack_start( GTK_BOX( frame_vbox ), cb_delete, FALSE, TRUE, 0 );
	gtk_widget_show( cb_delete );

	hsep = gtk_hseparator_new();
	gtk_box_pack_start( GTK_BOX( vbox ), hsep, FALSE, TRUE, 5 );
	gtk_widget_show( hsep );

	hbox = gtk_hbox_new( FALSE, 0 );
	gtk_box_pack_start( GTK_BOX( vbox ), hbox, FALSE, TRUE, 10 );
	gtk_widget_show( hbox );

	button = gtk_button_new_with_label( _("Delete") );
	gtk_box_pack_start( GTK_BOX( hbox ), button, TRUE, TRUE, 5 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
	                    GTK_SIGNAL_FUNC( _project_delete ), NULL );
	gtk_widget_show( button );

	/* insert data */
	dir = opendir( prj_path );
	while( (dirent = readdir( dir )) )
	{
		if( strstr( dirent->d_name, ".prj" ) )
		{
			strncpy( tmpstr, dirent->d_name, STRLEN );
			ptr = strstr( tmpstr, ".prj" );
			if( ptr )
				*ptr = '\0';
			insrow[0] = tmpstr;
			gtk_clist_append( GTK_CLIST( prj_list ), insrow );
		}
	}
	closedir( dir );

	gtk_widget_show( project_window );
}

/* If they selected Project->New menu */
void project_new( GtkWidget *widget, gpointer data )
{
	gI_project *project;

	/* if new mode, new gI_project */
	project = project_create();

	project->todoList = gI_todo_list_create();

	_project_add_to_current(gI_project_get_current(), project);

	project_mask( project, 0 );
}

/* Add project to project list.  Currently, just add it - fixme when needed */
static void _project_add_to_current(gI_project *parent_project, gI_project *project)
{
	g_assert(project);

	if(parent_project)
		project_destroy(parent_project);

	current_project = project;
}

void project_open( GtkWidget *widget, gpointer data )
{
	gI_project_open_dialog();
}


void project_delete( GtkWidget *widget, gpointer data )
{
	gI_project_delete_dialog();
}


void project_close( GtkWidget *widget, gpointer data )
{
	gI_project *project;

	project = gI_project_get_current();
	if( !project )
		return;

	gtk_widget_destroy( root_tree );
	root_tree = NULL;

	gtk_widget_hide( main_window->tree_box );

	gtk_widget_queue_resize( main_window->window );

	/* close the project */
	close_project_files( project );

	/* If a project window was open, close it */
	if( project_window )
	{
		gtk_widget_destroy( project_window );
		project_window = NULL;
	}

	/* free memory */
	/* g_free( project ); */
	/*    g_free( current_project );  Only once, please */

	project_destroy( project );

	gtk_paned_set_position( GTK_PANED( main_window->hpane ), 0 );

	project = NULL;
	current_project = NULL;
}


void project_edit( GtkWidget *widget, gpointer data )
{
	gI_project *project;

	project = gI_project_get_current();

	if( !project )
		return;

	project_mask( project, 4 );
}


void _close_all_files( gI_window *window )
{
	gint nod,i;

	nod = gI_document_get_no( main_window );

	for(i=0;i<nod;i++)
	{
		gtk_notebook_set_page( GTK_NOTEBOOK( main_window->notebook ), i );
		file_close( NULL, NULL );
	}
}


void close_all_files( GtkWidget *widget, gpointer data )
{
	_close_all_files( main_window );
}


void close_project_files( gI_project *project )
{
	glong j,k;
	gchar source[MAXLEN];

	for(k=0;k<project->targets_no;k++)
	{
		for(j=0;j<project->targets[k]->sources_no;j++)
		{
			if( isempty( project->prjroot ) )
				g_snprintf( source, sizeof(source), project->targets[k]->sources[j] );
			else
				g_snprintf( source, sizeof(source), "%s/%s", project->prjroot, project->targets[k]->sources[j] );

			if( check_file_open( source ) )
			{
				if( goto_file( source ) )
				{
					file_close( NULL, NULL );
				}
			}
		}
	}
}


void project_open_file( GtkWidget *widget, gpointer data )
{
	if( project_window )
		return;

	project_window = gtk_window_new( GTK_WINDOW_TOPLEVEL );
	gtk_widget_set_usize( project_window, 250, 250 );
	gtk_window_set_title( GTK_WINDOW( project_window ), _("Open Project File...") );
	gtk_widget_show( project_window );
}


void create_makefile( GtkWidget *widget, gpointer data )
{
	FILE *makefile;
	gI_project *project;
	glong i,j;
	gchar tmpstr[STRLEN];
	gchar *ptr;
	gchar *incpaths[64];
	gchar *libpaths[64];
	gchar libdirs[MAXLEN];
	gchar libs[MAXLEN];
	gchar includes[MAXLEN];
	gchar *mf;

	project = gI_project_get_current();

	/* create makefile for current project */
	if( project == NULL )
		return;

	if( !isempty( project->version ) )
		mf = g_strconcat(project->prjroot, "/Makefile", ".", project->name, "-", project->version, NULL );
	else
		mf = g_strconcat(project->prjroot, "/Makefile", ".", project->name, NULL );

	if( file_exist( mf ) )
	{
		if( gI_ask_dialog( _("The Makefile does already exist.\nDo You really want to overwrite it?")) != 0)
		{
			return;
		}
	}

	makefile = fopen( mf, "w" );
	if( !makefile )
	{
		g_free( mf );
		perror( "fopen" );
		return;
	}
	g_free( mf );

	strcpy( includes, "" );
	if( !isempty( project->cinc ) )
	{
		SK_GetFields( project->cinc, incpaths, ':' );

		for(i=1;i<(atoi(incpaths[0]));i++)
		{
			sprintf( includes, "%s -I%s", includes, incpaths[i] );
		}
	}

	strcpy( libdirs, "" );
	if( !isempty( project->llib ) )
	{
		SK_GetFields( project->llib, libpaths, ':' );

		for(i=1;i<(atoi(libpaths[0]));i++)
		{
			sprintf( libdirs, "%s -L%s", libdirs, libpaths[i] );
		}
	}

	strcpy( libs, "" );
	if( project->libs_no > 0 )
	{
		for(i=0;i<project->libs_no;i++)
		{
			sprintf( libs, "%s -l%s", libs, project->libs[i] );
		}
	}

	fprintf( makefile, "# Makefile for Project '%s' generated by gIDE %s\n", project->name, VERSION );

	fprintf( makefile, "CC=%s\n", cfg->cc );
	fprintf( makefile, "LD=%s\n", cfg->cc );
	fprintf( makefile, "RM=%s\n", "rm" );
	fprintf( makefile, "INSTALL=%s\n\n", "install" );

	fprintf( makefile, "INCLUDES=%s\n", includes );
	fprintf( makefile, "LIB_DIRS=%s\n", libdirs );
	fprintf( makefile, "LIBS=%s\n", libs );
	fprintf( makefile, "LDFLAGS=%s\n", project->lpar );
	fprintf( makefile, "CFLAGS=%s\n\n", project->cpar );

	fprintf( makefile, "COMPILE=$(CC) $(INCLUDES) $(CFLAGS) -c $<\n" );
	fprintf( makefile, "LINK=$(LD) $(LDFLAGS) -o $(MTARGET) $(OBJECTS) $(LIB_DIRS) $(LIBS)\n\n" );

	/***
	    fprintf( makefile, "all:" );
	    for(i=0;i<project->targets_no;i++)
	        fprintf( makefile, " %s", project->targets[i]->name );
	    fprintf( makefile, "\n" );
	***/


	/***
	    for(i=0;i<project->targets_no;i++)
	    {
	        fprintf( makefile, "%s:", project->targets[i]->name );
	        for(j=0;j<project->targets[i]->sources_no;j++)
	        {
	            fprintf( makefile, " %s", project->targets[i]->sources[j] );
	        }
	        fprintf( makefile, "\n\n" );
	    }
	***/

	fprintf( makefile, "MTARGET=%s\n", project->mtarget );

	fprintf( makefile, "OBJECTS=" );
	for(i=0;i<project->targets_no;i++)
	{
		for(j=0;j<project->targets[i]->sources_no;j++)
		{
			if( !project->targets[i]->build[j] )
				continue;

			strcpy( tmpstr, project->targets[i]->sources[j] );
			if( (ptr = strstr( tmpstr, ".c" )) )
			{
				*ptr = '\0';
				fprintf( makefile, " %s.o", g_basename( tmpstr ) );
			}
		}
	}
	fprintf( makefile, "\n\n" );

	fprintf( makefile, "all: %s\n\n", project->mtarget );

	fprintf( makefile, "%s: $(OBJECTS)\n", project->mtarget);
	fprintf( makefile, "\t$(LINK)\n\n" );

	for(i=0;i<project->targets_no;i++)
	{
		for(j=0;j<project->targets[i]->sources_no;j++)
		{
			if( !project->targets[i]->build[j] )
				continue;

			strcpy( tmpstr, project->targets[i]->sources[j] );
			if( (ptr = strstr( tmpstr, ".c" )) )
			{
				*ptr = '\0';
				fprintf( makefile, "%s.o:", g_basename( tmpstr ) );
				fprintf( makefile, " %s\n", g_basename( project->targets[i]->sources[j] ) );
				fprintf( makefile, "\t$(COMPILE)\n\n" );
			}
		}
	}
	fprintf( makefile, "\n\n" );

	fprintf( makefile, "install:\n\t$(INSTALL) -m 755 %s /usr/local/bin\n\n", project->mtarget );

	fprintf( makefile, "clean:\n\t$(RM) -f *~ core *.o %s\n", project->mtarget );
	fprintf( makefile, "\n\n" );

	fclose( makefile );
}


static void project_file_selected( GtkWidget *widget, GdkEventButton *event,  gchar *file )
{

	if (event->button==3)
	{
		GtkWidget *prj_popup_menu;
		GtkWidget *prj_popup_open_file;
		GtkWidget *prj_popup_new_file;
		GtkWidget *prj_popup_remove_file;

		prj_popup_menu=gtk_menu_new();
		prj_popup_open_file=gtk_menu_item_new_with_label
		                    (_("Open file in editor"));
		prj_popup_new_file=gtk_menu_item_new_with_label
		                    (_("Add new file to project"));
		prj_popup_remove_file=gtk_menu_item_new_with_label
		                    (_("Remove file from project"));

		gtk_signal_connect(GTK_OBJECT(prj_popup_open_file),"activate",
		                   GTK_SIGNAL_FUNC(project_open_file_in_editor),file);
		gtk_signal_connect(GTK_OBJECT(prj_popup_new_file),"activate",
		                   GTK_SIGNAL_FUNC(project_add_new_file_to),NULL);
		gtk_signal_connect(GTK_OBJECT(prj_popup_remove_file),"activate",
		                   GTK_SIGNAL_FUNC(project_remove_file_from),file);

		gtk_menu_append( GTK_MENU(prj_popup_menu),prj_popup_open_file);
		gtk_menu_append( GTK_MENU(prj_popup_menu),prj_popup_new_file);
		gtk_menu_append( GTK_MENU(prj_popup_menu),prj_popup_remove_file);
		gtk_widget_show_all(prj_popup_menu);

		gtk_menu_popup (GTK_MENU(prj_popup_menu), NULL, NULL, NULL, NULL,
		                event->button, event->time);
	}
	else if (event->button==1 && GTK_IS_TREE_ITEM( widget ) &&
	         (event->type == GDK_2BUTTON_PRESS ) )
	{
		gchar prjfile[MAXLEN];
		gI_project *project;

		project = gI_project_get_current();
		if( !project )
			return;

		if( project->prjroot )
			g_snprintf( prjfile, MAXLEN, "%s/%s", project->prjroot, file );
		else
			g_snprintf( prjfile, MAXLEN, "%s", file );

		if( !check_file_open( prjfile ) )
			file_open_by_name( main_window, prjfile );
		else
			goto_file( prjfile );
	}
}


void project_files_tree( GtkWidget *container, gI_project *project )
{
	GtkWidget *root_item;
	GtkWidget *sub_tree;
	GtkWidget *sub_item;
	GList *con_list;
	glong i,j;

	if( container == NULL )
		return;

	if( root_tree != NULL )
	{
		con_list = gtk_container_children( GTK_CONTAINER( container ) );
		if( con_list )
			gtk_container_remove( GTK_CONTAINER( container ), root_tree );
	}

	gtk_paned_set_position( GTK_PANED( main_window->hpane ), -1 );

	root_tree = gtk_tree_new();
	gtk_container_add( GTK_CONTAINER( container ), root_tree );
	gtk_widget_show( root_tree );

	root_item = gtk_tree_item_new_with_label( project->name );
	gtk_tree_append( GTK_TREE( root_tree ), root_item );

	for(j=0;j<project->targets_no;j++)
	{
		sub_tree = gtk_tree_new();
		gtk_tree_item_set_subtree( GTK_TREE_ITEM( root_item ), sub_tree );
		gtk_widget_show( sub_tree );

		for(i=0;i<project->targets[j]->sources_no;i++)
		{
			sub_item = gtk_tree_item_new_with_label( project->targets[j]->sources[i] );
			gtk_signal_connect( GTK_OBJECT( sub_item ), "button_press_event",
			                    GTK_SIGNAL_FUNC( project_file_selected ), project->targets[j]->sources[i] );
			gtk_tree_append( GTK_TREE( sub_tree ), sub_item );
			gtk_widget_show( sub_item );
		}
	}
	gtk_tree_item_expand( GTK_TREE_ITEM( root_item ) );
	gtk_widget_show( root_item );
}


void project_open_file_in_editor(GtkWidget *widget, gchar *file)
{
	gchar prjfile[MAXLEN];
	gI_project *project = gI_project_get_current();

	if( !project )
		return;

	if( !isempty( project->prjroot ) )
		g_snprintf( prjfile, MAXLEN, "%s/%s", project->prjroot, file );
	else
		g_snprintf( prjfile, MAXLEN, "%s", file );

	if( !check_file_open( prjfile ) )
		file_open_by_name( main_window, prjfile );
	else
		goto_file( prjfile );
}


void project_add_new_file_to(GtkWidget *widget,gpointer p )
{
	gI_ok_dialog( _("not supported yet") );
}


static void project_remove_file_from( GtkWidget *widget, gchar *file )
{
	glong i,j;
	gI_project *project;

	project = gI_project_get_current();
	if( !project )
		return;

	/****
		/- we should close the project mask -/
		if( project_window && GTK_WIDGET_VISIBLE( project_window ) )
		{
			if( modal_dialog( "This will close the Project Dialog\nAre You Sure?", "Close Dialog?", MB_YESNO ) == IDNO )
			{
				return;
			}

			gtk_widget_destroy( project_window );
		}
	****/

	for(i=0;i<project->targets_no;i++)
	{
		for(j=0;j<project->targets[i]->sources_no;j++)
		{
			if( !strcmp( project->targets[i]->sources[j], file ) )
			{
				/* move up entries */
				move_up_entries( project, i, j );

				if( project_window && GTK_WIDGET_VISIBLE( project_window ) )
					gtk_clist_remove( GTK_CLIST( files_list ), j );
			}
		}
	}

	/* its easier to re-generate the tree, than to correct it */
	if( cfg->prjftree )
	{
		gtk_widget_show( main_window->tree_box );
		project_files_tree( main_window->tree_viewport, project );
	}

}


glong cw_vis( gI_document *doc )
{
	if( !doc )
		return( 0 );
	if( !doc->compile_window )
		return( 0 );
	if( !doc->compile_window->window )
		return( 0 );
	if( !doc->compile_window->list )
		return( 0 );

	if( !GTK_WIDGET_VISIBLE( doc->compile_window->window ) )
		return( 0 );

	return( 1 );
}

/*
 * TODO: make it use compile sets for linker determination
 */
static void _build_project( gI_project *project, gchar *c_filename, gI_document *document, glong mode )
{
	gchar exec_string[MAXLEN];
	gchar filename[STRLEN];
	gchar exec_file[STRLEN];
	gchar *ptr, *path;
	gchar options[MAXLEN];
	gchar tmp_string[STRLEN];
	gchar buf[STRLEN];
	gchar *incpaths[64];
	gchar *libpaths[64];
	gchar *item[1];
	FILE *file;
	glong i;
	glong cset_found = 0;
	gI_comp_set *cset = NULL;
	gchar *p;

	switch( mode )
	{
		/* compile source files to objects */
	case 1:
		{
			if( c_filename == NULL || isempty( c_filename ) )
				return;

			strcpy( exec_file, c_filename );

			ptr = match_cset_fpat( (cset = get_comp_set_from_filename( c_filename )), exec_file );
			if( !ptr )
			{
				cset_found = 0;

				if( !(ptr = strstr( exec_file, ".c" )) )
					return;
			}
			else
			{
				cset_found = 1;
			}

			/* only files, no targets */
			if( c_filename[0] == '%' )
				return;

			/* tmp filename */
			g_snprintf( filename, STRLEN, "%s/gide_bldprj.%d.%d",
			            cfg->tmpdir, (int) time(0), (int)getpid() );

			/*strcpy( exec_file, c_filename );
			ptr = strstr( exec_file, ".c" );*/
			if( ptr )
				*ptr = '\0';

			if( isempty( project->prjroot ) )
			{
				gchar object[MAXLEN];

				g_snprintf( object, sizeof(object), "%s.o", exec_file );

				if( get_last_mod( object ) >= get_last_mod( c_filename ) )
				{
					sprintf( objects, "%s %s", objects, object );
					return;
				}
			}
			else
			{
				gchar object[MAXLEN];
				gchar source[MAXLEN];

				g_snprintf( object, sizeof(object), "%s/%s.o", project->prjroot, exec_file );
				g_snprintf( source, sizeof(object), "%s/%s", project->prjroot, c_filename );

				if( get_last_mod( object ) >= get_last_mod( source ) )
				{
					sprintf( objects, "%s %s", objects, object );
					return;
				}
			}

			/* change to working dir */
			path = get_path( c_filename );
			chdir( path );
			g_free( path );

			strcpy( options, project->cpar );

			if( !isempty( project->cinc ) )
			{
				SK_GetFields( project->cinc, incpaths, ':' );

				for(i=1;i<(atoi(incpaths[0]));i++)
				{
					sprintf( options, "%s -I%s", options, incpaths[i] );
				}
			}

			/* real exec */
			if( isempty( project->prjroot ) )
			{
				g_snprintf( exec_string, STRLEN, "%s -c \"(%s %s -c %s -o %s.o 1>%s 2>&1 ; touch %s.done) &\"", cfg->bash, cset_found ? cset->compiler : cfg->cc, options, c_filename, exec_file, filename, filename );
			}
			else
			{
				g_snprintf( exec_string, STRLEN, "%s -c \"(%s %s -c %s/%s -o %s/%s.o 1>%s 2>&1 ; touch %s.done) &\"", cfg->bash, cset_found ? cset->compiler : cfg->cc, options, project->prjroot, c_filename, project->prjroot, exec_file, filename, filename );
			}
			system( exec_string );

			if( !cw_vis( document ) )
				return;

			/**/
			ptr = strstr( exec_string, "1>" );
			if( ptr )
				*ptr = '\0';
			ptr = strchr( exec_string, '(' );
			ptr++;
			item[0] = ptr;
			gtk_clist_append( GTK_CLIST( document->compile_window->list ), item );

			g_snprintf( tmp_string, STRLEN, "%s.done", filename );
			while( !file_exist( tmp_string ) )
			{
				while( gtk_events_pending() )
				{
					/* process gtk stuff */
					gtk_main_iteration();
				}
			}

			/* remove .done file */
			remove( tmp_string );

			file = fopen( filename, "r" );
			while( fgets( buf, sizeof( buf ), file ) )
			{
				if( !cw_vis( document ) )
					return;

				/* new item */
				if( !isempty( buf ) )
				{
					/*
					 * a line splitter is needed here,
					 * but what how long is one line???
					 */

					/*
					 * MAX_LINE_LENGTH is defined in
						 * gI_compile.h, currently its set
					 * to 100. Maybe we should set dynamically
					 * depending on the current window width.		 
					 */

					if( strlen( buf ) > MAX_LINE_LENGTH )
					{
						p = &buf[0];
						while( strlen( p ) > MAX_LINE_LENGTH )
						{
							gchar *e = &p[MAX_LINE_LENGTH];
							gchar tmp[MAX_LINE_LENGTH+1];

							while( *e != ' ' )
								e--;

							strncpy( tmp, p, e-p );
							tmp[e-p] = '\0';

							item[0] = tmp;
							gtk_clist_append( GTK_CLIST( document->compile_window->list ), item );

							p = e + 1;
						}

						if( strlen( p ) > 0 )
						{
							item[0] = p;
							gtk_clist_append( GTK_CLIST( document->compile_window->list ), item );
						}
					}
					else
					{
						item[0] = buf;
						gtk_clist_append( GTK_CLIST( document->compile_window->list ), item );
					}
				}
			}

			/* remove the tmp file */
			remove( filename );

			/* add object to array */
			if( isempty( project->prjroot ) )
				sprintf( objects, "%s %s.o", objects, exec_file );
			else
				sprintf( objects, "%s %s/%s.o", objects, project->prjroot, exec_file );

			if( !cw_vis( document ) )
				return;

			/* correct the scrolling */
			gtk_clist_moveto( GTK_CLIST( document->compile_window->list ),
			                  GTK_CLIST( document->compile_window->list )->rows-1,
			                  0,
			                  1.0,
			                  0.0 );
			break;
		}

		/* link together to main target */
	case 2:
		{
			strcpy( options, project->lpar );

			if( isempty( project->prjroot ) )
			{
				g_snprintf( exec_string, STRLEN, "%s -c \"(%s %s -o %s ", cfg->bash, cset_found ? cset->linker : cfg->cc, options, project->mtarget );
			}
			else
			{
				gchar *path;

				path = get_path( project->mtarget );
				if( path[0] == '\0' )
				{
					g_snprintf( exec_string, STRLEN, "%s -c \"(%s %s -o %s/%s ", cfg->bash, cset_found ? cset->linker : cfg->cc, options, project->prjroot, project->mtarget );
				}
				else
				{
					g_snprintf( exec_string, STRLEN, "%s -c \"(%s %s -o %s ", cfg->bash, cset_found ? cset->linker : cfg->cc, options, project->mtarget );
				}

				g_free( path );
			}

			strcat( exec_string, objects );

			if( !isempty( project->llib ) )
			{
				SK_GetFields( project->llib, libpaths, ':' );

				for(i=1;i<(atoi(libpaths[0]));i++)
				{
					sprintf( options, "%s -L%s", options, libpaths[i] );
				}
			}

			for(i=0;i<project->libs_no;i++)
			{
				sprintf( options, "%s -l%s", options, project->libs[i] );
			}

			sprintf( exec_string, "%s %s 1>%s 2>&1 ; touch %s.done) &\"", exec_string, options, filename, filename );

			system( exec_string );

			if( !cw_vis( document ) )
				return;

			/**/
			ptr = strstr( exec_string, "1>" );
			if( ptr )
				*ptr = '\0';
			ptr = strchr( exec_string, '(' );
			ptr++;
			item[0] = ptr;
			gtk_clist_append( GTK_CLIST( document->compile_window->list ), item );
			g_snprintf( tmp_string, STRLEN, "%s.done", filename );
			while( !file_exist( tmp_string ) )
			{
				while( gtk_events_pending() )
				{
					/* process gtk stuff */
					gtk_main_iteration();
				}
			}

			/* remove .done file */
			remove( tmp_string );

			file = fopen( filename, "r" );
			while( fgets( buf, sizeof( buf ), file ) )
			{
				if( !cw_vis( document ) )
					return;

				/* new item */
				if( !isempty( buf ) )
				{
					/*
					 * a line splitter is needed here,
					 * but what how long is one line???
					 */

					/*
					 * MAX_LINE_LENGTH is defined in
						 * gI_compile.h, currently its set
					 * to 100. Maybe we should set dynamically
					 * depending on the current window width.		 
					 */

					if( strlen( buf ) > MAX_LINE_LENGTH )
					{
						p = &buf[0];
						while( strlen( p ) > MAX_LINE_LENGTH )
						{
							gchar *e = &p[MAX_LINE_LENGTH];
							gchar tmp[MAX_LINE_LENGTH+1];

							while( *e != ' ' )
								e--;

							strncpy( tmp, p, e-p );
							tmp[e-p] = '\0';

							item[0] = tmp;
							gtk_clist_append( GTK_CLIST( document->compile_window->list ), item );

							p = e + 1;
						}

						if( strlen( p ) > 0 )
						{
							item[0] = p;
							gtk_clist_append( GTK_CLIST( document->compile_window->list ), item );
						}
					}
					else
					{
						item[0] = buf;
						gtk_clist_append( GTK_CLIST( document->compile_window->list ), item );
					}
				}
			}

			if( !cw_vis( document ) )
				return;

			strcpy( buf, "Done." );
			item[0] = buf;
			gtk_clist_append( GTK_CLIST( document->compile_window->list ), item );

			/* remove temp file */
			remove( filename );

			if( !cw_vis( document ) )
				return;

			/* correct the scrolling */
			gtk_clist_moveto( GTK_CLIST( document->compile_window->list ),
			                  GTK_CLIST( document->compile_window->list )->rows-1,
			                  0,
			                  1.0,
			                  0.0 );

			break;
		}

	default:
		{
			g_warning( "this should never happen...report to sk@pn.org\n" );
			return;
		}
	}
}


void build_project( GtkWidget *widget, gpointer data )
{
	glong i,j;
	gI_document *current;
	gI_project *project;
	glong f = 0;
	static glong build_is_running = 0;

	if( build_is_running )
		return;

	build_is_running = 1;

	/* in fact, we don't need the curren document here, but w/ it, we can use the old functions */
	current = gI_document_get_current( main_window );
	if( !current )
	{
		current = gI_document_new( main_window );
	}

	project = gI_project_get_current();
	if( project != NULL )
	{
		if( current->compile_window == NULL )
		{
			current->compile_window = gI_compile_window_new( _("Compile Window") );
			gtk_signal_connect( GTK_OBJECT( current->compile_window->window ), "destroy",
			                    GTK_SIGNAL_FUNC( gI_compile_window_destroy ), current  );
			gtk_signal_connect( GTK_OBJECT( current->compile_window->close_button ), "clicked",
			                    GTK_SIGNAL_FUNC( gI_compile_window_destroy ), current );
			gtk_widget_show( current->compile_window->window );
		}

		/* init. */
		if( objects != NULL )
		{
			g_free( objects );
			objects = NULL;
		}

		show_compiling( current, current->compile_window );

		/* allocate memory for objects */
		for(i=0;i<project->targets_no;i++)
		{
			for(j=0;j<project->targets[i]->sources_no;j++)
			{
				f++;
			}
		}
		objects = g_malloc0( STRLEN * f );

		/* compile all project files */
		for(i=0;i<project->targets_no;i++)
		{
			for(j=0;j<project->targets[i]->sources_no;j++)
			{
				if( project->targets[i]->build[j] )	/* build the source? */
				{
					_build_project( project, project->targets[i]->sources[j], current, 1 );
				}
			}
		}
		_build_project( project, project->mtarget, current, 2 );

		if( objects != NULL )
		{
			g_free( objects );
			objects = NULL;
		}

		if( !cw_vis( current ) )
			return;

		gtk_widget_destroy( current->compile_window->comp_dialog );
		current->compile_window->comp_dialog = NULL;
	}

	build_is_running = 0;
}


gchar *move_to_tmp( gchar *filename )
{
	gchar *newfname;
	gchar tmpstuff[STRLEN];

	g_snprintf( tmpstuff, STRLEN, "%s/gide_chnglog^^.%d.%d", cfg->tmpdir,
	            (int) time(0), (int) getpid() );

	newfname = g_strdup( tmpstuff );

	if( rename( filename, newfname ) == -1 )
	{
		perror( "rename" );
		g_free( newfname );
		return( NULL );
	}

	return( newfname );
}


glong append_file( gchar *filea, gchar *fileb )
{
	FILE *fa, *fb;
	gchar buf[STRLEN];

	fa = fopen( filea, "a" );
	if( !fa )
	{
		perror( "fopen" );
		return( -1 );
	}

	fb = fopen( fileb, "r" );
	if( !fb )
	{
		perror( "fopen" );
		return( -1 );
	}

	while( fgets( buf, sizeof(buf), fb ) )
	{
		fputs( buf, fa );
	}

	fclose( fa );
	fclose( fb );

	return( 0 );
}


static void move_up_entries( gI_project *project, glong target, glong source )
{
	glong i;

	if( !project )
		return;

	for(i=source;i<(project->targets[target]->sources_no-1);i++)
	{
		project->targets[target]->sources[i] = realloc( project->targets[target]->sources[i], (strlen( project->targets[target]->sources[i+1] ) + 1) );
		strcpy( project->targets[target]->sources[i], project->targets[target]->sources[i+1] );
	}

	g_free( project->targets[target]->sources[project->targets[target]->sources_no] );
	project->targets[target]->sources_no--;
}


/****************************************************************************
 *
 *
 *
 ****************               TODO LIST           *************************
 *
 *
 *
 ****************************************************************************/

static const gchar *todo_status_strings[] = {
	        "Cancelled",
	        "To do",
	        "In progress",
	        "Done (still open)",
	        "Closed"
        };

/*********************************************************************
 *
 * Todo Items
 *
 * These are the individual items in the todo list.  They hold various
 * data, like timestamps etc.
 *********************************************************************/

/* Local functions declarations */

static void
todo_item_set_status_string(gI_TodoItem *todo);

static void
todo_item_set_time(gchar **todo_time,
                   gchar  *Time);
static gboolean
todo_getline(FILE *file,
             GString *buf);
static gI_TodoItem *
todo_item_read_item_from_file(FILE *file);
static void
todo_item_read_comments_from_file(FILE *file,
                                  gI_TodoItem *todo);

/* Implementation */


gI_TodoItem *
gI_todo_item_create(gchar *item,
                    gchar *time)
{
	gI_TodoItem *todo;

	g_return_val_if_fail(item != NULL, NULL);

	todo = g_new0(gI_TodoItem, 1);

	todo->item = g_new(gchar, strlen(item) + 1);
	strcpy(todo->item, item);

	todo_item_set_time(&(todo->openedTime), time);

	todo->todo_status = TODO_TODO;
	todo_item_set_status_string(todo);

	return todo;
}

void
gI_todo_item_destroy(gI_TodoItem *todo)
{
	gchar *temp;
	GList *list;

	g_return_if_fail(todo != NULL);

	g_free(todo->item);
	g_free(todo->openedTime);
	g_free(todo->closedTime);
	g_free(todo->dueDate);
	g_free(todo->assignedTo);

	list = todo->comments;
	while(list)
	{
		temp = list->data;
		g_free(temp);
		list = list->next;
	}

	g_free(todo);
}


void
gI_todo_item_increment(gI_TodoItem *todo)
{
	g_return_if_fail(todo != NULL);

	if(todo->todo_status >= TODO_DONE)
		return;

	todo->todo_status++;

	todo_item_set_status_string(todo);

	todo_item_set_time(&(todo->modifiedTime), NULL);
}

void
gI_todo_item_decrement(gI_TodoItem *todo)
{
	g_return_if_fail(todo != NULL);

	if(todo->todo_status <= TODO_CANCELLED)
		return;

	todo->todo_status--;

	todo_item_set_status_string(todo);

	todo_item_set_time(&(todo->modifiedTime), NULL);
}

void
gI_todo_item_close(gI_TodoItem *todo)
{
	g_return_if_fail(todo != NULL);

	todo->todo_status = TODO_CLOSED;

	todo_item_set_status_string(todo);

	todo_item_set_time(&(todo->modifiedTime), NULL);
	todo_item_set_time(&(todo->closedTime), NULL);
}

void
gI_todo_item_assign(gI_TodoItem *todo,
                    gchar       *who)
{
	g_return_if_fail(todo != NULL);

	todo->seen = FALSE;

	if(!who)
	{
		g_free(todo->assignedTo);
		todo->assignedTo = NULL;
	}
	else
	{
		todo->assignedTo = g_renew(gchar, todo->assignedTo, strlen(who) + 1);
		strcpy(todo->assignedTo, who);
	}
}

void
gI_todo_item_add_comment(gI_TodoItem *todo,
                         gchar *comment)
{
	gchar *buf;

	g_return_if_fail(todo);
	g_return_if_fail(comment);

	buf = g_new(gchar, strlen(comment) + 1);

	strcpy(buf, comment);

	todo->comments = g_list_append(todo->comments, buf);

	todo_item_set_time(&(todo->modifiedTime), NULL);
}

static void
todo_item_set_status_string(gI_TodoItem *todo)
{
	todo->status = todo_status_strings[todo->todo_status];
}

static void
todo_item_set_time(gchar **todo_time,
                   gchar  *Time)
{
	time_t *tm;
	gchar *temp;
	gint len;

	g_return_if_fail(todo_time != NULL);

	if(Time)
		temp = Time;
	else
	{
		tm = g_new(time_t, 1);
		time(tm);
		temp = ctime(tm);
	}

	len = strlen(temp);

	*todo_time = g_renew(gchar, *todo_time, len + 1);
	strcpy(*todo_time, temp);

	/* Ctime puts a newline in there */
	if(!Time)
		(*todo_time)[len - 1] = '\0';

}

/*********************************************************************
 *
 * Todo Item List
 *
 * This is a list of todo items.  We need a class for this, because
 * we need pointers to all attached Todo List Panes.  (IE, user
 * interfaces).  This is so we can link a sub-window back to the parent
 * and still let it be editable.
 *
 * Hence, we have to have a list of things that need to be updated.
 *
 *********************************************************************/

gI_TodoList *
gI_todo_list_create(void)
{
	return g_new0(gI_TodoList, 1);
}

void
gI_todo_list_destroy(gI_TodoList *tlist)
{
	GList *list;

	g_return_if_fail(tlist != NULL);

	list = tlist->todoItems;
	while(list)
	{
		gI_todo_item_destroy( (gI_TodoItem *) list->data);
		list = g_list_next(list);
	}

	g_free(tlist);
}

void
gI_todo_list_attach(gI_TodoList *tlist,
                    gI_TodoPane *tpane)
{
	g_return_if_fail(tlist != NULL);
	g_return_if_fail(tpane != NULL);

	tlist->todoPanes = g_list_append(tlist->todoPanes, tpane);
}

void
gI_todo_list_detach(gI_TodoList *tlist,
                    gI_TodoPane *tpane)
{
	g_return_if_fail(tlist != NULL);
	g_return_if_fail(tpane != NULL);

	tlist->todoPanes = g_list_remove(tlist->todoPanes, tpane);
}

inline void
gI_todo_list_add(gI_TodoList *tlist,
                 gI_TodoItem *todo)
{
	tlist->todoItems = g_list_append(tlist->todoItems, todo);
}

inline void
gI_todo_list_remove(gI_TodoList *tlist,
                    gI_TodoItem *todo)
{
	GList *tmp;

	tmp = g_list_find(tlist->todoItems, todo);

	g_return_if_fail(tmp != NULL);

	gI_todo_item_destroy( (gI_TodoItem *) tmp->data);

	tlist->todoItems = g_list_remove(tlist->todoItems, todo);
}


/* Print out the todo list to the specified file, using the specified
 * begin and end strings.
 */

gboolean
gI_todo_list_write_to_file(gI_TodoList *tlist,
                           FILE *file,
                           gchar *beginString,
                           gchar *endString)
{
	GString *buf;
	gI_TodoItem *todo;
	GList *items, *comments;
	gint a;

	g_return_val_if_fail(tlist, FALSE);
	g_return_val_if_fail(file, FALSE);
	g_return_val_if_fail(beginString, FALSE);
	g_return_val_if_fail(endString, FALSE);

	buf = g_string_new("");

	/* Print header to Todo List */

	fputs(beginString, file);
	fputs("\n", file);

	/* Print all Todo Items */

	items = tlist->todoItems;
	while(items)
	{
		todo = items->data;

		/* Item list */

		g_string_assign(buf, "$Begin Item\n");
		fputs(buf->str, file);

		/* Item */

		g_string_assign(buf, "Item: ");
		g_string_append(buf, todo->item);
		g_string_append_c(buf, '\n');

		fputs(buf->str, file);

		/* Status FIXME will fail if enum is changed */

		g_string_sprintf(buf, "Status: %d, %s\n",
		                 todo->todo_status,
		                 todo->status);
		fputs(buf->str, file);

		/* Times */

		g_string_sprintf(buf,
		                 "Times:\nOpened: %s\nModified: %s\nClosed: %s\nDue: %s\n",
		                 todo->openedTime,
		                 todo->modifiedTime ? todo->modifiedTime : "",
		                 todo->closedTime ? todo->closedTime : "",
		                 todo->dueDate ? todo->dueDate : "");
		fputs(buf->str, file);


		/* Assignment */

		g_string_sprintf(buf, "Assigned: %s\n",
		                 todo->assignedTo ? todo->assignedTo : "");
		fputs(buf->str, file);

		g_string_sprintf(buf, "Seen: %s\n", todo->seen ? "Yes" : "No");
		fputs(buf->str, file);


		/* Comments */

		g_string_assign(buf, "$Begin Comments:\n");
		fputs(buf->str, file);

		comments = todo->comments;
		while(comments)
		{
			g_string_assign(buf, comments->data);

			/* Comments might have newlines in them,
			 * so we replace the newline with a literal '\' 'n'
			 * and escape the backslashes */

			for(a = 0; a < buf->len; a++)
			{
				if(buf->str[a] == '\n')
				{
					g_string_erase(buf, a, 1);
					g_string_insert(buf, a, "\\n");
					a++;
				}
				else if(buf->str[a] == '\\')
				{
					g_string_insert_c(buf, a, '\\');
					a++;
				}
			}

			g_string_append_c(buf, '\n');
			fputs(buf->str, file);

			comments = g_list_next(comments);
		}

		g_string_assign(buf, "$End Comments\n");
		fputs(buf->str, file);

		/* End item */
		g_string_assign(buf, "$End Item\n");
		fputs(buf->str, file);

		items = g_list_next(items);
	}

	fputs(endString, file);
	fputs("\n", file);

	g_string_free(buf, FALSE);

	return TRUE;
}

/* Read in and create todo list from file.  The begin string must have
 * been seen by the calling function, so we only scan for the ending
 * string */

gI_TodoList *
gI_todo_list_read_from_file(FILE *file,
                            gchar *endString)
{
	gI_TodoList *tlist;
	gI_TodoItem *todo;
	GString *lineIn;

	g_return_val_if_fail(file, NULL);
	g_return_val_if_fail(file, NULL);

	lineIn = g_string_new("");
	tlist = gI_todo_list_create();

	while(todo_getline(file, lineIn) && strcmp(lineIn->str, endString))
	{
		if(strcmp(lineIn->str, "$Begin Item"))
			continue;

		todo = todo_item_read_item_from_file(file);

		if(todo)
			gI_todo_list_add(tlist, todo);
		else
			g_print("File IO Error reading Todo List!");
	}

	g_string_free(lineIn, FALSE);

	return tlist;
}

static gboolean
todo_getline(FILE *file,
             GString *buf)
{
	gchar c = 0;

	g_string_truncate(buf, 0);

	c = fgetc(file);
	while(!feof(file) && (c != '\n'))
	{
		g_string_append_c(buf, c);

		c = fgetc(file);
	}

	return !feof(file);
}

static gI_TodoItem *
todo_item_read_item_from_file(FILE *file)
{
	gI_TodoItem *todo;
	GString *lineIn;

	lineIn = g_string_new("");

	/* Item */

	todo_getline(file, lineIn);
	if(strncmp(lineIn->str, "Item: ", 6))
		return NULL;  /* Error! */
	g_string_erase(lineIn, 0, 6);

	todo = gI_todo_item_create(lineIn->str, "");

	/* Item Status */

	todo_getline(file, lineIn);
	if(strncmp(lineIn->str, "Status: ", 8))
		return NULL;  /* Error! */
	g_string_erase(lineIn, 0, 8);
	todo->todo_status = atoi(lineIn->str);
	todo_item_set_status_string(todo);

	/* Times */

	todo_getline(file, lineIn);
	if(strncmp(lineIn->str, "Times:", 6))
		return NULL;  /* Error! */

	todo_getline(file, lineIn);
	if(strncmp(lineIn->str, "Opened: ", 8))
		return NULL;  /* Error! */
	g_string_erase(lineIn, 0, 8);
	if(lineIn->len < 2)
		return NULL;  /* How can there be no creation date?! */
	todo_item_set_time(&(todo->openedTime), lineIn->str);

	todo_getline(file, lineIn);
	if(strncmp(lineIn->str, "Modified: ", 10))
		return NULL;  /* Error! */
	g_string_erase(lineIn, 0, 10);
	if(lineIn->len > 2)
		todo_item_set_time(&(todo->modifiedTime), lineIn->str);

	todo_getline(file, lineIn);
	if(strncmp(lineIn->str, "Closed: ", 8))
		return NULL;  /* Error! */
	g_string_erase(lineIn, 0, 8);
	if(lineIn->len > 2)
		todo_item_set_time(&(todo->modifiedTime), lineIn->str);

	todo_getline(file, lineIn);
	if(strncmp(lineIn->str, "Due: ", 5))
		return NULL;  /* Error! */
	g_string_erase(lineIn, 0, 5);
	if(lineIn->len > 2)
		todo_item_set_time(&(todo->dueDate), lineIn->str);


	/* Assigned To */


	todo_getline(file, lineIn);
	if(strncmp(lineIn->str, "Assigned: ", 10))
		return NULL;  /* Error! */
	g_string_erase(lineIn, 0, 10);
	if(lineIn->len > 2)
		gI_todo_item_assign(todo, lineIn->str);


	/* Does this person know it's assigned? */


	todo_getline(file, lineIn);
	if(strncmp(lineIn->str, "Seen: ", 6))
		return NULL;  /* Error! */
	g_string_erase(lineIn, 0, 6);
	if(lineIn->str[0] == 'Y')
		todo->seen = TRUE;
	else
		todo->seen = FALSE;

	todo_getline(file, lineIn);
	if(strncmp(lineIn->str, "$Begin Comments", 15))
		return NULL;  /* Error! */

	todo_item_read_comments_from_file(file, todo);

	g_string_free(lineIn, FALSE);

	return todo;
}

static void
todo_item_read_comments_from_file(FILE *file,
                                  gI_TodoItem *todo)
{
	GString *lineIn;
	gint a;

	lineIn = g_string_new("");

	while(todo_getline(file, lineIn) &&
	        strncmp(lineIn->str, "$End Comments", 14))
	{
		/* Strip escape gchars */

		for(a = 0; a < (lineIn->len - 1); a++)
		{
			if(lineIn->str[a] == '\\')
			{
				if(lineIn->str[a + 1] == 'n')
				{
					g_string_erase(lineIn, a, 2);
					g_string_insert_c(lineIn, a, '\n');
				}
				else if(lineIn->str[a + 1] == '\\')
				{
					g_string_erase(lineIn, a, 1);
				}
				else
					break; /* ERROR! */
			}
		}

		gI_todo_item_add_comment(todo, lineIn->str);
	}

	g_string_free(lineIn, FALSE);
}

/*************************************************************************
 *
 *
 *
 ****************   TODO PANE - Draws todo list in a vbox ****************
 *
 *
 *
 *************************************************************************/


/* Local strings *****************************************************/

static const gchar *listFrameTitle = N_("gIDE Todo List");
static const gchar *listEditFrameTitle = N_("List");
static const gchar *itemEditFrameTitle = N_("Item");
static const gchar *miscFrameTitle = N_("Misc");
static const gchar *newItemFrameTitle = N_("Enter new item name & assignment:");
static const gchar *commentFrameTitle = N_("Add comment:");

static const gchar *listEditNewTitle = N_(" New Item ");
static const gchar *listEditEditTitle = N_(" Edit ");
static const gchar *listEditDeleteTitle = N_(" Delete ");

static const gchar *itemEditIncrementTitle = N_(" Inc. Status ");
static const gchar *itemEditDecrementTitle = N_(" Dec. Status ");
static const gchar *itemEditCloseTitle = N_(" Close Item ");

static const gchar *miscAddCommentTitle = N_(" Add Comment ");
static const gchar *miscRemoveCommentTitle = N_(" Remove ");
static const gchar *miscAssignTitle = N_(" Assign to: ");

static const gchar *newItemAdd = N_(" Apply to List ");
static const gchar *newItemCancel = N_(" Cancel ");

static const gchar *commentAdd = N_(" Add Comment ");

static gchar *todoCTreeTitles[] = { "Item", "Assigned", "Status" };

static const gchar *todoItemOpenedDate =   N_("Created:        ");
static const gchar *todoItemModifiedDate = N_("Modified:       ");
static const gchar *todoItemClosedDate =   N_("Closed:         ");
static const gchar *todoItemDueDate =      N_("Completion Due: ");
static const gchar *todoItemComments =     N_("Comments:");

#if 0
static const gchar *errorNeedNameTitle = N_("Error");
#endif
static const gchar *errorNeedName = N_("Please enter a name for your Todo item");
static const gchar *errorNeedComment = N_("Please enter a comment to add" );

static const gchar *dialogAddChangelogTitle = N_("Add to changelog?");
static const gchar *dialogAddChangelogFrame = N_("Changelog addition:");
static const gchar *dialogAddChangelogOk = N_(" Add to Changelog ");
static const gchar *dialogAddChangelogCancel = N_(" Cancel ");

static const gint todo_sort_order[LAST_TODO] = {
	        10, /* TODO_CANCELLED */
	        1, /* TODO_TODO */
	        2, /* TODO_INPROGRESS */
	        3, /* TODO_DONE */
	        9 /* TODO_CLOSED */
        };

/* Local functions defs **********************************************/

static GList *
todo_pane_ctree_get_todo_selected(gI_TodoPane *tpane);

static void
todo_pane_set_row_text(gI_TodoPane *tpane,
                       GtkCTreeNode *node,
                       gchar *rowData[]);
static void
todo_pane_pack_node_from_todo(gI_TodoPane *tpane,
                              TodoPaneData *tdata,
                              gI_TodoItem *todo);
static void
changelogPopup(gchar *changelogEntry,
               gchar *changelogFileName);

/* Local Callbacks ***************************************************/

static gint
listEditNewButtonPress(GtkWidget *widget,
                       gpointer data);
static gint
listEditEditButtonPress(GtkWidget *widget,
                        gpointer data);
static gint
listEditDeleteButtonPress(GtkWidget *widget,
                          gpointer data);
static gint
itemIncrementButtonPress(GtkWidget *widget,
                         gpointer data);
static gint
itemDecrementButtonPress(GtkWidget *widget,
                         gpointer data);
static gint
itemCloseButtonPress(GtkWidget *widget,
                     gpointer data);
static gint
miscAddCommentButtonPress(GtkWidget *widget,
                          gpointer data);
static gint
miscRemoveCommentButtonPress(GtkWidget *widget,
                             gpointer data);
static gint
miscAssignButtonPress(GtkWidget *widget,
                      gpointer data);
static gint
newItemAddButtonPress(GtkWidget *widget,
                      gpointer data);
static gint
newItemCancelButtonPress(GtkWidget *widget,
                         gpointer data);
static gint
commentAddButtonPress(GtkWidget *widget,
                      gpointer data);
static gint
assignedColumnSortButtonPress(GtkWidget *widget,
                              gpointer data);
static gint
statusColumnSortButtonPress(GtkWidget *widget,
                            gpointer data);

static gint
statusColumnSortFunc(GtkCList *clist,
                     GtkCListRow *ptr1,
                     GtkCListRow *ptr2);
#ifdef HAVE_STRPTIME
static gint
itemColumnSortButtonPress(GtkWidget *widget,
                          gpointer data);
static gint
itemColumnSortFunc(GtkCList *clist,
                   GtkCListRow *ptr1,
                   GtkCListRow *ptr2);
#endif /* HAVE_STRPTIME */

static gint
dialogAddChangelogOkButtonPress(GtkWidget *widget,
                                gpointer data);


/* General functions *************************************************/

gI_TodoPane *
gI_todo_pane_create(void)
{
	GtkWidget *temp, *temp2;

	gI_TodoPane *tpane;

	tpane = g_new0(gI_TodoPane, 1);

	/* Top level elements */

	tpane->vbox = gtk_vbox_new(FALSE, FALSE);

	tpane->listFrame = gtk_frame_new( listFrameTitle );
	gtk_box_pack_start(GTK_BOX(tpane->vbox), tpane->listFrame,
	                   TRUE, TRUE, 0);

	tpane->ctree = gtk_ctree_new_with_titles( 3, 0, todoCTreeTitles );
	gtk_signal_connect(GTK_OBJECT(
	                       ((GtkCListColumn)(GTK_CLIST(tpane->ctree)->column[1]))
	                       .button), "clicked",
	                   GTK_SIGNAL_FUNC(assignedColumnSortButtonPress),
	                   tpane);
	gtk_signal_connect(GTK_OBJECT(
	                       ((GtkCListColumn)(GTK_CLIST(tpane->ctree)->column[2]))
	                       .button), "clicked",
	                   GTK_SIGNAL_FUNC(statusColumnSortButtonPress),
	                   tpane);

#ifdef HAVE_STRPTIME
	gtk_signal_connect(GTK_OBJECT(
	                       ((GtkCListColumn)(GTK_CLIST(tpane->ctree)->column[0]))
	                       .button), "clicked",
	                   GTK_SIGNAL_FUNC(itemColumnSortButtonPress),
	                   tpane);
#endif /* HAVE_STRPTIME */

	/* For 1.1.5 */
	temp = gtk_scrolled_window_new(NULL, NULL);

	gtk_container_add(GTK_CONTAINER(tpane->listFrame), temp);
	gtk_container_add(GTK_CONTAINER(temp), tpane->ctree);

	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(temp),
	                               GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);
	/* 1.1.5 */

	gtk_clist_set_column_width(GTK_CLIST(tpane->ctree), 0, 300);
	gtk_clist_set_column_width(GTK_CLIST(tpane->ctree), 1, 60);
	gtk_clist_set_column_width(GTK_CLIST(tpane->ctree), 2, 75);
#if 0 /* doesn't work right */
	gtk_clist_set_column_auto_resize(GTK_CLIST(tpane->ctree),
	                                 0, TRUE);
	gtk_clist_set_column_auto_resize(GTK_CLIST(tpane->ctree),
	                                 1, FALSE);
	gtk_clist_set_column_auto_resize(GTK_CLIST(tpane->ctree),
	                                 2, FALSE);
#endif
	gtk_clist_set_selection_mode(GTK_CLIST(tpane->ctree),
	                             GTK_SELECTION_EXTENDED);

	tpane->buttonHBox = gtk_hbox_new(FALSE, FALSE);
	gtk_box_pack_start(GTK_BOX(tpane->vbox), tpane->buttonHBox,
	                   FALSE, FALSE, 0);

	tpane->listEditFrame = gtk_frame_new( listEditFrameTitle );
	gtk_box_pack_start(GTK_BOX(tpane->buttonHBox), tpane->listEditFrame,
	                   FALSE, FALSE, 0);

	tpane->itemEditFrame = gtk_frame_new( itemEditFrameTitle );
	gtk_box_pack_start(GTK_BOX(tpane->buttonHBox), tpane->itemEditFrame,
	                   FALSE, FALSE, 0);

	tpane->miscFrame = gtk_frame_new( miscFrameTitle );
	gtk_box_pack_start(GTK_BOX(tpane->buttonHBox), tpane->miscFrame,
	                   FALSE, FALSE, 0);

	/* We pack the new item frame and the new comment frame into a
	   notebook with no tabs */

	tpane->editArea = gtk_notebook_new();

	/* Is this ok? */
	gtk_notebook_set_show_border(GTK_NOTEBOOK(tpane->editArea), FALSE);


	gtk_box_pack_start(GTK_BOX(tpane->buttonHBox), tpane->editArea,
	                   TRUE, TRUE, 0);

	temp = gtk_label_new("");
	tpane->newItemFrame = gtk_frame_new(newItemFrameTitle);
	gtk_notebook_append_page(GTK_NOTEBOOK(tpane->editArea),
	                         tpane->newItemFrame, temp);

	temp = gtk_label_new("");

	tpane->commentFrame = gtk_frame_new(commentFrameTitle);
	gtk_notebook_append_page(GTK_NOTEBOOK(tpane->editArea),
	                         tpane->commentFrame, temp);

	/* Blank page */
	temp = gtk_label_new("");
	temp2 = gtk_hbox_new(FALSE, FALSE);
	gtk_notebook_append_page(GTK_NOTEBOOK(tpane->editArea),
	                         temp2, temp);

	gtk_notebook_set_show_tabs(GTK_NOTEBOOK(tpane->editArea), FALSE);

	/* Buttons in the List Edit frame */

	tpane->listEditVBox = gtk_vbox_new(FALSE, FALSE);
	gtk_container_add(GTK_CONTAINER(tpane->listEditFrame),
	                  tpane->listEditVBox);

	tpane->listEditNew = gtk_button_new_with_label(listEditNewTitle);
	tpane->listEditEdit = gtk_button_new_with_label(listEditEditTitle);
	tpane->listEditDelete = gtk_button_new_with_label(listEditDeleteTitle);

	gtk_box_pack_start(GTK_BOX(tpane->listEditVBox), tpane->listEditNew,
	                   FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(tpane->listEditVBox), tpane->listEditEdit,
	                   FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(tpane->listEditVBox), tpane->listEditDelete,
	                   FALSE, FALSE, 0);

	gtk_signal_connect(GTK_OBJECT(tpane->listEditNew), "clicked",
	                   GTK_SIGNAL_FUNC(listEditNewButtonPress),
	                   tpane);
	gtk_signal_connect(GTK_OBJECT(tpane->listEditEdit), "clicked",
	                   GTK_SIGNAL_FUNC(listEditEditButtonPress),
	                   tpane);
	gtk_signal_connect(GTK_OBJECT(tpane->listEditDelete), "clicked",
	                   GTK_SIGNAL_FUNC(listEditDeleteButtonPress),
	                   tpane);


	/* Buttons in the Item Edit frame */

	tpane->itemEditVBox = gtk_vbox_new(FALSE, FALSE);
	gtk_container_add(GTK_CONTAINER(tpane->itemEditFrame),
	                  tpane->itemEditVBox);

	tpane->itemEditIncrement = gtk_button_new_with_label(
	                               itemEditIncrementTitle);
	tpane->itemEditDecrement = gtk_button_new_with_label(
	                               itemEditDecrementTitle);
	tpane->itemEditClose = gtk_button_new_with_label(
	                           itemEditCloseTitle);

	gtk_box_pack_start(GTK_BOX(tpane->itemEditVBox), tpane->itemEditIncrement,
	                   FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(tpane->itemEditVBox), tpane->itemEditDecrement,
	                   FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(tpane->itemEditVBox), tpane->itemEditClose,
	                   FALSE, FALSE, 0);

	gtk_signal_connect(GTK_OBJECT(tpane->itemEditIncrement), "clicked",
	                   GTK_SIGNAL_FUNC(itemIncrementButtonPress),
	                   tpane);
	gtk_signal_connect(GTK_OBJECT(tpane->itemEditDecrement), "clicked",
	                   GTK_SIGNAL_FUNC(itemDecrementButtonPress),
	                   tpane);
	gtk_signal_connect(GTK_OBJECT(tpane->itemEditClose), "clicked",
	                   GTK_SIGNAL_FUNC(itemCloseButtonPress),
	                   tpane);



	/* Buttons in the Misc frame */



	tpane->miscEditVBox = gtk_vbox_new(FALSE, FALSE);
	gtk_container_add(GTK_CONTAINER(tpane->miscFrame),
	                  tpane->miscEditVBox);

	tpane->miscAddComment = gtk_button_new_with_label(miscAddCommentTitle);
	tpane->miscRemoveComment = gtk_button_new_with_label(
	                               miscRemoveCommentTitle);
	gtk_widget_set_sensitive(tpane->miscRemoveComment, FALSE);
	tpane->miscAssign = gtk_button_new_with_label(
	                        miscAssignTitle);
	gtk_widget_set_sensitive(tpane->miscAssign, FALSE);

	gtk_box_pack_start(GTK_BOX(tpane->miscEditVBox), tpane->miscAddComment,
	                   FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(tpane->miscEditVBox), tpane->miscRemoveComment,
	                   FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(tpane->miscEditVBox), tpane->miscAssign,
	                   FALSE, FALSE, 0);


	gtk_signal_connect(GTK_OBJECT(tpane->miscAddComment), "clicked",
	                   GTK_SIGNAL_FUNC(miscAddCommentButtonPress), tpane);
	gtk_signal_connect(GTK_OBJECT(tpane->miscRemoveComment), "clicked",
	                   GTK_SIGNAL_FUNC(miscRemoveCommentButtonPress), tpane);
	gtk_signal_connect(GTK_OBJECT(tpane->miscAssign), "clicked",
	                   GTK_SIGNAL_FUNC(miscAssignButtonPress), tpane);



	/* Buttons & Entries in New Item frame */



	tpane->newItemVBox = gtk_vbox_new(FALSE, FALSE);
	gtk_container_add(GTK_CONTAINER(tpane->newItemFrame), tpane->newItemVBox);

	tpane->itemNameEntry = gtk_entry_new();
	tpane->itemAssignedEntry = gtk_entry_new();

	temp = gtk_hbox_new(FALSE, FALSE);
	tpane->itemAdd = gtk_button_new_with_label(newItemAdd);
	tpane->itemCancel = gtk_button_new_with_label(newItemCancel);

	gtk_box_pack_start(GTK_BOX(temp), tpane->itemAdd, FALSE, FALSE, 0);
	gtk_box_pack_end(GTK_BOX(temp), tpane->itemCancel, FALSE, FALSE, 0);

	gtk_box_pack_start(GTK_BOX(tpane->newItemVBox), tpane->itemNameEntry,
	                   FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(tpane->newItemVBox), tpane->itemAssignedEntry,
	                   FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(tpane->newItemVBox), temp,
	                   FALSE, FALSE, 0);

	gtk_signal_connect(GTK_OBJECT(tpane->itemAdd), "clicked",
	                   GTK_SIGNAL_FUNC(newItemAddButtonPress), tpane);
	gtk_signal_connect(GTK_OBJECT(tpane->itemCancel), "clicked",
	                   GTK_SIGNAL_FUNC(newItemCancelButtonPress), tpane);



	/* Buttons and text area in the add comment frame ******/



	tpane->commentVBox = gtk_vbox_new(FALSE, FALSE);
	gtk_container_add(GTK_CONTAINER(tpane->commentFrame), tpane->commentVBox);

	tpane->commentText = gtk_text_new(NULL, NULL);
	gtk_widget_set_usize(GTK_WIDGET(tpane->commentText), -1, 10);
	gtk_text_set_editable(GTK_TEXT(tpane->commentText), TRUE);

	temp = gtk_hbox_new(FALSE, FALSE);
	tpane->commentAdd = gtk_button_new_with_label(commentAdd);
	tpane->commentCancel = gtk_button_new_with_label(newItemCancel);

	gtk_box_pack_start(GTK_BOX(temp), tpane->commentAdd, FALSE, FALSE, 0);
	gtk_box_pack_end(GTK_BOX(temp), tpane->commentCancel, FALSE, FALSE, 0);

	gtk_box_pack_start(GTK_BOX(tpane->commentVBox), tpane->commentText,
	                   TRUE, TRUE, 0);
	gtk_box_pack_start(GTK_BOX(tpane->commentVBox), temp,
	                   FALSE, FALSE, 0);

	gtk_signal_connect(GTK_OBJECT(tpane->commentAdd), "clicked",
	                   GTK_SIGNAL_FUNC(commentAddButtonPress), tpane);
	gtk_signal_connect(GTK_OBJECT(tpane->commentCancel), "clicked",
	                   GTK_SIGNAL_FUNC(newItemCancelButtonPress), tpane);




	/* End of contstructor */


	gtk_widget_show_all(tpane->vbox);

	/* New item frame is not visible by default */

	gtk_notebook_set_page(GTK_NOTEBOOK(tpane->editArea), 2);

	return tpane;
}


gI_TodoPane *
gI_todo_pane_create_from_todo(gI_TodoList *tlist)
{
	gI_TodoPane *tpane;
	GList *list;
	gI_TodoItem *todo;


	g_return_val_if_fail(tlist != NULL, NULL);

	tpane = gI_todo_pane_create();

	tpane->tlist = tlist;

	list = tlist->todoItems;
	while(list)
	{
		todo = list->data;

		todo_pane_pack_node_from_todo(tpane, NULL, todo);

		list = g_list_next(list);
	}

	gI_todo_list_attach(tlist, tpane);

	return tpane;
}

void
gI_todo_pane_destroy(gI_TodoPane *tpane)
{
	g_return_if_fail(tpane);

	gI_todo_list_detach(tpane->tlist, tpane);

	g_free(tpane);
}


/* Local helper functions *******************************************/

static void
todo_pane_set_row_text(gI_TodoPane *tpane,
                       GtkCTreeNode *node,
                       gchar *rowData[])
{
	gint a;
	for(a = 0; a < 3; a++)
		if(rowData[a])
			gtk_ctree_node_set_text(GTK_CTREE(tpane->ctree),
			                        node, a, rowData[a]);
}

static void
todo_pane_pack_node_from_todo(gI_TodoPane *tpane,
                              TodoPaneData *tdata,
                              gI_TodoItem *todo)
{
	GString *string;
	gchar *rowData[3];
	GtkCTreeNode *last_node = NULL;
	GtkCTreeNode *node;
	GList *comments, *commentsNodes;

	string = g_string_new("");

	if(!tdata)
	{
		tdata = g_new0(TodoPaneData, 1);
		last_node = NULL;
	}
	else
	{
		last_node = tdata->top;
	}

	tdata->todo = todo;

	/* Initial row */

	rowData[0] = todo->item;
	rowData[1] = todo->assignedTo;
	rowData[2] = (gchar *)todo->status;

	if(!tdata->top)
		tdata->top = gtk_ctree_insert_node(GTK_CTREE(tpane->ctree),
		                                   NULL, last_node,
		                                   NULL, 0,
		                                   NULL, NULL, NULL, NULL,
		                                   FALSE, FALSE);

	todo_pane_set_row_text(tpane, tdata->top, rowData);

	gtk_ctree_node_set_row_data(GTK_CTREE(tpane->ctree), tdata->top, tdata);

	/* Create date - always available */

	rowData[0] = rowData[1] = rowData[2] = NULL;

	string = g_string_assign(string, todoItemOpenedDate);
	string = g_string_append(string, todo->openedTime);
	rowData[0] = string->str;

	if(!tdata->createDate)
		tdata->createDate = gtk_ctree_insert_node(GTK_CTREE(tpane->ctree),
		                    tdata->top, NULL,
		                    NULL, 0,
		                    NULL, NULL, NULL, NULL,
		                    TRUE, FALSE);
	todo_pane_set_row_text(tpane, tdata->createDate, rowData);

	gtk_ctree_node_set_row_data(GTK_CTREE(tpane->ctree),
	                            tdata->createDate, tdata);

	if(todo->modifiedTime)
	{
		string = g_string_assign(string, todoItemModifiedDate);
		string = g_string_append(string, todo->modifiedTime);

		rowData[0] = string->str;

		if(!tdata->modifiedDate)
			tdata->modifiedDate = gtk_ctree_insert_node(
			                          GTK_CTREE(tpane->ctree),
			                          tdata->top, tdata->closedDate ? tdata->closedDate :
			                          tdata->dueDate ? tdata->dueDate : tdata->commentsRoot,
			                          NULL, 0,
			                          NULL, NULL, NULL, NULL,
			                          TRUE, FALSE);
		todo_pane_set_row_text(tpane, tdata->modifiedDate, rowData);

		gtk_ctree_node_set_row_data(GTK_CTREE(tpane->ctree),
		                            tdata->modifiedDate, tdata);

	}

	if(todo->closedTime)
	{
		string = g_string_assign(string, todoItemClosedDate);
		string = g_string_append(string, todo->closedTime);

		rowData[0] = string->str;

		if(!tdata->closedDate)
			tdata->closedDate = gtk_ctree_insert_node(
			                        GTK_CTREE(tpane->ctree),
			                        tdata->top,
			                        tdata->dueDate ? tdata->dueDate : tdata->commentsRoot,
			                        rowData, 0,
			                        NULL, NULL, NULL, NULL,
			                        TRUE, FALSE);
		todo_pane_set_row_text(tpane, tdata->closedDate, rowData);

		gtk_ctree_node_set_row_data(GTK_CTREE(tpane->ctree),
		                            tdata->closedDate, tdata);

	}

	if(todo->dueDate)
	{
		string = g_string_assign(string, todoItemDueDate);
		string = g_string_append(string, todo->dueDate);

		rowData[0] = string->str;

		if(!tdata->dueDate)
			tdata->dueDate = gtk_ctree_insert_node(
			                     GTK_CTREE(tpane->ctree),
			                     tdata->top, tdata->commentsRoot,
			                     rowData, 0,
			                     NULL, NULL, NULL, NULL,
			                     TRUE, FALSE);
		todo_pane_set_row_text(tpane, tdata->dueDate, rowData);

		gtk_ctree_node_set_row_data(GTK_CTREE(tpane->ctree),
		                            tdata->dueDate, tdata);

	}

	if(todo->comments)
	{
		comments = todo->comments;
		commentsNodes = tdata->commentsNodes;

		if(!tdata->commentsRoot)
		{
			rowData[0] = (gchar *)todoItemComments;

			tdata->commentsRoot = gtk_ctree_insert_node(
			                          GTK_CTREE(tpane->ctree),
			                          tdata->top, NULL,
			                          rowData, 0,
			                          NULL, NULL, NULL, NULL,
			                          FALSE, TRUE);
		}
		else
		{
			while(comments && commentsNodes)
			{
				comments = g_list_next(comments);
				commentsNodes = g_list_next(commentsNodes);
			}
		}

		gtk_ctree_node_set_row_data(GTK_CTREE(tpane->ctree),
		                            tdata->commentsRoot, tdata);

		while(comments)
		{
			rowData[0] = comments->data;

			node = gtk_ctree_insert_node(
			           GTK_CTREE(tpane->ctree),
			           tdata->commentsRoot, NULL,
			           rowData, 0,
			           NULL, NULL, NULL, NULL,
			           TRUE, TRUE);
			gtk_ctree_node_set_row_data(GTK_CTREE(tpane->ctree),
			                            node, tdata);

			tdata->commentsNodes = g_list_append(tdata->commentsNodes, node);

			comments = g_list_next(comments);
		}
	}

	g_string_free(string, FALSE);
}

/* Grovels through the Ctree and spews out a unique list of items which
 * were selected.  100% probability that this is the wrong way to do it.
 * If course, CTree is inherently sick, so I don't care. */

static GList *
todo_pane_ctree_get_todo_selected(gI_TodoPane *tpane)
{
	GtkCTreeNode *select;
	GList *selected_data = NULL;
	TodoPaneData *tdata;

	g_return_val_if_fail(GTK_IS_CTREE(tpane->ctree), 0);

	select = GTK_CTREE_NODE(GTK_CLIST(tpane->ctree)->selection);

	if(!select)
	{
		return NULL;
	}

	while(select)
	{
		tdata = gtk_ctree_node_get_row_data(GTK_CTREE(tpane->ctree),
		                                    GTK_CTREE_NODE(
		                                        GTK_CTREE_ROW(select)));

		if(!tdata)
			g_assert_not_reached();

		if(!g_list_find(selected_data, tdata))
			selected_data = g_list_append(selected_data, tdata);

		select = GTK_CTREE_NODE_NEXT(select);
	}

	return selected_data;
}


/* Local callback functions ******************************************/


static gint
listEditNewButtonPress(GtkWidget *widget,
                       gpointer data)
{
	gI_TodoPane *tpane;

	tpane = data;

	if(tpane->editingData)
		newItemCancelButtonPress(widget, data);

	gtk_notebook_set_page(GTK_NOTEBOOK(tpane->editArea), 0);

	return 0;
}

static gint
listEditEditButtonPress(GtkWidget *widget,
                        gpointer data)
{
	gI_TodoPane *tpane;
	TodoPaneData *tdata;
	gI_TodoItem *todo;
	GList *selected;

	tpane = data;

	selected = todo_pane_ctree_get_todo_selected(tpane);

	if(!selected)
		return 0;

	gtk_notebook_set_page(GTK_NOTEBOOK(tpane->editArea), 0);

	tdata = selected->data;
	todo = tdata->todo;

	gtk_entry_set_text(GTK_ENTRY(tpane->itemNameEntry), todo->item);
	if(todo->assignedTo)
		gtk_entry_set_text(GTK_ENTRY(tpane->itemAssignedEntry),
		                   todo->assignedTo);

	tpane->editingData = tdata;

	g_list_free(selected);

	return 0;
}

static gint
listEditDeleteButtonPress(GtkWidget *widget,
                          gpointer data)
{
	gI_TodoPane *tpane;
	TodoPaneData *tdata;
	GList *selected;

	tpane = data;

	selected = todo_pane_ctree_get_todo_selected(tpane);

	if(!selected)
		return 0;

	newItemCancelButtonPress(widget, data);

	gtk_clist_freeze(GTK_CLIST(tpane->ctree));

	while(selected)
	{
		tdata = selected->data;

		gI_todo_list_remove(tpane->tlist, tdata->todo);

		gtk_ctree_remove_node(GTK_CTREE(tpane->ctree), tdata->top);

		g_free(tdata);

		selected = g_list_next(selected);
	}

	gtk_clist_thaw(GTK_CLIST(tpane->ctree));

	return 0;
}

static gint
itemIncrementButtonPress(GtkWidget *widget,
                         gpointer data)
{
	gI_TodoPane *tpane;
	TodoPaneData *tdata;
	GList *selected;

	tpane = data;

	selected = todo_pane_ctree_get_todo_selected(tpane);

	if(!selected)
		return 0;

	gtk_clist_freeze(GTK_CLIST(tpane->ctree));

	while(selected)
	{
		tdata = selected->data;

		gI_todo_item_increment(tdata->todo);

		todo_pane_pack_node_from_todo(tpane, tdata, tdata->todo);

		selected = g_list_next(selected);
	}

	gtk_clist_thaw(GTK_CLIST(tpane->ctree));

	g_list_free(selected);
	return 0;
}

static gint
itemDecrementButtonPress(GtkWidget *widget,
                         gpointer data)
{
	gI_TodoPane *tpane;
	TodoPaneData *tdata;
	GList *selected;

	tpane = data;

	selected = todo_pane_ctree_get_todo_selected(tpane);

	if(!selected)
		return 0;

	gtk_clist_freeze(GTK_CLIST(tpane->ctree));

	while(selected)
	{
		tdata = selected->data;

		gI_todo_item_decrement(tdata->todo);

		todo_pane_pack_node_from_todo(tpane, tdata, tdata->todo);

		selected = g_list_next(selected);
	}

	gtk_clist_thaw(GTK_CLIST(tpane->ctree));

	g_list_free(selected);
	return 0;
}

static gint
itemCloseButtonPress(GtkWidget *widget,
                     gpointer data)
{
	gI_TodoPane *tpane;
	TodoPaneData *tdata;
	GList *selected,
	*comments;
	GString *buf;
	gchar *user;
	gI_project *project;
	extern gI_config *cfg;

	gchar *changelogFile;

	tpane = data;

	selected = todo_pane_ctree_get_todo_selected(tpane);

	if(!selected)
		return 0;

	gtk_clist_freeze(GTK_CLIST(tpane->ctree));

	while(selected)
	{
		tdata = selected->data;

		gI_todo_item_close(tdata->todo);

		todo_pane_pack_node_from_todo(tpane, tdata, tdata->todo);

		/* Add changelog entry if necessary */

		if(cfg->changelog)
		{
			project = gI_project_get_current();

			if( isempty( project->changelog ) )
			{
				/* error handling */
				gI_error_dialog( _("No ChangeLog-File specified.") );
				return 0;
			}

			changelogFile = project->changelog;

			user = getenv( "USER" );

			buf = g_string_new("");

			if( user )
				g_string_sprintf(buf, "%s <%s>\n",
				                 tdata->todo->closedTime, user );
			else
				g_string_sprintf(buf, "%s\n", tdata->todo->closedTime );
			g_string_sprintfa( buf, "\t* %s\n", tdata->todo->item );

			comments = tdata->todo->comments;
			while(comments)
			{
				g_string_sprintfa( buf, "\t* %s\n", (gchar *)(comments->data));
				comments = g_list_next(comments);
			}

			g_string_sprintfa( buf, "\n" );

			changelogPopup(buf->str, changelogFile);

			g_string_free(buf, FALSE);


		}
		selected = g_list_next(selected);
	}

	gtk_clist_thaw(GTK_CLIST(tpane->ctree));

	g_list_free(selected);

	return 0;
}

static gint
miscAddCommentButtonPress(GtkWidget *widget,
                          gpointer data)
{
	gI_TodoPane *tpane;
	TodoPaneData *tdata;
	gI_TodoItem *todo;
	GList *selected;

	tpane = data;

	newItemCancelButtonPress(widget, data);

	selected = todo_pane_ctree_get_todo_selected(tpane);

	if(!selected)
		return 0;

	tdata = selected->data;
	todo = tdata->todo;

	tpane->editingData = tdata;

	gtk_notebook_set_page(GTK_NOTEBOOK(tpane->editArea), 1);

	return 0;
}

static gint
miscRemoveCommentButtonPress(GtkWidget *widget,
                             gpointer data)
{
	/* FIXME STUB */

	return 0;
}

static gint
miscAssignButtonPress(GtkWidget *widget,
                      gpointer data)
{
#if 0 /* JUST FOR TESTING */
	gI_TodoPane *tpane;
	gI_TodoList *tlist;
	FILE *file;
	/* FIXME Just a stub */

	tpane = data;
	tlist = tpane->tlist;

	file = fopen("TestTodoFile.txt", "w");

	gI_todo_list_write_to_file(tlist, file, "$Begin Todo List",
	                           "$End Todo List");

	fclose(file);
#endif
	return 0;
}

static gint
newItemAddButtonPress(GtkWidget *widget,
                      gpointer data)
{
	gI_TodoPane *tpane;
	TodoPaneData *tdata = NULL;
	gI_TodoItem *todo;
	gchar *name;
	gchar *assign;

	tpane = data;

	name = gtk_entry_get_text(GTK_ENTRY(tpane->itemNameEntry));
	assign = gtk_entry_get_text(GTK_ENTRY(tpane->itemAssignedEntry));

	if(isempty(name))
	{
		gI_ok_dialog((gchar *)errorNeedName);
		return 0;
	}


	if(tpane->editingData)
	{
		tdata = tpane->editingData;
		todo = gI_todo_item_create(name, tdata->todo->openedTime);

		gI_todo_list_remove(tpane->tlist, tdata->todo);
		tdata->todo = todo;
	}
	else
		todo = gI_todo_item_create(name, NULL);

	if(!isempty(assign))
		gI_todo_item_assign(todo, assign);

	gI_todo_list_add(tpane->tlist, todo);

	gtk_clist_freeze(GTK_CLIST(tpane->ctree));

	todo_pane_pack_node_from_todo(tpane, tdata, todo);

	gtk_clist_thaw(GTK_CLIST(tpane->ctree));

	newItemCancelButtonPress(widget, data);

	return 0;
}

static gint
newItemCancelButtonPress(GtkWidget *widget,
                         gpointer data)
{
	gI_TodoPane *tpane;

	tpane = data;

	gtk_entry_set_text(GTK_ENTRY(tpane->itemNameEntry), "");
	gtk_entry_set_text(GTK_ENTRY(tpane->itemAssignedEntry), "");

	tpane->editingData = NULL;

	gtk_notebook_set_page(GTK_NOTEBOOK(tpane->editArea), 2);

	return 0;
}

static gint
commentAddButtonPress(GtkWidget *widget,
                      gpointer data)
{
	gI_TodoPane *tpane;
	TodoPaneData *tdata;
	gI_TodoItem *todo;
	gint len;
	gchar *comment;

	tpane = data;

	tdata = tpane->editingData;

	g_return_val_if_fail(tdata, 0);

	todo = tdata->todo;

	len = gtk_text_get_length(GTK_TEXT(tpane->commentText));
	comment = gtk_editable_get_chars(GTK_EDITABLE(tpane->commentText),
	                                 0, len);
	if(isempty(comment))
	{
		gI_ok_dialog((gchar *)errorNeedComment);
		return 0;
	}

	gI_todo_item_add_comment(todo, comment);

	gtk_clist_freeze(GTK_CLIST(tpane->ctree));
	todo_pane_pack_node_from_todo(tpane, tdata, todo);
	gtk_clist_thaw(GTK_CLIST(tpane->ctree));

	newItemCancelButtonPress(widget, data);

	gtk_editable_select_region(GTK_EDITABLE(tpane->commentText), 0, len);
	gtk_editable_delete_selection(GTK_EDITABLE(tpane->commentText));

	return 0;
}

static gint
assignedColumnSortButtonPress(GtkWidget *widget,
                              gpointer data)
{
	GtkWidget *ctree;

	ctree = ((gI_TodoPane *)data)->ctree;

	if(GTK_CLIST(ctree)->sort_column == 1)
		gtk_clist_set_sort_type(GTK_CLIST(ctree),
		                        !(GTK_CLIST(ctree)->sort_type));

	gtk_clist_set_sort_column(GTK_CLIST(ctree), 1);

	gtk_clist_freeze(GTK_CLIST(ctree));
	gtk_clist_sort(GTK_CLIST(ctree));
	gtk_clist_thaw(GTK_CLIST(ctree));

	return 0;
}

static gint
statusColumnSortButtonPress(GtkWidget *widget,
                            gpointer data)
{
	GtkWidget *ctree;

	ctree = ((gI_TodoPane *)data)->ctree;

	if(GTK_CLIST(ctree)->sort_column == 2)
		gtk_clist_set_sort_type(GTK_CLIST(ctree),
		                        !(GTK_CLIST(ctree)->sort_type));

	gtk_clist_set_sort_column(GTK_CLIST(ctree), 2);

	gtk_clist_set_compare_func(GTK_CLIST(ctree),
	                           (GtkCListCompareFunc)statusColumnSortFunc);
	gtk_clist_freeze(GTK_CLIST(ctree));
	gtk_clist_sort(GTK_CLIST(ctree));
	gtk_clist_thaw(GTK_CLIST(ctree));
	gtk_clist_set_compare_func(GTK_CLIST(ctree), NULL);

	return 0;
}

static gint
statusColumnSortFunc(GtkCList *clist,
                     GtkCListRow *ptr1,
                     GtkCListRow *ptr2)
{
	TodoPaneData *tdata1,
	*tdata2;

	tdata1 = ptr1->data;
	tdata2 = ptr2->data;

	if(tdata1 == tdata2)
		return 0;

	if(tdata1->todo->todo_status == tdata2->todo->todo_status)
		return 0;

	if(todo_sort_order[tdata1->todo->todo_status] >
	        todo_sort_order[tdata2->todo->todo_status])
		return 1;

	return -1;
}

#ifdef HAVE_STRPTIME
static gint
itemColumnSortButtonPress(GtkWidget *widget,
                          gpointer data)
{
	GtkWidget *ctree;

	ctree = ((gI_TodoPane *)data)->ctree;

	if(GTK_CLIST(ctree)->sort_column == 0)
		gtk_clist_set_sort_type(GTK_CLIST(ctree),
		                        !(GTK_CLIST(ctree)->sort_type));

	gtk_clist_set_sort_column(GTK_CLIST(ctree), 0);

	gtk_clist_set_compare_func(GTK_CLIST(ctree),
	                           (GtkCListCompareFunc)itemColumnSortFunc);
	gtk_clist_freeze(GTK_CLIST(ctree));
	gtk_ctree_sort_node(GTK_CTREE(ctree), NULL);
	gtk_clist_thaw(GTK_CLIST(ctree));
	gtk_clist_set_compare_func(GTK_CLIST(ctree), NULL);

	return 0;
}

static gint
itemColumnSortFunc(GtkCList *clist,
                   GtkCListRow *ptr1,
                   GtkCListRow *ptr2)
{
	TodoPaneData *tdata1,
	*tdata2;
	struct tm tm1, tm2;

	tdata1 = ptr1->data;
	tdata2 = ptr2->data;

	if(tdata1 == tdata2)
		return 0;

	strptime(tdata1->todo->openedTime, "%c", &tm1);
	strptime(tdata2->todo->openedTime, "%c", &tm2);

	return(difftime( mktime(&tm1), mktime(&tm2) ) );
}
#endif /* HAVE_STRPTIME */

/* Changelog Add Dialog */

static const gchar *dlgKey = "dialogChangeLogFileKey";
static const gchar *dlgWinKey = "dialogChangeLogWindowKey";

static void
changelogPopup(gchar *changelogEntry,
               gchar *changelogFileName)
{
	GtkWidget *dialogWindow;
	GtkWidget *frame;
	GtkWidget *textEntry;
	GtkWidget *okButton;
	GtkWidget *cancelButton;

	gint pos = 0;

	g_return_if_fail(changelogEntry);
	g_return_if_fail(changelogFileName);

	dialogWindow = gtk_dialog_new();
	gtk_window_set_title(GTK_WINDOW(dialogWindow), dialogAddChangelogTitle);
	gtk_widget_set_usize(dialogWindow, 500, 150);
	gtk_signal_connect_object(GTK_OBJECT(dialogWindow), "destroy",
	                          GTK_SIGNAL_FUNC(gtk_widget_destroy),
	                          GTK_OBJECT(dialogWindow));

	frame = gtk_frame_new(dialogAddChangelogFrame);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialogWindow)->vbox),
	                   frame, TRUE, TRUE, 0);

	textEntry = gtk_text_new(FALSE, FALSE);
	gtk_text_set_editable(GTK_TEXT(textEntry), TRUE);
	gtk_container_add(GTK_CONTAINER(frame), textEntry);

	okButton = gtk_button_new_with_label(dialogAddChangelogOk);
	gtk_signal_connect(GTK_OBJECT(okButton), "clicked",
	                   GTK_SIGNAL_FUNC(dialogAddChangelogOkButtonPress),
	                   textEntry);
	gtk_object_set_data(GTK_OBJECT(okButton), dlgKey, changelogFileName);
	gtk_object_set_data(GTK_OBJECT(okButton), dlgWinKey, dialogWindow);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialogWindow)->action_area),
	                   okButton, FALSE, FALSE, 0);

	cancelButton = gtk_button_new_with_label(dialogAddChangelogCancel);
	gtk_signal_connect_object(GTK_OBJECT(cancelButton), "clicked",
	                          GTK_SIGNAL_FUNC(gtk_widget_destroy),
	                          GTK_OBJECT(dialogWindow));
	gtk_box_pack_end(GTK_BOX(GTK_DIALOG(dialogWindow)->action_area),
	                 cancelButton, FALSE, FALSE, 0);

	gtk_widget_show_all(dialogWindow);
	gtk_widget_realize(textEntry);

	gtk_editable_insert_text(GTK_EDITABLE(textEntry), changelogEntry,
	                         strlen(changelogEntry), &pos);
};

static gint
dialogAddChangelogOkButtonPress(GtkWidget *widget,
                                gpointer data)
{
	GtkWidget *dialogWindow;
	GtkWidget *text;
	gchar *changelogFileName;
	gchar *changelogEntry;
	gint len;

	text = data;
	dialogWindow = gtk_object_get_data(GTK_OBJECT(widget), dlgWinKey);
	changelogFileName = gtk_object_get_data(GTK_OBJECT(widget), dlgKey);

	g_return_val_if_fail(text, 0);
	g_return_val_if_fail(changelogFileName, 0);
	g_return_val_if_fail(dialogWindow, 0);

	len = gtk_text_get_length(GTK_TEXT(text));

	changelogEntry = gtk_editable_get_chars(GTK_EDITABLE(text),
	                                        0, len);

	if(isempty(changelogEntry))
	{
		gI_error_dialog( _("Please enter a changelog addition.") );
		return 0;
	}

	gI_add_to_changelog(changelogEntry, changelogFileName);

	gtk_widget_destroy(dialogWindow);

	return 0;
}

void
gI_add_to_changelog(gchar *changelogEntry,
                    gchar *changelogFileName)
{
	GString *buf;
	FILE *changelog;
	gchar *tmpname = NULL;

	if( file_exist( changelogFileName ) )
	{
		tmpname = move_to_tmp( changelogFileName );
		if( !tmpname )
		{
			/* error handling */
			gI_error_dialog( _("Unable to move ChangeLog to temponary file") );
			return;
		}
	}
	changelog = fopen( changelogFileName, "w" );
	if( !changelog )
	{
		/* error handling */
		gI_error_dialog( _("Unable to Open ChangeLog-File") );
		return;
	}

	/* Only 2 trailing newlines */

	buf = g_string_new(changelogEntry);
	while(buf->len && buf->str[buf->len - 1] == '\n')
		g_string_truncate(buf, buf->len - 1);

	if(!isempty(buf->str))
		fprintf(changelog, "%s\n\n", buf->str);

	g_string_free(buf, FALSE);

	fclose( changelog );
	if( tmpname )
		append_file( changelogFileName, tmpname );

	remove( tmpname );

	g_free( tmpname );
}
