/* $Header: /cvs/gnome/gIDE/src/gI_tools.c,v 1.4 1999/12/05 07:17:51 jpr Exp $ */
/* gIDE
 * Copyright (C) 1998-2000 Steffen Kern
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk/gtk.h>
#include <gnome.h>
#include <ctype.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <dirent.h>
#include "structs.h"
#include "gI_functions.h"
#include "gI_document.h"
#include "gI_tools.h"
#include "gI_file.h"
#include "gI_common.h"
#include "gI_menus.h"
#include "tools_help.h"
#include "gI_pathwidget.h"

/* globals */
static GtkWidget *tools_window = NULL;
static GtkWidget *custom_tools_window = NULL;
static GtkWidget *cb_append;
static GtkWidget *e_source;
static GtkWidget *e_target;
static GtkWidget *cb_static;
static gchar org_line[MAXLEN];
static FILE *infile,*outfile;

static GtkWidget *e_cmdline;
static GtkWidget *e_menu_item_name;
static GtkWidget *r_new;
static GtkWidget *r_append;
static GtkWidget *r_box;
static GtkWidget *r_ignore;
static GtkWidget *e_name;
static GtkWidget *r_insert;
static GtkWidget *r_xterm;
static GtkWidget *r_pipe;
static glong kz_edit = FALSE;


/* externs */
extern gI_window *main_window;
extern GtkItemFactory *factory;
extern gchar gide_path[];
extern gchar tools_path[];
extern gI_config *cfg;


/*
 * Callback: destroy tools_window
 */
static void tools_window_destroy( GtkWidget *widget, gpointer data )
{
	if( !tools_window )
		return;

	gtk_widget_destroy( tools_window );
	tools_window = NULL;
}


/*
 * Callback: destroy custom_tools_window
 */
static void custom_tools_window_destroy( GtkWidget *widget, gpointer data )
{
	if( !custom_tools_window )
		return;

	gtk_widget_destroy( custom_tools_window );
	custom_tools_window = NULL;
}


/*
 * Verify: checks the entries of the Prototype Generator Dialog.
 */
static glong check_entries()
{
	gchar *ptr;

	ptr = gtk_entry_get_text( GTK_ENTRY( e_source ) );
	if( ptr )
	{
		if( isempty( ptr ) )
			return( 0 );
	}
	else
		return( 0 );

	ptr = gtk_entry_get_text( GTK_ENTRY( e_target ) );
	if( ptr )
	{
		if( isempty( ptr ) )
			return( 0 );
	}
	else
		return( 0 );

	return( 1 );
}


/*
 * Callback: OK-Button in Prototype Generator
 */
static glong gen_proto_start( GtkWidget *widget, gpointer data )
{
	gchar *ptr;
	gchar source[STRLEN],target[STRLEN];
	glong i;
	gchar buf[MAXLEN];
	glong written;
	glong line = 0;
	static c_status c_status;
	gchar HelpString[MAXLEN];

	if( !check_entries() )
		return(-1);

	ptr = gtk_entry_get_text( GTK_ENTRY( e_source ) );
	strcpy( source, ptr );

	infile = fopen( source, "r" );
	if( infile == NULL )
	{
		printf("ERROR: can't open file %s\n",source);
		return( -1 );
	}

	init_cstatus( &c_status );

	while( !feof( infile ) )
	{
		fgets( buf, sizeof( buf ), infile );
		if( feof( infile ) )
			break;
		for(i=0;i<=strlen(buf);i++)
			c_parse_special(buf,i,&c_status);
	}
	/*
	    if( !config.ignore )
	    {
	        if( c_status.comment )
	        {
	            printf( "\nERROR: base parsing failed, unfinished comment\n" );
	            return( -1 );
	        }

	        if( c_status.klammern_1 || c_status.klammern_2 || c_status.klammern_3 )
	        {
	            printf( "\nERROR: base parsing failed, numbers doesn't match: %ld, %ld, %ld\n", c_status.klammern_1,c_status.klammern_2,c_status.klammern_3 );
	        return( -1 );
	        }
	    }
	    else
	    {
	        if( c_status.comment || c_status.klammern_1 || c_status.klammern_2 || c_status.klammern_3 )
	        {
	            printf( "ignoring detected errors, continuation forced..." );
	        }
	    }
	*/

	ptr = gtk_entry_get_text( GTK_ENTRY( e_target ) );
	strcpy( target, ptr );

	if( GTK_TOGGLE_BUTTON( cb_append )->active )
		outfile = fopen( target, "a" );
	else
		outfile = fopen( target, "w" );

	if( outfile == NULL )
	{
		printf("ERROR: can't open file %s\n",target);
		return( -1 );
	}

	/* Re-Init */
	rewind( infile );
	init_cstatus( &c_status );

	ptr = strrchr( target, '/' );
	if( !ptr )
		ptr = target;
	else
		ptr++;

	fprintf( outfile, "\n/*\n * Prototypes for '%s'\n */\n", ptr );


	while( !feof( infile ) )
	{
		fgets( buf, sizeof( buf ), infile );
		line++;
		if( feof( infile ) )
			break;
		c_parse_line( buf, line );
	}

	fclose( infile );
	written = ftell( outfile );
	fclose( outfile );

	sprintf( HelpString, "\n    Done!    \n    %ld bytes written to '%s'.    \n", written, target );
	gI_ok_dialog( HelpString);

	tools_window_destroy( NULL, NULL );

	return( 1 );
}


glong c_parse_line( gchar *buf, glong line )
{
	gchar key[MAXLEN];
	gchar *ptr;
	gchar cmp[MAXLEN];
	glong kc = 0;
	glong i;
	static c_status c_status;
	static glong waiting = 0;

	/* backup the complete original line */
	if( !waiting )
		strcpy( org_line, buf );
	else
		strcat( org_line, buf );

	for(i=0;i<strlen(buf);i++)
	{
		c_parse_special( buf, i, &c_status );

		if( c_status.comment || c_status.hyph || c_status.dhyph )
			continue;

		if( c_status.klammern_1 && waiting )
		{
			waiting = 0;
			ptr = strchr( org_line, ')' );
			if( !ptr )
			{
				printf("ERROR: incomplete function head.. this point should never be reached\n" );
				exit( -1 );
			}
			else
			{
				ptr = strchr( org_line, '{' );
				if( !ptr )
				{
					printf("ERROR: something is going wrong here....aborting!\n" );
					exit( -1 );
				}

				ptr--;

				while( *ptr != ')' )
				{
					ptr--;
				}

				ptr++;
				*ptr = ';';
				ptr++;
				*ptr = '\0';
				if( !GTK_TOGGLE_BUTTON( cb_static )->active )
				{
					fprintf( outfile, "%s\n",org_line);
				}
				else
				{
					if( sscanf( org_line, "%s\n", cmp ) != 1 )
					{
						fprintf( outfile, "%s\n",org_line);
					}
					else
					{
						if( strcmp( cmp, "static" ) )
						{
							fprintf( outfile, "%s\n",org_line);
						}
					}
				}
				continue;
			}
		}

		if( buf[i] == ';' && waiting )
			waiting = 0;

		if( c_status.klammern_1 )
			continue;

		switch( buf[i] )
		{
		case '(':
			if( kc != 0 )
			{
				key[kc] = '\0';
				kc = 0;

				waiting = 1;
			}
			break;

		case ')':
		case ';':
		case '=':
		case ' ':
		case '\t':
		case '/':
		case '*':
		case '+':
		case '-':
			kc = 0;
			break;

		default:
			key[kc] = buf[i];
			kc++;
			break;
		}
	}

	return( 1 );
}


/*
 * Dialog.: Prototype Generator
 */
void gen_proto( GtkWidget *widget, gpointer data )
{
	GtkWidget *vbox;
	GtkWidget *hbox;
	GtkWidget *label;
	GtkWidget *hsep;
	GtkWidget *button;


	if( tools_window )
		return;

	tools_window = gtk_window_new( GTK_WINDOW_TOPLEVEL );
	gtk_widget_set_usize( tools_window, 300, 190 );
	gtk_window_set_title( GTK_WINDOW( tools_window ), _("Tools - Prototype Generator") );
	gtk_signal_connect( GTK_OBJECT( tools_window ), "destroy",
	                    GTK_SIGNAL_FUNC( tools_window_destroy ), NULL );

	vbox = gtk_vbox_new( FALSE, 0 );
	gtk_container_add( GTK_CONTAINER( tools_window ), vbox );
	gtk_widget_show( vbox );

	hbox = gtk_hbox_new( FALSE, 0 );
	gtk_box_pack_start( GTK_BOX( vbox ), hbox, FALSE, TRUE, 10 );
	gtk_widget_show( hbox );

	label = gtk_label_new( "C Source" );
	gtk_box_pack_start( GTK_BOX( hbox ), label, FALSE, TRUE, 5 );
	gtk_widget_show( label );

	e_source = gtk_entry_new_with_max_length( 255 );
	gtk_box_pack_start( GTK_BOX( hbox ), e_source, TRUE, TRUE, 5 );
	gtk_widget_grab_focus( e_source );
	gtk_widget_show( e_source );

	hbox = gtk_hbox_new( FALSE, 0 );
	gtk_box_pack_start( GTK_BOX( vbox ), hbox, FALSE, TRUE, 10 );
	gtk_widget_show( hbox );

	label = gtk_label_new( _("Target File") );
	gtk_box_pack_start( GTK_BOX( hbox ), label, FALSE, TRUE, 5 );
	gtk_widget_show( label );

	e_target = gtk_entry_new_with_max_length( 255 );
	gtk_box_pack_start( GTK_BOX( hbox ), e_target, TRUE, TRUE, 5 );
	gtk_widget_show( e_target );

	hbox = gtk_hbox_new( FALSE, 0 );
	gtk_box_pack_start( GTK_BOX( vbox ), hbox, FALSE, TRUE, 0 );
	gtk_widget_show( hbox );

	cb_append = gtk_check_button_new_with_label( _("Append to Targetfile") );
	gtk_box_pack_start( GTK_BOX( hbox ), cb_append, FALSE, TRUE, 5 );
	gtk_widget_show( cb_append );

	hbox = gtk_hbox_new( FALSE, 0 );
	gtk_box_pack_start( GTK_BOX( vbox ), hbox, FALSE, TRUE, 0 );
	gtk_widget_show( hbox );

	cb_static = gtk_check_button_new_with_label( _("Skip Static Declarations") );
	gtk_box_pack_start( GTK_BOX( hbox ), cb_static, FALSE, TRUE, 5 );
	gtk_widget_show( cb_static );

	hsep = gtk_hseparator_new();
	gtk_box_pack_start( GTK_BOX( vbox ), hsep, FALSE, TRUE, 5 );
	gtk_widget_show( hsep );

	hbox = gtk_hbox_new( FALSE, 0 );
	gtk_box_pack_start( GTK_BOX( vbox ), hbox, FALSE, TRUE, 10 );
	gtk_widget_show( hbox );

	button = gnome_stock_button( GNOME_STOCK_BUTTON_OK );
	gtk_box_pack_start( GTK_BOX( hbox ), button, TRUE, TRUE, 5 );
	gtk_signal_connect( GTK_OBJECT( button ), "clicked",
	                    GTK_SIGNAL_FUNC( gen_proto_start ), NULL );
	gtk_widget_show( button );

	gtk_widget_show( tools_window );
}



gI_tool *gI_tool_new()
{
	gI_tool *tool = NULL;

	tool = g_malloc( sizeof( gI_tool ) );

	return( tool );
}


void gI_tool_init( gI_tool *tool )
{
}


static void gI_tool_save( gI_tool *tool )
{
	FILE *toolfile;
	gchar tfwp[MAXLEN];

	if( !tool )
		return;

	g_snprintf( tfwp, MAXLEN, "%s/%s.tl", tools_path, tool->name );

	toolfile = fopen( tfwp, "w" );
	if( !toolfile )
	{
		/* error handling */
		return;
	}


	fprintf( toolfile, "%s\n", tool->name );
	fprintf( toolfile, "%s\n", tool->menu_item_name );
	fprintf( toolfile, "%s\n", tool->cmdline );
	fprintf( toolfile, "%d\n", tool->output );


	fclose( toolfile );
}


void gI_tool_lookup( gchar *toolname )
{
	gchar *tf;
	FILE *toolfile;
	gI_tool *tool;
	gchar buf[STRLEN];

	g_snprintf( buf, STRLEN, "%s.tl", toolname );

	tf = g_strconcat( tools_path, "/", buf, NULL );
	if( file_exist( tf ) )
	{
		toolfile = fopen( tf, "r" );
		if( !toolfile )
		{
			/* error handling */
			/* .. this can't happen! */
			g_snprintf( buf, STRLEN, _("\n    Unable to Open Tool File '%s'    \n"), tf );
			gI_error_dialog( buf);
			g_free( tf );
			return;
		}

		kz_edit = TRUE;

		tool = gI_tool_new();

		fgets( buf, MAXLEN, toolfile );
		rem_return( buf );
		tool->name = g_strdup( buf );
		fgets( buf, MAXLEN, toolfile );
		rem_return( buf );
		tool->menu_item_name = g_strdup( buf );
		fgets( buf, MAXLEN, toolfile );
		rem_return( buf );
		tool->cmdline = g_strdup( buf );
		fgets( buf, MAXLEN, toolfile );
		tool->output = atoi( buf );

		/* show! */
		gtk_entry_set_text( GTK_ENTRY( e_name ), tool->name );
		gtk_entry_set_text( GTK_ENTRY( e_cmdline ), tool->cmdline );
		gtk_entry_set_text( GTK_ENTRY( e_menu_item_name ), tool->menu_item_name );

		/* switch the right one on */
		switch( tool->output )
		{
		case TOOL_OUTPUT_NEW:
			gtk_widget_activate( r_new );
			break;

		case TOOL_OUTPUT_APPEND:
			gtk_widget_activate( r_append );
			break;

		case TOOL_OUTPUT_BOX:
			gtk_widget_activate( r_box );
			break;

		case TOOL_OUTPUT_IGNORE:
			gtk_widget_activate( r_ignore );
			break;

		case TOOL_OUTPUT_INSERT:
			gtk_widget_activate( r_insert );
			break;

		case TOOL_OUTPUT_XTERM:
			gtk_widget_activate( r_xterm );
			break;

		case TOOL_OUTPUT_PIPE:
			gtk_widget_activate( r_pipe );
			break;
		}

		g_free( tool );
	}

	g_free( tf );
}


static void show_tool( GtkWidget *widget, gpointer data )
{
	gI_tool_lookup( gtk_entry_get_text( GTK_ENTRY( e_name ) ) );
}


static void insert_parameters( gchar *target, gchar *source )
{
	glong source_len;
	glong i,j=0;
	gI_document *current;

	current = gI_document_get_current( main_window );
	source_len = strlen( source );

	for(i=0;i<source_len;i++)
	{
		if( source[i] != '%' )
		{
			target[j++] = source[i];
		}
		else
		{
			i++;

			switch( source[i] )
			{
			case 'f':
				target[j] = '\0';
				strcat( target, current->filename );
				j += strlen( current->filename );
				break;

			default:
				target[j++] = '%';
				target[j++] = source[i];
				break;
			}
		}
	}

	target[j++] = '\0';
}

static void custom_tool_destroy( GtkWidget *widget, gI_tool *tool )
{
	g_free( tool->name );
	g_free( tool->menu_item_name );
	g_free( tool->cmdline );
	g_free( tool );
}

static void custom_tool_activate( GtkWidget *widget, gI_tool *tool )
{
	gchar exec_string[MAXLEN];
	gchar tmpstring[STRLEN];
	FILE *tmpfile;
	gchar *tempname = NULL;
	GtkWidget *text;
	gchar buf[MAXLEN];
	gchar title[STRLEN];
	GtkWidget *scrolled_win;
	gI_document *document;
	gchar *tempPtr;

	/*
	 * FIXME: when executing a tool, fork a subprocess and install a
	 * timer to allow the process to get killed and gIDE to continue...
	 */ 

#if 0
	g_print( "tool->name: %s\n", tool->name );
	g_print( "tool->menu_item_name: %s\n",tool->menu_item_name);
	g_print( "tool->cmdline: %s\n",tool->cmdline);
	g_print( "tool->output: %d\n", tool->output);
#endif

	insert_parameters( exec_string, tool->cmdline );

	if( tool->output == TOOL_OUTPUT_PIPE )
	{
		/*
		 * we need a document ... :)
		 */
		document = gI_document_get_current( main_window );
		if( !document )
		{
			return;
		}

		/*
		 * if the document is changed, warn!
		 */
		if( document->changed )
		{
		}

		/* generate temp. filename */
		tempPtr = g_strconcat( tool->name, "XXXXX", NULL );
		tempname = tempnam( cfg->tmpdir, tempPtr );
		g_free( tempPtr );

		/*
		 * construct exec_string and execute it
		 * using popen().
		 */	
		g_snprintf( tmpstring, sizeof(tmpstring), "%s 1>%s 2>&1",
		            exec_string, tempname );
		strcpy( exec_string, tmpstring );
		tmpfile = popen( exec_string, "w" );
		if( tmpfile )
		{
			tempPtr = gtk_editable_get_chars( GTK_EDITABLE( document->text ),
			                                  0, -1 );
			fwrite( tempPtr,
			        gI_text_get_length(document->text),
			        1,
			        tmpfile );

			pclose( tmpfile );
			g_free( tempPtr );
		}
		else
		{
			g_warning( "Unable to Execute Tool!" );
		}

		tmpfile = fopen( tempname, "r" );
		if( tmpfile )
		{
			gI_text_freeze( document->text );

			/* clear the document */
			gI_document_clear_text( document );

			/* insert the output as new document */
			while( fgets( buf, sizeof(buf), tmpfile ) )
			{
				gI_document_insert( document, NULL, NULL, NULL, buf, strlen(buf) );
			}

			fclose( tmpfile );

			gI_text_thaw( document->text );
		}
		else
		{
			g_warning( "Unable to Open temponary File!" );
		}

		/* free memory */
		remove( tempname );
		g_free( tempname );

		return;
	}

	if( tool->output == TOOL_OUTPUT_IGNORE )
	{
		strcat( exec_string, " 1>/dev/null 2>&1" );
	}
	else
	{
		if( tool->output == TOOL_OUTPUT_XTERM )
		{
			g_snprintf( tmpstring, sizeof(tmpstring), "%s -T \"%s\"  -e %s &", cfg->xterm, tool->menu_item_name, exec_string );
			strcpy( exec_string, tmpstring );
		}
		else
		{
			tempPtr = g_strconcat( tool->name, "XXXXX", NULL );
			tempname = tempnam( cfg->tmpdir, tempPtr );
			g_snprintf( tmpstring, STRLEN, " 1>\"%s\" 2>&1", tempname );
			strcat( exec_string, tmpstring );
			g_free( tempPtr );
		}
	}

	system( exec_string );

	if( tool->output == TOOL_OUTPUT_XTERM )
		return;

	if( tool->output != TOOL_OUTPUT_IGNORE )
	{
		tmpfile = fopen( tempname, "r" );
		if( !tmpfile )
		{
			/* error handling */
			g_snprintf( buf, MAXLEN, _("\n    Unable to Open Tool File '%s'    \n"), tempname );
			gI_error_dialog( buf);
			return;
		}

		if( tool->output == TOOL_OUTPUT_BOX )
		{
			custom_tools_window = gtk_window_new( GTK_WINDOW_TOPLEVEL );
			gtk_widget_set_usize( custom_tools_window, 450, 250 );
			gtk_window_set_position( GTK_WINDOW( custom_tools_window ), GTK_WIN_POS_MOUSE );
			g_snprintf( title, STRLEN, _("Output of '%s'"), tool->name );
			gtk_window_set_title( GTK_WINDOW( custom_tools_window ), title );
			gtk_signal_connect( GTK_OBJECT( custom_tools_window ), "destroy",
			                    GTK_SIGNAL_FUNC( custom_tools_window_destroy ), NULL );

			scrolled_win = gtk_scrolled_window_new( NULL, NULL );
			gtk_container_add( GTK_CONTAINER( custom_tools_window ), scrolled_win );
			gtk_widget_show( scrolled_win );

			text = gtk_text_new( NULL, gtk_scrolled_window_get_vadjustment( GTK_SCROLLED_WINDOW( scrolled_win ) ) );
			gtk_container_add( GTK_CONTAINER( scrolled_win ), text );
			gtk_widget_show( text );

			gtk_widget_realize( text );

			while( fgets( buf, MAXLEN, tmpfile ) )
			{
				gI_text_insert(  text, NULL, NULL, NULL, buf, strlen(buf) );
			}

			gtk_widget_show( custom_tools_window );
		}

		if( tool->output == TOOL_OUTPUT_NEW )
		{
			document = gI_document_new( main_window );

			while( fgets( buf, MAXLEN, tmpfile ) )
			{
				gI_document_insert( document, NULL, NULL, NULL, buf, strlen(buf) );
			}

			gtk_signal_emit_by_name( GTK_OBJECT( document->text ), "changed" );

		}

		if( tool->output == TOOL_OUTPUT_APPEND )
		{
			document = gI_document_get_current( main_window );

			gI_text_set_point(  document->text, gI_text_get_length(  document->text ) );

			while( fgets( buf, MAXLEN, tmpfile ) )
			{
				gI_document_insert( document, NULL, NULL, NULL, buf, strlen(buf) );
			}

			gtk_signal_emit_by_name( GTK_OBJECT( document->text ), "changed" );
		}

		if( tool->output == TOOL_OUTPUT_INSERT )
		{
			document = gI_document_get_current( main_window );

			while( fgets( buf, MAXLEN, tmpfile ) )
			{
				gI_document_insert( document, NULL, NULL, NULL, buf, strlen(buf) );
			}

			gtk_signal_emit_by_name( GTK_OBJECT( document->text ), "changed" );
		}

		fclose( tmpfile );

		remove( tempname );

		g_free( tempname );
	}
}


void menu_add_tool( gI_window *window, gI_tool *tool )
{
	gchar entry[200];
	GtkWidget *widget;
	GtkMenuShell *menushell;
	GtkMenuBar *menubar;
	GtkWidget *parent;
	gint pos;
	static gchar last_tool[200] = "Tools/<Separator>";

	menubar = GTK_MENU_BAR( GNOME_APP( window->window )->menubar );
	menushell = &menubar->menu_shell;
	parent = gnome_app_find_menu_pos( GTK_WIDGET( menushell ), last_tool, &pos );

	widget = gtk_menu_item_new_with_label( tool->menu_item_name );
	gtk_menu_shell_insert( GTK_MENU_SHELL( parent ), widget, pos );
	gtk_signal_connect( GTK_OBJECT( widget ), "activate",
	                    GTK_SIGNAL_FUNC( custom_tool_activate ), (gpointer) tool );
	gtk_signal_connect( GTK_OBJECT( widget ), "destroy",
	                    GTK_SIGNAL_FUNC( custom_tool_destroy ), (gpointer) tool );
	gtk_widget_show( widget );

	/* store last tool item name */
	sprintf( last_tool, "Tools/%s", tool->menu_item_name );
	
	/* add new item to association list */
	g_snprintf( entry, 200, "/Tools/%s", tool->menu_item_name );
	menus_add_item_widget( entry, widget );
}


void menu_remove_tool( gchar *menu_item_name )
{
	gchar path[STRLEN];
	GtkWidget *widget;

	g_snprintf( path, STRLEN, "/Tools/%s", menu_item_name );

	widget = menus_get_item_widget( path );
	if( widget )
		gtk_widget_destroy( widget );
	else
		printf( "Unable to destroy %s\n",path );

	/* remove association */
	menus_remove_item_widget( path );
}


void rem_return( gchar *str )
               {
	               gchar *ptr;

	               ptr = strrchr( str, '\n' );
	               if( ptr )
	               {
		               *ptr = '\0';
	               }
               }


               void add_all_tools( gI_window *window )
               {
	               DIR *dir;
	               struct dirent *entry;
	               FILE *toolfile;
	               gchar buf[MAXLEN];
	               gI_tool *tool;
	               gchar tfwp[MAXLEN];

	               dir = opendir( tools_path );

	               while( (entry = readdir( dir ) ) )
	               {
		               if( !strstr( entry->d_name, ".tl" ) )
			               continue;

		               tool = gI_tool_new();

		               g_snprintf( tfwp, MAXLEN, "%s/%s", tools_path, entry->d_name );
		               toolfile = fopen( tfwp, "r" );
		               if( !toolfile )
		               {
			               /* error handling */
			               g_snprintf( buf, MAXLEN, _("\n    Unable to Open Tool File '%s'    \n"), entry->d_name );
			               gI_error_dialog( buf);
			               continue;
		               }

		               fgets( buf, MAXLEN, toolfile );
		               rem_return( buf );
		               tool->name = g_strdup( buf );
		               fgets( buf, MAXLEN, toolfile );
		               rem_return( buf );
		               tool->menu_item_name = g_strdup( buf );
		               fgets( buf, MAXLEN, toolfile );
		               rem_return( buf );
		               tool->cmdline = g_strdup( buf );
		               fgets( buf, MAXLEN, toolfile );
		               tool->output = atoi( buf );

		               fclose( toolfile );

		               menu_add_tool( window, tool );
	               }

	               closedir( dir );
               }


               static void custom_tools_help_select( GtkWidget *widget, gpointer data )
               {
	               static GtkWidget *help_window = NULL;
	               GtkWidget *hbox, *vbox;
	               GtkWidget *text;
	               GtkWidget *vscrollbar;
	               GtkWidget *button;
	               GtkWidget *hsep;
	               glong i;

	               if( help_window )
		               return;

	               help_window = gtk_window_new( GTK_WINDOW_TOPLEVEL );
	               gtk_window_set_title( GTK_WINDOW( help_window ), _("Custom Tools Help") );
	               gtk_widget_set_usize( help_window, 600, 400 );

	               vbox = gtk_vbox_new( FALSE, 0 );
	               gtk_container_add( GTK_CONTAINER( help_window ), vbox );
	               gtk_widget_show( vbox );

	               hbox = gtk_hbox_new( FALSE, 0 );
	               gtk_box_pack_start( GTK_BOX( vbox ), hbox, TRUE, TRUE, 5 );
	               gtk_widget_show( hbox );

	               text = gtk_text_new( NULL, NULL );
	               gtk_box_pack_start( GTK_BOX( hbox ), text, TRUE, TRUE, 5 );
	               gtk_widget_show( text );

	               vscrollbar = gtk_vscrollbar_new( GTK_TEXT( text )->vadj );
	               gtk_box_pack_end( GTK_BOX( hbox ), vscrollbar, FALSE, TRUE, 5 );
	               gtk_widget_show( vscrollbar );

	               hsep = gtk_hseparator_new();
	               gtk_box_pack_start( GTK_BOX( vbox ), hsep, FALSE, TRUE, 5 );
	               gtk_widget_show( hsep );

	               hbox = gtk_hbox_new( FALSE, 0 );
	               gtk_box_pack_start( GTK_BOX( vbox ), hbox, FALSE, TRUE, 10 );
	               gtk_widget_show( hbox );

	               button = gnome_stock_button( GNOME_STOCK_BUTTON_CLOSE );
	               gtk_box_pack_start( GTK_BOX( hbox ), button, TRUE, TRUE, 5 );
	               gtk_signal_connect_object( GTK_OBJECT( button ), "clicked",
	                                          GTK_SIGNAL_FUNC( gtk_widget_destroy ), GTK_OBJECT( help_window ) );
	               GTK_WIDGET_SET_FLAGS( button, GTK_CAN_DEFAULT );
	               gtk_widget_grab_default( button );
	               gtk_widget_show( button );

	               gtk_widget_show( help_window );

	               /* insert text */
	               gtk_text_freeze( GTK_TEXT( text ) );
	               for(i=0;i<(sizeof( tools_help_text ) / sizeof( tools_help_text[0] ));i++)
		               gtk_text_insert( GTK_TEXT( text ) , NULL, &text->style->black, NULL, tools_help_text[i], strlen( tools_help_text[i] ) );
	               gtk_text_thaw(  GTK_TEXT( text ) );
               }


               static void cmdline_file_ok( GtkWidget *widget, GtkWidget *filesel )
               {
	               gchar *filename;

	               filename = gtk_file_selection_get_filename( GTK_FILE_SELECTION( filesel ) );

	               gtk_entry_set_text( GTK_ENTRY( e_cmdline ), filename );

	               if( GTK_WIDGET_VISIBLE( filesel ) )
		               gtk_widget_hide( filesel );
               }


               static void cmdline_file_cancel( GtkWidget *widget, GtkWidget *filesel )
               {
	               if( GTK_WIDGET_VISIBLE( filesel ) )
		               gtk_widget_hide( filesel );
               }


               static void cmdline_browse_select( GtkWidget *widget, gpointer data )
               {
	               static GtkWidget *filesel = NULL;

	               if( !filesel )
	               {
		               filesel = gtk_file_selection_new( _("Select File...") );
		               gtk_signal_connect( GTK_OBJECT( filesel ), "destroy",
		                                   GTK_SIGNAL_FUNC( cmdline_file_cancel ), filesel );
		               gtk_signal_connect( GTK_OBJECT( GTK_FILE_SELECTION( filesel )->ok_button ), "clicked",
		                                   GTK_SIGNAL_FUNC( cmdline_file_ok ), filesel  );
		               gtk_signal_connect( GTK_OBJECT( GTK_FILE_SELECTION( filesel )->cancel_button ), "clicked",
		                                   GTK_SIGNAL_FUNC( cmdline_file_cancel ), filesel );
	               }

	               if( !GTK_WIDGET_VISIBLE( filesel ) )
		               gtk_widget_show( filesel );
               }


               static void custom_tools_ok_select( GtkWidget *widget, gpointer data )
               {
	               gI_tool *tool;
	               gchar *ptr;

	               ptr = gtk_entry_get_text( GTK_ENTRY( e_name ) );
	               if( !ptr || isempty( ptr ) )
	               {
		               gI_ok_dialog( _("Please enter a Tool Name!") );
		               return;
	               }
	               if( strchr( ptr, ' ' ) )
	               {
		               gI_ok_dialog( _("Tool Name must not contain blanks!") );
		               return;
	               }

	               ptr = gtk_entry_get_text( GTK_ENTRY( e_cmdline ) );
	               if( !ptr || isempty( ptr ) )
	               {
		               gI_ok_dialog( _("Please enter a Command-Line!") );
		               return;
	               }

	               ptr = gtk_entry_get_text( GTK_ENTRY( e_menu_item_name ) );
	               if( !ptr || isempty( ptr ) )
	               {
		               gI_ok_dialog( _("Please enter a Menu-Item-Name!") );
		               return;
	               }

	               if( kz_edit )
	               {
		               kz_edit = FALSE;
		               menu_remove_tool( gtk_entry_get_text( GTK_ENTRY( e_menu_item_name ) ) );
	               }

	               tool = gI_tool_new();

	               ptr = gtk_entry_get_text( GTK_ENTRY( e_name ) );
	               tool->name = g_strdup( ptr );

	               ptr = gtk_entry_get_text( GTK_ENTRY( e_menu_item_name ) );
	               tool->menu_item_name = g_strdup( ptr );

	               ptr = gtk_entry_get_text( GTK_ENTRY( e_cmdline ) );
	               tool->cmdline = g_strdup( ptr );

	               if( GTK_TOGGLE_BUTTON( r_new )->active )
		               tool->output = TOOL_OUTPUT_NEW;
	               if( GTK_TOGGLE_BUTTON( r_append )->active )
		               tool->output = TOOL_OUTPUT_APPEND;
	               if( GTK_TOGGLE_BUTTON( r_box )->active )
		               tool->output = TOOL_OUTPUT_BOX;
	               if( GTK_TOGGLE_BUTTON( r_ignore )->active )
		               tool->output = TOOL_OUTPUT_IGNORE;
	               if( GTK_TOGGLE_BUTTON( r_insert )->active )
		               tool->output = TOOL_OUTPUT_INSERT;
	               if( GTK_TOGGLE_BUTTON( r_xterm )->active )
		               tool->output = TOOL_OUTPUT_XTERM;
	               if( GTK_TOGGLE_BUTTON( r_pipe )->active )
		               tool->output = TOOL_OUTPUT_PIPE;

	               gI_tool_save( tool );

	               menu_add_tool( main_window, tool );

	               custom_tools_window_destroy( NULL, NULL );
               }


               /*
                ---------------------------------------------------------------------
                    Function: custom_tools()
                    Desc: Callback-Function /Preferences/Custom Tools...
                ---------------------------------------------------------------------
               */

               void custom_tools( GtkWidget *widget, gpointer data )
               {
	               GtkWidget *vbox;
	               GtkWidget *hbox;
	               GtkWidget *label;
	               GtkWidget *button;
	               GtkWidget *frame;
	               GtkWidget *frame_vbox;
	               GSList *output_group;
	               GtkWidget *hsep;


	               if( custom_tools_window )
		               return;

	               custom_tools_window = gtk_window_new( GTK_WINDOW_TOPLEVEL );
	               gtk_widget_set_usize( custom_tools_window, 400, 445 );
	               gtk_window_set_title( GTK_WINDOW( custom_tools_window ), _("Tool Configuration...") );
	               gtk_signal_connect( GTK_OBJECT( custom_tools_window ), "destroy",
	                                   GTK_SIGNAL_FUNC( custom_tools_window_destroy ), NULL );
	               gtk_container_set_border_width( GTK_CONTAINER( custom_tools_window ), 10 );
	               gtk_widget_realize( custom_tools_window );

	               vbox = gtk_vbox_new( FALSE, 0 );
	               gtk_container_add( GTK_CONTAINER( custom_tools_window ), vbox );
	               gtk_widget_show( vbox );

	               hbox = gtk_hbox_new( FALSE, 0 );
	               gtk_box_pack_start( GTK_BOX( vbox ), hbox, FALSE, TRUE, 5 );
	               gtk_widget_show( hbox );

	               label = gtk_label_new( _("Name:") );
	               gtk_box_pack_start( GTK_BOX( hbox ), label, FALSE, TRUE, 5 );
	               gtk_widget_show( label );

	               hbox = gtk_hbox_new( FALSE, 0 );
	               gtk_box_pack_start( GTK_BOX( vbox ), hbox, FALSE, TRUE, 0 );
	               gtk_widget_show( hbox );

	               e_name = gtk_entry_new_with_max_length( 255 );
	               gtk_box_pack_start( GTK_BOX( hbox ), e_name, FALSE, TRUE, 5 );
	               gtk_widget_grab_focus( e_name );
	               gtk_signal_connect( GTK_OBJECT( e_name ), "activate",
	                                   GTK_SIGNAL_FUNC( show_tool ), NULL );
	               gtk_widget_show( e_name );

	               hbox = gtk_hbox_new( FALSE, 0 );
	               gtk_box_pack_start( GTK_BOX( vbox ), hbox, FALSE, TRUE, 5 );
	               gtk_widget_show( hbox );

	               hbox = gtk_hbox_new( FALSE, 0 );
	               gtk_box_pack_start( GTK_BOX( vbox ), hbox, FALSE, TRUE, 5 );
	               gtk_widget_show( hbox );

	               label = gtk_label_new( _("Command Line:") );
	               gtk_box_pack_start( GTK_BOX( hbox ), label, FALSE, TRUE, 5 );
	               gtk_widget_show( label );

	               hbox = gtk_hbox_new( FALSE, 0 );
	               gtk_box_pack_start( GTK_BOX( vbox ), hbox, FALSE, TRUE, 0 );
	               gtk_widget_show( hbox );

	               e_cmdline = gtk_entry_new_with_max_length( 255 );
	               gtk_box_pack_start( GTK_BOX( hbox ), e_cmdline, TRUE, TRUE, 5 );
	               gtk_widget_show( e_cmdline );

	               button = gtk_button_new_with_label( _("   Browse...   ") );
	               gtk_box_pack_start( GTK_BOX( hbox ), button, FALSE, TRUE, 10 );
	               gtk_signal_connect( GTK_OBJECT( button ), "clicked",
	                                   GTK_SIGNAL_FUNC( cmdline_browse_select ), NULL );
	               gtk_widget_show( button );

	               hbox = gtk_hbox_new( FALSE, 0 );
	               gtk_box_pack_start( GTK_BOX( vbox ), hbox, FALSE, TRUE, 5 );
	               gtk_widget_show( hbox );

	               hbox = gtk_hbox_new( FALSE, 0 );
	               gtk_box_pack_start( GTK_BOX( vbox ), hbox, FALSE, TRUE, 5 );
	               gtk_widget_show( hbox );

	               label = gtk_label_new( _("Menu Item Name:") );
	               gtk_box_pack_start( GTK_BOX( hbox ), label, FALSE, TRUE, 5 );
	               gtk_widget_show( label );

	               hbox = gtk_hbox_new( FALSE, 0 );
	               gtk_box_pack_start( GTK_BOX( vbox ), hbox, FALSE, TRUE, 0 );
	               gtk_widget_show( hbox );

	               e_menu_item_name = gtk_entry_new_with_max_length( 32 );
	               gtk_box_pack_start( GTK_BOX( hbox ), e_menu_item_name, TRUE, TRUE, 5 );
	               gtk_widget_show( e_menu_item_name );

	               hbox = gtk_hbox_new( FALSE, 0 );
	               gtk_box_pack_start( GTK_BOX( vbox ), hbox, FALSE, TRUE, 20 );
	               gtk_widget_show( hbox );

	               frame = gtk_frame_new( _("Command Output") );
	               gtk_box_pack_start( GTK_BOX( hbox ), frame, TRUE, TRUE, 5 );
	               gtk_widget_show( frame );

	               frame_vbox = gtk_vbox_new( FALSE, 0 );
	               gtk_container_add( GTK_CONTAINER( frame ), frame_vbox );
	               gtk_widget_show( frame_vbox );

	               hbox = gtk_hbox_new( FALSE, 0 );
	               gtk_box_pack_start( GTK_BOX( frame_vbox ), hbox, FALSE, TRUE, 0 );
	               gtk_widget_show( hbox );

	               r_new = gtk_radio_button_new_with_label( NULL, _("Create New File") );
	               gtk_box_pack_start( GTK_BOX( hbox ), r_new, FALSE, TRUE, 5 );
	               gtk_widget_show( r_new );

	               output_group = gtk_radio_button_group( GTK_RADIO_BUTTON( r_new ) );

	               hbox = gtk_hbox_new( FALSE, 0 );
	               gtk_box_pack_start( GTK_BOX( frame_vbox ), hbox, FALSE, TRUE, 0 );
	               gtk_widget_show( hbox );

	               r_append = gtk_radio_button_new_with_label( output_group, _("Append to Current File") );
	               gtk_box_pack_start( GTK_BOX( hbox ), r_append, FALSE, TRUE, 5 );
	               gtk_widget_show( r_append );

	               hbox = gtk_hbox_new( FALSE, 0 );
	               gtk_box_pack_start( GTK_BOX( frame_vbox ), hbox, FALSE, TRUE, 0 );
	               gtk_widget_show( hbox );

	               output_group = gtk_radio_button_group( GTK_RADIO_BUTTON( r_append ) );

	               r_insert = gtk_radio_button_new_with_label( output_group, _("Insert at Cursor Position") );
	               gtk_box_pack_start( GTK_BOX( hbox ), r_insert, FALSE, TRUE, 5 );
	               gtk_widget_show( r_insert );

	               hbox = gtk_hbox_new( FALSE, 0 );
	               gtk_box_pack_start( GTK_BOX( frame_vbox ), hbox, FALSE, TRUE, 0 );
	               gtk_widget_show( hbox );

	               output_group = gtk_radio_button_group( GTK_RADIO_BUTTON( r_insert ) );

	               r_box = gtk_radio_button_new_with_label( output_group, _("Output to Text Box") );
	               gtk_box_pack_start( GTK_BOX( hbox ), r_box, FALSE, TRUE, 5 );
	               gtk_widget_show( r_box );

	               hbox = gtk_hbox_new( FALSE, 0 );
	               gtk_box_pack_start( GTK_BOX( frame_vbox ), hbox, FALSE, TRUE, 0 );
	               gtk_widget_show( hbox );

	               output_group = gtk_radio_button_group( GTK_RADIO_BUTTON( r_box ) );

	               r_ignore = gtk_radio_button_new_with_label( output_group, _("Ignore Output") );
	               gtk_box_pack_start( GTK_BOX( hbox ), r_ignore, FALSE, TRUE, 5 );
	               gtk_widget_show( r_ignore );

	               hbox = gtk_hbox_new( FALSE, 0 );
	               gtk_box_pack_start( GTK_BOX( frame_vbox ), hbox, FALSE, TRUE, 0 );
	               gtk_widget_show( hbox );

	               output_group = gtk_radio_button_group( GTK_RADIO_BUTTON( r_ignore ) );

	               r_xterm = gtk_radio_button_new_with_label( output_group, _("Run in XTerm") );
	               gtk_box_pack_start( GTK_BOX( hbox ), r_xterm, FALSE, TRUE, 5 );
	               gtk_widget_show( r_xterm );

	               hbox = gtk_hbox_new( FALSE, 0 );
	               gtk_box_pack_start( GTK_BOX( frame_vbox ), hbox, FALSE, TRUE, 0 );
	               gtk_widget_show( hbox );

	               output_group = gtk_radio_button_group( GTK_RADIO_BUTTON( r_xterm ) );

	               r_pipe = gtk_radio_button_new_with_label( output_group, _("Pipe thru Command") );
	               gtk_box_pack_start( GTK_BOX( hbox ), r_pipe, FALSE, TRUE, 5 );
	               gtk_widget_show( r_pipe );


	               hsep = gtk_hseparator_new();
	               gtk_box_pack_start( GTK_BOX( vbox ), hsep, FALSE, TRUE, 5 );
	               gtk_widget_show( hsep );

	               hbox = gtk_hbox_new( FALSE, 0 );
	               gtk_box_pack_start( GTK_BOX( vbox ), hbox, FALSE, TRUE, 5 );
	               gtk_widget_show( hbox );

	               button = gnome_stock_button( GNOME_STOCK_BUTTON_OK );
	               gtk_box_pack_start( GTK_BOX( hbox ), button, TRUE, TRUE, 5 );
	               gtk_signal_connect( GTK_OBJECT( button ), "clicked",
	                                   GTK_SIGNAL_FUNC( custom_tools_ok_select ), NULL );
	               gtk_widget_show( button );

	               button = gnome_stock_button( GNOME_STOCK_BUTTON_CANCEL );
	               gtk_box_pack_start( GTK_BOX( hbox ), button, TRUE, TRUE, 5 );
	               gtk_signal_connect( GTK_OBJECT( button ), "clicked",
	                                   GTK_SIGNAL_FUNC( custom_tools_window_destroy ), NULL );
	               gtk_widget_show( button );

	               button = gnome_stock_button( GNOME_STOCK_BUTTON_HELP );
	               gtk_box_pack_start( GTK_BOX( hbox ), button, TRUE, TRUE, 5 );
	               gtk_signal_connect( GTK_OBJECT( button ), "clicked",
	                                   GTK_SIGNAL_FUNC( custom_tools_help_select ), NULL );
	               gtk_widget_show( button );

	               gtk_widget_show( custom_tools_window );
               }


               static void tools_ascii_table_select( GtkWidget *clist, gint row, gint column, GdkEventButton *bevent )
               {
	               if( !bevent )
		               return;

	               if( bevent->type == GDK_2BUTTON_PRESS )
	               {
		               gI_document *current;
		               gchar *ch;

		               current = gI_document_get_current( main_window );
		               if( !current )
			               return;

		               gtk_clist_get_text( GTK_CLIST( clist ), row, 0, &ch );
		               ch += 2;

		               gI_document_insert( current, NULL, NULL, NULL, ch, 1 );

		               gI_document_set_changed( current );
	               }
               }


               void tools_ascii_table( GtkWidget *widget, gpointer data )
               {
	               GtkWidget *window;
	               GtkWidget *scrwindow;
	               GtkWidget *clist;
	               gchar *items[4];
	               gchar ch[10];
	               gchar dec[10];
	               gchar hex[10];
	               gchar oct[10];
	               gint i;
	               gchar *list_titles[] = { "Char", "Dec#", "Hex#", "Oct#" };

	               window = gtk_window_new( GTK_WINDOW_TOPLEVEL );
	               gtk_signal_connect( GTK_OBJECT( window ), "destroy",
	                                   GTK_SIGNAL_FUNC( gtk_widget_destroyed ), NULL );
	               gtk_window_set_title( GTK_WINDOW( window ), _("Tools - ASCII Table") );
	               gtk_widget_set_usize( window, 210, 400 );

	               scrwindow = gtk_scrolled_window_new( NULL, NULL );
	               gtk_container_add( GTK_CONTAINER( window ), scrwindow );

	               clist = gtk_clist_new_with_titles( 4, list_titles );
	               gtk_signal_connect( GTK_OBJECT( clist ), "select_row",
	                                   GTK_SIGNAL_FUNC( tools_ascii_table_select ), NULL );
	               gtk_container_add( GTK_CONTAINER( scrwindow ), clist );
	               gtk_clist_column_titles_passive( GTK_CLIST( clist ) );
	               gtk_clist_set_column_width( GTK_CLIST( clist ), 0, 40 );
	               gtk_clist_set_column_width( GTK_CLIST( clist ), 1, 40 );
	               gtk_clist_set_column_width( GTK_CLIST( clist ), 2, 40 );
	               gtk_clist_set_column_width( GTK_CLIST( clist ), 3, 40 );

	               /* fill list */
	               for(i=0;i<256;i++)
	               {
		               sprintf( ch, "%3c", i );
		               sprintf( dec, "%3d", i );
		               sprintf( hex, "0x%2.2X", i );
		               sprintf( oct, "%3.3o", i );

		               items[0] = ch;
		               items[1] = dec;
		               items[2] = hex;
		               items[3] = oct;

		               gtk_clist_append( GTK_CLIST( clist ), items );
	               }

	               gtk_widget_show_all( window );
               }


               void tools_calculator( GtkWidget *widget, gpointer data )
               {
	               GtkWidget *window;
	               GtkWidget *calc;

	               window = gtk_window_new( GTK_WINDOW_TOPLEVEL );
	               gtk_window_set_title( GTK_WINDOW( window ), _("Tools - Calculator") );
	               gtk_signal_connect( GTK_OBJECT( window ), "destroy",
	                                   GTK_SIGNAL_FUNC( gtk_widget_destroyed ),
	                                   NULL );

	               calc = gnome_calculator_new();
	               gtk_container_add( GTK_CONTAINER( window ), calc );
	               gtk_window_add_accel_group( GTK_WINDOW( window ),
	                                           GNOME_CALCULATOR( calc )->accel );

	               gtk_widget_show_all( window );
               }



               static void tools_diff_ok( GtkWidget *widget, GtkDialog *win )
               {
	               GtkWidget *entry;
	               gchar *file1;
	               gchar *file2;
	               gchar msg[STRLEN];

	               entry = (GtkWidget *)
	                       gtk_object_get_data( GTK_OBJECT( win ),
	                                            "e_file1" );
	               file1 = gtk_entry_get_text( GTK_ENTRY( entry ) );

	               entry = (GtkWidget *)
	                       gtk_object_get_data( GTK_OBJECT( win ),
	                                            "e_file2" );
	               file2 = gtk_entry_get_text( GTK_ENTRY( entry ) );

	               /* check if the files really exist */
	               if( isempty( file1 ) || !file_exist( file1 ) )
	               {
		               g_snprintf( msg, STRLEN, _("The File '%s' does not exist!"),
		                           file1 );
		               gI_error_dialog( msg);
		               return;
	               }

	               if( isempty( file2 ) || !file_exist( file2 ) )
	               {
		               g_snprintf( msg, STRLEN, _("The File '%s' does not exist!"),
		                           file2 );
		               gI_error_dialog( msg);
		               return;
	               }

	               /* diff... */
	               diff_files_if( file1, file2 );

	               gtk_widget_destroy( GTK_WIDGET( win ) );
               }


               static void tools_diff_cancel( GtkWidget *widget, GtkDialog *win )
               {
	               gtk_widget_destroy( GTK_WIDGET( win ) );
               }


               void tools_diff( GtkWidget *widget, gpointer data )
               {
	               GtkWidget *win;
	               GtkWidget *fixed;
	               GtkWidget *label;
	               GtkWidget *entry;
	               GtkWidget *button;

	               win = gtk_dialog_new();
	               gtk_window_set_title( &GTK_DIALOG( win )->window, _("Tools - Diff") );
	               gtk_widget_set_usize( win, 300, 150 );

	               fixed = gtk_fixed_new();
	               gtk_container_add( GTK_CONTAINER( GTK_DIALOG( win )->vbox ), fixed ),

	               label = gtk_label_new( _("File 1") );
	               gtk_fixed_put( GTK_FIXED( fixed ),
	                              label,
	                              20,
	                              20 );

	               entry = gtk_entry_new_with_max_length( 255 );
	               gtk_object_set_data( GTK_OBJECT( win ),
	                                    "e_file1",
	                                    entry );
	               gtk_fixed_put( GTK_FIXED( fixed ),
	                              entry,
	                              70,
	                              20 );
	               gtk_widget_grab_focus( entry );

	               label = gtk_label_new( _("File 2") );
	               gtk_fixed_put( GTK_FIXED( fixed ),
	                              label,
	                              20,
	                              50 );

	               entry = gtk_entry_new_with_max_length( 255 );
	               gtk_object_set_data( GTK_OBJECT( win ),
	                                    "e_file2",
	                                    entry );
	               gtk_fixed_put( GTK_FIXED( fixed ),
	                              entry,
	                              70,
	                              50 );

	               button = gnome_stock_button( GNOME_STOCK_BUTTON_OK );
	               gtk_signal_connect( GTK_OBJECT( button ), "clicked",
	                                   GTK_SIGNAL_FUNC( tools_diff_ok ),
	                                   (gpointer) win );
	               gtk_box_pack_start( GTK_BOX( GTK_DIALOG( win )->action_area ),
	                                   button,
	                                   FALSE, TRUE, 5 );

	               button = gnome_stock_button( GNOME_STOCK_BUTTON_CANCEL );
	               gtk_signal_connect( GTK_OBJECT( button ), "clicked",
	                                   GTK_SIGNAL_FUNC( tools_diff_cancel ),
	                                   (gpointer) win );
	               gtk_box_pack_end( GTK_BOX( GTK_DIALOG( win )->action_area ),
	                                 button,
	                                 FALSE, TRUE, 5 );

	               gtk_widget_show_all( win );
               }


               gint diff_files( gchar *file1, gchar *file2 )
               {
	               FILE *fp1, *fp2;
	               gchar f1_line[MAXLEN], f2_line[MAXLEN];	/* current line */
	               gchar f1_buf[3][MAXLEN];	/* to save the */
	               gchar f2_buf[3][MAXLEN];	/* last three lines */
	               gint f1_status, f2_status;
	               gint buf_count = 0;		/* index for f1_buf / f2_buf */
	               GtkWidget *win;
	               GtkWidget *vbox, *hbox;
	               GtkWidget *clist1, *clist2;
	               GtkWidget *scrwin;
	               gchar *list_line[2];
	               gchar no_str[15];
	               glong line = 0;
	               gint row1, row2;
	               GdkColormap *cmap;
	               GdkColor ColorRed;
	               gint set = 0;
	               gint show_next_one = 0;

	               /* allocate color */
	               cmap = gdk_colormap_get_system();
	               gdk_color_parse( "red", &ColorRed );

	               /* create window et al */
	               win = gtk_window_new( GTK_WINDOW_TOPLEVEL );
	               gtk_window_set_title( GTK_WINDOW( win ), _("Difference Tool") );
	               gtk_widget_set_usize( win, 640, 480 );
	               vbox = gtk_vbox_new( FALSE, 0 );
	               gtk_container_add( GTK_CONTAINER( win ), vbox );
	               hbox = gtk_hbox_new( FALSE, 0 );
	               gtk_box_pack_start( GTK_BOX( vbox ), hbox, TRUE, TRUE, 0 );
	               scrwin = gtk_scrolled_window_new( NULL, NULL );
	               gtk_box_pack_start( GTK_BOX( hbox ), scrwin, TRUE, TRUE, 5 );
	               clist1 = gtk_clist_new( 2 );
	               gtk_container_add( GTK_CONTAINER( scrwin ), clist1 );
	               scrwin = gtk_scrolled_window_new( NULL, NULL );
	               gtk_box_pack_end( GTK_BOX( hbox ), scrwin, TRUE, TRUE, 5 );
	               clist2 = gtk_clist_new( 2 );
	               gtk_container_add( GTK_CONTAINER( scrwin ), clist2 );

	               /* set size */
	               gtk_clist_set_column_width( GTK_CLIST( clist1 ),
	                                           0,
	                                           40 );
	               gtk_clist_set_column_width( GTK_CLIST( clist2 ),
	                                           0,
	                                           40 );


	               /* open files */
	               fp1 = fopen( file1, "rt" );
	               fp2 = fopen( file2, "rt" );

	               while(1)
	               {
		               /* read from both files */
		               fgets( f1_line, sizeof(f1_line), fp1 );
		               f1_status = feof( fp1 );
		               fgets( f2_line, sizeof(f2_line), fp2 );
		               f2_status = feof( fp2 );

		               /* when we're finished with both files, abort loop */
		               if( f1_status && f2_status )
			               break;

		               line++;


		               if( f1_status )
			               strcpy( f1_line, "EOF" );
		               if( f2_status )
			               strcpy( f2_line, "EOF" );

		               if( strcmp( f1_line, f2_line ) )
		               {
			               if( set )
			               {
				               /* add last line */
				               sprintf( no_str, "%d", set );
				               list_line[0] = no_str;

				               list_line[1] = f1_buf[buf_count];
				               row1 = gtk_clist_append( GTK_CLIST( clist1 ), list_line );

				               list_line[1] = f2_buf[buf_count];
				               row2 = gtk_clist_append( GTK_CLIST( clist2 ), list_line );
			               }

			               /* ... */
			               sprintf( no_str, "%ld", line );
			               list_line[0] = no_str;

			               list_line[1] = f1_line;
			               row1 = gtk_clist_append( GTK_CLIST( clist1 ), list_line );

			               list_line[1] = f2_line;
			               row2 = gtk_clist_append( GTK_CLIST( clist2 ), list_line );

			               /* set colors */
			               gtk_clist_set_foreground( GTK_CLIST( clist1 ),
			                                         row1,
			                                         &ColorRed );
			               gtk_clist_set_foreground( GTK_CLIST( clist2 ),
			                                         row2,
			                                         &ColorRed );

			               set = 0;
			               show_next_one = 1;
		               }
		               else
		               {
			               if( show_next_one )
			               {
				               show_next_one = 0;

				               /* add next line */
				               sprintf( no_str, "%ld", line );
				               list_line[0] = no_str;

				               list_line[1] = f1_line;
				               row1 = gtk_clist_append( GTK_CLIST( clist1 ), list_line );

				               list_line[1] = f2_line;
				               row2 = gtk_clist_append( GTK_CLIST( clist2 ), list_line );
			               }
			               else
			               {
				               strcpy( f1_buf[buf_count], f1_line );
				               strcpy( f2_buf[buf_count], f2_line );
				               set = line;
			               }
		               }

		               /* FIXME: buffer last three lines */
	               }

	               /* close files */
	               fclose( fp1 );
	               fclose( fp2 );

	               /* show window and all child widgets */
	               gtk_widget_show_all( win );

	               return 0;
               }



               gint diff_files_if( gchar *file1, gchar *file2 )
               {
	               gchar *diff = "/usr/bin/diff";
	               FILE *fp;
	               gchar execString[STRLEN];
	               gchar buf[MAXLEN];
	               gint section = 0;
	               gint f1_start = 0, f1_nol = 0;
	               gint f2_start = 0, f2_nol = 0;
	               gchar tmpStr1[20], tmpStr2[20];
	               gchar *p;
	               glong f1_line = -1, f2_line = -1;
	               gint row1, row2;
	               gchar *list_line[2];
	               gchar *list_titles[2];
	               gchar no_str[15];
	               GtkWidget *win;
	               GtkWidget *vbox, *hbox;
	               GtkWidget *clist1, *clist2;
	               GtkWidget *scrwin;
	               GdkColormap *cmap;
	               GdkColor ColorRed, ColorGrey;

	               /* allocate color */
	               cmap = gdk_colormap_get_system();
	               gdk_color_parse( "red", &ColorRed );
	               gdk_color_parse( "grey", &ColorGrey );

	               /* create window et al */
	               win = gtk_window_new( GTK_WINDOW_TOPLEVEL );
	               gtk_window_set_title( GTK_WINDOW( win ), "Difference Tool" );
	               gtk_widget_set_usize( win, 640, 480 );
	               vbox = gtk_vbox_new( FALSE, 0 );
	               gtk_container_add( GTK_CONTAINER( win ), vbox );
	               hbox = gtk_hbox_new( FALSE, 0 );
	               gtk_box_pack_start( GTK_BOX( vbox ), hbox, TRUE, TRUE, 0 );
	               scrwin = gtk_scrolled_window_new( NULL, NULL );
	               gtk_box_pack_start( GTK_BOX( hbox ), scrwin, TRUE, TRUE, 5 );
	               list_titles[0] = "Line";
	               list_titles[1] = file1;
	               clist1 = gtk_clist_new_with_titles( 2, list_titles );
	               gtk_clist_column_titles_passive( GTK_CLIST( clist1 ) );
	               gtk_clist_set_column_auto_resize( GTK_CLIST( clist1 ), 1, TRUE );
	               gtk_container_add( GTK_CONTAINER( scrwin ), clist1 );
	               scrwin = gtk_scrolled_window_new( NULL, NULL );
	               gtk_box_pack_end( GTK_BOX( hbox ), scrwin, TRUE, TRUE, 5 );
	               list_titles[1] = file2;
	               clist2 = gtk_clist_new_with_titles( 2, list_titles );
	               gtk_clist_set_column_auto_resize( GTK_CLIST( clist2 ), 1, TRUE );
	               gtk_clist_column_titles_passive( GTK_CLIST( clist2 ) );
	               gtk_container_add( GTK_CONTAINER( scrwin ), clist2 );

	               /* set size */
	               gtk_clist_set_column_width( GTK_CLIST( clist1 ),
	                                           0,
	                                           40 );
	               gtk_clist_set_column_width( GTK_CLIST( clist2 ),
	                                           0,
	                                           40 );

	               g_snprintf( execString, STRLEN, "%s -u %s %s", diff, file1, file2 );
	               fp = popen( execString, "r" );
	               if( !fp )
	               {
		               g_print( "Unable to execute diff\n" );
		               gI_error_dialog( _("Unable to execute diff") );
		               return -1;
	               }

	               if( feof( fp ) )
	               {
		               /* couldnt execute diff */
		               g_print( "Unable to execute diff\n" );
		               gI_error_dialog( "Unable to execute diff");
		               return -1;
	               }

	               while( fgets( buf, sizeof(buf), fp ) )
	               {
		               if( !section )
		               {
			               /*
			                * continue reading...
			                */
			               if( strncmp( buf, "@@", 2 ) != 0 )
			               {
				               continue;
			               }
			               else
			               {
				               section = 1;

				               if( sscanf( buf, "%*s %s %s %*s",
				                           tmpStr1, tmpStr2 ) != 2 )
				               {
					               /* error, abort! */
					               g_print( "wrong diff output\n" );
					               gI_error_dialog( _("Wrong diff output") );
					               return -1;
				               }

				               p = strchr( tmpStr1, ',' );
				               if( !p )
				               {
					               /* error, abort! */
					               g_print( "wrong diff output\n" );
					               gI_error_dialog( _("Wrong diff output") );
					               return -1;
				               }
				               *p = '\0';
				               p++;
				               f1_nol = atol( p );
				               f1_start = atol( tmpStr1+1 );

				               p = strchr( tmpStr2, ',' );
				               if( !p )
				               {
					               /* error, abort! */
					               g_print( "wrong diff output\n" );
					               gI_error_dialog( _("Wrong diff output") );
					               return -1;
				               }
				               *p = '\0';
				               p++;
				               f2_nol = atol( p );
				               f2_start = atol( tmpStr2+1 );

				               f1_line = f1_start;
				               f2_line = f2_start;
			               }
		               }
		               else
		               {
			               if( buf[0] == ' ' )
			               {
				               f1_line++;
				               f2_line++;

				               sprintf( no_str, "%ld", f1_line );
				               list_line[0] = no_str;
				               list_line[1] = buf + 1;
				               row1 = gtk_clist_append( GTK_CLIST( clist1 ), list_line );
				               sprintf( no_str, "%ld", f2_line );
				               list_line[0] = no_str;
				               list_line[1] = buf + 1;
				               row2 = gtk_clist_append( GTK_CLIST( clist2 ), list_line );
			               }

			               if( buf[0] == '-' )
			               {
				               f1_line++;

				               sprintf( no_str, "%ld", f1_line );
				               list_line[0] = no_str;
				               list_line[1] = buf + 1;
				               row1 = gtk_clist_append( GTK_CLIST( clist1 ), list_line );

				               list_line[0] = NULL;
				               list_line[1] = NULL;
				               row2 = gtk_clist_append( GTK_CLIST( clist2 ), list_line );
				               gtk_clist_set_background( GTK_CLIST( clist2 ),
				                                         row2,
				                                         &ColorGrey );
			               }

			               if( buf[0] == '+' )
			               {
				               f2_line++;

				               sprintf( no_str, "%ld", f2_line );
				               list_line[0] = no_str;
				               list_line[1] = buf + 1;
				               row2 = gtk_clist_append( GTK_CLIST( clist2 ), list_line );

				               gtk_clist_set_foreground( GTK_CLIST( clist2 ),
				                                         row2,
				                                         &ColorRed );

				               list_line[0] = NULL;
				               list_line[1] = NULL;
				               row1 = gtk_clist_append( GTK_CLIST( clist1 ), list_line );
				               gtk_clist_set_background( GTK_CLIST( clist1 ),
				                                         row1,
				                                         &ColorGrey );
			               }

			               if( buf[0] == '@' )
			               {
				               if( sscanf( buf, "%*s %s %s %*s",
				                           tmpStr1, tmpStr2 ) != 2 )
				               {
					               /* error, abort! */
					               g_print( "wrong diff output\n" );
					               gI_error_dialog( _("Wrong diff output") );
					               return -1;
				               }

				               p = strchr( tmpStr1, ',' );
				               if( !p )
				               {
					               /* error, abort! */
					               g_print( "wrong diff output\n" );
					               gI_error_dialog( _("Wrong diff output") );
					               return -1;
				               }
				               *p = '\0';
				               p++;
				               f1_nol = atol( p );
				               f1_start = atol( tmpStr1+1 );

				               p = strchr( tmpStr2, ',' );
				               if( !p )
				               {
					               /* error, abort! */
					               g_print( "wrong diff output\n" );
					               gI_error_dialog( _("Wrong diff output") );
					               return -1;
				               }
				               *p = '\0';
				               p++;
				               f2_nol = atol( p );
				               f2_start = atol( tmpStr2+1 );

				               f1_line = f1_start;
				               f2_line = f2_start;
			               }
		               }
	               }

	               if( pclose( fp ) == -1 )
	               {
		               /* couldnt execute diff */
		               g_print( "Unable to execute diff\n" );
		               gI_error_dialog( _("Unable to execute diff") );
		               return -1;
	               }

	               /* show window and all childs */
	               gtk_widget_show_all( win );

	               return 1;
               }



               void tools_word_count( GtkWidget *widget, gpointer data )
               {
	               gI_document *current;
	               gchar *c;
	               gint in_word = 0;
	               glong words = 0;
	               glong chars = 0;
	               glong chars_non_space = 0;
	               GtkWidget *dlg;
	               GtkWidget *label_words;
	               /*GtkWidget *label_chars;*/
	               GtkWidget *label_chars_non_space;
	               GtkWidget *button;
	               gchar *tmpString;
	               glong i;
	               glong length;

	               current = gI_document_get_current( main_window );
	               if( !current )
	               {
		               return;
	               }

	               length = gI_text_get_length(  current->text );
	               if( length == 0 )
	               {
		               return;
	               }

	               /* go thru document... */
	               for(i=1;i<=length;i++)
	               {
		               c = gtk_editable_get_chars( GTK_EDITABLE( current->text ), i-1, i );

		               /* Character/Word Counters */
		               chars++;
		               if( !isspace( *c ) )
		               {
			               chars_non_space++;

			               if( *c == ',' ||
			                       *c == ';' ||
			                       *c == ':' ||
			                       *c == '.' )
			               {
				               if( in_word )
				               {
					               in_word = 0;
				               }
			               }
			               else
			               {
				               if( !in_word )
				               {
					               in_word = 1;
					               words++;
				               }

			               }
		               }
		               else
		               {
			               if( in_word )
			               {
				               in_word = 0;
			               }
		               }

		               g_free( c );

	               }

	               /* Dialog */
	               dlg = gtk_dialog_new();
	               gtk_window_set_title( &(GTK_DIALOG( dlg )->window), _("Tools - Word Count") );
	               gtk_container_set_border_width( GTK_CONTAINER( GTK_DIALOG( dlg )->vbox ), 10 );
	               gtk_window_set_modal( &(GTK_DIALOG( dlg )->window), TRUE );
	               gtk_window_set_position( &(GTK_DIALOG( dlg )->window), GTK_WIN_POS_MOUSE );

	               tmpString = g_strdup_printf( _("Words: %ld"), words );
	               label_words = gtk_label_new( tmpString );
	               g_free( tmpString );
	               gtk_box_pack_start( GTK_BOX( GTK_DIALOG( dlg )->vbox ), label_words, FALSE, TRUE, 5 );

	               tmpString = g_strdup_printf( _("Non-Space Characters: %ld"), chars_non_space );
	               label_chars_non_space = gtk_label_new( tmpString );
	               g_free( tmpString );
	               gtk_box_pack_start( GTK_BOX( GTK_DIALOG( dlg )->vbox ), label_chars_non_space, FALSE, TRUE, 5 );

	               /*tmpString = g_strdup_printf( _("Characters: %ld"), chars );
	               label_chars = gtk_label_new( tmpString );
	               g_free( tmpString );
	               gtk_box_pack_start( GTK_BOX( dlg->vbox ), label_chars, TRUE, TRUE, 5 );*/

	               button = gnome_stock_button( GNOME_STOCK_BUTTON_OK );
	               gtk_signal_connect_object( GTK_OBJECT( button ), "clicked",
	                                          GTK_SIGNAL_FUNC( gtk_widget_destroy ), GTK_OBJECT( dlg ) );
	               gtk_container_add( GTK_CONTAINER( GTK_DIALOG( dlg )->action_area ), button );

	               gtk_widget_show_all( dlg );
               }

