/* giFTui
 * Copyright (C) 2003 the giFTui team
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef __UI_CONF_H__
#define __UI_CONF_H__

#include <gtk/gtk.h>

#include "ui_child.h"

/*
  GiftuiChild
      +----GiftuiChildPref
*/

#define GIFTUI_TYPE_PREF (giftui_pref_get_type ())
#define GIFTUI_PREF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GIFTUI_TYPE_PREF, GiftuiPref))
#define GIFTUI_PREF_CLASS(class) (G_TYPE_CHECK_CLASS_CAST ((class), GIFTUI_TYPE_PREF, GiftuiPrefClass))
#define GIFTUI_IS_PREF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GIFTUI_TYPE_PREF))
#define GIFTUI_IS_PREF_CLASS(class) (G_TYPE_CHECK_CLASS_TYPE ((class), GIFTUI_TYPE_PREF))
#define GIFTUI_PREF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GIFTUI_TYPE_PREF, GiftuiPrefClass))

typedef struct _GiftuiPref GiftuiPref;
typedef struct _GiftuiPrefClass GiftuiPrefClass;

struct _GiftuiPref
{
	GiftuiChild parent_instance;
	
	/* < private_data > */
	gboolean resyncing : 1;
	GtkWidget *lblSync;
	GtkWidget *shsShow, *shsHide;
	
	/* giFT */
	GtkWidget *txtHost, *txtPort;
	GtkWidget *cbLaunch, *omKill;
	
	/* giFTui */
	GtkWidget *chcomplete, *chcancel;
	
	GdkColor colors[4];
	GtkWidget *wcolors[4];
};

struct _GiftuiPrefClass
{
	GiftuiChildClass parent_class;
};

GType giftui_pref_get_type (void);
GtkWidget *giftui_pref_new (void);

#endif
