/*
 * GImageView
 * Copyright (C) 2001 Takuro Ashie
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdio.h>

#include "gimageview.h"
#include "text_viewer.h"


static void
cb_text_viewer_destroy (GtkWidget *widget, TextViewer *text_viewer)
{
   g_return_if_fail (text_viewer);

   if (text_viewer->filename)
      g_free (text_viewer->filename);

   g_free (text_viewer);
}


gboolean
text_viewer_load_file (TextViewer *text_viewer, gchar *filename)
{
   FILE *textfile;
   gchar *tmpstr;
   gchar buf[BUF_SIZE];
   GtkText *text;
   GdkFont *font;

   g_return_val_if_fail (text_viewer && filename, FALSE);

   text = GTK_TEXT (text_viewer->textbox);

   if (text_viewer->filename) {
      gtk_text_backward_delete (text, gtk_text_get_length(text));
      g_free (text_viewer->filename);
      text_viewer->filename = NULL;
   }

   textfile = fopen (filename, "r");
   if (!textfile) {
      g_warning (_("Can't open text file: %s\n"), filename);
      return FALSE;
   }

   /* FIXME!! */
   font = gdk_fontset_load ("-alias-fixed-medium-r-normal--14-*-*-*-*-*-*-*");

   gtk_text_freeze (text);
   while (fgets (buf, sizeof(buf), textfile)) {
      gtk_text_insert (text, font, NULL, NULL, buf, -1);
   }
   gtk_text_thaw (text);

   fclose (textfile);

   tmpstr = g_strconcat (_("File Name: "), filename, NULL);
   gtk_statusbar_push(GTK_STATUSBAR (text_viewer->statusbar), 1, tmpstr);
   g_free (tmpstr);

   text_viewer->filename = g_strdup (filename);

   gdk_font_unref (font);

   return TRUE;
}


TextViewer *
text_viewer_create (gchar *filename)
{
   TextViewer *text_viewer;
   GtkWidget *window, *vbox;
   GtkWidget *scrolledwin, *text;
   GtkWidget *statusbar;

   text_viewer = g_new0 (TextViewer, 1);
   text_viewer->filename = NULL;

   /* window */
   text_viewer->window = window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
   gtk_window_set_title (GTK_WINDOW (window), PROG_NAME" -Text Viewer-");
   gtk_window_set_default_size (GTK_WINDOW(window), 600, 500);
   gtk_widget_show (window);
   gtk_signal_connect (GTK_OBJECT (window), "destroy",
		       GTK_SIGNAL_FUNC (cb_text_viewer_destroy), text_viewer);

   /* main vbox */
   vbox = gtk_vbox_new (FALSE, 0);
   gtk_container_add (GTK_CONTAINER (window), vbox);
   gtk_widget_show (vbox);

   /* text box */
   scrolledwin = gtk_scrolled_window_new (NULL, NULL);
   gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW(scrolledwin),
				   GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);
   gtk_box_pack_start (GTK_BOX (vbox), scrolledwin, TRUE, TRUE, 0);
   gtk_widget_show (scrolledwin);

   text = gtk_text_new (gtk_scrolled_window_get_hadjustment
			(GTK_SCROLLED_WINDOW (scrolledwin)),
			gtk_scrolled_window_get_vadjustment
			(GTK_SCROLLED_WINDOW (scrolledwin)));
   text_viewer->textbox = text;
   gtk_container_add (GTK_CONTAINER (scrolledwin), text);
   gtk_widget_show (text);

   /* statusbar */
   text_viewer->statusbar = statusbar = gtk_statusbar_new ();
   gtk_container_border_width (GTK_CONTAINER (statusbar), 1);
   gtk_box_pack_start (GTK_BOX (vbox), statusbar, FALSE, TRUE, 0);
   gtk_statusbar_push(GTK_STATUSBAR (statusbar), 1, "New Window");
   gtk_widget_show (statusbar);

   /* set text from file */
   if (filename)
      text_viewer_load_file (text_viewer, filename);

   return text_viewer;
}
