/*
   Copyright (c) 2004, 2005 by AOSASA Shigeru and Red Hat, Inc.
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are
   met:

   - Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.

   - Redistributions in binary form must reproduce the above
   copyright notice, this list of conditions and the following
   disclaimer in the documentation and/or other materials provided
   with the distribution.  

   - Neither the name of the AOSASA Shigeru, Red Hat, Inc
   nor the names of its contributors may be used to endorse or
   promote products derived from this software without specific
   prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
   COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
   INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
   (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
   SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
   STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
   OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*
   This software development was supported by
   Information-technorogy Promotion Agency, Japan (IPA).
*/

#include "ginspector-builtin.h"

#include "ginspector-core.h"
#include "ginspector-gtk.h"
#include "ginspector-ui.h"

#include "gtktreecontainer.h"

#include "glrr-glib.h"
#include "glrr-gobject.h"
#include "glrr-gtk.h"



static void builtin_module_init (void);

static gpointer create_panel (gpointer data,
			      gpointer func_data,
			      gpointer invoke_data);



void
g_inspector_builtin_register_module_panel_enum_class (void)
{
  {
    static GInspectorBuiltinModuleInfo builtin_module_info;

    builtin_module_info.name       = "builtin-panel-enum-class";
    builtin_module_info.data       = NULL;
    builtin_module_info.init       = builtin_module_init;
    builtin_module_info.activate   = NULL;
    builtin_module_info.deactivate = NULL;

    g_inspector_builtin_register_module (&builtin_module_info);
  }
}

static void
builtin_module_init (void)
{
  g_inspector_register_procedure ("create-panel-enum-value-list",
				  "",
				  G_INSPECTOR_PROCEDURE_TYPE_PANEL,
				  G_INSPECTOR_ELEMENT_TYPE_GTYPECLASS,
				  G_TYPE_ENUM,
				  create_panel,
				  NULL);
  g_inspector_register_procedure ("create-panel-flags-value-list",
				  "",
				  G_INSPECTOR_PROCEDURE_TYPE_PANEL,
				  G_INSPECTOR_ELEMENT_TYPE_GTYPECLASS,
				  G_TYPE_ENUM,
				  create_panel,
				  NULL);
}



/*
 *
 */



enum
{
  COLUMN_0,

  COLUMN_VALUE,
  COLUMN_NAME,
  COLUMN_NICK,

  NUM_COLUMNS
};

static GInspectorElementListColumnInfo columns_enum[NUM_COLUMNS] =
{
  G_INSPECTOR_ELEMENT_LIST_COLUMN_INFO_0,

  { COLUMN_VALUE,	  "Value",		"gint",		"text" },
  { COLUMN_NAME,	  "Name",		"gchararray",	"text" },
  { COLUMN_NICK,	  "Nick",		"gchararray",	"text" },
};

static GInspectorElementListColumnInfo columns_flags[NUM_COLUMNS] =
{
  G_INSPECTOR_ELEMENT_LIST_COLUMN_INFO_0,

  { COLUMN_VALUE,	  "Value",		"guint",	"text" },
  { COLUMN_NAME,	  "Name",		"gchararray",	"text" },
  { COLUMN_NICK,	  "Nick",		"gchararray",	"text" },
};


static void
append_row_enum (GtkListStore *list_store,
		 GEnumValue   *enum_value)
{
  GtkTreeIter tree_iter;
  
  gtk_list_store_append (list_store, &tree_iter);

  g_inspector_element_list_set_row_element (list_store, &tree_iter,
					    G_INSPECTOR_ELEMENT_TYPE_MISC,
					    enum_value);

  gtk_list_store_set (list_store, &tree_iter,
		      COLUMN_VALUE, enum_value->value,
		      COLUMN_NAME,  enum_value->value_name,
		      COLUMN_NICK,  enum_value->value_nick,
		      -1);
}

static void
append_row_flags (GtkListStore *list_store,
		  GFlagsValue   *flags_value)
{
  GtkTreeIter tree_iter;
  
  gtk_list_store_append (list_store, &tree_iter);

  g_inspector_element_list_set_row_element (list_store, &tree_iter,
					    G_INSPECTOR_ELEMENT_TYPE_MISC,
					    flags_value);

  gtk_list_store_set (list_store, &tree_iter,
		      COLUMN_VALUE, flags_value->value,
		      COLUMN_NAME,  flags_value->value_name,
		      COLUMN_NICK,  flags_value->value_nick,
		      -1);
}

static void
create_list_enum (GtkListStore *list_store,
		  GType         enum_type)
{
  GEnumClass *enum_class;
  GEnumValue *enum_values;
  guint       n_enum_values;
  gchar      *name;
  guint i;

  
  g_return_if_fail (G_TYPE_IS_ENUM (enum_type));


  enum_class = g_type_class_ref (enum_type);

  enum_values   = enum_class->values;
  n_enum_values = enum_class->n_values;


  for (i = 0; i < n_enum_values; ++i)
    {
      append_row_enum (list_store,
		       &(enum_values[i]));
    }

  g_type_class_unref (enum_class);
}

static void
create_list_flags (GtkListStore *list_store,
		  GType         flags_type)
{
  GFlagsClass *flags_class;
  GFlagsValue *flags_values;
  guint       n_flags_values;
  gchar      *name;
  guint i;

  
  g_return_if_fail (G_TYPE_IS_FLAGS (flags_type));


  flags_class = g_type_class_ref (flags_type);

  flags_values   = flags_class->values;
  n_flags_values = flags_class->n_values;


  for (i = 0; i < n_flags_values; ++i)
    {
      append_row_flags (list_store,
			&(flags_values[i]));
    }

  g_type_class_unref (flags_class);
}

static void
update (GInspectorElementList *element_list,
	gpointer               user_data)
{
  GInspectorPanel *panel;
  GType type;
  GtkListStore *list_store;

  panel = G_INSPECTOR_PANEL (user_data);

  type = GPOINTER_TO_TYPE (panel->element);
  list_store = GTK_LIST_STORE (gtk_tree_view_get_model (GTK_TREE_VIEW (element_list)));

  gtk_list_store_clear (list_store);

  if (G_TYPE_IS_ENUM (type))
    {
      create_list_enum (list_store, type);
    }
  else /* G_TYPE_IS_FLAGS (type) */
    {
      create_list_flags (list_store, type);
    }
}

static gpointer
create_panel (gpointer data,
	      gpointer func_data,
	      gpointer invoke_data)
{
  GType type;

  GtkWidget *top;
  GtkWidget *panel;
  GtkWidget *frame;
  GtkWidget *scrolled_window;
  GtkWidget *element_list;

  type = GPOINTER_TO_TYPE (data);


  {
    panel = g_object_new (G_TYPE_INSPECTOR_PANEL,
			  NULL);
    G_INSPECTOR_PANEL (panel)->element_type = G_INSPECTOR_ELEMENT_TYPE_GTYPECLASS;
    G_INSPECTOR_PANEL (panel)->element = GTYPE_TO_POINTER (type);
    top = panel;
  }

  {
    frame = g_inspector_panel_frame_new ();
    g_inspector_panel_frame_set_title (G_INSPECTOR_PANEL_FRAME (frame), "GEnum Values");
    gtk_container_add (GTK_CONTAINER (panel), frame);
  }

  {
    scrolled_window = gtk_scrolled_window_new (NULL, NULL);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window),
				    GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

    gtk_container_add (GTK_CONTAINER (frame), scrolled_window);
  }

  {
    if (G_TYPE_IS_ENUM (type))
      {
	element_list = g_inspector_element_list_new (columns_enum,
						     G_N_ELEMENTS (columns_enum));
      }
    else /* G_TYPE_IS_FLAGS (type) */
      {
	element_list = g_inspector_element_list_new (columns_flags,
						     G_N_ELEMENTS (columns_flags));
      }

    g_signal_connect (element_list,
		      "update",
		      G_CALLBACK (update),
		      panel);

    gtk_container_add (GTK_CONTAINER (scrolled_window),
		       element_list);

    g_inspector_panel_attach_element_list (G_INSPECTOR_PANEL (panel),
					   G_INSPECTOR_ELEMENT_LIST (element_list));
  }


  g_inspector_panel_update (G_INSPECTOR_PANEL (panel));


  return top;
}



