/*
   Copyright (c) 2004, 2005 by AOSASA Shigeru and Red Hat, Inc.
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are
   met:

   - Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.

   - Redistributions in binary form must reproduce the above
   copyright notice, this list of conditions and the following
   disclaimer in the documentation and/or other materials provided
   with the distribution.  

   - Neither the name of the AOSASA Shigeru, Red Hat, Inc
   nor the names of its contributors may be used to endorse or
   promote products derived from this software without specific
   prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
   COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
   INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
   (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
   SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
   STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
   OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*
   This software development was supported by
   Information-technorogy Promotion Agency, Japan (IPA).
*/

#include "ginspectorelementlist.h"

#include "ginspector-core.h"
#include "ginspector-gtk.h"

#include "ginspector-ui-cellrenderer.h"
#include "ginspector-ui-dnd.h"

#include "glrr-gobject.h"



enum {
  UPDATE,
  LAST_SIGNAL
};

enum {
  PROP_0,
  PROP_VALUE,
};


static void g_inspector_element_list_set_property (GObject      *object,
						   guint         prop_id,
						   const GValue *value,
						   GParamSpec   *pspec);
static void g_inspector_element_list_get_property (GObject      *object,
						   guint         prop_id,
						   GValue       *value,
						   GParamSpec   *pspec);

static gboolean g_inspector_element_list_button_press       (GtkWidget         *widget,
							     GdkEventButton    *event);
static void     g_inspector_element_list_row_activated      (GtkTreeView       *tree_view,
							     GtkTreePath       *path,
							     GtkTreeViewColumn *column);

static void     g_inspector_element_list_drag_begin         (GtkWidget	      *widget,
							     GdkDragContext   *context);
static void     g_inspector_element_list_drag_end           (GtkWidget	      *widget,
							     GdkDragContext   *context);
static void     g_inspector_element_list_drag_data_get      (GtkWidget	      *widget,
							     GdkDragContext   *context,
							     GtkSelectionData *selection_data,
							     guint	       info,
							     guint	       time);
static void     g_inspector_element_list_drag_data_delete   (GtkWidget	      *widget,
							     GdkDragContext   *context);

static void     g_inspector_element_list_drag_leave         (GtkWidget        *widget,
							     GdkDragContext   *context,
							     guint             time);
static gboolean g_inspector_element_list_drag_motion        (GtkWidget        *widget,
							     GdkDragContext   *context,
							     gint              x,
							     gint              y,
							     guint             time);
static gboolean g_inspector_element_list_drag_drop          (GtkWidget        *widget,
							     GdkDragContext   *context,
							     gint              x,
							     gint              y,
							     guint             time);
static void     g_inspector_element_list_drag_data_received (GtkWidget        *widget,
							     GdkDragContext   *context,
							     gint              x,
							     gint              y,
							     GtkSelectionData *data,
							     guint             info,
							     guint             time);

static gint g_inspector_element_list_compare_func (GtkTreeModel *model,
						   GtkTreeIter  *a,
						   GtkTreeIter  *b,
						   gpointer      user_data);




static guint inspector_element_list_signals[LAST_SIGNAL] = { 0 };


G_DEFINE_TYPE (GInspectorElementList, g_inspector_element_list, GTK_TYPE_TREE_VIEW);


static void
g_inspector_element_list_class_init (GInspectorElementListClass *klass)
{
  GObjectClass *gobject_class;
  GtkWidgetClass *widget_class;
  GtkTreeViewClass *tree_view_class;
  GInspectorElementListClass *inspector_element_list_class;

  gobject_class = G_OBJECT_CLASS (klass);
  widget_class = (GtkWidgetClass*) klass;
  tree_view_class = (GtkTreeViewClass*) klass;
  inspector_element_list_class = (GInspectorElementListClass*) klass;

  gobject_class->set_property = g_inspector_element_list_set_property;
  gobject_class->get_property = g_inspector_element_list_get_property;


  widget_class->button_press_event = g_inspector_element_list_button_press;
  widget_class->drag_begin = g_inspector_element_list_drag_begin;
  widget_class->drag_end = g_inspector_element_list_drag_end;
  widget_class->drag_data_get = g_inspector_element_list_drag_data_get;
  widget_class->drag_data_delete = g_inspector_element_list_drag_data_delete;
  widget_class->drag_leave = g_inspector_element_list_drag_leave;
  widget_class->drag_motion = g_inspector_element_list_drag_motion;
  widget_class->drag_drop = g_inspector_element_list_drag_drop;
  widget_class->drag_data_received = g_inspector_element_list_drag_data_received;


  inspector_element_list_signals[UPDATE] =
    g_signal_new ("update",
                  G_TYPE_FROM_CLASS (gobject_class),
                  G_SIGNAL_RUN_FIRST,
                  G_STRUCT_OFFSET (GInspectorElementListClass, update),
                  NULL, NULL,
                  g_cclosure_marshal_VOID__VOID,
                  G_TYPE_NONE, 0);
}

static void
g_inspector_element_list_init (GInspectorElementList *inspector_element_list)
{
  inspector_element_list->press_element = NULL;
  inspector_element_list->dnd_element = NULL;
}

static void
g_inspector_element_list_set_property (GObject      *object,
				       guint         prop_id,
				       const GValue *value,
				       GParamSpec   *pspec)
{
  switch (prop_id)
    {
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
      break;
    }
}

static void
g_inspector_element_list_get_property (GObject    *object,
				       guint       prop_id,
				       GValue     *value,
				       GParamSpec *pspec)
{
  switch (prop_id)
    {
    default:
      G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
      break;
    }
}

GtkWidget*
g_inspector_element_list_new (GInspectorElementListColumnInfo *columns,
			      gint                             n_columns)
{
  GInspectorElementList *element_list;

  g_return_val_if_fail (n_columns > 0, NULL);
  g_return_val_if_fail (columns != NULL, NULL);


  element_list = g_object_new (G_TYPE_INSPECTOR_ELEMENT_LIST,
			       NULL);


  {
    GtkListStore *list_store;
    GInspectorElementListColumnInfo *column_info;

    {
      GType *types;
      int i;

      types = g_new0 (GType, n_columns);

      for (i = 0; i < n_columns; ++i)
	{
	  column_info = &(columns[i]);

	  types[i] = g_type_from_name (column_info->gtype_name);
	}

      list_store = gtk_list_store_newv (n_columns, types);

      g_free (types);
    }

    {
      int i;
      GType type;

      for (i = 1; i < n_columns; ++i)
	{
	  column_info = &(columns[i]);

	  type = gtk_tree_model_get_column_type (GTK_TREE_MODEL (list_store),
						 i);

	  if (g_type_is_a (type, G_INSPECTOR_TYPE_GTYPE) ||
	      g_type_is_a (type, G_TYPE_POINTER))
	    {
	      gtk_tree_sortable_set_sort_func (GTK_TREE_SORTABLE (list_store),
					       i,
					       g_inspector_element_list_compare_func,
					       GINT_TO_POINTER (i),
					       NULL);
	    }
	}
    }

    gtk_tree_view_set_model (GTK_TREE_VIEW (element_list),
			     GTK_TREE_MODEL (list_store));

    g_object_unref (list_store);
  }

  {
    GtkCellRenderer *renderer;
    GtkTreeViewColumn *column;
    GInspectorElementListColumnInfo *column_info;
    int i;


    for (i = 1; i < n_columns; ++i)
      {
	column_info = &(columns[i]);


	if (g_type_is_a (g_type_from_name (column_info->gtype_name),
			 G_INSPECTOR_TYPE_STOCK_ID))
	  {
	    renderer = gtk_cell_renderer_pixbuf_new ();
	  }
	else
	  {  
	    renderer = g_inspector_cell_renderer_new ();
	  }

	column
	  = gtk_tree_view_column_new_with_attributes (column_info->title,
						      renderer,
						      column_info->attribute,
						      column_info->column,
						      NULL);
	gtk_tree_view_column_set_sort_column_id (column, column_info->column);

	gtk_tree_view_append_column (GTK_TREE_VIEW (element_list),
				     column);
      }
  }

  {
    g_inspector_dnd_drag_source_set (GTK_WIDGET (element_list),
				     GDK_BUTTON1_MASK,
				     (GDK_ACTION_COPY | GDK_ACTION_MOVE));

    g_inspector_dnd_drag_dest_set (GTK_WIDGET (element_list),
				   GTK_DEST_DEFAULT_ALL,
				   (GDK_ACTION_COPY | GDK_ACTION_MOVE));
  }


  return (GtkWidget *)element_list;
}



static gboolean
g_inspector_element_list_button_press (GtkWidget      *widget,
				       GdkEventButton *event)
{
  GInspectorElementList *element_list;
  GtkTreeViewColumn     *tree_view_column;
  GtkTreePath           *tree_path;
  gboolean r;

  element_list = G_INSPECTOR_ELEMENT_LIST (widget);


  r = gtk_tree_view_get_path_at_pos (GTK_TREE_VIEW (element_list),
                                     event->x,
				     event->y,
                                     &tree_path,
				     &tree_view_column,
				     NULL,
				     NULL);

  if (r == TRUE)
    {
      GtkTreeModel *tree_model;
      GtkTreeIter   tree_iter;
      GInspectorElementHolder *element_holder;

      tree_model = gtk_tree_view_get_model (GTK_TREE_VIEW (element_list));
      gtk_tree_model_get_iter (tree_model, &tree_iter, tree_path);


      gtk_tree_model_get (GTK_TREE_MODEL (tree_model),
			  &tree_iter,
			  G_INSPECTOR_ELEMENT_LIST_COLUMN_ELEMENT_HOLDER, &element_holder,
			  -1);

      if (event->button == 1)
	{
	  element_list->press_element = element_holder;
	}
      if (event->button == 3)
	{
	  if (element_holder != NULL)
	    {
	      g_inspector_invoke_procedure_by_name ("popup-menu-for-element",
						    element_holder,
						    event);
	    }
	}

      if (element_holder != NULL)
	{
	  g_object_unref (element_holder);
	}
    }

  GTK_WIDGET_CLASS (g_inspector_element_list_parent_class)->button_press_event (widget,
										event);

  return FALSE;
}

static void
g_inspector_element_list_drag_begin (GtkWidget      *widget,
				     GdkDragContext *context)
{
  g_print ("%s()\n", __FUNCTION__);


  {
    GInspectorElementList *element_list;
    gpointer dnd_element;

    element_list = G_INSPECTOR_ELEMENT_LIST (widget);


    dnd_element = element_list->press_element;
    element_list->dnd_element = dnd_element;


    g_inspector_dnd_set_drag_widget_element (context,
					     dnd_element);
  }
}

static void
g_inspector_element_list_drag_end (GtkWidget	  *widget,
				   GdkDragContext *context)
{
  g_print ("%s()\n", __FUNCTION__);


  {
    GInspectorElementList *element_list;

    element_list = G_INSPECTOR_ELEMENT_LIST (widget);


    element_list->dnd_element = NULL;
  }
}

static void  
g_inspector_element_list_drag_data_get (GtkWidget	 *widget,
					GdkDragContext   *context,
					GtkSelectionData *selection_data,
					guint		  info,
					guint		  time)
{
  g_print ("%s()\n", __FUNCTION__);

  {
    GInspectorElementList *element_list;
    gpointer dnd_element;

    element_list = G_INSPECTOR_ELEMENT_LIST (widget);


    dnd_element = element_list->dnd_element;


    g_inspector_dnd_selection_data_set_element (selection_data,
						dnd_element);
  }
}

static void  
g_inspector_element_list_drag_data_delete (GtkWidget	  *widget,
					   GdkDragContext *context)
{
  g_print ("%s()\n", __FUNCTION__);
}

static void  
g_inspector_element_list_drag_leave (GtkWidget      *widget,
				     GdkDragContext *context,
				     guint           time)
{
  g_print ("%s()\n", __FUNCTION__);
}

static gboolean
g_inspector_element_list_drag_motion (GtkWidget      *widget,
				      GdkDragContext *context,
				      gint            x,
				      gint            y,
				      guint           time)
{
  g_print ("%s()\n", __FUNCTION__);

  return FALSE;
}

static gboolean
g_inspector_element_list_drag_drop (GtkWidget      *widget,
				    GdkDragContext *context,
				    gint            x,
				    gint            y,
				    guint           time)
{
  g_print ("%s()\n", __FUNCTION__);

  return TRUE;
}

static void  
g_inspector_element_list_drag_data_received (GtkWidget        *widget,
					     GdkDragContext   *context,
					     gint              x,
					     gint              y,
					     GtkSelectionData *selection_data,
					     guint             info,
					     guint             time)
{
  g_print ("%s()\n", __FUNCTION__);

  {
    GInspectorElementHolder *element_holder;
    gpointer element;    

    element_holder = g_inspector_dnd_selection_data_get_element (selection_data);

    element = g_inspector_element_holder_get_element (element_holder);

    g_print ("received: %p\n", element);
  }

  {
    gtk_drag_finish (context, FALSE, FALSE, time);
  }
}

static gint
g_inspector_element_list_compare_func (GtkTreeModel *model,
				       GtkTreeIter  *a,
				       GtkTreeIter  *b,
				       gpointer      user_data)
{
  gint column;
  GType type;
  GValue a_value;
  GValue b_value;
  gint retval;


  column = GPOINTER_TO_INT (user_data);
  type = gtk_tree_model_get_column_type (model, column);

  g_value_fill0 (&a_value);
  g_value_fill0 (&b_value);

  gtk_tree_model_get_value (model, a, column, &a_value);
  gtk_tree_model_get_value (model, b, column, &b_value);


  if (0)
    {
    }
  else if (g_type_is_a (type, G_INSPECTOR_TYPE_GTYPE))
    {
      const gchar *a_name;
      const gchar *b_name;

      a_name = g_type_name (g_value_get_ulong (&a_value));
      b_name = g_type_name (g_value_get_ulong (&b_value));

      if (a_name == NULL)
	{
	  a_name = "";
	}
      if (b_name == NULL)
	{
	  b_name = "";
	}

      retval = g_utf8_collate (a_name, b_name);
    }
  else if (g_type_is_a (type, G_TYPE_POINTER))
    {
      gpointer a_p;
      gpointer b_p;

      a_p = g_value_get_pointer (&a_value);
      b_p = g_value_get_pointer (&b_value);

      if (a_p < b_p)
	{
	  retval = -1;
	}
      else if (a_p == b_p)
	{
	  retval = 0;
	}
      else /* (a_p > b_p) */
	{
	  retval = 1;
	}
    }
  else
    {
      /* g_assert_not_reached (); */
      retval = 0;
    }


  return retval;
}










void
g_inspector_element_list_update (GInspectorElementList *element_list)
{
  g_return_if_fail (element_list != NULL);
  g_return_if_fail (G_IS_INSPECTOR_ELEMENT_LIST (element_list));


  g_signal_emit (element_list, inspector_element_list_signals[UPDATE], 0);
}

void
g_inspector_element_list_set_row_element (GtkListStore          *list_store,
					  GtkTreeIter           *tree_iter,
					  GInspectorElementType  element_type,
					  gpointer               element)
{
  GInspectorElementHolder *element_holder;

  g_return_if_fail (list_store != NULL);
  g_return_if_fail (tree_iter != NULL);
  g_return_if_fail (GTK_IS_LIST_STORE (list_store));


  element_holder = g_inspector_element_holder_new ();
  
  g_inspector_element_holder_set (element_holder,
				  element_type,
				  element);

  gtk_list_store_set (list_store,
		      tree_iter,
		      G_INSPECTOR_ELEMENT_LIST_COLUMN_ELEMENT_HOLDER, element_holder,
		      -1);

  g_object_unref (element_holder);
}

gboolean
g_inspector_element_list_get_iter (GtkListStore          *list_store,
				   GtkTreeIter           *tree_iter,
				   GInspectorElementType  element_type,
				   gpointer               element)
{
  gboolean found;
  gboolean r;
  GtkTreeIter tmp_tree_iter;
  GInspectorElementHolder *tmp_element_holder;
  GInspectorElementType tmp_element_type;
  gpointer tmp_element;

  g_return_val_if_fail (list_store != NULL, FALSE);
  g_return_val_if_fail (tree_iter != NULL, FALSE);
  g_return_val_if_fail (GTK_IS_LIST_STORE (list_store), FALSE);


  found = FALSE;


  r = gtk_tree_model_get_iter_first (GTK_TREE_MODEL (list_store),
				     &tmp_tree_iter);
  while (r == TRUE)
    {
      gtk_tree_model_get (GTK_TREE_MODEL (list_store),
			  &tmp_tree_iter,
			  G_INSPECTOR_ELEMENT_LIST_COLUMN_ELEMENT_HOLDER, &tmp_element_holder,
			  -1);

      tmp_element_type = g_inspector_element_holder_get_element_type (tmp_element_holder);
      tmp_element      = g_inspector_element_holder_get_element      (tmp_element_holder);

      g_object_unref (tmp_element_holder);


      if ((tmp_element_type == element_type) &&
	  (tmp_element      == element))
	{
	  found = TRUE;
	  break;
	}

      r = gtk_tree_model_iter_next (GTK_TREE_MODEL (list_store),
				    &tmp_tree_iter);
    }

  if (found == TRUE)
    {
      /* XXX */
      tree_iter->stamp      = tmp_tree_iter.stamp;
      tree_iter->user_data  = tmp_tree_iter.user_data;
      tree_iter->user_data2 = tmp_tree_iter.user_data2;
      tree_iter->user_data3 = tmp_tree_iter.user_data3;
    }
  else
    {
      /* XXX */
      tree_iter->stamp      = 0;
      tree_iter->user_data  = NULL;
      tree_iter->user_data2 = NULL;
      tree_iter->user_data3 = NULL;
    }

  return found;
}
