#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <dirent.h>
#include <gtk/gtk.h>

#include "../config.h"

#include "defines.h"
#include "actions.h"
#include "add.h"
#include "remove.h"
#include "gui.h"
#include "conf.h"

#ifdef HAVE_GNOME
int is_applet;
#endif

/*
  Handlers for the gtk widgets
*/
GtkWidget *main_window;

/* combo box */
GtkWidget *main_combo;

/* 
   The connect and disconnect buttons are replaced by
   each other as the connection status changes
*/
GtkWidget *button_connect,
  *button_disconnect,
  *button_add, 
  *button_remove, 
  *button_quit;

/* 
   this is the context used to manage the statusbar
*/
GtkWidget *statusbar;
guint context;

/*
  This are here cause they're used by many controling functions
*/
GtkWidget *pixmap;
/* pixmaps */
GdkPixmap *on, 
  *off,
  *waiting;
GdkBitmap *mask;
GtkStyle *style;

/* displays connection time */
GtkWidget *t_frame;
GtkWidget *t_label;

/* in/out */
GtkWidget *in_frame;
GtkWidget *in_label;
GtkWidget *in_table;
GtkWidget *in_pix;

GtkWidget *out_frame;
GtkWidget *out_label;
GtkWidget *out_table;
GtkWidget *out_pix;

GdkPixmap *in_out_on, *in_out_off;
GdkBitmap *in_out_mask;

/***************************************************************/
/* This file is to manage windows and other gui-related stuff  */
/***************************************************************/
/*************************
  Creates the main window 
**************************/
void create_main_window ()
{
  GtkWidget *main_frame;
  GtkWidget *table_main;

  /* Menus */
  GtkWidget *menubar;
  GtkWidget *menu_file,
    *file_main,
    *file_quit;
  GtkWidget *menu_prefs,
    *prefs_main,
    *prefs_connect_cmd,
    *prefs_disconnect_cmd,
    *prefs_modem,
    *prefs_lock;
  GtkWidget *menu_help,
    *help_main,
    *help_about;

  /* Window Definition */
  main_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW(main_window), gk_dial_version);
#ifdef HAVE_GNOME
  if (is_applet)
    gtk_signal_connect_object (GTK_OBJECT(main_window), "delete_event",
			       GTK_SIGNAL_FUNC(gtk_widget_hide),
			       GTK_OBJECT(main_window));
  else
#endif
    gtk_signal_connect (GTK_OBJECT(main_window), "delete_event",
			GTK_SIGNAL_FUNC(delete_event), NULL);
  gtk_container_border_width (GTK_CONTAINER(main_window), 1);
    

  /* Frame Definition */
  main_frame = gtk_frame_new (NULL);
  gtk_container_border_width (GTK_CONTAINER(main_frame), 2);
  gtk_frame_set_label_align (GTK_FRAME(main_frame), 0.0, 0.0);
  gtk_widget_show(main_frame);

  /* Menu Bar */
  menubar = gtk_menu_bar_new ();
  gtk_widget_show(menubar);
  /* File Menu */
  menu_file = gtk_menu_new ();
  file_main = gtk_menu_item_new_with_label (_("File"));
  gtk_menu_item_set_submenu (GTK_MENU_ITEM(file_main), menu_file);
  gtk_menu_bar_append (GTK_MENU_BAR(menubar), file_main);
  gtk_widget_show (file_main);
  /* File Menu Itens */
  file_quit = gtk_menu_item_new_with_label (_("Quit"));
#ifdef HAVE_GNOME
  if (is_applet)
    gtk_signal_connect_object (GTK_OBJECT(file_quit), "activate",
			       GTK_SIGNAL_FUNC(gtk_widget_hide),
			       GTK_OBJECT(main_window));
  else
#endif
    gtk_signal_connect (GTK_OBJECT(file_quit), "activate",
			GTK_SIGNAL_FUNC(delete_event), NULL);
  gtk_menu_append(GTK_MENU(menu_file), file_quit);
  gtk_widget_show (file_quit);
  /* Preferences Menu */
  menu_prefs = gtk_menu_new ();
  prefs_main = gtk_menu_item_new_with_label (_("Preferences"));
  gtk_menu_item_set_submenu (GTK_MENU_ITEM(prefs_main), menu_prefs);
  gtk_menu_bar_append (GTK_MENU_BAR(menubar), prefs_main);
  gtk_widget_show (prefs_main);
  /* Preferences Menu Items */
  prefs_connect_cmd = gtk_menu_item_new_with_label (_("Connect command..."));
  gtk_menu_append (GTK_MENU(menu_prefs), prefs_connect_cmd);
  gtk_signal_connect (GTK_OBJECT(prefs_connect_cmd), "activate",
		      GTK_SIGNAL_FUNC(configure_prefs), "connect_cmd");
  gtk_widget_show (prefs_connect_cmd);

  prefs_disconnect_cmd = gtk_menu_item_new_with_label (_("Disconnect command..."));
  gtk_menu_append (GTK_MENU(menu_prefs), prefs_disconnect_cmd);
  gtk_signal_connect (GTK_OBJECT(prefs_disconnect_cmd), "activate",
		      GTK_SIGNAL_FUNC(configure_prefs), "disconnect_cmd");
  gtk_widget_show (prefs_disconnect_cmd);

  prefs_modem = gtk_menu_item_new_with_label (_("Modem device..."));
  gtk_menu_append (GTK_MENU(menu_prefs), prefs_modem);
  gtk_signal_connect (GTK_OBJECT(prefs_modem), "activate",
		      GTK_SIGNAL_FUNC(configure_prefs), "modem");
  gtk_widget_show (prefs_modem);

  prefs_lock = gtk_menu_item_new_with_label (_("Lock file to monitor..."));
  gtk_menu_append (GTK_MENU(menu_prefs), prefs_lock);
  gtk_signal_connect (GTK_OBJECT(prefs_lock), "activate",
		      GTK_SIGNAL_FUNC(configure_prefs), "lock");
  gtk_widget_show (prefs_lock);
  /* Help Menu */
  menu_help = gtk_menu_new ();
  help_main = gtk_menu_item_new_with_label (_("Help"));
  gtk_menu_item_set_submenu (GTK_MENU_ITEM(help_main), menu_help);
  gtk_menu_item_right_justify (GTK_MENU_ITEM(help_main));
  gtk_menu_bar_append (GTK_MENU_BAR(menubar), help_main);
  gtk_widget_show (help_main);
  /* Help Items */
  help_about = gtk_menu_item_new_with_label (_("About"));
  gtk_menu_append (GTK_MENU(menu_help), help_about);
  gtk_signal_connect (GTK_OBJECT(help_about), "activate",
		      GTK_SIGNAL_FUNC(gkdial_about), VERSION);
  gtk_widget_show (help_about);


  /* Combo Box Definition */
  main_combo = gtk_combo_new ();
  gtk_entry_set_editable (GTK_ENTRY(GTK_COMBO(main_combo)->entry), FALSE);
  gtk_combo_set_use_arrows_always (GTK_COMBO(main_combo), TRUE);
  gtk_widget_show(main_combo);

  /* Buttons Definition */
  /* connect */
  button_connect = gtk_button_new_with_label (_("Connect!"));
  gtk_signal_connect (GTK_OBJECT(button_connect), "clicked",
		      GTK_SIGNAL_FUNC(gk_connect), main_combo);
  gtk_widget_show(button_connect);

  /* disconnect */
  button_disconnect = gtk_button_new_with_label (_("Disconnect!"));
  gtk_signal_connect (GTK_OBJECT(button_disconnect), "clicked",
		      GTK_SIGNAL_FUNC(gk_disconnect), NULL);

  /* remove */
  button_remove = gtk_button_new_with_label (_("Remove"));
  gtk_signal_connect (GTK_OBJECT(button_remove), "clicked",
		      GTK_SIGNAL_FUNC(remove_callback), main_combo);
  gtk_widget_show(button_remove);

  /* add */
  button_add = gtk_button_new_with_label (_("Add"));
  gtk_signal_connect (GTK_OBJECT(button_add), "clicked",
		      GTK_SIGNAL_FUNC(create_add_window), main_combo);
  gtk_widget_show(button_add);

  /* quit */
  button_quit = gtk_button_new_with_label (_("Quit"));
#ifdef HAVE_GNOME
  if (is_applet)
    gtk_signal_connect_object (GTK_OBJECT(button_quit), "clicked",
			       GTK_SIGNAL_FUNC(gtk_widget_hide),
			       GTK_OBJECT(main_window));
  else
#endif
    gtk_signal_connect (GTK_OBJECT(button_quit), "clicked",
			GTK_SIGNAL_FUNC(delete_event), NULL);
  gtk_widget_show(button_quit);
  
  /* Status Bar */
  statusbar = gtk_statusbar_new ();
  context = gtk_statusbar_get_context_id (GTK_STATUSBAR (statusbar),
					  "GK Dial");
  gtk_statusbar_push (GTK_STATUSBAR(statusbar), context,
		      _(" GKDial started..."));
  gtk_widget_show (statusbar);

  /* Pixmaps */
  style = gtk_widget_get_style (main_window);
  /* on */
  on = create_gkdial_image (main_window, "on.xpm", mask);
  /* off */
  off = create_gkdial_image (main_window, "off.xpm", mask);
  /* while waiting for connection to complete */
  waiting = create_gkdial_image (main_window, "waiting.xpm", mask);

  pixmap = gtk_pixmap_new (off, mask);

  /* showing off only */
  gtk_widget_show (pixmap);

  /* Time label */
  t_label = gtk_label_new (_("Time: 00:00:00"));
  gtk_widget_show (t_label);

  t_frame = gtk_frame_new (NULL);
  gtk_container_set_border_width (GTK_CONTAINER(t_frame), 3);
  gtk_container_add (GTK_CONTAINER(t_frame), t_label);
  gtk_widget_show (t_frame);

  /* in/out Pixmaps */
  /* on */
  in_out_on = create_gkdial_image (main_window, "in_out_on.xpm", in_out_mask);
  /* off */
  in_out_off = create_gkdial_image (main_window, "in_out_off.xpm", in_out_mask);
  /* in/out */
  in_label = gtk_label_new (_("In"));
  gtk_widget_show (in_label);

  in_pix = gtk_pixmap_new (in_out_off, in_out_mask);
  gtk_widget_show (in_pix);

  in_table = gtk_table_new (1, 2, FALSE);
  gtk_table_attach_defaults (GTK_TABLE(in_table), in_label,
			     0, 1, 0, 1);
  gtk_table_attach_defaults (GTK_TABLE(in_table), in_pix,
			     1, 2, 0, 1);
  gtk_widget_show (in_table);

  in_frame = gtk_frame_new (NULL);
  gtk_container_set_border_width (GTK_CONTAINER(in_frame), 3);
  gtk_container_add (GTK_CONTAINER(in_frame), in_table);
  gtk_widget_show (in_frame);

  out_label = gtk_label_new (_("Out"));
  gtk_widget_show (out_label);

  out_pix = gtk_pixmap_new (in_out_off, in_out_mask);
  gtk_widget_show (out_pix);

  out_table = gtk_table_new (1, 2, FALSE);
  gtk_table_attach_defaults (GTK_TABLE(out_table), out_label,
			     0, 1, 0, 1);
  gtk_table_attach_defaults (GTK_TABLE(out_table), out_pix,
			     1, 2, 0, 1);
  gtk_widget_show (out_table);

  out_frame = gtk_frame_new (NULL);
  gtk_container_set_border_width (GTK_CONTAINER(out_frame), 3);
  gtk_container_add (GTK_CONTAINER(out_frame), out_table);
  gtk_widget_show (out_frame);

  /* Table Definition */
  table_main = gtk_table_new (5, 3, TRUE);
  gtk_widget_show(table_main);

  /* Putting widgets in the table */    
  /* Menu */
  gtk_table_attach (GTK_TABLE(table_main), menubar, 0, 3, 0, 1,
		    GTK_FILL, GTK_EXPAND, 1, 1);

  /* Combo Box */    
  gtk_table_attach (GTK_TABLE(table_main), main_combo, 0, 2, 1, 2, 
		    GTK_FILL, GTK_EXPAND, 2, 2);
  /* Buttons */
  gtk_table_attach (GTK_TABLE(table_main), button_connect, 2, 3, 1, 2, 
		    GTK_FILL, GTK_EXPAND, 2, 2);

  gtk_table_attach (GTK_TABLE(table_main), button_disconnect, 2, 3, 1, 2, 
		    GTK_FILL, GTK_EXPAND, 2, 2);

  gtk_table_attach (GTK_TABLE(table_main), button_add, 0, 1, 2, 3, 
		    GTK_FILL, GTK_EXPAND, 2, 2);

  gtk_table_attach (GTK_TABLE(table_main), button_remove, 1, 2, 2, 3, 
		    GTK_FILL, GTK_EXPAND, 2, 2);

  gtk_table_attach (GTK_TABLE(table_main), button_quit, 2, 3, 2, 3, 
		    GTK_FILL, GTK_EXPAND, 2, 2);

  /* Status bar */
  gtk_table_attach (GTK_TABLE(table_main), statusbar, 0, 2, 3, 4, 
		    GTK_FILL, GTK_EXPAND, 1, 1);

  /* Pixmap */
  gtk_table_attach (GTK_TABLE(table_main), pixmap, 2, 3, 3, 4, 
		    GTK_FILL, GTK_EXPAND, 2, 2);

  /* in/out label (frame) */
  gtk_table_attach (GTK_TABLE(table_main), in_frame, 0, 1, 4, 5,
		    GTK_FILL, GTK_EXPAND, 1, 1);
  gtk_table_attach (GTK_TABLE(table_main), out_frame, 1, 2, 4, 5,
		    GTK_FILL, GTK_EXPAND, 1, 1);

  /* time label (frame) */
  gtk_table_attach (GTK_TABLE(table_main), t_frame, 2, 3, 4, 5,
		    GTK_FILL, GTK_EXPAND, 1, 1);

  /* Showing th Main Window */
  gtk_container_add (GTK_CONTAINER(main_frame), table_main);
  gtk_container_add (GTK_CONTAINER(main_window), main_frame);

#ifdef HAVE_GNOME
  if (!is_applet)
#endif
    gtk_widget_show(main_window);
}

/* 
   Creates add window
*/
void create_add_window (GtkWidget *w, gpointer data)
{
  GtkWidget *window_conf;

  GtkWidget *frame_conf;

  GtkWidget *button_ok_conf, 
    *button_cancel_conf;

  GtkWidget *label_name_conf,
    *label_phone_conf,
    *label_username_conf,
    *label_password_conf,
    *label_c_type_conf;

  GList		*types_list = NULL;

  GtkWidget *table_conf;

  /* Window Definition */
  window_conf = gtk_window_new (GTK_WINDOW_DIALOG);
  gtk_window_set_title (GTK_WINDOW (window_conf), _("Add"));
  gtk_container_border_width (GTK_CONTAINER(window_conf), 2);

  gtk_signal_connect (GTK_OBJECT (window_conf), "delete_event",
		      GTK_SIGNAL_FUNC (widget_quit), window_conf);
  gtk_signal_connect (GTK_OBJECT (window_conf), "destroy",
		      GTK_SIGNAL_FUNC (delete_event), window_conf);
			
  /* Frame Definition */
  frame_conf = gtk_frame_new (_("Add Conection..."));
  gtk_container_border_width (GTK_CONTAINER(frame_conf), 3);
  gtk_frame_set_label_align (GTK_FRAME(frame_conf), 0.0, 0.0);

  /* Table Definition */
  table_conf = gtk_table_new (7, 2, TRUE);

  /* Creating Labels */
  label_name_conf = gtk_label_new (_("Server Name"));
  gtk_label_set_justify (GTK_LABEL(label_name_conf), GTK_JUSTIFY_LEFT);
    
  label_phone_conf = gtk_label_new (_("Phone"));
  gtk_label_set_justify (GTK_LABEL(label_phone_conf), GTK_JUSTIFY_LEFT);
    
  label_username_conf = gtk_label_new (_("Username"));
  gtk_label_set_justify (GTK_LABEL(label_username_conf), GTK_JUSTIFY_LEFT);
    
  label_password_conf = gtk_label_new (_("Password"));
  gtk_label_set_justify (GTK_LABEL(label_password_conf), GTK_JUSTIFY_LEFT);

  label_c_type_conf = gtk_label_new (_("Connection type"));
  gtk_label_set_justify (GTK_LABEL(label_c_type_conf), GTK_JUSTIFY_LEFT);

  /* Creating entrys */
  text_entry_name = gtk_entry_new_with_max_length (30);
  text_entry_phone = gtk_entry_new_with_max_length (12);
  text_entry_username = gtk_entry_new_with_max_length (20);
  text_entry_password = gtk_entry_new_with_max_length (16);
  gtk_entry_set_visibility (GTK_ENTRY(text_entry_password), FALSE);

  /* Creating combo */
  combo_conf = gtk_combo_new ();
  types_list = g_list_append (types_list, "CHAT");
  types_list = g_list_append (types_list, "PAP");
  types_list = g_list_append (types_list, "CHAP");
  gtk_entry_set_editable (GTK_ENTRY(GTK_COMBO(combo_conf)->entry), FALSE);
  gtk_combo_set_popdown_strings (GTK_COMBO(combo_conf), types_list);

  /* Creating buttons */
  button_ok_conf = gtk_button_new_with_label (_("Add"));
  gtk_signal_connect (GTK_OBJECT (button_ok_conf), "clicked",
		      GTK_SIGNAL_FUNC (write_callback), main_combo);
  gtk_signal_connect (GTK_OBJECT (button_ok_conf), "clicked",
		      GTK_SIGNAL_FUNC (widget_quit), window_conf);

  button_cancel_conf = gtk_button_new_with_label (_("Cancel"));
  gtk_signal_connect (GTK_OBJECT (button_cancel_conf), "clicked",
		      GTK_SIGNAL_FUNC (widget_quit), window_conf);

  /* Putting widgets in table */
  /* first and second lines */
  gtk_table_attach (GTK_TABLE(table_conf), label_name_conf, 0, 1, 0, 1, 
		    GTK_FILL, GTK_EXPAND, 0, 0);
  gtk_table_attach (GTK_TABLE(table_conf), text_entry_name, 0, 1, 1, 2, 
		    GTK_FILL, GTK_EXPAND, 4, 1);
  gtk_table_attach (GTK_TABLE(table_conf), label_phone_conf, 1, 2, 0, 1, 
		    GTK_FILL, GTK_EXPAND, 0, 0);
  gtk_table_attach (GTK_TABLE(table_conf), text_entry_phone, 1, 2, 1, 2, 
		    GTK_FILL, GTK_EXPAND, 4, 1);
  /* third and fourth */
  gtk_table_attach (GTK_TABLE(table_conf), label_username_conf, 0, 1, 2, 3, 
		    GTK_FILL, GTK_EXPAND, 0, 0);
  gtk_table_attach (GTK_TABLE(table_conf), text_entry_username, 0, 1, 3, 4, 
		    GTK_FILL, GTK_EXPAND, 4, 1);
  gtk_table_attach (GTK_TABLE(table_conf), label_password_conf, 1, 2, 2, 3, 
		    GTK_FILL, GTK_EXPAND, 0, 0);
  gtk_table_attach (GTK_TABLE(table_conf), text_entry_password, 1, 2, 3, 4, 
		    GTK_FILL, GTK_EXPAND, 4, 1);
  gtk_table_attach (GTK_TABLE(table_conf), label_c_type_conf, 1, 2, 4, 5, 
		    GTK_FILL, GTK_EXPAND, 0, 0);
  gtk_table_attach (GTK_TABLE(table_conf), combo_conf, 1, 2, 5, 6, 
		    GTK_FILL, GTK_EXPAND, 4, 1);

  gtk_table_attach (GTK_TABLE(table_conf), button_ok_conf, 0, 1, 6, 7, 
		    GTK_FILL, GTK_EXPAND, 4, 6);
  gtk_table_attach (GTK_TABLE(table_conf), button_cancel_conf, 1, 2, 6, 7, 
		    GTK_FILL, GTK_EXPAND, 4, 6);
    
  gtk_container_add (GTK_CONTAINER (window_conf), frame_conf);
  gtk_container_add (GTK_CONTAINER (frame_conf), table_conf);


  /* Showing widgets */
  /* labels */
  gtk_widget_show (label_name_conf);
  gtk_widget_show (label_phone_conf);
  gtk_widget_show (label_username_conf);
  gtk_widget_show (label_password_conf);
  gtk_widget_show (label_c_type_conf);
	
  /* text entrys */
  gtk_widget_show (text_entry_name);
  gtk_widget_show (text_entry_phone);
  gtk_widget_show (text_entry_username);
  gtk_widget_show (text_entry_password);
	
  gtk_widget_show (combo_conf);
	
  /* buttons */
  gtk_widget_show (button_ok_conf);
  gtk_widget_show (button_cancel_conf);
  /* parent widgets */
  gtk_widget_show (frame_conf);
  gtk_widget_show (table_conf);
  gtk_widget_show (window_conf);
}    

/*
  Creates the configuration window
*/
void create_config_window (gchar *label_content, gchar *entry_content, gchar *config)
{
  GtkWidget *conf_win;
  GtkWidget *conf_frame;

  GtkWidget *conf_table;

  GtkWidget *conf_label;
  GtkWidget *conf_entry;

  GtkWidget *conf_btn_ok,
    *conf_btn_cancel;

  /* Window */
  conf_win = gtk_window_new (GTK_WINDOW_DIALOG);
  gtk_window_set_title (GTK_WINDOW(conf_win), _("GkDial: Configure"));
  gtk_container_set_border_width (GTK_CONTAINER(conf_win), 2);
  gtk_signal_connect_object (GTK_OBJECT(conf_win), "delete_event",
			     GTK_SIGNAL_FUNC(gtk_widget_destroy),
			     GTK_OBJECT(conf_win));

  /* Frame */
  conf_frame = gtk_frame_new (NULL);
  gtk_container_set_border_width(GTK_CONTAINER(conf_frame), 3);
  gtk_container_add (GTK_CONTAINER(conf_win), conf_frame);
  gtk_widget_show (conf_frame);

  /* Table */
  conf_table = gtk_table_new (2, 2, FALSE);
  gtk_container_add (GTK_CONTAINER(conf_frame), conf_table);
  gtk_widget_show (conf_table);

  /* Label and Entry */
  conf_label = gtk_label_new (label_content);
  gtk_label_set_justify (GTK_LABEL(conf_label), GTK_JUSTIFY_LEFT);
  conf_entry = gtk_entry_new_with_max_length (FILENAME_MAX);
  gtk_entry_set_text (GTK_ENTRY(conf_entry), entry_content);
  gtk_widget_show (conf_label);
  gtk_widget_show (conf_entry);

  /* Buttons */
  /* ok */
  conf_btn_ok = gtk_button_new_with_label (_("OK"));
  if (!strcmp(config,"modem"))
    {
      gtk_signal_connect (GTK_OBJECT(conf_btn_ok), "clicked",
			  GTK_SIGNAL_FUNC(conf_set_modem),
			  conf_entry);
    }
  else if (!strcmp(config, "lock"))
    {
      gtk_signal_connect (GTK_OBJECT(conf_btn_ok), "clicked",
			  GTK_SIGNAL_FUNC(conf_set_lock),
			  conf_entry);
    }
  else if (!strcmp(config, "connect_cmd"))
    {
      gtk_signal_connect (GTK_OBJECT(conf_btn_ok), "clicked",
			  GTK_SIGNAL_FUNC(conf_set_connect_cmd),
			  conf_entry);
    }
  else if (!strcmp(config, "disconnect_cmd"))
    {
      gtk_signal_connect (GTK_OBJECT(conf_btn_ok), "clicked",
			  GTK_SIGNAL_FUNC(conf_set_disconnect_cmd),
			  conf_entry);
    }
  gtk_signal_connect_object (GTK_OBJECT(conf_btn_ok), "clicked",
			     GTK_SIGNAL_FUNC(gtk_widget_destroy),
			     GTK_OBJECT(conf_win));
  /* cancel */
  conf_btn_cancel = gtk_button_new_with_label (_("Cancel"));
  gtk_signal_connect_object (GTK_OBJECT(conf_btn_cancel), "clicked",
			     GTK_SIGNAL_FUNC(gtk_widget_destroy),
			     GTK_OBJECT(conf_win));
  gtk_widget_show (conf_btn_ok);
  gtk_widget_show (conf_btn_cancel);

  /* Attaching */
  gtk_table_attach (GTK_TABLE(conf_table), conf_label, 0, 2, 0, 1,
		    GTK_FILL, GTK_EXPAND, 2, 2);
  gtk_table_attach (GTK_TABLE(conf_table), conf_entry, 0, 2, 1, 2,
		    GTK_FILL, GTK_EXPAND, 2, 2);
  gtk_table_attach (GTK_TABLE(conf_table), conf_btn_ok, 0, 1, 2, 3,
		    GTK_FILL, GTK_EXPAND, 4, 4);
  gtk_table_attach (GTK_TABLE(conf_table), conf_btn_cancel, 1, 2, 2, 3,
		    GTK_FILL, GTK_EXPAND, 4, 4);

  gtk_widget_show (conf_win);
}

/* hides/show widgets based on connection status */
void gk_set_state (guint which)
{
  switch (which)
    {
    case PIX_ON:
      gtk_pixmap_set (GTK_PIXMAP(pixmap), on, mask);
      if (GTK_WIDGET_VISIBLE(button_connect))
	  gtk_widget_hide (button_connect);
      if (!GTK_WIDGET_VISIBLE(button_disconnect))
	  gtk_widget_show (button_disconnect);
      break;
    case PIX_WAITING:
      gtk_pixmap_set (GTK_PIXMAP(pixmap), waiting, mask);
      if (GTK_WIDGET_VISIBLE(button_connect))
	  gtk_widget_hide (button_connect);
      if (!GTK_WIDGET_VISIBLE(button_disconnect))
	  gtk_widget_show (button_disconnect);
      break;
    default:
      gtk_pixmap_set (GTK_PIXMAP(pixmap), off, mask);
      if (!GTK_WIDGET_VISIBLE(button_connect))
	gtk_widget_show (button_connect);
      if (GTK_WIDGET_VISIBLE(button_disconnect))
	gtk_widget_hide (button_disconnect);
    }
}

GdkPixmap*
create_gkdial_image (GtkWidget *win, gchar *iname, 
		     GdkBitmap *mask)
{
  GdkPixmap *pix;
  GdkColormap *colormap;
  GtkStyle *style;
  gchar pixmap_file[FILENAME_MAX];

#ifndef PREFIX
#define PREFIX "/usr"
#endif

  sprintf (pixmap_file, "%s/share/gkdial/%s", PREFIX, iname);

  /* pixmap */
  style = gtk_widget_get_style (win);
  colormap = gtk_widget_get_colormap(win);
  pix = gdk_pixmap_colormap_create_from_xpm (NULL, colormap, &mask,
					     NULL, pixmap_file);
  return pix;
}

/* 
   Shows 'msg' in a dialog box with an OK button 
   This function is to be a helper for functions needing to
   display some information to the user
*/
void gk_diag (gchar *msg)
{
  GtkWidget *diag_win;
  GtkWidget *diag_frame;
  GtkWidget *diag_table;
  GtkWidget *diag_label;
  GtkWidget *button_ok;

  diag_win = gtk_window_new (GTK_WINDOW_DIALOG);
  gtk_window_set_title (GTK_WINDOW(diag_win), "GkDial");
  gtk_signal_connect_object (GTK_OBJECT(diag_win), "delete_event",
			     GTK_SIGNAL_FUNC(gtk_widget_destroy), 
			     GTK_OBJECT(diag_win));
  gtk_container_set_border_width (GTK_CONTAINER(diag_win), 3);

  diag_frame = gtk_frame_new (NULL);
  gtk_container_set_border_width (GTK_CONTAINER(diag_frame), 3);
  gtk_container_add (GTK_CONTAINER(diag_win), diag_frame);
  gtk_widget_show (diag_frame);

  button_ok = gtk_button_new_with_label (_("OK"));
  gtk_signal_connect_object (GTK_OBJECT(button_ok), "clicked",
			     GTK_SIGNAL_FUNC(gtk_widget_destroy), 
			     GTK_OBJECT(diag_win));

  diag_label = gtk_label_new (msg);
  gtk_label_set_justify (GTK_LABEL(diag_label), GTK_JUSTIFY_LEFT);

  diag_table = gtk_table_new (2, 1, FALSE);
  gtk_container_add (GTK_CONTAINER(diag_frame), diag_table);

  gtk_table_attach (GTK_TABLE(diag_table), diag_label, 0, 1, 0, 1, 
		    GTK_FILL, GTK_EXPAND, 4, 4);
  gtk_table_attach (GTK_TABLE(diag_table), button_ok, 0, 1, 1, 2,
		    GTK_FILL, GTK_EXPAND, 4, 4);

  gtk_widget_show (button_ok);
  gtk_widget_show (diag_label);
  gtk_widget_show (diag_table);
  gtk_widget_show (diag_win);
}

void gkdial_about (GtkWidget *w, gpointer data)
{
  gchar about_msg[1024];

  sprintf (about_msg,
	   _("GK Dial: %s\n\n"
	     "This program is meant to novice or experienced users\n"
	     "who doesn't like the ways he/she/they have to connect\n"
	     "to the Internet (e.g.: my girlfriend).\n\n"
	     "Author: Gustavo Noronha Silva (kov) <kov@debian.org>\n"
	     "WebSite: http://gkdial.sourceforge.net\n"
	     "Please, report bugs directly to me on my personal email.\n"),
	   VERSION);

  gk_diag (about_msg);
}
