/*
** THIS SOFTWARE IS SUBJECT TO COPYRIGHT PROTECTION AND IS OFFERED ONLY
** PURSUANT TO THE 3DFX GLIDE GENERAL PUBLIC LICENSE. THERE IS NO RIGHT
** TO USE THE GLIDE TRADEMARK WITHOUT PRIOR WRITTEN PERMISSION OF 3DFX
** INTERACTIVE, INC. A COPY OF THIS LICENSE MAY BE OBTAINED FROM THE 
** DISTRIBUTOR OR BY CONTACTING 3DFX INTERACTIVE INC(info@3dfx.com). 
** THIS PROGRAM IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER 
** EXPRESSED OR IMPLIED. SEE THE 3DFX GLIDE GENERAL PUBLIC LICENSE FOR A
** FULL TEXT OF THE NON-WARRANTY PROVISIONS.  
** 
** USE, DUPLICATION OR DISCLOSURE BY THE GOVERNMENT IS SUBJECT TO
** RESTRICTIONS AS SET FORTH IN SUBDIVISION (C)(1)(II) OF THE RIGHTS IN
** TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 252.227-7013,
** AND/OR IN SIMILAR OR SUCCESSOR CLAUSES IN THE FAR, DOD OR NASA FAR
** SUPPLEMENT. UNPUBLISHED RIGHTS RESERVED UNDER THE COPYRIGHT LAWS OF
** THE UNITED STATES.  
** 
** COPYRIGHT 3DFX INTERACTIVE, INC. 1999, ALL RIGHTS RESERVED
**
** $Header: /cvsroot/glide/glide3x/h3/minihwc/hwcio.h,v 1.1.1.1.2.1 2000/08/30 08:47:03 alanh Exp $
** $Log: hwcio.h,v $
** Revision 1.1.1.1.2.1  2000/08/30 08:47:03  alanh
** Changes for Voodoo3 for 64bit architectures
**
** Revision 1.1.1.1  1999/11/24 21:45:04  joseph
** Initial checkin for SourceForge
**
** 
** 3     4/06/99 3:36p Dow
** Alt tab stuff
** 
** 
** 2     3/11/98 8:27p Dow
** WinGlide
** 
** 1     3/04/98 4:13p Dow
**
*/
#ifndef HWCIO_H
#define HWCIO_H

extern char *ioRegNames[];
extern char *cmdAGPRegNames[];
extern char *waxRegNames[];
extern char *sstRegNames[];

#ifdef __alpha__
extern unsigned int _fxget32(unsigned int *);
#define GET(s) _fxget32((unsigned int *)&s);
#define SET(d,s) d = s
#endif

#ifndef GET
#define GET(s) s
#define SET(d,s) d = s
#endif

/*
**  I/O Macros
*/
#define HWC_IO_STORE(regInfo, reg, val)\
GDBG_INFO(120, "Storing 0x%x to IO Register %s\n", val,\
  ioRegNames[(offsetof(SstIORegs, reg)) >> 2]);\
SET(((SstIORegs *) regInfo.ioMemBase)->reg,val)

#define HWC_IO_LOAD(regInfo, reg, val)\
val = GET(((SstIORegs *) regInfo.ioMemBase)->reg);\
GDBG_INFO(120, "Loaded 0x%x from IO Register %s\n", val,\
  ioRegNames[(offsetof(SstIORegs, reg)) >> 2]);

#define HWC_CAGP_STORE(regInfo, reg, val)\
GDBG_INFO(120, "Storing 0x%x to CAGP Register %s\n", val,\
  cmdAGPRegNames[(offsetof(SstCRegs, reg)) >> 2]);\
SET(((SstCRegs *) (regInfo.cmdAGPBase))->reg,val)

#define HWC_CAGP_LOAD(regInfo, reg, val)\
val = GET(((SstCRegs *) (regInfo).cmdAGPBase)->reg);\
GDBG_INFO(120, "Loaded 0x%x from CAGP Register %s\n", val,\
  cmdAGPRegNames[(offsetof(SstCRegs, reg)) >> 2]);
  
#define HWC_WAX_STORE(regInfo, reg, val)\
GDBG_INFO(120, "Storing 0x%x to WAX Register %s\n", val,\
  waxRegnames[(offsetof(SstGRegs, reg)) >> 2]);\
SET(((SstGRegs *) regInfo.waxBase)->reg,val)

#define HWC_WAX_LOAD(regInfo, reg, val)\
val = GET(((SstGRegs *) regInfo.waxBase)->reg);\
GDBG_INFO(120, "Loaded 0x%x from WAX Register %s\n", val,\
  waxRegnames[(offsetof(SstGRegs, reg)) >> 2]);

#define HWC_SST_STORE(regInfo, reg, val)\
GDBG_INFO(120, "Storing 0x%x to 3D Register %s\n", val,\
 sstRegNames[(offsetof(SstRegs, reg)) >> 2]);\
SET(((SstRegs *) regInfo.sstBase)->reg,val)

#define HWC_SST_LOAD(regInfo, reg, val)\
val = GET(((SstRegs *) regInfo.sstBase)->reg);\
GDBG_INFO(120, "Loaded 0x%x from WAX Register %s\n", val,\
 sstRegNames[(offsetof(SstRegs, reg)) >> 2]);

#endif                          /* HWCIO_H not defined */
