
/* This file is part of MetaDOM
 * a generic bind package for the Document Object Model API.
 * Copyright (C) 2001  Luca Padovani <luca.padovani@cs.unibo.it>
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * For more information, please visit the author's home page
 * http://www.cs.unibo.it/~lpadovan
 * or send an email to <luca.padovani@cs.unibo.it>
 *
 * DO NOT EDIT: this file has been generated automatically by MetaDOM
 */

#include <gdome.h>


#include "GdomeSmartDOMBasic.hh"
#include "GdomeSmartDOMDOMImplementation.hh"
#include "GdomeSmartDOMCore.hh"


namespace GdomeSmartDOM {

CharacterData::CharacterData(GdomeCharacterData* obj)

  : Node((GdomeNode*) obj) { }
  CharacterData::CharacterData(const CharacterData& obj)
  
  : Node(obj)
      
{
  
}

  CharacterData::CharacterData(const Node& obj)
  
  : Node((GdomeNode*) gdome_cast_cd(obj.gdome_object()))
      
{
  
}

  CharacterData& CharacterData::operator=(const CharacterData& obj)
{
  if (this == &obj) return *this;

  GdomeException exc_ = 0;

  if (gdome_obj != 0) {

    gdome_cd_unref((GdomeCharacterData*) gdome_obj, &exc_);
  

    gdome_obj = 0;
  }
  
  if (exc_ == 0) {
    gdome_obj = obj.gdome_obj;

    if (gdome_obj != 0) gdome_cd_ref((GdomeCharacterData*) gdome_obj, &exc_);
  
  }
  
  if (exc_ != 0) throw DOMException(exc_, "CharacterData::operator=");

  return *this;
}

bool CharacterData::operator==(const CharacterData& obj) const
{
  return gdome_obj == obj.gdome_obj;
}

CharacterData::~CharacterData()
{
  
}

DOMString CharacterData::get_data() const
{
  GdomeException exc_;
  GdomeDOMString* res_ = gdome_cd_data((GdomeCharacterData*) gdome_obj, &exc_);
  if (exc_ != 0) throw DOMException(exc_, "CharacterData::get_data");
  return DOMString_of_GdomeDOMString(res_);
}

void
CharacterData::set_data(const DOMString& v) const
{
  GdomeException exc_;
  GdomeDOMString* v_ = GdomeDOMString_of_DOMString(v);
  gdome_cd_set_data((GdomeCharacterData*) gdome_obj, v_, &exc_);
  
  if (v_ != 0) gdome_str_unref(v_);
  
  if (exc_ != 0) throw DOMException(exc_, "CharacterData::set_data");
}

unsigned long CharacterData::get_length() const
{
  GdomeException exc_;
  unsigned long res_ = gdome_cd_length((GdomeCharacterData*) gdome_obj, &exc_);
  if (exc_ != 0) throw DOMException(exc_, "CharacterData::get_length");
  return res_;
}

DOMString CharacterData::substringData(const unsigned long offset, const unsigned long count) const
{
  GdomeException exc_;
  GdomeDOMString* res_ = gdome_cd_substringData((GdomeCharacterData*) gdome_obj, offset, count, &exc_);
  
  if (exc_ != 0) throw DOMException(exc_, "CharacterData::substringData");
  return DOMString_of_GdomeDOMString(res_);
}

void CharacterData::appendData(const DOMString& arg) const
{
  GdomeException exc_;
  GdomeDOMString* arg_ = GdomeDOMString_of_DOMString(arg);
  gdome_cd_appendData((GdomeCharacterData*) gdome_obj, arg_, &exc_);
  
  if (arg_ != 0) gdome_str_unref(arg_);
  
  if (exc_ != 0) throw DOMException(exc_, "CharacterData::appendData");
  
}

void CharacterData::insertData(const unsigned long offset, const DOMString& arg) const
{
  GdomeException exc_;
  GdomeDOMString* arg_ = GdomeDOMString_of_DOMString(arg);
  gdome_cd_insertData((GdomeCharacterData*) gdome_obj, offset, arg_, &exc_);
  
  if (arg_ != 0) gdome_str_unref(arg_);
  
  if (exc_ != 0) throw DOMException(exc_, "CharacterData::insertData");
  
}

void CharacterData::deleteData(const unsigned long offset, const unsigned long count) const
{
  GdomeException exc_;
  gdome_cd_deleteData((GdomeCharacterData*) gdome_obj, offset, count, &exc_);
  
  if (exc_ != 0) throw DOMException(exc_, "CharacterData::deleteData");
  
}

void CharacterData::replaceData(const unsigned long offset, const unsigned long count, const DOMString& arg) const
{
  GdomeException exc_;
  GdomeDOMString* arg_ = GdomeDOMString_of_DOMString(arg);
  gdome_cd_replaceData((GdomeCharacterData*) gdome_obj, offset, count, arg_, &exc_);
  
  if (arg_ != 0) gdome_str_unref(arg_);
  
  if (exc_ != 0) throw DOMException(exc_, "CharacterData::replaceData");
  
}



}

