
/* This file is part of MetaDOM
 * a generic bind package for the Document Object Model API.
 * Copyright (C) 2001  Luca Padovani <luca.padovani@cs.unibo.it>
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * For more information, please visit the author's home page
 * http://www.cs.unibo.it/~lpadovan
 * or send an email to <luca.padovani@cs.unibo.it>
 *
 * DO NOT EDIT: this file has been generated automatically by MetaDOM
 */

#include <gdome.h>


#include "GdomeSmartDOMBasic.hh"
#include "GdomeSmartDOMDOMImplementation.hh"
#include "GdomeSmartDOMCore.hh"


namespace GdomeSmartDOM {

NamedNodeMap::NamedNodeMap(GdomeNamedNodeMap* obj)

{
  gdome_obj = obj;
  if (gdome_obj != 0) {
    GdomeException exc_;
    gdome_nnm_ref(gdome_obj, &exc_);
    if (exc_ != 0) throw DOMException(exc_, "NamedNodeMap::NamedNodeMap");
  }
}

NamedNodeMap::NamedNodeMap(const NamedNodeMap& obj)
  
{
  
  GdomeException exc_ = 0;
  gdome_obj = obj.gdome_obj;
  if (gdome_obj != 0) gdome_nnm_ref(gdome_obj, &exc_);
  if (exc_ != 0) throw DOMException(exc_, "NamedNodeMap::NamedNodeMap casting from NamedNodeMap");
  
}

  NamedNodeMap& NamedNodeMap::operator=(const NamedNodeMap& obj)
{
  if (this == &obj) return *this;

  GdomeException exc_ = 0;

  if (gdome_obj != 0) {

    gdome_nnm_unref(gdome_obj, &exc_);
  

    gdome_obj = 0;
  }
  
  if (exc_ == 0) {
    gdome_obj = obj.gdome_obj;

    if (gdome_obj != 0) gdome_nnm_ref(gdome_obj, &exc_);
  
  }
  
  if (exc_ != 0) throw DOMException(exc_, "NamedNodeMap::operator=");

  return *this;
}

bool NamedNodeMap::operator==(const NamedNodeMap& obj) const
{
  return gdome_obj == obj.gdome_obj;
}

NamedNodeMap::~NamedNodeMap()
{
  
  if (gdome_obj != 0) {
    GdomeException exc_;
    gdome_nnm_unref(gdome_obj, &exc_);
    if (exc_ != 0) throw DOMException(exc_, "NamedNodeMap::~NamedNodeMap");
    gdome_obj = 0;
  }
  
}


GdomeNamedNodeMap* NamedNodeMap::gdome_object() const
{
  if (gdome_obj != 0) {
    GdomeException exc_;
    gdome_nnm_ref(gdome_obj, &exc_);
    if (exc_ != 0) throw DOMException(exc_, "NamedNodeMap::gdome_object");
  }

  return gdome_obj;
}
unsigned long NamedNodeMap::get_length() const
{
  GdomeException exc_;
  unsigned long res_ = gdome_nnm_length((GdomeNamedNodeMap*) gdome_obj, &exc_);
  if (exc_ != 0) throw DOMException(exc_, "NamedNodeMap::get_length");
  return res_;
}

Node NamedNodeMap::getNamedItem(const DOMString& name) const
{
  GdomeException exc_;
  GdomeDOMString* name_ = GdomeDOMString_of_DOMString(name);
  GdomeNode* res_ = gdome_nnm_getNamedItem((GdomeNamedNodeMap*) gdome_obj, name_, &exc_);
  
  if (name_ != 0) gdome_str_unref(name_);
  
  if (exc_ != 0) throw DOMException(exc_, "NamedNodeMap::getNamedItem");
  return Node(res_);
}

Node NamedNodeMap::setNamedItem(const Node& arg) const
{
  GdomeException exc_;
  GdomeNode* res_ = gdome_nnm_setNamedItem((GdomeNamedNodeMap*) gdome_obj, (GdomeNode*) arg.gdome_object(), &exc_);
  
  if (exc_ != 0) throw DOMException(exc_, "NamedNodeMap::setNamedItem");
  return Node(res_);
}

Node NamedNodeMap::removeNamedItem(const DOMString& name) const
{
  GdomeException exc_;
  GdomeDOMString* name_ = GdomeDOMString_of_DOMString(name);
  GdomeNode* res_ = gdome_nnm_removeNamedItem((GdomeNamedNodeMap*) gdome_obj, name_, &exc_);
  
  if (name_ != 0) gdome_str_unref(name_);
  
  if (exc_ != 0) throw DOMException(exc_, "NamedNodeMap::removeNamedItem");
  return Node(res_);
}

Node NamedNodeMap::item(const unsigned long index) const
{
  GdomeException exc_;
  GdomeNode* res_ = gdome_nnm_item((GdomeNamedNodeMap*) gdome_obj, index, &exc_);
  
  if (exc_ != 0) throw DOMException(exc_, "NamedNodeMap::item");
  return Node(res_);
}

Node NamedNodeMap::getNamedItemNS(const DOMString& namespaceURI, const DOMString& localName) const
{
  GdomeException exc_;
  GdomeDOMString* namespaceURI_ = GdomeDOMString_of_DOMString(namespaceURI);
  GdomeDOMString* localName_ = GdomeDOMString_of_DOMString(localName);
  GdomeNode* res_ = gdome_nnm_getNamedItemNS((GdomeNamedNodeMap*) gdome_obj, namespaceURI_, localName_, &exc_);
  
  if (namespaceURI_ != 0) gdome_str_unref(namespaceURI_);
  
  if (localName_ != 0) gdome_str_unref(localName_);
  
  if (exc_ != 0) throw DOMException(exc_, "NamedNodeMap::getNamedItemNS");
  return Node(res_);
}

Node NamedNodeMap::setNamedItemNS(const Node& arg) const
{
  GdomeException exc_;
  GdomeNode* res_ = gdome_nnm_setNamedItemNS((GdomeNamedNodeMap*) gdome_obj, (GdomeNode*) arg.gdome_object(), &exc_);
  
  if (exc_ != 0) throw DOMException(exc_, "NamedNodeMap::setNamedItemNS");
  return Node(res_);
}

Node NamedNodeMap::removeNamedItemNS(const DOMString& namespaceURI, const DOMString& localName) const
{
  GdomeException exc_;
  GdomeDOMString* namespaceURI_ = GdomeDOMString_of_DOMString(namespaceURI);
  GdomeDOMString* localName_ = GdomeDOMString_of_DOMString(localName);
  GdomeNode* res_ = gdome_nnm_removeNamedItemNS((GdomeNamedNodeMap*) gdome_obj, namespaceURI_, localName_, &exc_);
  
  if (namespaceURI_ != 0) gdome_str_unref(namespaceURI_);
  
  if (localName_ != 0) gdome_str_unref(localName_);
  
  if (exc_ != 0) throw DOMException(exc_, "NamedNodeMap::removeNamedItemNS");
  return Node(res_);
}



}

