/* This file is part of MetaDOM
 * a generic bind package for the Document Object Model API.
 * Copyright (C) 2001  Luca Padovani <luca.padovani@cs.unibo.it>
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * For more information, please visit the author's home page
 * http://www.cs.unibo.it/~lpadovan
 * or send an email to <luca.padovani@cs.unibo.it>
 */

#include <config.h>

#include <gdome.h>
#include <iostream>

#include "GdomeSmartDOM.hh"
#include "GdomeSmartDOMDOMStringAux.hh"

using namespace GdomeSmartDOM;

void
navigate(unsigned indent, const Node& node)
{
  if (node == 0) {
    for (unsigned i = 0; i < indent; i++) cout << ' ';
    cout << "(null)" << endl;
    return;
  }
  
  unsigned short type = node.get_nodeType();
  switch (type) {
  case Node::DOCUMENT_NODE:
    {
      Document doc(node);
      Element root = doc.get_documentElement();
      navigate(indent, root);
    }
    break;
  case Node::ELEMENT_NODE:
    {
      Element elem(node);
  
      for (unsigned i = 0; i < indent; i++) cout << ' ';
      cout << "<" << node.get_nodeName();
      NamedNodeMap nmap = node.get_attributes();
      for (unsigned i = 0; i < nmap.get_length(); i++) {
	Attr attr = nmap.item(i);
	cout << " ";
	navigate(0, attr);
      }
      if (node.get_firstChild() == 0)
	cout << "/>" << endl;
      else {
	cout << ">" << endl;      
	for (Node p = elem.get_firstChild(); p != 0; p = p.get_nextSibling())
	  navigate(indent + 2, p);
	for (unsigned i = 0; i < indent; i++) cout << ' ';
	cout << "</" << elem.get_tagName() << ">" << endl;
      }
    }
    break;
  case Node::ATTRIBUTE_NODE:
    {
      cout << node.get_nodeName() << "=\"" << node.get_nodeValue() << "\"";
    }
    break;
  case Node::CDATA_SECTION_NODE:
  case Node::TEXT_NODE:
    {
      DOMString s = node.get_nodeValue();
      if (!s.isEmpty()) {
	for (unsigned i = 0; i < indent; i++) cout << ' ';      
	cout << s << endl;
      }
    }
    break;
  case Node::COMMENT_NODE:
    {
      DOMString s = node.get_nodeValue();
      for (unsigned i = 0; i < indent; i++) cout << ' ';      
      cout << "<!--" << s << "-->" << endl;
    }
    break;
  default:
    cout << "unrecognized node type " << node.get_nodeType() << endl;
    break;
  }
}

int
main(int argc, char* argv[])
{
  if (argc < 2) {
  	cerr << "usage: test <file>" << endl;
	return 1;
  }

  try {
    for (unsigned i = 1; i < argc; i++) {
      DOMImplementation di;
      cout << endl << "********** file: " << argv[i] << endl;
      Document doc = di.createDocumentFromURI(argv[i], 0);
      navigate(0, doc);
    }
  } catch (DOMException exc) {
    cerr << "exc: " << exc.code << " " << exc.msg << endl;
  }
}

