#include "support.h"
#include "callbacks.h"
#include "mfsk.h"

static GdkPixmap *bitshapepixmap = NULL;
static GdkGC *gc_black;
static GdkGC *gc_green;

gboolean on_bitshapedarea_configure_event(GtkWidget *widget,
					  GdkEventConfigure *event,
					  gpointer user_data)
{
	if (bitshapepixmap)
		gdk_pixmap_unref(bitshapepixmap);

	bitshapepixmap = gdk_pixmap_new(widget->window,
					widget->allocation.width,
					widget->allocation.height, -1);

	gdk_draw_rectangle(bitshapepixmap,
			   widget->style->black_gc,
			   TRUE,
			   0, 0,
			   widget->allocation.width,
			   widget->allocation.height);

	return TRUE;
}

gboolean on_bitshapedarea_expose_event(GtkWidget *widget,
				       GdkEventExpose *event,
				       gpointer user_data)
{
	gdk_draw_pixmap(widget->window,
			widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
			bitshapepixmap,
			event->area.x, event->area.y,
			event->area.x, event->area.y,
			event->area.width, event->area.height);
	return TRUE;
}

void bitshape_init(void)
{
	GdkColor color;
	GdkColormap *cmap;

	cmap = gdk_colormap_get_system();

	/* get black foreground */
	gdk_color_parse("black", &color); 
	if (!gdk_color_alloc(cmap, &color))
		g_error("Couldn't allocate color");

	gc_black = gdk_gc_new(bitshapepixmap);
	gdk_gc_set_foreground(gc_black, &color);

	/* get green foreground */
	gdk_color_parse("green", &color);
	if (!gdk_color_alloc(cmap, &color))
		g_error("Couldn't allocate color");

	gc_green = gdk_gc_new(bitshapepixmap);
	gdk_gc_set_foreground(gc_green, &color);
}

#define	MAXWIDTH	256

void bitshape_draw(struct mfskrx *m)
{
	GtkWidget *widget;
	GdkPoint pt[MAXWIDTH];
	gfloat yval[MAXWIDTH], ymax;
	gint x, y, i, j;

	widget = lookup_widget(appwindow, "bitshapedarea");

	if (!GTK_WIDGET_DRAWABLE(widget))
		return;

	x = widget->allocation.width;
	y = widget->allocation.height;

	if (x > MAXWIDTH)
		x = MAXWIDTH;

	ymax = 0.0;
	for (i = 0; i < x; i++) {
		j = ((i * PipeLen / x) + m->pipeptr) % PipeLen;
		yval[i] = cmod(m->pipe[j].vector[m->prev1symbol]);
		if (yval[i] > ymax)
			ymax = yval[i];
	}

	for (i = 0; i < x; i++) {
		pt[i].x = i;
		pt[i].y = y - floor(y * yval[i] / ymax);
	}

	gdk_draw_rectangle(bitshapepixmap,
			   widget->style->black_gc,
			   TRUE,
			   0, 0,
			   x, y);

	gdk_draw_lines(bitshapepixmap, gc_green, pt, x);

	gdk_draw_pixmap(widget->window,
			widget->style->fg_gc[GTK_WIDGET_STATE(widget)],
			bitshapepixmap,
			0, 0,
			0, 0,
			x, y);
}
