#include <gnome.h>

#include "support.h"
#include "mfsk.h"
#include "macro.h"
#include "prefs.h"

#include "ascii.h"

static gint carriage_return_seen = 0;

static FILE *logfile = NULL;
static gchar *logfilename = NULL;

static void log_to_file(const gchar *s);

/* ---------------------------------------------------------------------- */

void show_rx_char(unsigned int c)
{
	GtkText *text;
	GdkColor *colr;
	gchar *p;

	if (c == 0)
		return;

	/* a CR-LF is reduced to just one CR */
	if (carriage_return_seen && c == 10) {
		carriage_return_seen = 0;
		return;
	}

	if (c == 13)
		carriage_return_seen = 1;

	text = GTK_TEXT(lookup_widget(appwindow, "rxtext"));

	/* backspace */
	if (c == 8) {
		gtk_text_backward_delete(text, 1);
		log_to_file("<BS>");
		return;
	}

	p = ascii[c];

	if (*p == '<' && c != '<')
		colr = &prefs.hl_color;
	else
		colr = &prefs.rx_color;

	gtk_text_insert(text, txfont, colr, NULL, p, -1);

	log_to_file(p);
}

void show_tx_char(unsigned int c)
{
	GtkText *text;
	gchar *p;

	if (c == 0)
		return;

	text = GTK_TEXT(lookup_widget(appwindow, "rxtext"));

	/* backspace */
	if (c == 8) {
		gtk_text_backward_delete(text, 1);
		log_to_file("<BS>");
		return;
	}

	p = ascii[c];

	gtk_text_insert(text, txfont, &prefs.tx_color, NULL, p, -1);

	log_to_file(p);
}

/* ---------------------------------------------------------------------- */

static void log_to_file(const gchar *s)
{
	if (!logfile)
		return;

	if (fputs(s, logfile) == EOF || fflush(logfile) == EOF) {
		log_to_file_stop();
		errmsg("Error writing to log file: %m");
	}
}

gint log_to_file_start(const gchar *name)
{
	if ((logfile = fopen(name, "a")) == NULL)
		return -1;

	logfilename = g_strdup(name);

	return 0;
}

void log_to_file_stop(void)
{
	if (!logfile)
		return;

	fclose(logfile);
	logfile = NULL;

	g_free(logfilename);
	logfilename = NULL;
}

gchar *log_to_file_get_name(void)
{
	if (!logfile)
		return NULL;

	return logfilename;
}

/* ---------------------------------------------------------------------- */

