/* gmoo - a gtk+ based graphical MOO/MUD/MUSH/... client
 * Copyright (C) 1999-2000 Gert Scholten
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef GM_USERLIST_H
#define GM_USERLIST_H

#include "world.h"
#include "mcp.h"
#include "list.h"

struct _userlist_t {
    world *belongs_to;

    GList *fields;
    GList *icon_names;
    GList *icons;

    GList *friends;
    GList *gaglist;
 
    MOOVar *menu;
    int     menudefault;
    int     me;

    GList *users;
    GList *users_invisible;

    GCompareFunc compare;
};

void gm_userlist_init();
void gm_userlist_exit();

userlist_t *gm_userlist_new(world *w);
void gm_userlist_new_widgets(world *w);
void gm_userlist_free(userlist_t *u);
void gm_userlist_toggle_world(world *w);
void gm_userlist_toggle();

void gm_userlist_update_friends_color(userlist_t *u);

/* mcp interface */
void gm_userlist_mcp_init(mcp_package *p);

#endif /* GM_USERLIST_H */
