/* gmoo - a gtk+ based graphical MOO/MUD/MUSH/... client
 * Copyright (C) 1999-2000 Gert Scholten
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef GM_WORLD_H
#define GM_WORLD_H

#include <gtk/gtk.h>
#include <stdio.h>

#include "config.h"
#include "configdb.h"

typedef struct _world          world;
typedef struct _d_properties_t d_properties_t;
typedef struct _login_t        login_t;
typedef struct _history        history;
typedef struct _editor_t       editor_t;
typedef struct _properties_t   properties_t;
typedef struct _dsend_t        dsend_t;
typedef struct _mcp_session    mcp_session;
typedef struct _mcp_package    mcp_package;
typedef struct _userlist_t     userlist_t;
typedef struct _server_t       server_t;

#include "net.h"
#include "properties.h"
#include "mcp.h"
#include "userlist.h"

struct _world {
	properties_t *p;  /* All world specific saved properties */
	server_t *server;

	int id;
	int position;

	guint quick : 1;          /* Indicate if it is an quick connect world */

	int new_lines;            /* number of new lines written to the screen */

	char *status_msg;         /* The text on the statusbar */

	FILE *log;                /* the fie that the logs will be written in */

	/* scripting buffers */
	char *buffered_print_line;
	char *buffered_write_line;

	/* Standard output buffers */
	char *buffered_data_line;
	int   buffered_data_line_len;

	history *history;         /* Input history */

	mcp_session *mcp;

	/* Dialogs (that deed to be closed when closing the world */
	d_properties_t *dialog_properties;
	login_t *dialog_login;
	dsend_t *dialog_send;

	GList *editors;           /* all the editors assiciated with this world */
	editor_t *current_editor; /* Where #@#EXTERNAL#@# commands go to */

	userlist_t *userlist;

	/* The widgets */
	GtkWidget *tab_label;         /* The GtkLabel on the notebooktab */
	GtkWidget *vpaned;            /* GtkVPaned that contain input and output */
	GtkWidget *hcontainer;      /* Main output container (HPaned of HBox) */
	GtkWidget *output_scrollw;      /* Container for the output */
	GtkWidget *output;         /* Output widget */
	GtkWidget *scrollbar;    /* The scrollbar container */
	GtkWidget *userlist_container;    /* Scrolled window */
	GtkWidget *userlist_clist;        /* The userlist output window */
	GtkWidget *userlist_totals;       /* The userlist totals label */
	GtkWidget *userlist_totals_frame; /* The userlist totals container */
#ifdef __PROMPT__
	GtkWidget *prompt;
#endif
	GtkWidget *input;           /* The input window */
};

/* World file access */
world *gm_world_create       (const char *name);
void   gm_world_create_quick (const char *hostname, int port);
GList *gm_world_get_names    ();
void   gm_world_save_settings(world *w); /* world must exist ... */
void   gm_world_remove       (const char *name);
int    gm_world_create_config(properties_t *p);
int    gm_world_apply_properties        (world *w, properties_t *p);
int    gm_world_apply_properties_by_name(const char *name, properties_t *p);
properties_t *gm_world_get_settings_by_name(const char *name);
int    gm_world_copy_by_name(const char *name, const char *newname);
void   gm_world_save_order(GList *order);
void   gm_world_create_template();


/* World closing ... */
int    gm_world_ok_to_close          (world *w);
void   gm_world_close                (world *w);

/* IO */
/* Prints a string on the screen */
void gm_world_println                (world *w, const char *line);
void gm_world_print_buffered         (world *w, const char *line);
void gm_world_print_buffered_with_len(world *w, const char *line, int length);
/* Write text to the world */
void gm_world_write                  (world *w, const char *line);
void gm_world_write_with_len         (world *w, const char *line, int length);
void gm_world_writeln                (world *w, const char *line);
void gm_world_write_buffered         (world *w, const char *line);
void gm_world_write_buffered_with_len(world *w, const char *line, int length);

/* logging in */
void gm_world_log_in(world *w);

/* Network */
void gm_world_connect(world *w);
void gm_world_connecting(world *w);
void gm_world_connected(world *w);
void gm_world_disconnect(world *w);
void gm_world_disconnected(world *w);
void gm_world_try_disconnect(world *w);
void gm_world_handle_output_data(world *w, const char *text, int len);

/* loging */
void gm_world_open_log   (world *w);
void gm_world_close_log  (world *w);
void gm_world_println_log(world *w, const char *line);

/* misc */
int  gm_world_is_connected(world *w);
int  gm_world_is_connecting(world *w);

void gm_world_clear_screen(world *w);

void gm_world_got_focus(world *w);
void gm_world_update_tab_label(world *w);

void gm_world_update_scrollbar(world *w);
void gm_world_update_userlist_pos(world *w);
void gm_world_update_userlist_resizeable(world *w);
void gm_world_update_userlist_totals(world *w);
void gm_world_update_userlist_headers(world *w);
void gm_world_update_userlist_objects(world *w);
void gm_world_update_userlist_friends_color(world *w);

void gm_world_save_settings(world *w);

void gm_world_set_position(world *w, int pos);

#ifdef ZVT
void zvt_term_init(GtkWidget *term, properties_t *p);
#endif

#endif GM_WORLD_H
