/* Generated by GOB (v2.0.14)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 14

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "gmpc-mpddata-model.h"

#include "gmpc-mpddata-model-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */
/* self casting macros */
#define SELF(x) GMPC_MPDDATA_MODEL(x)
#define SELF_CONST(x) GMPC_MPDDATA_MODEL_CONST(x)
#define IS_SELF(x) GMPC_IS_MPDDATA_MODEL(x)
#define TYPE_SELF GMPC_TYPE_MPDDATA_MODEL
#define SELF_CLASS(x) GMPC_MPDDATA_MODEL_CLASS(x)

#define SELF_GET_CLASS(x) GMPC_MPDDATA_MODEL_GET_CLASS(x)

/* self typedefs */
typedef GmpcMpdDataModel Self;
typedef GmpcMpdDataModelClass SelfClass;

/* here are local prototypes */
static void ___object_set_property (GObject *object, guint property_id, const GValue *value, GParamSpec *pspec);
static void ___object_get_property (GObject *object, guint property_id, GValue *value, GParamSpec *pspec);
static void gmpc_mpddata_model_markup_changed (GmpcMpdDataModel * self, const char * markup, gpointer data) G_GNUC_UNUSED;
static void gmpc_mpddata_model_init (GmpcMpdDataModel * self) G_GNUC_UNUSED;
static void gmpc_mpddata_model_class_init (GmpcMpdDataModelClass * klass) G_GNUC_UNUSED;
static void ___7_gmpc_mpddata_model_finalize (GObject * obj) G_GNUC_UNUSED;
static GtkTreeModelFlags gmpc_mpddata_model_get_flags (GtkTreeModel * self) G_GNUC_UNUSED;
static gboolean gmpc_mpddata_model_get_iter (GtkTreeModel * model, GtkTreeIter * iter, GtkTreePath * path) G_GNUC_UNUSED;
static gboolean gmpc_mpddata_model_iter_next (GtkTreeModel * model, GtkTreeIter * iter) G_GNUC_UNUSED;
static gboolean gmpc_mpddata_model_iter_has_child (GtkTreeModel * self, GtkTreeIter * iter) G_GNUC_UNUSED;
static gint gmpc_mpddata_model_iter_n_children (GtkTreeModel * model, GtkTreeIter * iter) G_GNUC_UNUSED;
static gboolean gmpc_mpddata_model_iter_parent (GtkTreeModel * model, GtkTreeIter * iter, GtkTreeIter * child) G_GNUC_UNUSED;
static void gmpc_mpddata_model_cover_art_fetched (mpd_Song * song, MetaDataResult ret, char * coverpath, GtkTreeRowReference * ref) G_GNUC_UNUSED;
static void gmpc_mpddata_model_get_value (GtkTreeModel * model, GtkTreeIter * iter, gint column, GValue * value) G_GNUC_UNUSED;
static gboolean gmpc_mpddata_model_iter_nth_child (GtkTreeModel * model, GtkTreeIter * iter, GtkTreeIter * parent, gint n) G_GNUC_UNUSED;
static GtkTreePath * gmpc_mpddata_model_get_path (GtkTreeModel * self, GtkTreeIter * iter) G_GNUC_UNUSED;
static GType gmpc_mpddata_model_get_column_type (GtkTreeModel * model, gint index) G_GNUC_UNUSED;
static gboolean gmpc_mpddata_model_get_sort_column_id (GtkTreeSortable * model, gint * sort_column_id, GtkSortType * order) G_GNUC_UNUSED;
static void gmpc_mpddata_model_set_sort_column_id (GtkTreeSortable * model, gint sort_column_id, GtkSortType order) G_GNUC_UNUSED;
static gboolean gmpc_mpddata_model_has_default_sort_func (GtkTreeSortable * model) G_GNUC_UNUSED;
static int gmpc_mpddata_model_sort_func (gpointer ppaa, gpointer ppbb, Self * self) G_GNUC_UNUSED;
static void gmpc_mpddata_model_sort_column_changed (GtkTreeSortable * model) G_GNUC_UNUSED;

enum {
	PROP_0,
	PROP_HAS_UP
};

/* pointer to the class of our parent */
static GObjectClass *parent_class = NULL;

/* Short form macros */
#define self_get_has_up gmpc_mpddata_model_get_has_up
#define self_set_has_up gmpc_mpddata_model_set_has_up
#define self_markup_changed gmpc_mpddata_model_markup_changed
#define self_new gmpc_mpddata_model_new
#define self_get_flags gmpc_mpddata_model_get_flags
#define self_iter_children gmpc_mpddata_model_iter_children
#define self_get_n_columns gmpc_mpddata_model_get_n_columns
#define self_get_iter gmpc_mpddata_model_get_iter
#define self_iter_next gmpc_mpddata_model_iter_next
#define self_iter_has_child gmpc_mpddata_model_iter_has_child
#define self_iter_n_children gmpc_mpddata_model_iter_n_children
#define self_iter_parent gmpc_mpddata_model_iter_parent
#define self_cover_art_fetched gmpc_mpddata_model_cover_art_fetched
#define self_get_value gmpc_mpddata_model_get_value
#define self_iter_nth_child gmpc_mpddata_model_iter_nth_child
#define self_get_path gmpc_mpddata_model_get_path
#define self_get_column_type gmpc_mpddata_model_get_column_type
#define self_set_request_artist gmpc_mpddata_model_set_request_artist
#define self_set_mpd_data gmpc_mpddata_model_set_mpd_data
#define self_get_sort_column_id gmpc_mpddata_model_get_sort_column_id
#define self_set_sort_column_id gmpc_mpddata_model_set_sort_column_id
#define self_has_default_sort_func gmpc_mpddata_model_has_default_sort_func
#define self_sort_func gmpc_mpddata_model_sort_func
#define self_sort_column_changed gmpc_mpddata_model_sort_column_changed


static void
___Gtk_Tree_Model_init (GtkTreeModelIface *iface)
{
#line 170 "gmpc-mpddata-model.gob"
	iface->get_flags = self_get_flags;
#line 179 "gmpc-mpddata-model.gob"
	iface->iter_children = self_iter_children;
#line 199 "gmpc-mpddata-model.gob"
	iface->get_n_columns = self_get_n_columns;
#line 206 "gmpc-mpddata-model.gob"
	iface->get_iter = self_get_iter;
#line 245 "gmpc-mpddata-model.gob"
	iface->iter_next = self_iter_next;
#line 271 "gmpc-mpddata-model.gob"
	iface->iter_has_child = self_iter_has_child;
#line 277 "gmpc-mpddata-model.gob"
	iface->iter_n_children = self_iter_n_children;
#line 287 "gmpc-mpddata-model.gob"
	iface->iter_parent = self_iter_parent;
#line 336 "gmpc-mpddata-model.gob"
	iface->get_value = self_get_value;
#line 609 "gmpc-mpddata-model.gob"
	iface->iter_nth_child = self_iter_nth_child;
#line 639 "gmpc-mpddata-model.gob"
	iface->get_path = self_get_path;
#line 649 "gmpc-mpddata-model.gob"
	iface->get_column_type = self_get_column_type;
#line 124 "gmpc-mpddata-model.c"
}


static void
___Gtk_Tree_Sortable_init (GtkTreeSortableIface *iface)
{
#line 752 "gmpc-mpddata-model.gob"
	iface->get_sort_column_id = self_get_sort_column_id;
#line 764 "gmpc-mpddata-model.gob"
	iface->set_sort_column_id = self_set_sort_column_id;
#line 781 "gmpc-mpddata-model.gob"
	iface->has_default_sort_func = self_has_default_sort_func;
#line 873 "gmpc-mpddata-model.gob"
	iface->sort_column_changed = self_sort_column_changed;
#line 139 "gmpc-mpddata-model.c"
}

GType
gmpc_mpddata_model_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (GmpcMpdDataModelClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) gmpc_mpddata_model_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (GmpcMpdDataModel),
			0 /* n_preallocs */,
			(GInstanceInitFunc) gmpc_mpddata_model_init,
			NULL
		};

		static const GInterfaceInfo Gtk_Tree_Model_info = {
			(GInterfaceInitFunc) ___Gtk_Tree_Model_init,
			NULL,
			NULL
		};

		static const GInterfaceInfo Gtk_Tree_Sortable_info = {
			(GInterfaceInitFunc) ___Gtk_Tree_Sortable_init,
			NULL,
			NULL
		};

		type = g_type_register_static (G_TYPE_OBJECT, "GmpcMpdDataModel", &info, (GTypeFlags)0);
		g_type_add_interface_static (type,
			GTK_TYPE_TREE_MODEL,
			&Gtk_Tree_Model_info);
		g_type_add_interface_static (type,
			GTK_TYPE_TREE_SORTABLE,
			&Gtk_Tree_Sortable_info);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((GmpcMpdDataModel *)g_object_new(gmpc_mpddata_model_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static GmpcMpdDataModel * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static GmpcMpdDataModel *
GET_NEW_VARG (const char *first, ...)
{
	GmpcMpdDataModel *ret;
	va_list ap;
	va_start (ap, first);
	ret = (GmpcMpdDataModel *)g_object_new_valist (gmpc_mpddata_model_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "Gmpc:MpdData:Model::finalize"
	GmpcMpdDataModel *self G_GNUC_UNUSED = GMPC_MPDDATA_MODEL (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
#line 143 "gmpc-mpddata-model.gob"
	___7_gmpc_mpddata_model_finalize(obj_self);
#line 211 "gmpc-mpddata-model.c"
#line 59 "gmpc-mpddata-model.gob"
	if(self->_priv->req_artist) { g_free ((gpointer) self->_priv->req_artist); self->_priv->req_artist = NULL; }
#line 214 "gmpc-mpddata-model.c"
#line 66 "gmpc-mpddata-model.gob"
	if(self->_priv->markup) { g_free ((gpointer) self->_priv->markup); self->_priv->markup = NULL; }
#line 217 "gmpc-mpddata-model.c"
}
#undef __GOB_FUNCTION__

#line 105 "gmpc-mpddata-model.gob"
static void 
gmpc_mpddata_model_init (GmpcMpdDataModel * self G_GNUC_UNUSED)
#line 224 "gmpc-mpddata-model.c"
{
#define __GOB_FUNCTION__ "Gmpc:MpdData:Model::init"
	self->_priv = G_TYPE_INSTANCE_GET_PRIVATE(self,GMPC_TYPE_MPDDATA_MODEL,GmpcMpdDataModelPrivate);
#line 54 "gmpc-mpddata-model.gob"
	self->_priv->stamp = g_random_int();
#line 230 "gmpc-mpddata-model.c"
#line 54 "gmpc-mpddata-model.gob"
	self->_priv->data = NULL;
#line 233 "gmpc-mpddata-model.c"
#line 54 "gmpc-mpddata-model.gob"
	self->_priv->num_rows = 0;
#line 236 "gmpc-mpddata-model.c"
#line 54 "gmpc-mpddata-model.gob"
	self->_priv->images = NULL;
#line 239 "gmpc-mpddata-model.c"
#line 59 "gmpc-mpddata-model.gob"
	self->_priv->req_artist = NULL;
#line 242 "gmpc-mpddata-model.c"
#line 59 "gmpc-mpddata-model.gob"
	self->_priv->sort_order = GTK_SORT_ASCENDING;
#line 245 "gmpc-mpddata-model.c"
#line 59 "gmpc-mpddata-model.gob"
	self->_priv->sort_column = GTK_TREE_SORTABLE_UNSORTED_SORT_COLUMN_ID;
#line 248 "gmpc-mpddata-model.c"
#line 59 "gmpc-mpddata-model.gob"
	self->_priv->old_sort_column = GTK_TREE_SORTABLE_UNSORTED_SORT_COLUMN_ID;
#line 251 "gmpc-mpddata-model.c"
#line 59 "gmpc-mpddata-model.gob"
	self->has_up = FALSE;
#line 254 "gmpc-mpddata-model.c"
#line 66 "gmpc-mpddata-model.gob"
	self->_priv->markup = gmpc_signals_get_browser_markup(gmpc_signals);
#line 257 "gmpc-mpddata-model.c"
#line 66 "gmpc-mpddata-model.gob"
	self->_priv->markup_signal = 0;
#line 260 "gmpc-mpddata-model.c"
 {
#line 106 "gmpc-mpddata-model.gob"

        self->_priv->types[MPDDATA_MODEL_COL_MPDSONG] = G_TYPE_POINTER;
        self->_priv->types[MPDDATA_MODEL_COL_MARKUP] = G_TYPE_STRING;
        self->_priv->types[MPDDATA_MODEL_COL_PLAYING] = G_TYPE_BOOLEAN;
        self->_priv->types[MPDDATA_MODEL_COL_PLAYING_FONT_WEIGHT] = G_TYPE_INT;
        self->_priv->types[MPDDATA_MODEL_COL_PATH] = G_TYPE_STRING;
        self->_priv->types[MPDDATA_MODEL_COL_SONG_ARTIST] = G_TYPE_STRING;
        self->_priv->types[MPDDATA_MODEL_COL_SONG_ALBUM] = G_TYPE_STRING;
        self->_priv->types[MPDDATA_MODEL_COL_SONG_TITLE] = G_TYPE_STRING;
        self->_priv->types[MPDDATA_MODEL_COL_SONG_TITLEFILE] = G_TYPE_STRING;
        self->_priv->types[MPDDATA_MODEL_COL_SONG_TRACK] = G_TYPE_STRING;
        self->_priv->types[MPDDATA_MODEL_COL_SONG_GENRE] = G_TYPE_STRING;
        self->_priv->types[MPDDATA_MODEL_COL_SONG_NAME] = G_TYPE_STRING;
        self->_priv->types[MPDDATA_MODEL_COL_SONG_COMPOSER] = G_TYPE_STRING;
        self->_priv->types[MPDDATA_MODEL_COL_SONG_PERFORMER]= G_TYPE_STRING;
        self->_priv->types[MPDDATA_MODEL_COL_SONG_DATE] = G_TYPE_STRING;
        self->_priv->types[MPDDATA_MODEL_COL_SONG_LENGTH] = G_TYPE_INT;
        self->_priv->types[MPDDATA_MODEL_COL_SONG_LENGTH_FORMAT] = G_TYPE_STRING;
        self->_priv->types[MPDDATA_MODEL_COL_SONG_DISC] = G_TYPE_STRING;
        self->_priv->types[MPDDATA_MODEL_COL_SONG_COMMENT] = G_TYPE_STRING;
        self->_priv->types[MPDDATA_MODEL_COL_SONG_POS] = G_TYPE_INT;
        self->_priv->types[MPDDATA_MODEL_COL_SONG_ID] = G_TYPE_INT;
        self->_priv->types[MPDDATA_MODEL_COL_ICON_ID] = G_TYPE_STRING;
        self->_priv->types[MPDDATA_MODEL_TAG_TYPE] = G_TYPE_INT;
        self->_priv->types[MPDDATA_MODEL_ROW_TYPE] = G_TYPE_INT;
        self->_priv->types[MPDDATA_MODEL_META_DATA] = G_TYPE_OBJECT;

        self->_priv->markup_signal = g_signal_connect_swapped(G_OBJECT(gmpc_signals), "browser-markup-changed", G_CALLBACK(self_markup_changed), self);
    
#line 292 "gmpc-mpddata-model.c"
 }
}
#undef __GOB_FUNCTION__
#line 135 "gmpc-mpddata-model.gob"
static void 
gmpc_mpddata_model_class_init (GmpcMpdDataModelClass * klass G_GNUC_UNUSED)
#line 299 "gmpc-mpddata-model.c"
{
#define __GOB_FUNCTION__ "Gmpc:MpdData:Model::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) klass;

	g_type_class_add_private(klass,sizeof(GmpcMpdDataModelPrivate));

	parent_class = g_type_class_ref (G_TYPE_OBJECT);

#line 143 "gmpc-mpddata-model.gob"
	g_object_class->finalize = ___finalize;
#line 310 "gmpc-mpddata-model.c"
	g_object_class->get_property = ___object_get_property;
	g_object_class->set_property = ___object_set_property;
    {
	GParamSpec   *param_spec;

	param_spec = g_param_spec_boolean
		("has_up" /* name */,
		 _("Has Up") /* nick */,
		 _("Show an 'up row") /* blurb */,
		 FALSE /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_HAS_UP,
		param_spec);
    }
}
#undef __GOB_FUNCTION__

static void
___object_set_property (GObject *object,
	guint property_id,
	const GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "Gmpc:MpdData:Model::set_property"
{
	GmpcMpdDataModel *self G_GNUC_UNUSED;

	self = GMPC_MPDDATA_MODEL (object);

	switch (property_id) {
	case PROP_HAS_UP:
		{
#line 69 "gmpc-mpddata-model.gob"
self->has_up = g_value_get_boolean (VAL);
#line 345 "gmpc-mpddata-model.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__

static void
___object_get_property (GObject *object,
	guint property_id,
	GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "Gmpc:MpdData:Model::get_property"
{
	GmpcMpdDataModel *self G_GNUC_UNUSED;

	self = GMPC_MPDDATA_MODEL (object);

	switch (property_id) {
	case PROP_HAS_UP:
		{
#line 69 "gmpc-mpddata-model.gob"
g_value_set_boolean (VAL, self->has_up);
#line 376 "gmpc-mpddata-model.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__

#line 69 "gmpc-mpddata-model.gob"
gboolean 
gmpc_mpddata_model_get_has_up (GmpcMpdDataModel * self)
#line 394 "gmpc-mpddata-model.c"
{
#define __GOB_FUNCTION__ "Gmpc:MpdData:Model::get_has_up"
{
#line 69 "gmpc-mpddata-model.gob"
		gboolean val; g_object_get (G_OBJECT (self), "has_up", &val, NULL); return val;
}}
#line 401 "gmpc-mpddata-model.c"
#undef __GOB_FUNCTION__

#line 69 "gmpc-mpddata-model.gob"
void 
gmpc_mpddata_model_set_has_up (GmpcMpdDataModel * self, gboolean val)
#line 407 "gmpc-mpddata-model.c"
{
#define __GOB_FUNCTION__ "Gmpc:MpdData:Model::set_has_up"
{
#line 69 "gmpc-mpddata-model.gob"
		g_object_set (G_OBJECT (self), "has_up", val, NULL);
}}
#line 414 "gmpc-mpddata-model.c"
#undef __GOB_FUNCTION__

#line 76 "gmpc-mpddata-model.gob"
static void 
gmpc_mpddata_model_markup_changed (GmpcMpdDataModel * self, const char * markup, gpointer data)
#line 420 "gmpc-mpddata-model.c"
{
#define __GOB_FUNCTION__ "Gmpc:MpdData:Model::markup_changed"
#line 76 "gmpc-mpddata-model.gob"
	g_return_if_fail (self != NULL);
#line 76 "gmpc-mpddata-model.gob"
	g_return_if_fail (GMPC_IS_MPDDATA_MODEL (self));
#line 427 "gmpc-mpddata-model.c"
{
#line 79 "gmpc-mpddata-model.gob"
	
        int i=0;
        GtkTreePath *path = NULL;
        GtkTreeIter iter;
        MpdData *data2 = mpd_data_get_first(self->_priv->data); 

        /* set the new markup */
        if(self->_priv->markup )
            g_free(self->_priv->markup);
        self->_priv->markup  = g_strdup(markup);

        if(self->has_up) i = 1;
        for(;data2; data2 = mpd_data_get_next_real(data2,FALSE)) 
        {
            path = gtk_tree_path_new();
            gtk_tree_path_append_index(path,i);
            iter.stamp = self->_priv->stamp;
            iter.user_data = data2;
            iter.user_data2 =  GINT_TO_POINTER(i);

            /* propegate change */
            gtk_tree_model_row_changed(GTK_TREE_MODEL(self), path, &iter);
            i++;
        }
    }}
#line 455 "gmpc-mpddata-model.c"
#undef __GOB_FUNCTION__



#line 137 "gmpc-mpddata-model.gob"
GmpcMpdDataModel * 
gmpc_mpddata_model_new (void)
#line 463 "gmpc-mpddata-model.c"
{
#define __GOB_FUNCTION__ "Gmpc:MpdData:Model::new"
{
#line 139 "gmpc-mpddata-model.gob"
	
            return GET_NEW;
        }}
#line 471 "gmpc-mpddata-model.c"
#undef __GOB_FUNCTION__

#line 143 "gmpc-mpddata-model.gob"
static void 
___7_gmpc_mpddata_model_finalize (GObject * obj G_GNUC_UNUSED)
#line 477 "gmpc-mpddata-model.c"
#define PARENT_HANDLER(___obj) \
	{ if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(___obj); }
{
#define __GOB_FUNCTION__ "Gmpc:MpdData:Model::finalize"
{
#line 146 "gmpc-mpddata-model.gob"
	
            int i =0;
            Self *self = GMPC_MPDDATA_MODEL(obj); 
            if(self->_priv->markup_signal)
            {
                g_signal_handler_disconnect(G_OBJECT(gmpc_signals),self->_priv->markup_signal);
            }
            self->_priv->markup_signal = 0;

            if(self->_priv->data)
                mpd_data_free(self->_priv->data);
            if(self->_priv->images)
            {
                for(i=0;i<self->_priv->num_rows;i++)
                {
                    if(self->_priv->images[i])
                        g_object_unref(self->_priv->images[i]);
                }
                q_free(self->_priv->images);
            }
            PARENT_HANDLER(obj);
        }}
#line 507 "gmpc-mpddata-model.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 170 "gmpc-mpddata-model.gob"
static GtkTreeModelFlags 
gmpc_mpddata_model_get_flags (GtkTreeModel * self)
#line 514 "gmpc-mpddata-model.c"
{
#define __GOB_FUNCTION__ "Gmpc:MpdData:Model::get_flags"
#line 170 "gmpc-mpddata-model.gob"
	g_return_val_if_fail (self != NULL, (GtkTreeModelFlags )0);
#line 170 "gmpc-mpddata-model.gob"
	g_return_val_if_fail (GTK_IS_TREE_MODEL (self), (GtkTreeModelFlags )0);
#line 521 "gmpc-mpddata-model.c"
{
#line 172 "gmpc-mpddata-model.gob"
	
            /* Here would be the implementation */
            return (GtkTreeModelFlags)GTK_TREE_MODEL_LIST_ONLY;
        }}
#line 528 "gmpc-mpddata-model.c"
#undef __GOB_FUNCTION__

#line 179 "gmpc-mpddata-model.gob"
gboolean 
gmpc_mpddata_model_iter_children (GtkTreeModel * model, GtkTreeIter * iter, GtkTreeIter * parent)
#line 534 "gmpc-mpddata-model.c"
{
#define __GOB_FUNCTION__ "Gmpc:MpdData:Model::iter_children"
{
#line 181 "gmpc-mpddata-model.gob"
	
            Self *self  = GMPC_MPDDATA_MODEL(model);
            if(parent)
                return FALSE;
            if(self->_priv->num_rows == 0)
                return FALSE;
            /* Set iter to first item in list */
            iter->stamp = self->_priv->stamp; 
            iter->user_data = self->_priv->data;
            iter->user_data2 =  GINT_TO_POINTER(0);
            iter->user_data3 = NULL;	/* unused */

            return TRUE;
        }}
#line 553 "gmpc-mpddata-model.c"
#undef __GOB_FUNCTION__

#line 199 "gmpc-mpddata-model.gob"
gint 
gmpc_mpddata_model_get_n_columns (GtkTreeModel * model)
#line 559 "gmpc-mpddata-model.c"
{
#define __GOB_FUNCTION__ "Gmpc:MpdData:Model::get_n_columns"
{
#line 201 "gmpc-mpddata-model.gob"
	
            return MPDDATA_MODEL_N_COLUMNS;
        }}
#line 567 "gmpc-mpddata-model.c"
#undef __GOB_FUNCTION__

#line 206 "gmpc-mpddata-model.gob"
static gboolean 
gmpc_mpddata_model_get_iter (GtkTreeModel * model, GtkTreeIter * iter, GtkTreePath * path)
#line 573 "gmpc-mpddata-model.c"
{
#define __GOB_FUNCTION__ "Gmpc:MpdData:Model::get_iter"
#line 206 "gmpc-mpddata-model.gob"
	g_return_val_if_fail (model != NULL, (gboolean )0);
#line 206 "gmpc-mpddata-model.gob"
	g_return_val_if_fail (GTK_IS_TREE_MODEL (model), (gboolean )0);
#line 206 "gmpc-mpddata-model.gob"
	g_return_val_if_fail (iter != NULL, (gboolean )0);
#line 206 "gmpc-mpddata-model.gob"
	g_return_val_if_fail (path != NULL, (gboolean )0);
#line 584 "gmpc-mpddata-model.c"
{
#line 210 "gmpc-mpddata-model.gob"
	
            MpdData *data = NULL;
            Self *self = GMPC_MPDDATA_MODEL(model);
            gint *indices, n,depth,i;
            indices = gtk_tree_path_get_indices(path);
            depth = gtk_tree_path_get_depth(path);

            /* No Children */
            g_assert(depth == 1); 

            n = indices[0];		/* the n-th top level row */
            if (n >= self->_priv->num_rows || n < 0)
                return FALSE; 

            data = (MpdData*)self->_priv->data;
            i=0;
            if(self->has_up)
            {
                i=1;
            }
            for(; i < (n);i++)
            {
                data = mpd_data_get_next_real(data,FALSE);
            }
            g_assert(n<self->_priv->num_rows);
            if(self->has_up && n == 0)
                data = NULL;

            iter->stamp = self->_priv->stamp;
            iter->user_data = data; 
            iter->user_data2 = GINT_TO_POINTER(n);
            return TRUE;
        }}
#line 620 "gmpc-mpddata-model.c"
#undef __GOB_FUNCTION__

#line 245 "gmpc-mpddata-model.gob"
static gboolean 
gmpc_mpddata_model_iter_next (GtkTreeModel * model, GtkTreeIter * iter)
#line 626 "gmpc-mpddata-model.c"
{
#define __GOB_FUNCTION__ "Gmpc:MpdData:Model::iter_next"
#line 245 "gmpc-mpddata-model.gob"
	g_return_val_if_fail (model != NULL, (gboolean )0);
#line 245 "gmpc-mpddata-model.gob"
	g_return_val_if_fail (GTK_IS_TREE_MODEL (model), (gboolean )0);
#line 245 "gmpc-mpddata-model.gob"
	g_return_val_if_fail (iter != NULL, (gboolean )0);
#line 635 "gmpc-mpddata-model.c"
{
#line 247 "gmpc-mpddata-model.gob"
	
            Self *self = GMPC_MPDDATA_MODEL(model);
            MpdData *data = iter->user_data;
            int n = GPOINTER_TO_INT(iter->user_data2) ;
            if(data == NULL &&  n == 0 && self->has_up == TRUE)
            {
                iter->user_data = (MpdData *)self->_priv->data; 
                iter->user_data2 = GINT_TO_POINTER(1);
                if(iter->user_data == NULL)
                    return FALSE;
                return TRUE;
            }
            if(mpd_data_get_next_real(data,FALSE) == NULL)
            {
                return FALSE;
            }
            iter->user_data = (MpdData *)mpd_data_get_next_real(data,FALSE); 
            iter->user_data2 = GINT_TO_POINTER(n+1);
            g_assert(n < self->_priv->num_rows);

            return TRUE;
        }}
#line 660 "gmpc-mpddata-model.c"
#undef __GOB_FUNCTION__

#line 271 "gmpc-mpddata-model.gob"
static gboolean 
gmpc_mpddata_model_iter_has_child (GtkTreeModel * self, GtkTreeIter * iter)
#line 666 "gmpc-mpddata-model.c"
{
#define __GOB_FUNCTION__ "Gmpc:MpdData:Model::iter_has_child"
#line 271 "gmpc-mpddata-model.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 271 "gmpc-mpddata-model.gob"
	g_return_val_if_fail (GTK_IS_TREE_MODEL (self), (gboolean )0);
#line 673 "gmpc-mpddata-model.c"
{
#line 273 "gmpc-mpddata-model.gob"
	
            return FALSE;
        }}
#line 679 "gmpc-mpddata-model.c"
#undef __GOB_FUNCTION__

#line 277 "gmpc-mpddata-model.gob"
static gint 
gmpc_mpddata_model_iter_n_children (GtkTreeModel * model, GtkTreeIter * iter)
#line 685 "gmpc-mpddata-model.c"
{
#define __GOB_FUNCTION__ "Gmpc:MpdData:Model::iter_n_children"
#line 277 "gmpc-mpddata-model.gob"
	g_return_val_if_fail (model != NULL, (gint )0);
#line 277 "gmpc-mpddata-model.gob"
	g_return_val_if_fail (GTK_IS_TREE_MODEL (model), (gint )0);
#line 692 "gmpc-mpddata-model.c"
{
#line 279 "gmpc-mpddata-model.gob"
	 
            Self *list = GMPC_MPDDATA_MODEL(model);
            if(iter)
                return 0;
            return list->_priv->num_rows;
        }}
#line 701 "gmpc-mpddata-model.c"
#undef __GOB_FUNCTION__

#line 287 "gmpc-mpddata-model.gob"
static gboolean 
gmpc_mpddata_model_iter_parent (GtkTreeModel * model, GtkTreeIter * iter, GtkTreeIter * child)
#line 707 "gmpc-mpddata-model.c"
{
#define __GOB_FUNCTION__ "Gmpc:MpdData:Model::iter_parent"
#line 287 "gmpc-mpddata-model.gob"
	g_return_val_if_fail (model != NULL, (gboolean )0);
#line 287 "gmpc-mpddata-model.gob"
	g_return_val_if_fail (GTK_IS_TREE_MODEL (model), (gboolean )0);
#line 714 "gmpc-mpddata-model.c"
{
#line 289 "gmpc-mpddata-model.gob"
	
            return FALSE;
        }}
#line 720 "gmpc-mpddata-model.c"
#undef __GOB_FUNCTION__

#line 292 "gmpc-mpddata-model.gob"
static void 
gmpc_mpddata_model_cover_art_fetched (mpd_Song * song, MetaDataResult ret, char * coverpath, GtkTreeRowReference * ref)
#line 726 "gmpc-mpddata-model.c"
{
#define __GOB_FUNCTION__ "Gmpc:MpdData:Model::cover_art_fetched"
{
#line 295 "gmpc-mpddata-model.gob"
	

            if(ref && ref)
            {
                GtkTreePath *path =gtk_tree_row_reference_get_path(ref);
                GtkTreeModel *model = gtk_tree_row_reference_get_model(ref);
                if(path && model)
                {
                    int size = cfg_get_single_value_as_int_with_default(config, "gmpc-mpddata-model", "icon-size", 64);
                    Self *self = GMPC_MPDDATA_MODEL(model);
                    GtkTreeIter iter;
                    gtk_tree_model_get_iter(model, &iter, path);
                    int n = GPOINTER_TO_INT(iter.user_data2) ;
                    if(ret == META_DATA_AVAILABLE)
                    {
                        GdkPixbuf *pb = gdk_pixbuf_new_from_file_at_size(coverpath,size,size,NULL);
                        screenshot_add_border(&pb);
                        if(self->_priv->images[n]) g_object_unref(self->_priv->images[n]); 
                        self->_priv->images[n] = pb;
                    }
                    else   if(ret == META_DATA_UNAVAILABLE)
                    {
                        GdkPixbuf *pb2;
                        pb2 = gtk_icon_theme_load_icon(gtk_icon_theme_get_default(), "gmpc-no-cover", size, 0,NULL);
                        if(self->_priv->images[n]) g_object_unref(self->_priv->images[n]); 
                        self->_priv->images[n] = pb2;
                    }
                    gtk_tree_model_row_changed(model,path, &iter);
                }

                if(ret == META_DATA_AVAILABLE || ret == META_DATA_UNAVAILABLE)
                {
                    if(ref)
                    {
                        gtk_tree_row_reference_free(ref);
                    }
                }
            }
        }}
#line 770 "gmpc-mpddata-model.c"
#undef __GOB_FUNCTION__

#line 336 "gmpc-mpddata-model.gob"
static void 
gmpc_mpddata_model_get_value (GtkTreeModel * model, GtkTreeIter * iter, gint column, GValue * value)
#line 776 "gmpc-mpddata-model.c"
{
#define __GOB_FUNCTION__ "Gmpc:MpdData:Model::get_value"
#line 336 "gmpc-mpddata-model.gob"
	g_return_if_fail (model != NULL);
#line 336 "gmpc-mpddata-model.gob"
	g_return_if_fail (GTK_IS_TREE_MODEL (model));
#line 336 "gmpc-mpddata-model.gob"
	g_return_if_fail (iter != NULL);
#line 336 "gmpc-mpddata-model.gob"
	g_return_if_fail (column >= 0);
#line 336 "gmpc-mpddata-model.gob"
	g_return_if_fail (column < MPDDATA_MODEL_N_COLUMNS);
#line 336 "gmpc-mpddata-model.gob"
	g_return_if_fail (value != NULL);
#line 791 "gmpc-mpddata-model.c"
{
#line 338 "gmpc-mpddata-model.gob"
	
            Self *self = GMPC_MPDDATA_MODEL(model);
            MpdData_real *data = iter->user_data;	
            int n = GPOINTER_TO_INT(iter->user_data2);

            /* set value to the correct type */
            g_value_init(value, self->_priv->types[column]);

            /** 
             * Sanity checks 
             */
             g_assert((n < self->_priv->num_rows || n == 0));
            g_assert(!(data == NULL && n != 0));

            /* handle row up */
            if(data == NULL && n == 0)
            {
                switch(column)
                {
                    case MPDDATA_MODEL_COL_ICON_ID:
                        g_value_set_string(value, GTK_STOCK_GO_UP);
                        break;
                    case MPDDATA_MODEL_ROW_TYPE:
                        /**
                         * Make define 
                         */
                        g_value_set_int(value, -1);
                        break;
                    case MPDDATA_MODEL_COL_SONG_TITLE:
                    case MPDDATA_MODEL_COL_MARKUP:
                        {
                            g_value_set_string(value,"..");
                            break;
                        }
                    default:
                        break;
                }
                return;
            }

            if(column == MPDDATA_MODEL_META_DATA)
            {
                if(self->_priv->images[n] == NULL)
                {
                    int size = cfg_get_single_value_as_int_with_default(config, "gmpc-mpddata-model", "icon-size", 64);
                    if(data->type == MPD_DATA_TYPE_TAG && data->tag_type == MPD_TAG_ITEM_ARTIST)
                    {
                        mpd_Song *song;
                        GtkTreePath *path;
                        GtkTreeRowReference *ref;
                        self->_priv->images[n] = gtk_icon_theme_load_icon(gtk_icon_theme_get_default(), "gmpc-loading-cover", size, 0,NULL);
                        song = mpd_newSong();
                        song->artist = g_strdup(data->tag);
                        song->album = NULL; 
                        path = gtk_tree_model_get_path(GTK_TREE_MODEL(self), iter);
                        ref = gtk_tree_row_reference_new(GTK_TREE_MODEL(self),path);
                        gmpc_meta_watcher_get_meta_path_callback(gmw,song, META_ARTIST_ART, (MetaDataCallback)self_cover_art_fetched, (gpointer)ref);
                        mpd_freeSong(song);	
                        gtk_tree_path_free(path);
                    }

                    else if(data->type == MPD_DATA_TYPE_TAG && data->tag_type == MPD_TAG_ITEM_ALBUM && self->_priv->req_artist)
                    {
                        mpd_Song *song;
                        GtkTreePath *path;
                        GtkTreeRowReference *ref;
                        self->_priv->images[n] = gtk_icon_theme_load_icon(gtk_icon_theme_get_default(), "gmpc-loading-cover", size, 0,NULL);
                        song = mpd_newSong();
                        song->artist = g_strdup(self->_priv->req_artist); 
                        song->album = g_strdup(data->tag);
                        path = gtk_tree_model_get_path(GTK_TREE_MODEL(self), iter);
                        ref = gtk_tree_row_reference_new(GTK_TREE_MODEL(self),path);
                        gmpc_meta_watcher_get_meta_path_callback(gmw,song, META_ALBUM_ART, (MetaDataCallback)self_cover_art_fetched, ref);
                        mpd_freeSong(song);	
                        gtk_tree_path_free(path);
                    }
                    else 
                    {
                        self->_priv->images[n] = gtk_icon_theme_load_icon(gtk_icon_theme_get_default(), "gmpc-no-cover", size, 0,NULL);
                    }
                }
                g_value_set_object(value, self->_priv->images[n]);
            }
            /* handle row type, this is independent of the row type */
            if(column == MPDDATA_MODEL_ROW_TYPE)
            {
                g_value_set_int(value, data->type);
                return;
            } 
            if (data->type == MPD_DATA_TYPE_TAG) {
                switch(column)
                {
                    case MPDDATA_MODEL_COL_ICON_ID:
                        switch(data->tag_type) 
                        {
                            case MPD_TAG_ITEM_ALBUM:
                                g_value_set_string(value, "media-album");
                                break;
                            case MPD_TAG_ITEM_ARTIST:
                                g_value_set_string(value, "media-artist");
                                break;
                            default:
                                g_value_set_string(value, "media-tag");
                        }
                        break;
                    case MPDDATA_MODEL_COL_SONG_TITLE:
                    case MPDDATA_MODEL_COL_MARKUP:
                        {
                            g_value_set_string(value, data->tag);
                            break;
                        }
                    case MPDDATA_MODEL_COL_PATH:
                        g_value_set_string(value, data->tag);
                        break;                                         		
                    case MPDDATA_MODEL_TAG_TYPE:
                        g_value_set_int(value, data->tag_type);
                        break;                                         		
                    default:
                        break;
                }
            } else if(data->type == MPD_DATA_TYPE_DIRECTORY) {
                switch(column)
                {
                    case MPDDATA_MODEL_COL_ICON_ID:
                        g_value_set_string(value, GTK_STOCK_OPEN);
                        break;
                    case MPDDATA_MODEL_COL_SONG_TITLE:
                    case MPDDATA_MODEL_COL_SONG_TITLEFILE:
                    case MPDDATA_MODEL_COL_MARKUP:
                        {
                            gchar *basename = g_path_get_basename(data->directory);
                            g_value_set_string(value, basename);
                            g_free(basename);
                            break;
                        }
                    case MPDDATA_MODEL_COL_PATH:
                        g_value_set_string(value, data->directory);
                        break;                                         		
                    default:
                        break;
                }
            }
            else if(data->type == MPD_DATA_TYPE_PLAYLIST)
            {
                switch(column)
                {
                    case MPDDATA_MODEL_COL_ICON_ID:
                        g_value_set_string(value, "media-playlist");
                        break;
                    case MPDDATA_MODEL_COL_SONG_TITLE:
                    case MPDDATA_MODEL_COL_SONG_TITLEFILE:
                    case MPDDATA_MODEL_COL_MARKUP:
                        {
                            gchar *basename = g_path_get_basename(data->playlist);
                            g_value_set_string(value, basename);
                            g_free(basename);
                            break;
                        }
                    case MPDDATA_MODEL_COL_PATH:
                        g_value_set_string(value, data->playlist);
                        break;                                         		
                    default:
                        break;
                }
            }
            else if(data->type == MPD_DATA_TYPE_SONG)
            {
                mpd_Song *song = data->song;
                switch (column) {
                    case MPDDATA_MODEL_COL_MPDSONG:
                        g_value_set_pointer(value, song);
                        break;
                    case MPDDATA_MODEL_COL_PLAYING:
                        g_value_set_boolean(value, FALSE);
                        break;
                    case MPDDATA_MODEL_COL_PLAYING_FONT_WEIGHT:
                        g_value_set_int(value, PANGO_WEIGHT_NORMAL);
                        break;
                    case MPDDATA_MODEL_COL_MARKUP:
                        {
                            /* we want to go cache this stuff */
                            gchar buffer[1024];
                            mpd_song_markup(buffer, 1024, GMPC_MPDDATA_MODEL(model)->_priv->markup, song);
                            g_value_set_string(value, buffer);
                            break;
                        }
                    case MPDDATA_MODEL_COL_PATH:
                        g_value_set_string(value, song->file);
                        break;
                    case MPDDATA_MODEL_COL_SONG_ARTIST:
                        g_value_set_string(value, song->artist);
                        break;
                    case MPDDATA_MODEL_COL_SONG_ALBUM:
                        g_value_set_string(value, song->album);
                        break;
                    case MPDDATA_MODEL_COL_SONG_TITLE:
                        /* If there is a song available use that, else use the filename */
                        if(song->title) {
                            g_value_set_string(value, song->title);
                        } else {
                            /* Use the markup stuff, this makes sure it gets processed equaly */
                            gchar buffer[1024];
                            mpd_song_markup(buffer, 1024, "%shortfile%", song);
                            g_value_set_string(value, buffer);
                        }
                        break;
                    case MPDDATA_MODEL_COL_SONG_TITLEFILE:
                        {
                            gchar *path = g_path_get_basename(song->file);
                            g_value_set_string(value, path);
                            g_free(path);
                        }
                        break;                                       			
                    case MPDDATA_MODEL_COL_SONG_GENRE:
                        g_value_set_string(value, song->genre);
                        break;
                    case MPDDATA_MODEL_COL_SONG_TRACK:
                        g_value_set_string(value, song->track);
                        break;
                    case MPDDATA_MODEL_COL_SONG_NAME:
                        g_value_set_string(value, song->name);
                        break;
                    case MPDDATA_MODEL_COL_SONG_COMPOSER:
                        g_value_set_string(value, song->composer);
                        break;
                    case MPDDATA_MODEL_COL_SONG_PERFORMER:
                        g_value_set_string(value, song->performer);
                        break;
                    case MPDDATA_MODEL_COL_SONG_DATE:
                        g_value_set_string(value, song->date);
                        break;
                    case MPDDATA_MODEL_COL_SONG_LENGTH:
                        g_value_set_int(value, song->time);
                        break;
                    case MPDDATA_MODEL_COL_SONG_LENGTH_FORMAT:
                        {
                            if(song->time >= 0) {
                                gchar *data = g_strdup_printf("%02i:%02i",
                                        song->time/60, song->time%60);
                                g_value_set_string(value, data);
                                g_free(data);
                            } else {
                                g_value_set_string(value, "n/a");
                            }
                        }
                        break;                             			
                    case MPDDATA_MODEL_COL_SONG_DISC:
                        g_value_set_string(value, song->disc);
                        break;
                    case MPDDATA_MODEL_COL_SONG_COMMENT:
                        g_value_set_string(value, song->comment);
                        break;                                			
                    case MPDDATA_MODEL_COL_SONG_POS:
                        g_value_set_int(value, song->pos);
                        break;
                    case MPDDATA_MODEL_COL_SONG_ID:
                        g_value_set_int(value, song->id);
                        break;

                    case MPDDATA_MODEL_COL_ICON_ID:
                        if (strstr(song->file, "://")) {
                            g_value_set_string(value, "media-stream");
                        } else {
                            g_value_set_string(value, "media-audiofile");
                        }
                        break;
                }
            }
        }}
#line 1063 "gmpc-mpddata-model.c"
#undef __GOB_FUNCTION__

#line 609 "gmpc-mpddata-model.gob"
static gboolean 
gmpc_mpddata_model_iter_nth_child (GtkTreeModel * model, GtkTreeIter * iter, GtkTreeIter * parent, gint n)
#line 1069 "gmpc-mpddata-model.c"
{
#define __GOB_FUNCTION__ "Gmpc:MpdData:Model::iter_nth_child"
#line 609 "gmpc-mpddata-model.gob"
	g_return_val_if_fail (model != NULL, (gboolean )0);
#line 609 "gmpc-mpddata-model.gob"
	g_return_val_if_fail (GTK_IS_TREE_MODEL (model), (gboolean )0);
#line 609 "gmpc-mpddata-model.gob"
	g_return_val_if_fail (iter != NULL, (gboolean )0);
#line 609 "gmpc-mpddata-model.gob"
	g_return_val_if_fail (n >= 0, (gboolean )0);
#line 1080 "gmpc-mpddata-model.c"
{
#line 611 "gmpc-mpddata-model.gob"
	
            Self *self = GMPC_MPDDATA_MODEL(model);
            int i;
            MpdData *data = NULL;
            if(parent)
                return FALSE;
            if (n >= self->_priv->num_rows || n < 0)
                return FALSE; 

            data = (MpdData *)self->_priv->data;
            i=0;
            if(self->has_up)
                i=1;
            for(; i < (n);i++)
            {
                data = mpd_data_get_next_real(data, FALSE);
            }

            if(self->has_up && n == 0)
                data = NULL;

            iter->stamp = self->_priv->stamp;
            iter->user_data = data; 
            iter->user_data2 = GINT_TO_POINTER(n);
            return TRUE;
        }}
#line 1109 "gmpc-mpddata-model.c"
#undef __GOB_FUNCTION__

#line 639 "gmpc-mpddata-model.gob"
static GtkTreePath * 
gmpc_mpddata_model_get_path (GtkTreeModel * self, GtkTreeIter * iter)
#line 1115 "gmpc-mpddata-model.c"
{
#define __GOB_FUNCTION__ "Gmpc:MpdData:Model::get_path"
#line 639 "gmpc-mpddata-model.gob"
	g_return_val_if_fail (self != NULL, (GtkTreePath * )0);
#line 639 "gmpc-mpddata-model.gob"
	g_return_val_if_fail (GTK_IS_TREE_MODEL (self), (GtkTreePath * )0);
#line 639 "gmpc-mpddata-model.gob"
	g_return_val_if_fail (iter != NULL, (GtkTreePath * )0);
#line 1124 "gmpc-mpddata-model.c"
{
#line 641 "gmpc-mpddata-model.gob"
	
            GtkTreePath *path = NULL;
            path = gtk_tree_path_new();
            gtk_tree_path_append_index(path, GPOINTER_TO_INT(iter->user_data2));
            return path;
        }}
#line 1133 "gmpc-mpddata-model.c"
#undef __GOB_FUNCTION__

#line 649 "gmpc-mpddata-model.gob"
static GType 
gmpc_mpddata_model_get_column_type (GtkTreeModel * model, gint index)
#line 1139 "gmpc-mpddata-model.c"
{
#define __GOB_FUNCTION__ "Gmpc:MpdData:Model::get_column_type"
#line 649 "gmpc-mpddata-model.gob"
	g_return_val_if_fail (model != NULL, (GType )0);
#line 649 "gmpc-mpddata-model.gob"
	g_return_val_if_fail (GTK_IS_TREE_MODEL (model), (GType )0);
#line 649 "gmpc-mpddata-model.gob"
	g_return_val_if_fail (index >= 0, (GType )0);
#line 1148 "gmpc-mpddata-model.c"
{
#line 651 "gmpc-mpddata-model.gob"
	
            Self *self = GMPC_MPDDATA_MODEL(model);
            return self->_priv->types[index];
        }}
#line 1155 "gmpc-mpddata-model.c"
#undef __GOB_FUNCTION__

#line 655 "gmpc-mpddata-model.gob"
void 
gmpc_mpddata_model_set_request_artist (GmpcMpdDataModel * self, const char * artist)
#line 1161 "gmpc-mpddata-model.c"
{
#define __GOB_FUNCTION__ "Gmpc:MpdData:Model::set_request_artist"
#line 655 "gmpc-mpddata-model.gob"
	g_return_if_fail (self != NULL);
#line 655 "gmpc-mpddata-model.gob"
	g_return_if_fail (GMPC_IS_MPDDATA_MODEL (self));
#line 1168 "gmpc-mpddata-model.c"
{
#line 658 "gmpc-mpddata-model.gob"
	
            if(self->_priv->req_artist) 
                q_free(self->_priv->req_artist);
            self->_priv->req_artist = (artist != NULL)?g_strdup(artist):NULL;
        }}
#line 1176 "gmpc-mpddata-model.c"
#undef __GOB_FUNCTION__

#line 663 "gmpc-mpddata-model.gob"
long unsigned 
gmpc_mpddata_model_set_mpd_data (GmpcMpdDataModel * self, MpdData * data2)
#line 1182 "gmpc-mpddata-model.c"
{
#define __GOB_FUNCTION__ "Gmpc:MpdData:Model::set_mpd_data"
#line 663 "gmpc-mpddata-model.gob"
	g_return_val_if_fail (self != NULL, (long unsigned )0);
#line 663 "gmpc-mpddata-model.gob"
	g_return_val_if_fail (GMPC_IS_MPDDATA_MODEL (self), (long unsigned )0);
#line 1189 "gmpc-mpddata-model.c"
{
#line 665 "gmpc-mpddata-model.gob"
	
            int i;
            long unsigned retval = 0;
            GtkTreeIter iter;
            GtkTreePath *path = NULL;
            /* Do some cleanup, like removing rows, and so */
            /* loop and remove */
            while ( self->_priv->num_rows > 0 ) {
                path = gtk_tree_path_new();
                gtk_tree_path_append_index(path, self->_priv->num_rows - 1 );
                /* propegate change */
                gtk_tree_model_row_deleted(GTK_TREE_MODEL(self), path);
                gtk_tree_path_free(path);
                self->_priv->num_rows--;
            }


            /**
             * Free if there is a list and set it to NULL 
             */
            if(self->_priv->data)
                mpd_data_free(self->_priv->data);
            self->_priv->data = NULL;

            if(self->_priv->num_rows != 0)
                debug_printf(DEBUG_ERROR,"not every row cleared %i\n",self->_priv->num_rows);
            self->_priv->num_rows =0;

            /* Free possible stored images */
            if(self->_priv->images)
            {
                for(i=0;i<self->_priv->num_rows;i++)
                {
                    if(self->_priv->images[i])
                        g_object_unref(self->_priv->images[i]);
                }
                q_free(self->_priv->images);
            }
            if(data2 == NULL)
                return 0;

            self->_priv->data = mpd_data_get_first(data2);
            data2 = NULL;
            if(self->_priv->sort_column == MPDDATA_MODEL_COL_ICON_ID)
            {
                self->_priv->data = misc_sort_mpddata_by_album_disc_track(self->_priv->data);
            }
            else if ( self->_priv->sort_column != GTK_TREE_SORTABLE_UNSORTED_SORT_COLUMN_ID )
            {
                self->_priv->data = misc_sort_mpddata(self->_priv->data,(GCompareDataFunc)self_sort_func,self ); 
            }

            if(self->has_up) {
                path = gtk_tree_path_new();
                gtk_tree_path_append_index(path, self->_priv->num_rows);
                iter.stamp = self->_priv->stamp;
                iter.user_data = NULL; 
                iter.user_data2 =  GINT_TO_POINTER(self->_priv->num_rows);

                /* propegate change */
                gtk_tree_model_row_inserted(GTK_TREE_MODEL(self), path, &iter);
                gtk_tree_path_free(path);
                self->_priv->num_rows++;
            }
            for(data2 = mpd_data_get_first(self->_priv->data);data2; data2 = mpd_data_get_next_real(data2,FALSE)) {
                path = gtk_tree_path_new();
                gtk_tree_path_append_index(path,self->_priv->num_rows);
                iter.stamp = self->_priv->stamp;
                iter.user_data = data2;
                iter.user_data2 =  GINT_TO_POINTER(self->_priv->num_rows);

                /* propegate change */
                gtk_tree_model_row_inserted(GTK_TREE_MODEL(self), path, &iter);
                gtk_tree_path_free(path);
                self->_priv->num_rows++;
                if(data2->type == MPD_DATA_TYPE_SONG)
                {
                    retval+= data2->song->time;
                }
            }
            self->_priv->images = g_malloc0((self->_priv->num_rows)*sizeof(*(self->_priv->images)));

            return retval;
        }}
#line 1276 "gmpc-mpddata-model.c"
#undef __GOB_FUNCTION__

#line 752 "gmpc-mpddata-model.gob"
static gboolean 
gmpc_mpddata_model_get_sort_column_id (GtkTreeSortable * model, gint * sort_column_id, GtkSortType * order)
#line 1282 "gmpc-mpddata-model.c"
{
#define __GOB_FUNCTION__ "Gmpc:MpdData:Model::get_sort_column_id"
{
#line 754 "gmpc-mpddata-model.gob"
	
            Self *self = GMPC_MPDDATA_MODEL(model);
            if(sort_column_id) 
                *sort_column_id = self->_priv->sort_column;
            if(order)
                *order = self->_priv->sort_order;
            return TRUE;
        }}
#line 1295 "gmpc-mpddata-model.c"
#undef __GOB_FUNCTION__

#line 764 "gmpc-mpddata-model.gob"
static void 
gmpc_mpddata_model_set_sort_column_id (GtkTreeSortable * model, gint sort_column_id, GtkSortType order)
#line 1301 "gmpc-mpddata-model.c"
{
#define __GOB_FUNCTION__ "Gmpc:MpdData:Model::set_sort_column_id"
{
#line 766 "gmpc-mpddata-model.gob"
	
            Self *self = GMPC_MPDDATA_MODEL(model);
            int old_col = self->_priv->sort_column, old_ord = self->_priv->sort_order;
/*            if(sort_column_id == -1)
                return;
  */          self->_priv->sort_column = sort_column_id;
            self->_priv->sort_order = order;
            /* trigger signal */
            if(old_col != sort_column_id || old_ord != order)
                gtk_tree_sortable_sort_column_changed(model);
            self->_priv->old_sort_column = self->_priv->sort_column;

        }}
#line 1319 "gmpc-mpddata-model.c"
#undef __GOB_FUNCTION__

#line 781 "gmpc-mpddata-model.gob"
static gboolean 
gmpc_mpddata_model_has_default_sort_func (GtkTreeSortable * model)
#line 1325 "gmpc-mpddata-model.c"
{
#define __GOB_FUNCTION__ "Gmpc:MpdData:Model::has_default_sort_func"
{
#line 784 "gmpc-mpddata-model.gob"
	
            return FALSE;
        }}
#line 1333 "gmpc-mpddata-model.c"
#undef __GOB_FUNCTION__

#line 787 "gmpc-mpddata-model.gob"
static int 
gmpc_mpddata_model_sort_func (gpointer ppaa, gpointer ppbb, Self * self)
#line 1339 "gmpc-mpddata-model.c"
{
#define __GOB_FUNCTION__ "Gmpc:MpdData:Model::sort_func"
{
#line 789 "gmpc-mpddata-model.gob"
	
            MpdData_real *a = *(MpdData_real **)ppaa;
            MpdData_real *b = *(MpdData_real **)ppbb;
            int fact = (self->_priv->sort_order == GTK_SORT_ASCENDING)?-1:1;

            if(a->type != b->type )
            {
                int val = a->type - b->type; 
                return val; 
            }
            else if(a->type == b->type)
            {
                int val=0;
                GtkTreeIter iter;
                GValue va = {0,},vb = {0,};
                /* if the type is a directory or a tag, always sort on the title column */
                if(a->type == MPD_DATA_TYPE_DIRECTORY || b->type == MPD_DATA_TYPE_TAG)
                {
                    const char *ca,*cb;
                    iter.user_data = a;
                    iter.user_data2 = GPOINTER_TO_INT(0);
                    self_get_value(GTK_TREE_MODEL(self), &iter, MPDDATA_MODEL_COL_SONG_TITLE, &va);
                    iter.user_data = b;
                    self_get_value(GTK_TREE_MODEL(self), &iter, MPDDATA_MODEL_COL_SONG_TITLE, &vb);
                    ca = g_value_get_string(&va);
                    cb = g_value_get_string(&vb);
                    if(ca && cb) {
                        gchar *aa,*bb;
                        aa = g_utf8_strdown(ca, -1);
                        bb = g_utf8_strdown(cb, -1);
                        val = g_utf8_collate(aa,bb);
                        g_free(aa);
                        g_free(bb);
                    } else {
                        val = (ca == NULL)?((cb==NULL)?0:-1):1;
                    }
                    g_value_unset(&va);
                    g_value_unset(&vb);
                    /* return */
                    return val*fact;
                }
                /* Get values from tree view, so we don't have to replicate code to sort the right entries */
                iter.user_data = a;
                iter.user_data2 = GPOINTER_TO_INT(0);
                self_get_value(GTK_TREE_MODEL(self), &iter, self->_priv->sort_column, &va);
                iter.user_data = b;
                self_get_value(GTK_TREE_MODEL(self), &iter, self->_priv->sort_column, &vb);
                if(self->_priv->sort_column == MPDDATA_MODEL_COL_SONG_TRACK)
                {
                    const char *a = g_value_get_string(&va);
                    const char *b = g_value_get_string(&vb);
                    gint a1 = (a)?atoi(a):0;
                    gint b1 = (b)?atoi(b):0;
                    g_value_unset(&va);
                    g_value_unset(&vb);
                    return fact*(a1-b1);
                }
                else if(self->_priv->types[self->_priv->sort_column] == G_TYPE_INT)
                {
                    val = g_value_get_int(&va) - g_value_get_int(&vb);
                }
                else if (self->_priv->types[self->_priv->sort_column] == G_TYPE_STRING)
                {
                    const char *a = g_value_get_string(&va);
                    const char *b = g_value_get_string(&vb);
                    if(a && b) {
                        gchar *aa,*bb;
                        aa = g_utf8_strdown(a, -1);
                        bb = g_utf8_strdown(b, -1);
                        val = g_utf8_collate(aa,bb);
                        g_free(aa);
                        g_free(bb);
                    } else {
                        val = (a == NULL)?((b==NULL)?0:-1):1;
                    }
                }
                g_value_unset(&va);
                g_value_unset(&vb);
                return fact*val; 
            }
            return 0;
        }}
#line 1426 "gmpc-mpddata-model.c"
#undef __GOB_FUNCTION__

#line 873 "gmpc-mpddata-model.gob"
static void 
gmpc_mpddata_model_sort_column_changed (GtkTreeSortable * model)
#line 1432 "gmpc-mpddata-model.c"
{
#define __GOB_FUNCTION__ "Gmpc:MpdData:Model::sort_column_changed"
{
#line 876 "gmpc-mpddata-model.gob"
	
            Self *self = GMPC_MPDDATA_MODEL(model);
            if(!self->_priv->data || !(((MpdData_real *)self->_priv->data)->next))
                return; 
            if(self->_priv->sort_column == MPDDATA_MODEL_COL_ICON_ID)
            {
                self->_priv->data = misc_sort_mpddata_by_album_disc_track(self->_priv->data); 
            }
            else if(self->_priv->sort_column !=  GTK_TREE_SORTABLE_UNSORTED_SORT_COLUMN_ID)
            {
                self->_priv->data = misc_sort_mpddata(self->_priv->data,(GCompareDataFunc)self_sort_func,self ); 
            }
            self->_priv->old_sort_column = self->_priv->sort_column;

            /* tell the view that rows have changed  */    
            {
                int i=0;
                GtkTreePath *path = NULL;
                GtkTreeIter iter;
                MpdData *data2 = mpd_data_get_first(self->_priv->data); 
                if(self->has_up) i = 1;
                for(;data2; data2 = mpd_data_get_next_real(data2,FALSE)) 
                {
                    path = gtk_tree_path_new();
                    gtk_tree_path_append_index(path,i);
                    iter.stamp = self->_priv->stamp;
                    iter.user_data = data2;
                    iter.user_data2 =  GINT_TO_POINTER(i);

                    /* propegate change */
                    gtk_tree_model_row_changed(GTK_TREE_MODEL(self), path, &iter);
                    i++;
                }
            }
        }}
#line 1472 "gmpc-mpddata-model.c"
#undef __GOB_FUNCTION__
