------------------------------------------------------------------------------
--  Thin Ada95 binding to OCI (Oracle Call Interface)                    --
--  Copyright (C) 2000-2003 Dmitriy Anisimkov.                              --
--  License agreement and authors contact information are in file oci.ads   --
------------------------------------------------------------------------------

--  $Id: oci-thick-string_bounded.ads,v 1.3 2003/11/27 12:34:00 vagul Exp $

with OCI.Lib;
with OCI.Thick.Statements;

package OCI.Thick.String_Bounded is

   use Lib, Statements;

   subtype String_Size is C.Size_t;

   type Variable(Length : String_Size) is new Limited_Variable with
   private;

   procedure Bind (Stmt : Statement; Value : in out Variable; Name : String);
   procedure Bind (Stmt : Statement; Value : in out Variable; Position : Positive);
   procedure Define (Stmt : Statement; Value : in out Variable; Position : Positive);
   procedure Set_Value (Var : in out Variable; Value : String);
   function Get_Value (Var : Variable'Class) return String;

   function Value (Var : Variable'Class) return String renames Get_Value;
   function String_Value (Var : Variable'Class) return String renames Get_Value;

private

   type Variable (Length : String_Size) is new Limited_Variable with
   record
      Value : C.Char_Array (0 .. Length);
   end record;

end OCI.Thick.String_Bounded;