------------------------------------------------------------------------------
--                                                                          --
--                GNU ADA RUN-TIME LIBRARY (GNARL) COMPONENTS               --
--                                                                          --
--                 I N T E R F A C E S . V X W O R K S . I O                --
--                                                                          --
--                                  S p e c                                 --
--                                                                          --
--                             $Revision: 1.1 $
--                                                                          --
--             Copyright (C) 2002, Free Software Foundation, Inc.           --
--                                                                          --
-- GNARL is free software; you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion. GNARL is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNARL; see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- As a special exception,  if other files  instantiate  generics from this --
-- unit, or you link  this unit with other files  to produce an executable, --
-- this  unit  does not  by itself cause  the resulting  executable  to  be --
-- covered  by the  GNU  General  Public  License.  This exception does not --
-- however invalidate  any other reasons why  the executable file  might be --
-- covered by the  GNU Public License.                                      --
--                                                                          --
-- GNARL was developed by the GNARL team at Florida State University. It is --
-- now maintained by Ada Core Technologies Inc. in cooperation with Florida --
-- State University (http://www.gnat.com).                                  --
--                                                                          --
------------------------------------------------------------------------------

with Interfaces.C_Streams;

package Interfaces.VxWorks.IO is

   ------------------------------------------------------------------------
   --  Here is an example that shows how to use Enable_Get_Immediate and
   --  Disable_Get_Immediate:
   --  with Ada.Text_IO; use Ada.Text_IO;
   --  with Ada.Text_IO.C_Streams; use Ada.Text_IO.C_Streams;
   --  with Interfaces.VxWorks.IO; use Interfaces.VxWorks.IO;

   --  procedure Example_IO is
   --     Input     : Character;
   --     Available : Boolean;
   --     Success   : Boolean;
   --
   --  begin
   --     Enable_Get_Immediate (C_Stream (Current_Input), Success);
   --     if Success = False then
   --        raise Device_Error;
   --     end if;
   --
   --     --  Example with the first type of Get_Immediate
   --     --  Waits for an entry on the input. Immediately returns
   --     --  after having received an character on the input
   --     Put ("Input -> ");
   --     Get_Immediate (Input);
   --     New_Line;
   --     Put_Line ("Character read: " & Input);
   --
   --     --  Example with the second type of Get_Immediate
   --     --  This is equivalent to a non blocking read
   --     for J in 1 .. 10 loop
   --        Put ("Input -> ");
   --        Get_Immediate (Input, Available);
   --        New_Line;
   --
   --        if Available = True then
   --           Put_Line ("Character read: " & Input);
   --        end if;
   --        delay 1.0;
   --     end loop;
   --
   --     Disable_Get_Immediate (C_Stream (Current_Input), Success);
   --     if Success = False then
   --        raise Device_Error;
   --     end if;
   --
   --  exception
   --     when Device_Error =>
   --        Put_Line ("Device Error. Check your configuration");
   --  end Example_IO;

   package CSTR renames Interfaces.C_Streams;

   type FUNCODE is new int;
   --  Type of the function codes in ioctl

   type IOOPT is mod 2 ** int'Size;
   --  Type of the option codes in ioctl

   --  ioctl function codes
   --  For more information see ioLib.h
   FIONREAD       : constant FUNCODE := 1;
   FIOFLUSH       : constant FUNCODE := 2;
   FIOOPTIONS     : constant FUNCODE := 3;
   FIOBAUDRATE    : constant FUNCODE := 4;
   FIODISKFORMAT  : constant FUNCODE := 5;
   FIODISKINIT    : constant FUNCODE := 6;
   FIOSEEK        : constant FUNCODE := 7;
   FIOWHERE       : constant FUNCODE := 8;
   FIODIRENTRY    : constant FUNCODE := 9;
   FIORENAME      : constant FUNCODE := 10;
   FIOREADYCHANGE : constant FUNCODE := 11;
   FIONWRITE      : constant FUNCODE := 12;
   FIODISKCHANGE  : constant FUNCODE := 13;
   FIOCANCEL      : constant FUNCODE := 14;
   FIOSQUEEZE     : constant FUNCODE := 15;
   FIONBIO        : constant FUNCODE := 16;
   FIONMSGS       : constant FUNCODE := 17;
   FIOGETNAME     : constant FUNCODE := 18;
   FIOGETOPTIONS  : constant FUNCODE := 19;
   FIOSETOPTIONS  : constant FUNCODE := FIOOPTIONS;
   FIOISATTY      : constant FUNCODE := 20;
   FIOSYNC        : constant FUNCODE := 21;
   FIOPROTOHOOK   : constant FUNCODE := 22;
   FIOPROTOARG    : constant FUNCODE := 23;
   FIORBUFSET     : constant FUNCODE := 24;
   FIOWBUFSET     : constant FUNCODE := 25;
   FIORFLUSH      : constant FUNCODE := 26;
   FIOWFLUSH      : constant FUNCODE := 27;
   FIOSELECT      : constant FUNCODE := 28;
   FIOUNSELECT    : constant FUNCODE := 29;
   FIONFREE       : constant FUNCODE := 30;
   FIOMKDIR       : constant FUNCODE := 31;
   FIORMDIR       : constant FUNCODE := 32;
   FIOLABELGET    : constant FUNCODE := 33;
   FIOLABELSET    : constant FUNCODE := 34;
   FIOATTRIBSE    : constant FUNCODE := 35;
   FIOCONTIG      : constant FUNCODE := 36;
   FIOREADDIR     : constant FUNCODE := 37;
   FIOFSTATGET    : constant FUNCODE := 38;
   FIOUNMOUNT     : constant FUNCODE := 39;
   FIOSCSICOMMAND : constant FUNCODE := 40;
   FIONCONTIG     : constant FUNCODE := 41;
   FIOTRUNC       : constant FUNCODE := 42;
   FIOGETFL       : constant FUNCODE := 43;
   FIOTIMESET     : constant FUNCODE := 44;
   FIOINODETONAM  : constant FUNCODE := 45;
   FIOFSTATFSGE   : constant FUNCODE := 46;

   --  ioctl option values
   OPT_ECHO     : constant IOOPT := 16#0001#;
   OPT_CRMOD    : constant IOOPT := 16#0002#;
   OPT_TANDEM   : constant IOOPT := 16#0004#;
   OPT_7_BIT    : constant IOOPT := 16#0008#;
   OPT_MON_TRAP : constant IOOPT := 16#0010#;
   OPT_ABORT    : constant IOOPT := 16#0020#;
   OPT_LINE     : constant IOOPT := 16#0040#;
   OPT_RAW      : constant IOOPT := 16#0000#;
   OPT_TERMINAL : constant IOOPT := OPT_ECHO or OPT_CRMOD or OPT_TANDEM or
     OPT_MON_TRAP or OPT_7_BIT or OPT_ABORT or OPT_LINE;

   procedure Enable_Get_Immediate (File : CSTR.FILEs; Success : out Boolean);
   --  On VxWorks, a call to this procedure is required before subsequent calls
   --  to Get_Immediate have the desired effect of not waiting for a line
   --  return. The reason that this call is not automatic on such targets is
   --  that the call flushes the input buffer, discarding any previous input.
   --  NOTE that once Get_Immediate is enabled, you should only do
   --  Get_Immediate operations. Other Text_IO operations may not have the
   --  desired behavior.

   procedure Disable_Get_Immediate (File : CSTR.FILEs; Success : out Boolean);
   --  Use this function to reset File to its standard mode

   function fileno (Fp : CSTR.FILEs) return int;
   --  Binding to the C routine fileno

   function ioctl (Fd : int; Function_Code : FUNCODE; Arg : IOOPT) return int;
   --  Binding to the C routine ioctl

private

   pragma Import (C, fileno, "fileno");
   pragma Import (C, ioctl, "ioctl");

end Interfaces.VxWorks.IO;
