/* gnobog.h
 *
 * Copyright (C) 2000 Frdric LESPEZ & Renaud CHAILLAT
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef GNOBOG_APP_H
#define GNOBOG_APP_H

#include <gnome.h>
#include "gnobog_bookmarks.h"
#include "gnobog_arborescence.h"

//typedef struct _GnobogData GnobogData;
//struct _GnobogData {
//      /* Clipboard */
//      GList*          clipboard;
//};

gchar*      home_dir;

GtkWidget*  gnobog_app_new
                      (void);
GtkWidget*  gnobog_app_get_app
                      (void);
GtkWidget*  gnobog_app_get_active_view
                      (void);
void        gnobog_app_document_load 
                      (gchar* filename);
void        gnobog_app_document_new 
                      (void);
void        gnobog_app_document_new_from_selection 
                      (void);
void        gnobog_app_document_save 
                      (GnobogBookmarks* bookmarks);
void        gnobog_app_document_save_as 
                      (GnobogBookmarks* bookmarks);
void        gnobog_app_document_save_copy_as 
                      (GnobogBookmarks* bookmarks);
//void      gnobog_app_document_save_as_ui 
//                    (GnobogBookmarks* bookmarks);
void        gnobog_app_document_close 
                      (gpointer data);
void        gnobog_app_document_close_window 
                      (GtkWidget* window, 
                       gpointer data);
void        gnobog_app_document_close_all 
                      (void);
void        gnobog_app_document_window_new 
                      (GnobogBookmarks* bookmarks);
void        gnobog_app_quit
                      (GtkWidget* gnobog_app);

void        gnobog_app_copy_to_clipboard 
                      (GnobogBookmarks* source_bookmarks, 
                       GList* bookmarks_list);
void        gnobog_app_paste_from_clipboard 
                      (GnobogBookmarks* target_bookmarks, 
                       GnobogBookmarksNode anchor_node, 
                       GnobogBookmarksInsertMode insert_mode);
void        gnobog_app_clear_clipboard 
                      (void);
gboolean    gnobog_app_is_clipboard_empty 
                      (void);

void        gnobog_app_toggle_split_view 
                      (GnobogArborescence* arborescence);
void        gnobog_app_toggle_selection_all 
                      (void);

#endif

/* GNOBOG_APP_H */
