/******************************************************************************\
 gnofin/date.h   $Revision: 1.3 $
 Copyright (C) 1999-2000 Darin Fisher

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\******************************************************************************/

#ifndef DATE_H
#define DATE_H

#include "notification-list.h"

GNOFIN_API_BEGIN

void         date_now                   (GDate *date);
gchar       *date_stringize_with_format (gchar *buf, guint maxlen, const gchar *format, const GDate *date);
gchar       *date_stringize             (gchar *buf, guint maxlen, const GDate *date);
gboolean     date_parse                 (const gchar *buf, GDate *date);
void         date_set_format            (const gchar *format);
const gchar *date_get_format            (void);

/* Those interested in changes to the date format can attach to
 * this notification list. */
extern NotificationList date_format_change_listeners;

GNOFIN_API_END

#endif
