/* gnome-drud-page-finish.c
 * Copyright (C) 1999  J. Arthur Random
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <gnome.h>
#include "gnome-drud-page-finish.h"
#include "gnome-drud.h"

static void gnome_drud_page_finish_init 	 (GnomeDrudPageFinish		 *drud_page_finish);
static void gnome_drud_page_finish_class_init	 (GnomeDrudPageFinishClass	 *klass);
static void gnome_drud_page_finish_construct     (GnomeDrudPageFinish             *drud_page_finish);
static void gnome_drud_page_finish_configure_size(GnomeDrudPageFinish             *drud_page_finish,
						  gint                             width,
						  gint                             height);
static void gnome_drud_page_finish_size_allocate (GtkWidget                       *widget,
						  GtkAllocation                   *allocation);
static void gnome_drud_page_finish_realize       (GtkWidget                       *widget);
static void gnome_drud_page_finish_prepare	 (GnomeDrudPage		  *page,
						  GtkWidget                       *drud,
						  gpointer 			  *data);
static GnomeDrudPageClass *parent_class = NULL;

#define LOGO_WIDTH 50.0
#define DRUD_PAGE_HEIGHT 318
#define DRUD_PAGE_WIDTH 516

GtkType
gnome_drud_page_finish_get_type (void)
{
  static GtkType drud_page_finish_type = 0;

  if (!drud_page_finish_type)
    {
      static const GtkTypeInfo drud_page_finish_info =
      {
        "GnomeDrudPageFinish",
        sizeof (GnomeDrudPageFinish),
        sizeof (GnomeDrudPageFinishClass),
        (GtkClassInitFunc) gnome_drud_page_finish_class_init,
        (GtkObjectInitFunc) gnome_drud_page_finish_init,
        /* reserved_1 */ NULL,
        /* reserved_2 */ NULL,
        (GtkClassInitFunc) NULL,
      };

      drud_page_finish_type = gtk_type_unique (gnome_drud_page_get_type (), &drud_page_finish_info);
    }

  return drud_page_finish_type;
}

static void
gnome_drud_page_finish_class_init (GnomeDrudPageFinishClass *klass)
{
	GtkObjectClass *object_class;
	GtkWidgetClass *widget_class;

	object_class = (GtkObjectClass*) klass;
	widget_class = (GtkWidgetClass*) klass;
	widget_class->size_allocate = gnome_drud_page_finish_size_allocate;
	widget_class->realize = gnome_drud_page_finish_realize;
	parent_class = gtk_type_class (gnome_drud_page_get_type ());
}


static void
gnome_drud_page_finish_init (GnomeDrudPageFinish *drud_page_finish)
{


	/* initialize the color values */
	drud_page_finish->background_color.red = 6400; /* midnight blue */
	drud_page_finish->background_color.green = 6400;
	drud_page_finish->background_color.blue = 28672;
	drud_page_finish->textbox_color.red = 65280; /* white */
	drud_page_finish->textbox_color.green = 65280;
	drud_page_finish->textbox_color.blue = 65280;
	drud_page_finish->logo_background_color.red = 65280; /* white */
	drud_page_finish->logo_background_color.green = 65280;
	drud_page_finish->logo_background_color.blue = 65280;
	drud_page_finish->title_color.red = 65280; /* white */
	drud_page_finish->title_color.green = 65280;
	drud_page_finish->title_color.blue = 65280;
	drud_page_finish->text_color.red = 0; /* black */
	drud_page_finish->text_color.green = 0;
	drud_page_finish->text_color.blue = 0;

	/* Set up the canvas */ 
	gtk_container_set_border_width (GTK_CONTAINER (drud_page_finish), 0);
	drud_page_finish->canvas = gnome_canvas_new ();
	gtk_widget_set_usize (drud_page_finish->canvas, DRUD_PAGE_WIDTH, DRUD_PAGE_HEIGHT);
	gtk_widget_show (drud_page_finish->canvas);
	gnome_canvas_set_scroll_region (GNOME_CANVAS (drud_page_finish->canvas), 0.0, 0.0, DRUD_PAGE_WIDTH, DRUD_PAGE_HEIGHT);
	gtk_container_add (GTK_CONTAINER (drud_page_finish), drud_page_finish->canvas);

}
static void
gnome_drud_page_finish_configure_size (GnomeDrudPageFinish *drud_page_finish, gint width, gint height)
{
	gnome_canvas_item_set (drud_page_finish->background_item,
			       "x1", 0.0,
			       "y1", 0.0,
			       "x2", (gfloat) width,
			       "y2", (gfloat) height,
			       "width_units", 1.0, NULL);
	gnome_canvas_item_set (drud_page_finish->textbox_item,
			       "x1", (gfloat) width * 0.3,
			       "y1", (gfloat) LOGO_WIDTH + GNOME_PAD * 2.0,
			       "x2", (gfloat) width,
			       "y2", (gfloat) height,
			       "width_units", 1.0, NULL);
	gnome_canvas_item_set (drud_page_finish->logoframe_item,
			       "x1", (gfloat) width - LOGO_WIDTH -GNOME_PAD,
			       "y1", (gfloat) GNOME_PAD,
			       "x2", (gfloat) width - GNOME_PAD,
			       "y2", (gfloat) GNOME_PAD + LOGO_WIDTH,
			       "width_units", 1.0, NULL);
	gnome_canvas_item_set (drud_page_finish->logo_item,
			       "x", (gfloat) width - GNOME_PAD - LOGO_WIDTH,
			       "y", (gfloat) GNOME_PAD,
			       "anchor", GTK_ANCHOR_NORTH_WEST,
			       "width", (gfloat) LOGO_WIDTH,
			       "height", (gfloat) LOGO_WIDTH, NULL);
	gnome_canvas_item_set (drud_page_finish->watermark_item,
			       "x", 0.0,
			       "y", LOGO_WIDTH + GNOME_PAD * 2.0,
			       "anchor", GTK_ANCHOR_NORTH_WEST,
			       "width", width * 0.3,
			       "height", (gfloat) height - LOGO_WIDTH + GNOME_PAD * 2.0,
			       NULL);
	gnome_canvas_item_set (drud_page_finish->title_item,
			       "x", 15.0, 
			       "y", (gfloat) GNOME_PAD + LOGO_WIDTH / 2.0,
			       "anchor", GTK_ANCHOR_WEST,
			       NULL);
	gnome_canvas_item_set (drud_page_finish->text_item,
			       "x", width * 0.65,
			       "y", LOGO_WIDTH + GNOME_PAD * 2.0 + (height - (LOGO_WIDTH + GNOME_PAD * 2.0))/ 2.0,
			       "anchor", GTK_ANCHOR_CENTER,
			       NULL);
}

static void
gnome_drud_page_finish_construct (GnomeDrudPageFinish *drud_page_finish)
{
	/* set up the rest of the page */
	drud_page_finish->background_item =
		gnome_canvas_item_new (gnome_canvas_root (GNOME_CANVAS (drud_page_finish->canvas)),
				       gnome_canvas_rect_get_type (), NULL);
	drud_page_finish->textbox_item =
		gnome_canvas_item_new (gnome_canvas_root (GNOME_CANVAS (drud_page_finish->canvas)),
				       gnome_canvas_rect_get_type (), NULL);
	drud_page_finish->logoframe_item =
		gnome_canvas_item_new (gnome_canvas_root (GNOME_CANVAS (drud_page_finish->canvas)),
				       gnome_canvas_rect_get_type (), NULL);
	drud_page_finish->logo_item =
		gnome_canvas_item_new (gnome_canvas_root (GNOME_CANVAS (drud_page_finish->canvas)),
				       gnome_canvas_image_get_type (), NULL);
	if (drud_page_finish->logo_image != NULL)
		gnome_canvas_item_set (drud_page_finish->logo_item,
				       "image", drud_page_finish->logo_image, NULL);
	drud_page_finish->watermark_item =
		gnome_canvas_item_new (gnome_canvas_root (GNOME_CANVAS (drud_page_finish->canvas)),
				       gnome_canvas_image_get_type (),
				       "image", drud_page_finish->watermark_image, NULL);
	drud_page_finish->title_item =
		gnome_canvas_item_new (gnome_canvas_root (GNOME_CANVAS (drud_page_finish->canvas)),
				       gnome_canvas_text_get_type (), 
				       "text", drud_page_finish->title,
				       "font", "-adobe-helvetica-bold-r-normal-*-*-180-*-*-p-*-iso8859-1",
				       NULL);
	drud_page_finish->text_item =
		gnome_canvas_item_new (gnome_canvas_root (GNOME_CANVAS (drud_page_finish->canvas)),
				       gnome_canvas_text_get_type (),
				       "text", drud_page_finish->text,
				       "justification", GTK_JUSTIFY_LEFT,
				       "font", "-adobe-helvetica-medium-r-normal-*-*-120-*-*-p-*-iso8859-1",
				       NULL);

	gnome_drud_page_finish_configure_size (drud_page_finish, DRUD_PAGE_WIDTH, DRUD_PAGE_HEIGHT);
	gtk_signal_connect (GTK_OBJECT (drud_page_finish),
			    "prepare",
			    gnome_drud_page_finish_prepare,
			    NULL);
}
static void
gnome_drud_page_finish_prepare (GnomeDrudPage *page,
				GtkWidget *drud,
				gpointer *data)
{
	gnome_drud_set_buttons_sensitive (GNOME_DRUD (drud), TRUE, FALSE, TRUE);
	gnome_drud_set_show_finish (GNOME_DRUD (drud), TRUE);
	gtk_widget_grab_default (GNOME_DRUD (drud)->finish);
}


static void
gnome_drud_page_finish_size_allocate   (GtkWidget               *widget,
					GtkAllocation           *allocation)
{
	GTK_WIDGET_CLASS (parent_class)->size_allocate (widget, allocation);
	gnome_canvas_set_scroll_region (GNOME_CANVAS (GNOME_DRUD_PAGE_FINISH (widget)->canvas),
					0.0, 0.0,
					allocation->width,
					allocation->height);
	gnome_drud_page_finish_configure_size (GNOME_DRUD_PAGE_FINISH (widget),
					       allocation->width,
					       allocation->height);
}
static void
gnome_drud_page_finish_realize (GtkWidget *widget)
{
	GnomeDrudPageFinish *drud_page_finish;
	GdkColormap *cmap = gdk_imlib_get_colormap ();

	drud_page_finish = GNOME_DRUD_PAGE_FINISH (widget);
	gdk_colormap_alloc_color (cmap, &drud_page_finish->background_color, FALSE, TRUE);
	gdk_colormap_alloc_color (cmap, &drud_page_finish->textbox_color, FALSE, TRUE);
	gdk_colormap_alloc_color (cmap, &drud_page_finish->logo_background_color, FALSE, TRUE);
	gdk_colormap_alloc_color (cmap, &drud_page_finish->title_color, FALSE, TRUE);
	gdk_colormap_alloc_color (cmap, &drud_page_finish->text_color, FALSE, TRUE);

	gnome_canvas_item_set (drud_page_finish->background_item,
			       "fill_color_gdk", &(drud_page_finish->background_color),
			       NULL);
	gnome_canvas_item_set (drud_page_finish->textbox_item,
			       "fill_color_gdk", &(drud_page_finish->textbox_color),
			       "outline_color_gdk", &(drud_page_finish->background_color),
			       NULL);
	gnome_canvas_item_set (drud_page_finish->logoframe_item,
			       "fill_color_gdk", &drud_page_finish->logo_background_color,
			       NULL);
	gnome_canvas_item_set (drud_page_finish->title_item,
			       "fill_color_gdk", &drud_page_finish->title_color,
			       NULL);
	gnome_canvas_item_set (drud_page_finish->text_item,
			       "fill_color_gdk", &drud_page_finish->text_color,
			       NULL);
	GTK_WIDGET_CLASS (parent_class)->realize (widget);
}

/* Public functions */
GtkWidget *
gnome_drud_page_finish_new (void)
{
	GtkWidget *retval =  GTK_WIDGET (gtk_type_new (gnome_drud_page_finish_get_type ()));
	GNOME_DRUD_PAGE_FINISH (retval)->title = g_strdup ("");
	GNOME_DRUD_PAGE_FINISH (retval)->text = g_strdup ("");
	GNOME_DRUD_PAGE_FINISH (retval)->logo_image = NULL;
	GNOME_DRUD_PAGE_FINISH (retval)->watermark_image = NULL;
	gnome_drud_page_finish_construct (GNOME_DRUD_PAGE_FINISH (retval));
	return retval;
}
GtkWidget *
gnome_drud_page_finish_new_with_vals (const gchar *title, const gchar* text, GdkImlibImage *logo, GdkImlibImage *watermark)
{
	GtkWidget *retval =  gnome_drud_page_finish_new ();
	GNOME_DRUD_PAGE_FINISH (retval)->title = g_strdup (title);
	GNOME_DRUD_PAGE_FINISH (retval)->text = g_strdup (text);
	GNOME_DRUD_PAGE_FINISH (retval)->logo_image = logo;
	GNOME_DRUD_PAGE_FINISH (retval)->watermark_image = watermark;
	gnome_drud_page_finish_construct (GNOME_DRUD_PAGE_FINISH (retval));
	return retval;
}
void
gnome_drud_page_finish_set_bg_color      (GnomeDrudPageFinish *drud_page_finish,
					  GdkColor *color)
{
	g_return_if_fail (drud_page_finish != NULL);
	g_return_if_fail (GNOME_IS_DRUD_PAGE_FINISH (drud_page_finish));

	if (GTK_WIDGET_REALIZED (drud_page_finish)) {
		GdkColormap *cmap = gdk_imlib_get_colormap ();

		gdk_colormap_free_colors (cmap, &drud_page_finish->background_color, 1);
	}
	drud_page_finish->background_color.red = color->red;
	drud_page_finish->background_color.green = color->green;
	drud_page_finish->background_color.blue = color->blue;

	if (GTK_WIDGET_REALIZED (drud_page_finish)) {
		GdkColormap *cmap = gdk_imlib_get_colormap ();
		gdk_colormap_alloc_color (cmap, &drud_page_finish->background_color, FALSE, TRUE);
		gnome_canvas_item_set (drud_page_finish->textbox_item,
				       "outline_color_gdk", &drud_page_finish->background_color,
				       NULL);
		gnome_canvas_item_set (drud_page_finish->background_item,
				       "fill_color_gdk", &drud_page_finish->background_color,
				       NULL);
	}
}
void
gnome_drud_page_finish_set_textbox_color (GnomeDrudPageFinish *drud_page_finish,
					  GdkColor *color)
{
	g_return_if_fail (drud_page_finish != NULL);
	g_return_if_fail (GNOME_IS_DRUD_PAGE_FINISH (drud_page_finish));

	if (GTK_WIDGET_REALIZED (drud_page_finish)) {
		GdkColormap *cmap = gdk_imlib_get_colormap ();

		gdk_colormap_free_colors (cmap, &drud_page_finish->textbox_color, 1);
	}
	drud_page_finish->textbox_color.red = color->red;
	drud_page_finish->textbox_color.green = color->green;
	drud_page_finish->textbox_color.blue = color->blue;

	if (GTK_WIDGET_REALIZED (drud_page_finish)) {
		GdkColormap *cmap = gdk_imlib_get_colormap ();
		gdk_colormap_alloc_color (cmap, &drud_page_finish->textbox_color, FALSE, TRUE);
		gnome_canvas_item_set (drud_page_finish->textbox_item,
				       "fill_color_gdk", &drud_page_finish->textbox_color,
				       NULL);
	}
}
void
gnome_drud_page_finish_set_logo_bg_color (GnomeDrudPageFinish *drud_page_finish,
					  GdkColor *color)
{
	g_return_if_fail (drud_page_finish != NULL);
	g_return_if_fail (GNOME_IS_DRUD_PAGE_FINISH (drud_page_finish));

	if (GTK_WIDGET_REALIZED (drud_page_finish)) {
		GdkColormap *cmap = gdk_imlib_get_colormap ();

		gdk_colormap_free_colors (cmap, &drud_page_finish->logo_background_color, 1);
	}
	drud_page_finish->logo_background_color.red = color->red;
	drud_page_finish->logo_background_color.green = color->green;
	drud_page_finish->logo_background_color.blue = color->blue;

	if (GTK_WIDGET_REALIZED (drud_page_finish)) {
		GdkColormap *cmap = gdk_imlib_get_colormap ();
		gdk_colormap_alloc_color (cmap, &drud_page_finish->logo_background_color, FALSE, TRUE);
		gnome_canvas_item_set (drud_page_finish->logoframe_item,
				       "fill_color_gdk", &drud_page_finish->logo_background_color,
				       NULL);
	}
}
void
gnome_drud_page_finish_set_title_color   (GnomeDrudPageFinish *drud_page_finish,
					  GdkColor *color)
{
	g_return_if_fail (drud_page_finish != NULL);
	g_return_if_fail (GNOME_IS_DRUD_PAGE_FINISH (drud_page_finish));

	if (GTK_WIDGET_REALIZED (drud_page_finish)) {
		GdkColormap *cmap = gdk_imlib_get_colormap ();

		gdk_colormap_free_colors (cmap, &drud_page_finish->title_color, 1);
	}
	drud_page_finish->title_color.red = color->red;
	drud_page_finish->title_color.green = color->green;
	drud_page_finish->title_color.blue = color->blue;

	if (GTK_WIDGET_REALIZED (drud_page_finish)) {
		GdkColormap *cmap = gdk_imlib_get_colormap ();
		gdk_colormap_alloc_color (cmap, &drud_page_finish->title_color, FALSE, TRUE);
		gnome_canvas_item_set (drud_page_finish->title_item,
				       "fill_color_gdk", &drud_page_finish->title_color,
				       NULL);
	}

}
void
gnome_drud_page_finish_set_text_color    (GnomeDrudPageFinish *drud_page_finish,
					  GdkColor *color)
{
	g_return_if_fail (drud_page_finish != NULL);
	g_return_if_fail (GNOME_IS_DRUD_PAGE_FINISH (drud_page_finish));

	if (GTK_WIDGET_REALIZED (drud_page_finish)) {
		GdkColormap *cmap = gdk_imlib_get_colormap ();

		gdk_colormap_free_colors (cmap, &drud_page_finish->text_color, 1);
	}
	drud_page_finish->text_color.red = color->red;
	drud_page_finish->text_color.green = color->green;
	drud_page_finish->text_color.blue = color->blue;

	if (GTK_WIDGET_REALIZED (drud_page_finish)) {
		GdkColormap *cmap = gdk_imlib_get_colormap ();
		gdk_colormap_alloc_color (cmap, &drud_page_finish->text_color, FALSE, TRUE);
		gnome_canvas_item_set (drud_page_finish->text_item,
				       "fill_color_gdk", &drud_page_finish->text_color,
				       NULL);
	}

}
void
gnome_drud_page_finish_set_text          (GnomeDrudPageFinish *drud_page_finish,
					  const gchar *text)
{
	g_return_if_fail (drud_page_finish != NULL);
	g_return_if_fail (GNOME_IS_DRUD_PAGE_FINISH (drud_page_finish));

	g_free (drud_page_finish->text);
	drud_page_finish->text = g_strdup (text);
	gnome_canvas_item_set (drud_page_finish->text_item,
			       "text", drud_page_finish->text,
			       NULL);
}
void
gnome_drud_page_finish_set_title         (GnomeDrudPageFinish *drud_page_finish,
					  const gchar *title)
{
	g_return_if_fail (drud_page_finish != NULL);
	g_return_if_fail (GNOME_IS_DRUD_PAGE_FINISH (drud_page_finish));

	g_free (drud_page_finish->title);
	drud_page_finish->title = g_strdup (title);
	gnome_canvas_item_set (drud_page_finish->title_item,
			       "text", drud_page_finish->title,
			       NULL);
}
void
gnome_drud_page_finish_set_logo          (GnomeDrudPageFinish *drud_page_finish,
					  GdkImlibImage *logo_image)
{
	g_return_if_fail (drud_page_finish != NULL);
	g_return_if_fail (GNOME_IS_DRUD_PAGE_FINISH (drud_page_finish));

	drud_page_finish->logo_image = logo_image;
	gnome_canvas_item_set (drud_page_finish->logo_item,
			       "image", drud_page_finish->logo_image, NULL);
}
void
gnome_drud_page_finish_set_watermark     (GnomeDrudPageFinish *drud_page_finish,
					  GdkImlibImage *watermark)
{
	g_return_if_fail (drud_page_finish != NULL);
	g_return_if_fail (GNOME_IS_DRUD_PAGE_FINISH (drud_page_finish));

	drud_page_finish->logo_image = watermark;
	gnome_canvas_item_set (drud_page_finish->watermark_item,
			       "image", drud_page_finish->watermark_image, NULL);
}
