/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 *   Gnome Apt frontend
 *
 *   Copyright (C) 1998 Havoc Pennington <hp@pobox.com>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef GNOME_APT_PREFERENCES_H
#define GNOME_APT_PREFERENCES_H

#include "gnome-apt.h"

#include "pkglist.h"

class OrderEdit;

class Preferences
{
public:
  Preferences();
  ~Preferences();

  void edit();

  // kind of a hack, but not so bad I guess
  void set_pkglist(GAptPkgList* pl) { pkglist_ = pl; }

private:
  GtkWidget* dialog_;

  GtkWidget* info_hidden_;

  GAptPkgList* pkglist_;

  OrderEdit* oe_;

  friend class OrderEdit;

  static void apply_cb (GtkWidget* w, gint page, gpointer data);
  static void help_cb  (GtkWidget* w, gint page, gpointer data);

  void apply(gint page);
  void help (gint page);

  static gint close_cb (GtkWidget* w, gpointer data);
  void close();

  static void changed_cb (GtkWidget* w, gpointer data);
  void changed();
};

Preferences* gnome_apt_preferences();
void         gnome_apt_preferences_shutdown();

#endif
