/* 
 * Copyright (C) 1999 Robert Wilhelm
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#ifndef MOVELIST_H
#define MOVELIST_H

#include "position.h"

typedef struct {
	gint length;
	gint current;
	gint ply;
	GtkWidget *vbox;
	GtkWidget *clist;
	GtkWidget *result;
} MoveList;

MoveList* gnomechess_movelist_new(void);
void gnomechess_movelist_add(MoveList *movelist, int piece,int from, int to);
void gnomechess_movelist_movetoply(MoveList *movelist, unsigned int plynum);
void gnomechess_movelist_move_forward(MoveList *movelist);
void gnomechess_movelist_move_back(MoveList *movelist);
void gnomechess_movelist_move_start(MoveList *movelist);
void gnomechess_movelist_move_end(MoveList *movelist);
int gnomechess_movelist_currply(MoveList *movelist);
int gnomechess_movelist_maxply(MoveList *movelist);
void gnomechess_movelist_set_result(MoveList *movelist, gchar *result);
GtkWidget* gnomechess_movelist_getview(MoveList *movelist);
void gnomechess_movelist_clear_initial(MoveList *movelist, gint ply, position *pos);
void gnomechess_movelist_clear_from(MoveList *movelist, unsigned int plynum);
void gnomechess_movelist_clear(MoveList *movelist);

void generate_notation(char *buf, size_t len);
void move_to_engine(int from, int to);

#endif