/* 
 * Copyright (C) 1999 JP Rosevear
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#ifndef PREFS_H
#define PREFS_H

#include <glib.h>

typedef struct {
	gchar *name;
	gchar *location;
} PrefsProgram;

typedef struct {
	gchar *server;
	gchar *port;
	gchar *user;
	gchar *password;
	gchar *connect;
} PrefsServer;

void prefs_init(void);
void prefs_sync (void);

void prefs_get_light_color (guint8 *r, guint8 *g, guint8 *b);
void prefs_set_light_color (guint8 r, guint8 g, guint8 b);

void prefs_get_dark_color (guint8 *r, guint8 *g, guint8 *b);
void prefs_set_dark_color (guint8 r, guint8 g, guint8 b);

const gchar *prefs_get_piecedir (void);
void prefs_set_piecedir (const char *piecedir);

gint prefs_get_notation (void);
void prefs_set_notation (gint notation);

gboolean prefs_get_beeponmove (void);
void prefs_set_beeponmove (gboolean beep);

gboolean prefs_get_promotetoqueen (void);
void prefs_set_promotetoqueen (gboolean beep);

gboolean prefs_get_autoflag (void);
void prefs_set_autoflag (gboolean beep);

GList *prefs_get_programs (void);
void prefs_set_programs (GList *programs);
GList *prefs_copy_program_list (GList *list);
void prefs_free_program_list (GList *list);

GList *prefs_get_servers (void);
void prefs_set_servers (GList *servers);
GList *prefs_copy_server_list (GList *list);
void prefs_free_server_list (GList *list);

const gchar *prefs_get_telnetprogram (void);
void prefs_set_telnetprogram (const gchar *telnet_program);

#endif /* PREFS_H */

